/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import java.util.concurrent.Callable;
import org.webrtc.EglBase;
import org.webrtc.EglBase$_CC;
import org.webrtc.GlUtil;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.TextureBufferImpl;
import org.webrtc.ThreadUtils;
import org.webrtc.TimestampAligner;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.YuvConverter;
import org.webrtc._$;

public class SurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private final EglBase eglBase;
    private final FrameRefMonitor frameRefMonitor;
    private int frameRotation;
    private final Handler handler;
    private boolean hasPendingTexture;
    private boolean isQuitting;
    private volatile boolean isTextureInUse;
    private VideoSink listener;
    private final int oesTextureId;
    private VideoSink pendingListener;
    final Runnable setListenerRunnable;
    private final SurfaceTexture surfaceTexture;
    private int textureHeight;
    private final TextureBufferImpl.RefCountMonitor textureRefCountMonitor = new TextureBufferImpl.RefCountMonitor(){

        @Override
        public void onDestroy(TextureBufferImpl textureBufferImpl) {
            SurfaceTextureHelper.this.returnTextureFrame();
            if (SurfaceTextureHelper.this.frameRefMonitor != null) {
                SurfaceTextureHelper.this.frameRefMonitor.onDestroyBuffer(textureBufferImpl);
            }
        }

        @Override
        public void onRelease(TextureBufferImpl textureBufferImpl) {
            if (SurfaceTextureHelper.this.frameRefMonitor != null) {
                SurfaceTextureHelper.this.frameRefMonitor.onReleaseBuffer(textureBufferImpl);
            }
        }

        @Override
        public void onRetain(TextureBufferImpl textureBufferImpl) {
            if (SurfaceTextureHelper.this.frameRefMonitor != null) {
                SurfaceTextureHelper.this.frameRefMonitor.onRetainBuffer(textureBufferImpl);
            }
        }
    };
    private int textureWidth;
    private final TimestampAligner timestampAligner;
    private final YuvConverter yuvConverter;

    private SurfaceTextureHelper(EglBase.Context object, Handler handler, boolean bl, YuvConverter yuvConverter, FrameRefMonitor frameRefMonitor) {
        this.setListenerRunnable = new Runnable(){

            @Override
            public void run() {
                Object object = new StringBuilder();
                ((StringBuilder)object).append("Setting listener to ");
                ((StringBuilder)object).append(SurfaceTextureHelper.this.pendingListener);
                Logging.d(SurfaceTextureHelper.TAG, ((StringBuilder)object).toString());
                object = SurfaceTextureHelper.this;
                SurfaceTextureHelper.access$402((SurfaceTextureHelper)object, ((SurfaceTextureHelper)object).pendingListener);
                SurfaceTextureHelper.access$302(SurfaceTextureHelper.this, null);
                if (SurfaceTextureHelper.this.hasPendingTexture) {
                    SurfaceTextureHelper.this.updateTexImage();
                    SurfaceTextureHelper.access$502(SurfaceTextureHelper.this, false);
                }
            }
        };
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            this.handler = handler;
            TimestampAligner timestampAligner = bl ? new TimestampAligner() : null;
            this.timestampAligner = timestampAligner;
            this.yuvConverter = yuvConverter;
            this.frameRefMonitor = frameRefMonitor;
            this.eglBase = object = EglBase$_CC.create((EglBase.Context)object, EglBase.CONFIG_PIXEL_BUFFER);
            try {
                object.createDummyPbufferSurface();
                this.eglBase.makeCurrent();
            }
            catch (RuntimeException runtimeException) {
                this.eglBase.release();
                handler.getLooper().quit();
                throw runtimeException;
            }
            this.oesTextureId = GlUtil.generateTexture(36197);
            object = new SurfaceTexture(this.oesTextureId);
            this.surfaceTexture = object;
            SurfaceTextureHelper.setOnFrameAvailableListener((SurfaceTexture)object, (SurfaceTexture.OnFrameAvailableListener)new _$.Lambda.SurfaceTextureHelper.7YTfC0byyd0o_zI7mNhfP12Gm0Q(this), handler);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
    }

    static /* synthetic */ VideoSink access$302(SurfaceTextureHelper surfaceTextureHelper, VideoSink videoSink) {
        surfaceTextureHelper.pendingListener = videoSink;
        return videoSink;
    }

    static /* synthetic */ VideoSink access$402(SurfaceTextureHelper surfaceTextureHelper, VideoSink videoSink) {
        surfaceTextureHelper.listener = videoSink;
        return videoSink;
    }

    static /* synthetic */ boolean access$502(SurfaceTextureHelper surfaceTextureHelper, boolean bl) {
        surfaceTextureHelper.hasPendingTexture = bl;
        return bl;
    }

    public static SurfaceTextureHelper create(String string2, EglBase.Context context) {
        return SurfaceTextureHelper.create(string2, context, false, new YuvConverter(), null);
    }

    public static SurfaceTextureHelper create(String string2, EglBase.Context context, boolean bl) {
        return SurfaceTextureHelper.create(string2, context, bl, new YuvConverter(), null);
    }

    public static SurfaceTextureHelper create(String string2, EglBase.Context context, boolean bl, YuvConverter yuvConverter) {
        return SurfaceTextureHelper.create(string2, context, bl, yuvConverter, null);
    }

    public static SurfaceTextureHelper create(String string2, final EglBase.Context context, boolean bl, YuvConverter yuvConverter, FrameRefMonitor frameRefMonitor) {
        HandlerThread handlerThread = new HandlerThread(string2);
        handlerThread.start();
        handlerThread = new Handler(handlerThread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly((Handler)handlerThread, new Callable<SurfaceTextureHelper>((Handler)handlerThread, bl, yuvConverter, frameRefMonitor, string2){
            final /* synthetic */ boolean val$alignTimestamps;
            final /* synthetic */ FrameRefMonitor val$frameRefMonitor;
            final /* synthetic */ Handler val$handler;
            final /* synthetic */ String val$threadName;
            final /* synthetic */ YuvConverter val$yuvConverter;
            {
                this.val$handler = handler;
                this.val$alignTimestamps = bl;
                this.val$yuvConverter = yuvConverter;
                this.val$frameRefMonitor = frameRefMonitor;
                this.val$threadName = string2;
            }

            @Override
            public SurfaceTextureHelper call() {
                try {
                    SurfaceTextureHelper surfaceTextureHelper = new SurfaceTextureHelper(context, this.val$handler, this.val$alignTimestamps, this.val$yuvConverter, this.val$frameRefMonitor);
                    return surfaceTextureHelper;
                }
                catch (RuntimeException runtimeException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.val$threadName);
                    stringBuilder.append(" create failure");
                    Logging.e(SurfaceTextureHelper.TAG, stringBuilder.toString(), runtimeException);
                    return null;
                }
            }
        });
    }

    private void release() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isTextureInUse && this.isQuitting) {
                this.yuvConverter.release();
                GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
                this.surfaceTexture.release();
                this.eglBase.release();
                this.handler.getLooper().quit();
                TimestampAligner timestampAligner = this.timestampAligner;
                if (timestampAligner != null) {
                    timestampAligner.dispose();
                }
                return;
            }
            throw new IllegalStateException("Unexpected release.");
        }
        throw new IllegalStateException("Wrong thread.");
    }

    private void returnTextureFrame() {
        this.handler.post((Runnable)new _$.Lambda.SurfaceTextureHelper.jxH_WSP9WRRQypdzvhBYUcJFCM0(this));
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener);
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isQuitting && this.hasPendingTexture && !this.isTextureInUse && this.listener != null) {
                if (this.textureWidth != 0 && this.textureHeight != 0) {
                    this.isTextureInUse = true;
                    this.hasPendingTexture = false;
                    this.updateTexImage();
                    Object object = new float[16];
                    this.surfaceTexture.getTransformMatrix((float[])object);
                    long l3 = this.surfaceTexture.getTimestamp();
                    Object object2 = this.timestampAligner;
                    long l4 = l3;
                    if (object2 != null) {
                        l4 = ((TimestampAligner)object2).translateTimestamp(l3);
                    }
                    object2 = new TextureBufferImpl(this.textureWidth, this.textureHeight, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix((float[])object), this.handler, this.yuvConverter, this.textureRefCountMonitor);
                    object = this.frameRefMonitor;
                    if (object != null) {
                        object.onNewBuffer((VideoFrame.TextureBuffer)object2);
                    }
                    object = new VideoFrame((VideoFrame.Buffer)object2, this.frameRotation, l4);
                    this.listener.onFrame((VideoFrame)object);
                    ((VideoFrame)object).release();
                    return;
                }
                Logging.w(TAG, "Texture size has not been set.");
            }
            return;
        }
        throw new IllegalStateException("Wrong thread.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTexImage() {
        Object object = EglBase.lock;
        synchronized (object) {
            this.surfaceTexture.updateTexImage();
            return;
        }
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, (Runnable)new _$.Lambda.SurfaceTextureHelper._rN_9eOQ_CNGCBfz4icb_qNtPGs(this));
    }

    public Handler getHandler() {
        return this.handler;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public /* synthetic */ void lambda$dispose$5$SurfaceTextureHelper() {
        this.isQuitting = true;
        if (!this.isTextureInUse) {
            this.release();
        }
    }

    public /* synthetic */ void lambda$new$0$SurfaceTextureHelper(SurfaceTexture surfaceTexture) {
        this.hasPendingTexture = true;
        this.tryDeliverTextureFrame();
    }

    public /* synthetic */ void lambda$returnTextureFrame$4$SurfaceTextureHelper() {
        this.isTextureInUse = false;
        if (this.isQuitting) {
            this.release();
        } else {
            this.tryDeliverTextureFrame();
        }
    }

    public /* synthetic */ void lambda$setFrameRotation$3$SurfaceTextureHelper(int n2) {
        this.frameRotation = n2;
    }

    public /* synthetic */ void lambda$setTextureSize$2$SurfaceTextureHelper(int n2, int n3) {
        this.textureWidth = n2;
        this.textureHeight = n3;
        this.tryDeliverTextureFrame();
    }

    public /* synthetic */ void lambda$stopListening$1$SurfaceTextureHelper() {
        this.listener = null;
        this.pendingListener = null;
    }

    public void setFrameRotation(int n2) {
        this.handler.post((Runnable)new _$.Lambda.SurfaceTextureHelper.8I9BGYh1ysN70toph_WhdCfZCQ4(this, n2));
    }

    public void setTextureSize(int n2, int n3) {
        if (n2 > 0) {
            if (n3 > 0) {
                this.surfaceTexture.setDefaultBufferSize(n2, n3);
                this.handler.post((Runnable)new _$.Lambda.SurfaceTextureHelper.zvo_pspqaGa7qu1SNsn_kRedNVk(this, n2, n3));
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Texture height must be positive, but was ");
            stringBuilder.append(n3);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Texture width must be positive, but was ");
        stringBuilder.append(n2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void startListening(VideoSink videoSink) {
        if (this.listener == null && this.pendingListener == null) {
            this.pendingListener = videoSink;
            this.handler.post(this.setListenerRunnable);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
    }

    public void stopListening() {
        Logging.d(TAG, "stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, (Runnable)new _$.Lambda.SurfaceTextureHelper.Z2b9yhA_jJLZ9Hj7bJkKc8ZG0po(this));
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }

    public static interface FrameRefMonitor {
        public void onDestroyBuffer(VideoFrame.TextureBuffer var1);

        public void onNewBuffer(VideoFrame.TextureBuffer var1);

        public void onReleaseBuffer(VideoFrame.TextureBuffer var1);

        public void onRetainBuffer(VideoFrame.TextureBuffer var1);
    }
}

