/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.view.SurfaceHolder;
import java.util.concurrent.CountDownLatch;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc._$;

public class SurfaceEglRenderer
extends EglRenderer
implements SurfaceHolder.Callback {
    private static final String TAG = "SurfaceEglRenderer";
    private int frameRotation;
    private boolean isFirstFrameRendered;
    private boolean isRenderingPaused;
    private final Object layoutLock = new Object();
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameHeight;
    private int rotatedFrameWidth;

    public SurfaceEglRenderer(String string2) {
        super(string2);
    }

    private void logD(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        Logging.d(TAG, stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame videoFrame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.isRenderingPaused) {
                return;
            }
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                this.logD("Reporting first rendered frame.");
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth != videoFrame.getRotatedWidth() || this.rotatedFrameHeight != videoFrame.getRotatedHeight() || this.frameRotation != videoFrame.getRotation()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Reporting frame resolution changed to ");
                stringBuilder.append(videoFrame.getBuffer().getWidth());
                stringBuilder.append("x");
                stringBuilder.append(videoFrame.getBuffer().getHeight());
                stringBuilder.append(" with rotation ");
                stringBuilder.append(videoFrame.getRotation());
                this.logD(stringBuilder.toString());
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(videoFrame.getBuffer().getWidth(), videoFrame.getBuffer().getHeight(), videoFrame.getRotation());
                }
                this.rotatedFrameWidth = videoFrame.getRotatedWidth();
                this.rotatedFrameHeight = videoFrame.getRotatedHeight();
                this.frameRotation = videoFrame.getRotation();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disableFpsReduction() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = false;
        }
        super.disableFpsReduction();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(EglBase.Context context, RendererCommon.RendererEvents object, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = object;
        object = this.layoutLock;
        synchronized (object) {
            this.isFirstFrameRendered = false;
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = 0;
        }
        super.init(context, nArray, glDrawer);
    }

    @Override
    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.init(context, null, nArray, glDrawer);
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        this.updateFrameDimensionsAndReportEvents(videoFrame);
        super.onFrame(videoFrame);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void pauseVideo() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = true;
        }
        super.pauseVideo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setFpsReduction(float f3) {
        Object object = this.layoutLock;
        synchronized (object) {
            boolean bl = f3 == 0.0f;
            this.isRenderingPaused = bl;
        }
        super.setFpsReduction(f3);
    }

    public void surfaceChanged(SurfaceHolder object, int n2, int n3, int n4) {
        ThreadUtils.checkIsOnMainThread();
        object = new StringBuilder();
        ((StringBuilder)object).append("surfaceChanged: format: ");
        ((StringBuilder)object).append(n2);
        ((StringBuilder)object).append(" size: ");
        ((StringBuilder)object).append(n3);
        ((StringBuilder)object).append("x");
        ((StringBuilder)object).append(n4);
        this.logD(((StringBuilder)object).toString());
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.createEglSurface(surfaceHolder.getSurface());
    }

    public void surfaceDestroyed(SurfaceHolder object) {
        ThreadUtils.checkIsOnMainThread();
        object = new CountDownLatch(1);
        this.releaseEglSurface((Runnable)new _$.Lambda.5k6tNlswoNAjCdgttrkQIe8VHVs((CountDownLatch)object));
        ThreadUtils.awaitUninterruptibly((CountDownLatch)object);
    }
}

