/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.HashMap;
import org.webrtc.LibvpxVp8Decoder;
import org.webrtc.LibvpxVp9Decoder;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;

public class SoftwareVideoDecoderFactory
implements VideoDecoderFactory {
    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Decoder.nativeIsSupported()) {
            arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
    }

    @Override
    @Deprecated
    public VideoDecoder createDecoder(String string2) {
        return this.createDecoder(new VideoCodecInfo(string2, new HashMap<String, String>()));
    }

    @Override
    public VideoDecoder createDecoder(VideoCodecInfo videoCodecInfo) {
        if (videoCodecInfo.getName().equalsIgnoreCase("VP8")) {
            return new LibvpxVp8Decoder();
        }
        if (videoCodecInfo.getName().equalsIgnoreCase("VP9") && LibvpxVp9Decoder.nativeIsSupported()) {
            return new LibvpxVp9Decoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoDecoderFactory.supportedCodecs();
    }
}

