/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Handler;
import android.view.Surface;
import org.webrtc.CapturerObserver;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

@TargetApi(value=21)
public class ScreenCapturerAndroid
implements VideoCapturer,
VideoSink {
    private static final int DISPLAY_FLAGS = 3;
    private static final int VIRTUAL_DISPLAY_DPI = 400;
    private CapturerObserver capturerObserver;
    private int height;
    private boolean isDisposed;
    private MediaProjection mediaProjection;
    private final MediaProjection.Callback mediaProjectionCallback;
    private MediaProjectionManager mediaProjectionManager;
    private final Intent mediaProjectionPermissionResultData;
    private long numCapturedFrames;
    private SurfaceTextureHelper surfaceTextureHelper;
    private VirtualDisplay virtualDisplay;
    private int width;

    public ScreenCapturerAndroid(Intent intent, MediaProjection.Callback callback) {
        this.mediaProjectionPermissionResultData = intent;
        this.mediaProjectionCallback = callback;
    }

    static /* synthetic */ VirtualDisplay access$202(ScreenCapturerAndroid screenCapturerAndroid, VirtualDisplay virtualDisplay) {
        screenCapturerAndroid.virtualDisplay = virtualDisplay;
        return virtualDisplay;
    }

    static /* synthetic */ MediaProjection access$302(ScreenCapturerAndroid screenCapturerAndroid, MediaProjection mediaProjection) {
        screenCapturerAndroid.mediaProjection = mediaProjection;
        return mediaProjection;
    }

    private void checkNotDisposed() {
        if (!this.isDisposed) {
            return;
        }
        throw new RuntimeException("capturer is disposed.");
    }

    private void createVirtualDisplay() {
        this.surfaceTextureHelper.setTextureSize(this.width, this.height);
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", this.width, this.height, 400, 3, new Surface(this.surfaceTextureHelper.getSurfaceTexture()), null, null);
    }

    @Override
    public void changeCaptureFormat(int n2, int n3, int n4) {
        synchronized (this) {
            VirtualDisplay virtualDisplay;
            block4: {
                this.checkNotDisposed();
                this.width = n2;
                this.height = n3;
                virtualDisplay = this.virtualDisplay;
                if (virtualDisplay != null) break block4;
                return;
            }
            virtualDisplay = this.surfaceTextureHelper.getHandler();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ScreenCapturerAndroid.this.virtualDisplay.release();
                    ScreenCapturerAndroid.this.createVirtualDisplay();
                }
            };
            ThreadUtils.invokeAtFrontUninterruptibly((Handler)virtualDisplay, runnable);
            return;
        }
    }

    @Override
    public void dispose() {
        synchronized (this) {
            this.isDisposed = true;
            return;
        }
    }

    public long getNumCapturedFrames() {
        return this.numCapturedFrames;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(SurfaceTextureHelper object, Context context, CapturerObserver capturerObserver) {
        synchronized (this) {
            void var3_3;
            this.checkNotDisposed();
            if (var3_3 == null) {
                object = new RuntimeException("capturerObserver not set.");
                throw object;
            }
            this.capturerObserver = var3_3;
            if (object != null) {
                void var2_2;
                this.surfaceTextureHelper = object;
                this.mediaProjectionManager = (MediaProjectionManager)var2_2.getSystemService("media_projection");
                return;
            }
            object = new RuntimeException("surfaceTextureHelper not set.");
            throw object;
        }
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        ++this.numCapturedFrames;
        this.capturerObserver.onFrameCaptured(videoFrame);
    }

    @Override
    public void startCapture(int n2, int n3, int n4) {
        synchronized (this) {
            MediaProjection mediaProjection;
            this.checkNotDisposed();
            this.width = n2;
            this.height = n3;
            this.mediaProjection = mediaProjection = this.mediaProjectionManager.getMediaProjection(-1, this.mediaProjectionPermissionResultData);
            mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
            this.createVirtualDisplay();
            this.capturerObserver.onCapturerStarted(true);
            this.surfaceTextureHelper.startListening(this);
            return;
        }
    }

    @Override
    public void stopCapture() {
        synchronized (this) {
            this.checkNotDisposed();
            Handler handler = this.surfaceTextureHelper.getHandler();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ScreenCapturerAndroid.this.surfaceTextureHelper.stopListening();
                    ScreenCapturerAndroid.this.capturerObserver.onCapturerStopped();
                    if (ScreenCapturerAndroid.this.virtualDisplay != null) {
                        ScreenCapturerAndroid.this.virtualDisplay.release();
                        ScreenCapturerAndroid.access$202(ScreenCapturerAndroid.this, null);
                    }
                    if (ScreenCapturerAndroid.this.mediaProjection != null) {
                        ScreenCapturerAndroid.this.mediaProjection.unregisterCallback(ScreenCapturerAndroid.this.mediaProjectionCallback);
                        ScreenCapturerAndroid.this.mediaProjection.stop();
                        ScreenCapturerAndroid.access$302(ScreenCapturerAndroid.this, null);
                    }
                }
            };
            ThreadUtils.invokeAtFrontUninterruptibly(handler, runnable);
            return;
        }
    }
}

