/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;

public class RtpTransceiver {
    private RtpReceiver cachedReceiver;
    private RtpSender cachedSender;
    private long nativeRtpTransceiver;

    @CalledByNative
    protected RtpTransceiver(long l3) {
        this.nativeRtpTransceiver = l3;
        this.cachedSender = RtpTransceiver.nativeGetSender(l3);
        this.cachedReceiver = RtpTransceiver.nativeGetReceiver(l3);
    }

    private void checkRtpTransceiverExists() {
        if (this.nativeRtpTransceiver != 0L) {
            return;
        }
        throw new IllegalStateException("RtpTransceiver has been disposed.");
    }

    private static native RtpTransceiverDirection nativeCurrentDirection(long var0);

    private static native RtpTransceiverDirection nativeDirection(long var0);

    private static native MediaStreamTrack.MediaType nativeGetMediaType(long var0);

    private static native String nativeGetMid(long var0);

    private static native RtpReceiver nativeGetReceiver(long var0);

    private static native RtpSender nativeGetSender(long var0);

    private static native void nativeSetDirection(long var0, RtpTransceiverDirection var2);

    private static native void nativeStop(long var0);

    private static native boolean nativeStopped(long var0);

    @CalledByNative
    public void dispose() {
        this.checkRtpTransceiverExists();
        this.cachedSender.dispose();
        this.cachedReceiver.dispose();
        JniCommon.nativeReleaseRef(this.nativeRtpTransceiver);
        this.nativeRtpTransceiver = 0L;
    }

    public RtpTransceiverDirection getCurrentDirection() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeCurrentDirection(this.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getDirection() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeDirection(this.nativeRtpTransceiver);
    }

    public MediaStreamTrack.MediaType getMediaType() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMediaType(this.nativeRtpTransceiver);
    }

    public String getMid() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMid(this.nativeRtpTransceiver);
    }

    public RtpReceiver getReceiver() {
        return this.cachedReceiver;
    }

    public RtpSender getSender() {
        return this.cachedSender;
    }

    public boolean isStopped() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeStopped(this.nativeRtpTransceiver);
    }

    public void setDirection(RtpTransceiverDirection rtpTransceiverDirection) {
        this.checkRtpTransceiverExists();
        RtpTransceiver.nativeSetDirection(this.nativeRtpTransceiver, rtpTransceiverDirection);
    }

    public void stop() {
        this.checkRtpTransceiverExists();
        RtpTransceiver.nativeStop(this.nativeRtpTransceiver);
    }

    public static final class RtpTransceiverDirection
    extends Enum<RtpTransceiverDirection> {
        private static final /* synthetic */ RtpTransceiverDirection[] $VALUES;
        public static final /* enum */ RtpTransceiverDirection INACTIVE;
        public static final /* enum */ RtpTransceiverDirection RECV_ONLY;
        public static final /* enum */ RtpTransceiverDirection SEND_ONLY;
        public static final /* enum */ RtpTransceiverDirection SEND_RECV;
        private final int nativeIndex;

        static {
            RtpTransceiverDirection rtpTransceiverDirection;
            SEND_RECV = new RtpTransceiverDirection(0);
            SEND_ONLY = new RtpTransceiverDirection(1);
            RECV_ONLY = new RtpTransceiverDirection(2);
            INACTIVE = rtpTransceiverDirection = new RtpTransceiverDirection(3);
            $VALUES = new RtpTransceiverDirection[]{SEND_RECV, SEND_ONLY, RECV_ONLY, rtpTransceiverDirection};
        }

        private RtpTransceiverDirection(int n3) {
            this.nativeIndex = n3;
        }

        @CalledByNative(value="RtpTransceiverDirection")
        static RtpTransceiverDirection fromNativeIndex(int n2) {
            for (RtpTransceiverDirection rtpTransceiverDirection : RtpTransceiverDirection.values()) {
                if (rtpTransceiverDirection.getNativeIndex() != n2) continue;
                return rtpTransceiverDirection;
            }
            Object object = new StringBuilder();
            ((StringBuilder)object).append("Uknown native RtpTransceiverDirection type");
            ((StringBuilder)object).append(n2);
            object = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object;
        }

        public static RtpTransceiverDirection valueOf(String string2) {
            return Enum.valueOf(RtpTransceiverDirection.class, string2);
        }

        public static RtpTransceiverDirection[] values() {
            return (RtpTransceiverDirection[])$VALUES.clone();
        }

        @CalledByNative(value="RtpTransceiverDirection")
        int getNativeIndex() {
            return this.nativeIndex;
        }
    }

    public static final class RtpTransceiverInit {
        private final RtpTransceiverDirection direction;
        private final List<RtpParameters.Encoding> sendEncodings;
        private final List<String> streamIds;

        public RtpTransceiverInit() {
            this(RtpTransceiverDirection.SEND_RECV);
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection) {
            this(rtpTransceiverDirection, Collections.emptyList(), Collections.emptyList());
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection, List<String> list) {
            this(rtpTransceiverDirection, list, Collections.emptyList());
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection, List<String> list, List<RtpParameters.Encoding> list2) {
            this.direction = rtpTransceiverDirection;
            this.streamIds = new ArrayList<String>(list);
            this.sendEncodings = new ArrayList<RtpParameters.Encoding>(list2);
        }

        @CalledByNative(value="RtpTransceiverInit")
        int getDirectionNativeIndex() {
            return this.direction.getNativeIndex();
        }

        @CalledByNative(value="RtpTransceiverInit")
        List<RtpParameters.Encoding> getSendEncodings() {
            return new ArrayList<RtpParameters.Encoding>(this.sendEncodings);
        }

        @CalledByNative(value="RtpTransceiverInit")
        List<String> getStreamIds() {
            return new ArrayList<String>(this.streamIds);
        }
    }
}

