/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.DtmfSender;
import org.webrtc.FrameEncryptor;
import org.webrtc.JniCommon;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;

public class RtpSender {
    private MediaStreamTrack cachedTrack;
    private final DtmfSender dtmfSender;
    private long nativeRtpSender;
    private boolean ownsTrack = true;

    @CalledByNative
    public RtpSender(long l3) {
        this.nativeRtpSender = l3;
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(RtpSender.nativeGetTrack(l3));
        l3 = RtpSender.nativeGetDtmfSender(l3);
        DtmfSender dtmfSender = l3 != 0L ? new DtmfSender(l3) : null;
        this.dtmfSender = dtmfSender;
    }

    private void checkRtpSenderExists() {
        if (this.nativeRtpSender != 0L) {
            return;
        }
        throw new IllegalStateException("RtpSender has been disposed.");
    }

    private static native long nativeGetDtmfSender(long var0);

    private static native String nativeGetId(long var0);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native List<String> nativeGetStreams(long var0);

    private static native long nativeGetTrack(long var0);

    private static native void nativeSetFrameEncryptor(long var0, long var2);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native void nativeSetStreams(long var0, List<String> var2);

    private static native boolean nativeSetTrack(long var0, long var2);

    public void dispose() {
        this.checkRtpSenderExists();
        Object object = this.dtmfSender;
        if (object != null) {
            ((DtmfSender)object).dispose();
        }
        if ((object = this.cachedTrack) != null && this.ownsTrack) {
            ((MediaStreamTrack)object).dispose();
        }
        JniCommon.nativeReleaseRef(this.nativeRtpSender);
        this.nativeRtpSender = 0L;
    }

    public DtmfSender dtmf() {
        return this.dtmfSender;
    }

    long getNativeRtpSender() {
        this.checkRtpSenderExists();
        return this.nativeRtpSender;
    }

    public RtpParameters getParameters() {
        this.checkRtpSenderExists();
        return RtpSender.nativeGetParameters(this.nativeRtpSender);
    }

    public List<String> getStreams() {
        this.checkRtpSenderExists();
        return RtpSender.nativeGetStreams(this.nativeRtpSender);
    }

    public String id() {
        this.checkRtpSenderExists();
        return RtpSender.nativeGetId(this.nativeRtpSender);
    }

    public void setFrameEncryptor(FrameEncryptor frameEncryptor) {
        this.checkRtpSenderExists();
        RtpSender.nativeSetFrameEncryptor(this.nativeRtpSender, frameEncryptor.getNativeFrameEncryptor());
    }

    public boolean setParameters(RtpParameters rtpParameters) {
        this.checkRtpSenderExists();
        return RtpSender.nativeSetParameters(this.nativeRtpSender, rtpParameters);
    }

    public void setStreams(List<String> list) {
        this.checkRtpSenderExists();
        RtpSender.nativeSetStreams(this.nativeRtpSender, list);
    }

    public boolean setTrack(MediaStreamTrack mediaStreamTrack, boolean bl) {
        this.checkRtpSenderExists();
        long l3 = this.nativeRtpSender;
        long l4 = mediaStreamTrack == null ? 0L : mediaStreamTrack.getNativeMediaStreamTrack();
        if (!RtpSender.nativeSetTrack(l3, l4)) {
            return false;
        }
        MediaStreamTrack mediaStreamTrack2 = this.cachedTrack;
        if (mediaStreamTrack2 != null && this.ownsTrack) {
            mediaStreamTrack2.dispose();
        }
        this.cachedTrack = mediaStreamTrack;
        this.ownsTrack = bl;
        return true;
    }

    public MediaStreamTrack track() {
        return this.cachedTrack;
    }
}

