/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.FrameDecryptor;
import org.webrtc.JniCommon;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;

public class RtpReceiver {
    private MediaStreamTrack cachedTrack;
    private long nativeObserver;
    private long nativeRtpReceiver;

    @CalledByNative
    public RtpReceiver(long l3) {
        this.nativeRtpReceiver = l3;
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(RtpReceiver.nativeGetTrack(l3));
    }

    private void checkRtpReceiverExists() {
        if (this.nativeRtpReceiver != 0L) {
            return;
        }
        throw new IllegalStateException("RtpReceiver has been disposed.");
    }

    private static native String nativeGetId(long var0);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native long nativeGetTrack(long var0);

    private static native void nativeSetFrameDecryptor(long var0, long var2);

    private static native long nativeSetObserver(long var0, Observer var2);

    private static native void nativeUnsetObserver(long var0, long var2);

    public void SetObserver(Observer observer) {
        this.checkRtpReceiverExists();
        long l3 = this.nativeObserver;
        if (l3 != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, l3);
        }
        this.nativeObserver = RtpReceiver.nativeSetObserver(this.nativeRtpReceiver, observer);
    }

    @CalledByNative
    public void dispose() {
        this.checkRtpReceiverExists();
        this.cachedTrack.dispose();
        long l3 = this.nativeObserver;
        if (l3 != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, l3);
            this.nativeObserver = 0L;
        }
        JniCommon.nativeReleaseRef(this.nativeRtpReceiver);
        this.nativeRtpReceiver = 0L;
    }

    public RtpParameters getParameters() {
        this.checkRtpReceiverExists();
        return RtpReceiver.nativeGetParameters(this.nativeRtpReceiver);
    }

    public String id() {
        this.checkRtpReceiverExists();
        return RtpReceiver.nativeGetId(this.nativeRtpReceiver);
    }

    public void setFrameDecryptor(FrameDecryptor frameDecryptor) {
        this.checkRtpReceiverExists();
        RtpReceiver.nativeSetFrameDecryptor(this.nativeRtpReceiver, frameDecryptor.getNativeFrameDecryptor());
    }

    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onFirstPacketReceived(MediaStreamTrack.MediaType var1);
    }
}

