/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.List;
import java.util.Map;
import org.webrtc.CalledByNative;
import org.webrtc.MediaStreamTrack;

public class RtpParameters {
    public final List<Codec> codecs;
    public DegradationPreference degradationPreference;
    public final List<Encoding> encodings;
    private final List<HeaderExtension> headerExtensions;
    private final Rtcp rtcp;
    public final String transactionId;

    @CalledByNative
    RtpParameters(String string2, DegradationPreference degradationPreference, Rtcp rtcp, List<HeaderExtension> list, List<Encoding> list2, List<Codec> list3) {
        this.transactionId = string2;
        this.degradationPreference = degradationPreference;
        this.rtcp = rtcp;
        this.headerExtensions = list;
        this.encodings = list2;
        this.codecs = list3;
    }

    @CalledByNative
    List<Codec> getCodecs() {
        return this.codecs;
    }

    @CalledByNative
    DegradationPreference getDegradationPreference() {
        return this.degradationPreference;
    }

    @CalledByNative
    List<Encoding> getEncodings() {
        return this.encodings;
    }

    @CalledByNative
    public List<HeaderExtension> getHeaderExtensions() {
        return this.headerExtensions;
    }

    @CalledByNative
    public Rtcp getRtcp() {
        return this.rtcp;
    }

    @CalledByNative
    String getTransactionId() {
        return this.transactionId;
    }

    public static class Codec {
        public Integer clockRate;
        MediaStreamTrack.MediaType kind;
        public String name;
        public Integer numChannels;
        public Map<String, String> parameters;
        public int payloadType;

        @CalledByNative(value="Codec")
        Codec(int n2, String string2, MediaStreamTrack.MediaType mediaType, Integer n3, Integer n4, Map<String, String> map) {
            this.payloadType = n2;
            this.name = string2;
            this.kind = mediaType;
            this.clockRate = n3;
            this.numChannels = n4;
            this.parameters = map;
        }

        @CalledByNative(value="Codec")
        Integer getClockRate() {
            return this.clockRate;
        }

        @CalledByNative(value="Codec")
        MediaStreamTrack.MediaType getKind() {
            return this.kind;
        }

        @CalledByNative(value="Codec")
        String getName() {
            return this.name;
        }

        @CalledByNative(value="Codec")
        Integer getNumChannels() {
            return this.numChannels;
        }

        @CalledByNative(value="Codec")
        Map getParameters() {
            return this.parameters;
        }

        @CalledByNative(value="Codec")
        int getPayloadType() {
            return this.payloadType;
        }
    }

    public static final class DegradationPreference
    extends Enum<DegradationPreference> {
        private static final /* synthetic */ DegradationPreference[] $VALUES;
        public static final /* enum */ DegradationPreference BALANCED;
        public static final /* enum */ DegradationPreference DISABLED;
        public static final /* enum */ DegradationPreference MAINTAIN_FRAMERATE;
        public static final /* enum */ DegradationPreference MAINTAIN_RESOLUTION;

        static {
            DegradationPreference degradationPreference;
            DISABLED = new DegradationPreference();
            MAINTAIN_FRAMERATE = new DegradationPreference();
            MAINTAIN_RESOLUTION = new DegradationPreference();
            BALANCED = degradationPreference = new DegradationPreference();
            $VALUES = new DegradationPreference[]{DISABLED, MAINTAIN_FRAMERATE, MAINTAIN_RESOLUTION, degradationPreference};
        }

        @CalledByNative(value="DegradationPreference")
        static DegradationPreference fromNativeIndex(int n2) {
            return DegradationPreference.values()[n2];
        }

        public static DegradationPreference valueOf(String string2) {
            return Enum.valueOf(DegradationPreference.class, string2);
        }

        public static DegradationPreference[] values() {
            return (DegradationPreference[])$VALUES.clone();
        }
    }

    public static class Encoding {
        public boolean active = true;
        public Integer maxBitrateBps;
        public Integer maxFramerate;
        public Integer minBitrateBps;
        public Integer numTemporalLayers;
        public String rid;
        public Double scaleResolutionDownBy;
        public Long ssrc;

        public Encoding(String string2, boolean bl, Double d3) {
            this.rid = string2;
            this.active = bl;
            this.scaleResolutionDownBy = d3;
        }

        @CalledByNative(value="Encoding")
        Encoding(String string2, boolean bl, Integer n2, Integer n3, Integer n4, Integer n5, Double d3, Long l3) {
            this.rid = string2;
            this.active = bl;
            this.maxBitrateBps = n2;
            this.minBitrateBps = n3;
            this.maxFramerate = n4;
            this.numTemporalLayers = n5;
            this.scaleResolutionDownBy = d3;
            this.ssrc = l3;
        }

        @CalledByNative(value="Encoding")
        boolean getActive() {
            return this.active;
        }

        @CalledByNative(value="Encoding")
        Integer getMaxBitrateBps() {
            return this.maxBitrateBps;
        }

        @CalledByNative(value="Encoding")
        Integer getMaxFramerate() {
            return this.maxFramerate;
        }

        @CalledByNative(value="Encoding")
        Integer getMinBitrateBps() {
            return this.minBitrateBps;
        }

        @CalledByNative(value="Encoding")
        Integer getNumTemporalLayers() {
            return this.numTemporalLayers;
        }

        @CalledByNative(value="Encoding")
        String getRid() {
            return this.rid;
        }

        @CalledByNative(value="Encoding")
        Double getScaleResolutionDownBy() {
            return this.scaleResolutionDownBy;
        }

        @CalledByNative(value="Encoding")
        Long getSsrc() {
            return this.ssrc;
        }
    }

    public static class HeaderExtension {
        private final boolean encrypted;
        private final int id;
        private final String uri;

        @CalledByNative(value="HeaderExtension")
        HeaderExtension(String string2, int n2, boolean bl) {
            this.uri = string2;
            this.id = n2;
            this.encrypted = bl;
        }

        @CalledByNative(value="HeaderExtension")
        public boolean getEncrypted() {
            return this.encrypted;
        }

        @CalledByNative(value="HeaderExtension")
        public int getId() {
            return this.id;
        }

        @CalledByNative(value="HeaderExtension")
        public String getUri() {
            return this.uri;
        }
    }

    public static class Rtcp {
        private final String cname;
        private final boolean reducedSize;

        @CalledByNative(value="Rtcp")
        Rtcp(String string2, boolean bl) {
            this.cname = string2;
            this.reducedSize = bl;
        }

        @CalledByNative(value="Rtcp")
        public String getCname() {
            return this.cname;
        }

        @CalledByNative(value="Rtcp")
        public boolean getReducedSize() {
            return this.reducedSize;
        }
    }
}

