/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Point;
import android.opengl.Matrix;
import android.view.View;

public class RendererCommon {
    private static float BALANCED_VISIBLE_FRACTION = 0.5625f;

    private static void adjustOrigin(float[] fArray) {
        fArray[12] = fArray[12] - (fArray[0] + fArray[4]) * 0.5f;
        fArray[13] = fArray[13] - (fArray[1] + fArray[5]) * 0.5f;
        fArray[12] = fArray[12] + 0.5f;
        fArray[13] = fArray[13] + 0.5f;
    }

    public static float[] convertMatrixFromAndroidGraphicsMatrix(android.graphics.Matrix matrix) {
        float[] fArray = new float[9];
        matrix.getValues(fArray);
        return new float[]{fArray[0], fArray[3], 0.0f, fArray[6], fArray[1], fArray[4], 0.0f, fArray[7], 0.0f, 0.0f, 1.0f, 0.0f, fArray[2], fArray[5], 0.0f, fArray[8]};
    }

    public static android.graphics.Matrix convertMatrixToAndroidGraphicsMatrix(float[] object) {
        float f3 = object[0];
        float f4 = object[4];
        float f5 = object[12];
        float f6 = object[1];
        float f7 = object[5];
        float f8 = object[13];
        float f9 = object[3];
        float f10 = object[7];
        float f11 = object[15];
        object = new android.graphics.Matrix();
        object.setValues(new float[]{f3, f4, f5, f6, f7, f8, f9, f10, f11});
        return object;
    }

    private static float convertScalingTypeToVisibleFraction(ScalingType scalingType) {
        int n2 = 1.$SwitchMap$org$webrtc$RendererCommon$ScalingType[scalingType.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 == 3) {
                    return BALANCED_VISIBLE_FRACTION;
                }
                throw new IllegalArgumentException();
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public static Point getDisplaySize(float f3, float f4, int n2, int n3) {
        if (f3 != 0.0f && f4 != 0.0f) {
            return new Point(Math.min(n2, Math.round((float)n3 / f3 * f4)), Math.min(n3, Math.round((float)n2 / f3 / f4)));
        }
        return new Point(n2, n3);
    }

    public static Point getDisplaySize(ScalingType scalingType, float f3, int n2, int n3) {
        return RendererCommon.getDisplaySize(RendererCommon.convertScalingTypeToVisibleFraction(scalingType), f3, n2, n3);
    }

    public static float[] getLayoutMatrix(boolean bl, float f3, float f4) {
        if (f4 > f3) {
            f4 = f3 / f4;
            f3 = 1.0f;
        } else {
            f3 = f4 / f3;
            f4 = 1.0f;
        }
        float f5 = f3;
        if (bl) {
            f5 = f3 * -1.0f;
        }
        float[] fArray = new float[16];
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)f5, (float)f4, (float)1.0f);
        RendererCommon.adjustOrigin(fArray);
        return fArray;
    }

    public static interface GlDrawer {
        public void drawOes(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawRgb(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawYuv(int[] var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void release();
    }

    public static interface RendererEvents {
        public void onFirstFrameRendered();

        public void onFrameResolutionChanged(int var1, int var2, int var3);
    }

    public static final class ScalingType
    extends Enum<ScalingType> {
        private static final /* synthetic */ ScalingType[] $VALUES;
        public static final /* enum */ ScalingType SCALE_ASPECT_BALANCED;
        public static final /* enum */ ScalingType SCALE_ASPECT_FILL;
        public static final /* enum */ ScalingType SCALE_ASPECT_FIT;

        static {
            ScalingType scalingType;
            SCALE_ASPECT_FIT = new ScalingType();
            SCALE_ASPECT_FILL = new ScalingType();
            SCALE_ASPECT_BALANCED = scalingType = new ScalingType();
            $VALUES = new ScalingType[]{SCALE_ASPECT_FIT, SCALE_ASPECT_FILL, scalingType};
        }

        public static ScalingType valueOf(String string2) {
            return Enum.valueOf(ScalingType.class, string2);
        }

        public static ScalingType[] values() {
            return (ScalingType[])$VALUES.clone();
        }
    }

    public static class VideoLayoutMeasure {
        private float visibleFractionMatchOrientation = RendererCommon.access$000(ScalingType.SCALE_ASPECT_BALANCED);
        private float visibleFractionMismatchOrientation = RendererCommon.access$000(ScalingType.SCALE_ASPECT_BALANCED);

        public Point measure(int n2, int n3, int n4, int n5) {
            int n6 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)n2);
            int n7 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)n3);
            if (n4 != 0 && n5 != 0 && n6 != 0 && n7 != 0) {
                float f3 = (float)n4 / (float)n5;
                float f4 = (float)n6 / (float)n7;
                n5 = 1;
                n4 = f3 > 1.0f ? 1 : 0;
                if (!(f4 > 1.0f)) {
                    n5 = 0;
                }
                f4 = n4 == n5 ? this.visibleFractionMatchOrientation : this.visibleFractionMismatchOrientation;
                Point point = RendererCommon.getDisplaySize(f4, f3, n6, n7);
                if (View.MeasureSpec.getMode((int)n2) == 0x40000000) {
                    point.x = n6;
                }
                if (View.MeasureSpec.getMode((int)n3) == 0x40000000) {
                    point.y = n7;
                }
                return point;
            }
            return new Point(n6, n7);
        }

        public void setScalingType(ScalingType scalingType) {
            this.setScalingType(scalingType, scalingType);
        }

        public void setScalingType(ScalingType scalingType, ScalingType scalingType2) {
            this.visibleFractionMatchOrientation = RendererCommon.convertScalingTypeToVisibleFraction(scalingType);
            this.visibleFractionMismatchOrientation = RendererCommon.convertScalingTypeToVisibleFraction(scalingType2);
        }

        public void setVisibleFraction(float f3, float f4) {
            this.visibleFractionMatchOrientation = f3;
            this.visibleFractionMismatchOrientation = f4;
        }
    }
}

