/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.concurrent.atomic.AtomicInteger;
import org.webrtc.RefCounted;

class RefCountDelegate
implements RefCounted {
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final Runnable releaseCallback;

    public RefCountDelegate(Runnable runnable) {
        this.releaseCallback = runnable;
    }

    @Override
    public void release() {
        int n2 = this.refCount.decrementAndGet();
        if (n2 >= 0) {
            Runnable runnable;
            if (n2 == 0 && (runnable = this.releaseCallback) != null) {
                runnable.run();
            }
            return;
        }
        throw new IllegalStateException("release() called on an object with refcount < 1");
    }

    @Override
    public void retain() {
        if (this.refCount.incrementAndGet() >= 2) {
            return;
        }
        throw new IllegalStateException("retain() called on an object with refcount < 1");
    }
}

