/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.Iterator;
import java.util.Map;
import org.webrtc.CalledByNative;
import org.webrtc.RTCStats;

public class RTCStatsReport {
    private final Map<String, RTCStats> stats;
    private final long timestampUs;

    public RTCStatsReport(long l3, Map<String, RTCStats> map) {
        this.timestampUs = l3;
        this.stats = map;
    }

    @CalledByNative
    private static RTCStatsReport create(long l3, Map map) {
        return new RTCStatsReport(l3, map);
    }

    public Map<String, RTCStats> getStatsMap() {
        return this.stats;
    }

    public double getTimestampUs() {
        return this.timestampUs;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ timestampUs: ");
        stringBuilder.append(this.timestampUs);
        stringBuilder.append(", stats: [\n");
        Iterator<RTCStats> iterator = this.stats.values().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            RTCStats rTCStats = iterator.next();
            if (!bl) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append(rTCStats);
            bl = false;
        }
        stringBuilder.append(" ] }");
        return stringBuilder.toString();
    }
}

