/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.Map;
import org.webrtc.CalledByNative;

public class RTCStats {
    private final String id;
    private final Map<String, Object> members;
    private final long timestampUs;
    private final String type;

    public RTCStats(long l3, String string2, String string3, Map<String, Object> map) {
        this.timestampUs = l3;
        this.type = string2;
        this.id = string3;
        this.members = map;
    }

    private static void appendValue(StringBuilder stringBuilder, Object objectArray) {
        if (objectArray instanceof Object[]) {
            objectArray = objectArray;
            stringBuilder.append('[');
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                if (i3 != 0) {
                    stringBuilder.append(", ");
                }
                RTCStats.appendValue(stringBuilder, objectArray[i3]);
            }
            stringBuilder.append(']');
        } else if (objectArray instanceof String) {
            stringBuilder.append('\"');
            stringBuilder.append(objectArray);
            stringBuilder.append('\"');
        } else {
            stringBuilder.append(objectArray);
        }
    }

    @CalledByNative
    static RTCStats create(long l3, String string2, String string3, Map map) {
        return new RTCStats(l3, string2, string3, map);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getMembers() {
        return this.members;
    }

    public double getTimestampUs() {
        return this.timestampUs;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ timestampUs: ");
        stringBuilder.append(this.timestampUs);
        stringBuilder.append(", type: ");
        stringBuilder.append(this.type);
        stringBuilder.append(", id: ");
        stringBuilder.append(this.id);
        for (Map.Entry<String, Object> entry : this.members.entrySet()) {
            stringBuilder.append(", ");
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            RTCStats.appendValue(stringBuilder, entry.getValue());
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

