/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.Process;
import java.util.List;
import org.webrtc.AudioDecoderFactoryFactory;
import org.webrtc.AudioEncoderFactoryFactory;
import org.webrtc.AudioProcessingFactory;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.BuiltinAudioDecoderFactoryFactory;
import org.webrtc.BuiltinAudioEncoderFactoryFactory;
import org.webrtc.CalledByNative;
import org.webrtc.ContextUtils;
import org.webrtc.FecControllerFactoryFactoryInterface;
import org.webrtc.JNILogging;
import org.webrtc.Loggable;
import org.webrtc.Logging;
import org.webrtc.MediaCodecVideoDecoder;
import org.webrtc.MediaCodecVideoEncoder;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaTransportFactoryFactory;
import org.webrtc.NativeLibrary;
import org.webrtc.NativeLibraryLoader;
import org.webrtc.NetEqFactoryFactory;
import org.webrtc.NetworkControllerFactoryFactory;
import org.webrtc.NetworkStatePredictorFactoryFactory;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionDependencies;
import org.webrtc.SSLCertificateVerifier;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;

public class PeerConnectionFactory {
    private static final String TAG = "PeerConnectionFactory";
    public static final String TRIAL_ENABLED = "Enabled";
    private static final String VIDEO_CAPTURER_THREAD_NAME = "VideoCapturerThread";
    @Deprecated
    public static final String VIDEO_FRAME_EMIT_TRIAL = "VideoFrameEmit";
    private static volatile boolean internalTracerInitialized;
    private static ThreadInfo staticNetworkThread;
    private static ThreadInfo staticSignalingThread;
    private static ThreadInfo staticWorkerThread;
    private long nativeFactory;
    private volatile ThreadInfo networkThread;
    private volatile ThreadInfo signalingThread;
    private volatile ThreadInfo workerThread;

    @CalledByNative
    PeerConnectionFactory(long l3) {
        PeerConnectionFactory.checkInitializeHasBeenCalled();
        if (l3 != 0L) {
            this.nativeFactory = l3;
            return;
        }
        throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void checkInitializeHasBeenCalled() {
        if (NativeLibrary.isLoaded() && ContextUtils.getApplicationContext() != null) {
            return;
        }
        throw new IllegalStateException("PeerConnectionFactory.initialize was not called before creating a PeerConnectionFactory.");
    }

    private void checkPeerConnectionFactoryExists() {
        if (this.nativeFactory != 0L) {
            return;
        }
        throw new IllegalStateException("PeerConnectionFactory has been disposed.");
    }

    public static String fieldTrialsFindFullName(String string2) {
        string2 = NativeLibrary.isLoaded() ? PeerConnectionFactory.nativeFindFieldTrialsFullName(string2) : "";
        return string2;
    }

    public static void initialize(InitializationOptions initializationOptions) {
        Loggable loggable;
        ContextUtils.initialize((Context)initializationOptions.applicationContext);
        NativeLibrary.initialize(initializationOptions.nativeLibraryLoader, initializationOptions.nativeLibraryName);
        PeerConnectionFactory.nativeInitializeAndroidGlobals();
        PeerConnectionFactory.nativeInitializeFieldTrials(initializationOptions.fieldTrials);
        if (initializationOptions.enableInternalTracer && !internalTracerInitialized) {
            PeerConnectionFactory.initializeInternalTracer();
        }
        if ((loggable = initializationOptions.loggable) != null) {
            Logging.injectLoggable(loggable, initializationOptions.loggableSeverity);
            PeerConnectionFactory.nativeInjectLoggable(new JNILogging(initializationOptions.loggable), initializationOptions.loggableSeverity.ordinal());
        } else {
            Logging.d(TAG, "PeerConnectionFactory was initialized without an injected Loggable. Any existing Loggable will be deleted.");
            Logging.deleteInjectedLoggable();
            PeerConnectionFactory.nativeDeleteLoggable();
        }
    }

    @Deprecated
    public static void initializeFieldTrials(String string2) {
        PeerConnectionFactory.nativeInitializeFieldTrials(string2);
    }

    private static void initializeInternalTracer() {
        internalTracerInitialized = true;
        PeerConnectionFactory.nativeInitializeInternalTracer();
    }

    private static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    private static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    private static native long nativeCreateLocalMediaStream(long var0, String var2);

    private static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4, SSLCertificateVerifier var6);

    private static native PeerConnectionFactory nativeCreatePeerConnectionFactory(Context var0, Options var1, long var2, long var4, long var6, VideoEncoderFactory var8, VideoDecoderFactory var9, long var10, long var12, long var14, long var16, long var18, long var20);

    private static native long nativeCreateVideoSource(long var0, boolean var2, boolean var3);

    private static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    private static native void nativeDeleteLoggable();

    private static native String nativeFindFieldTrialsFullName(String var0);

    private static native void nativeFreeFactory(long var0);

    private static native long nativeGetNativePeerConnectionFactory(long var0);

    private static native void nativeInitializeAndroidGlobals();

    private static native void nativeInitializeFieldTrials(String var0);

    private static native void nativeInitializeInternalTracer();

    private static native void nativeInjectLoggable(JNILogging var0, int var1);

    private static native void nativePrintStackTrace(int var0);

    private static native void nativePrintStackTracesOfRegisteredThreads();

    private static native void nativeShutdownInternalTracer();

    private static native boolean nativeStartAecDump(long var0, int var2, int var3);

    private static native boolean nativeStartInternalTracingCapture(String var0);

    private static native void nativeStopAecDump(long var0);

    private static native void nativeStopInternalTracingCapture();

    @CalledByNative
    private void onNetworkThreadReady() {
        staticNetworkThread = this.networkThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onNetworkThreadReady");
    }

    @CalledByNative
    private void onSignalingThreadReady() {
        staticSignalingThread = this.signalingThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onSignalingThreadReady");
    }

    @CalledByNative
    private void onWorkerThreadReady() {
        staticWorkerThread = this.workerThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onWorkerThreadReady");
    }

    private static void printStackTrace(ThreadInfo threadInfo, boolean bl) {
        if (threadInfo == null) {
            return;
        }
        String string2 = threadInfo.thread.getName();
        Object object = threadInfo.thread.getStackTrace();
        if (((StackTraceElement[])object).length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(" stacktrace:");
            Logging.w(TAG, stringBuilder.toString());
            int n2 = ((Object)object).length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Logging.w(TAG, ((StackTraceElement)object[i3]).toString());
            }
        }
        if (bl) {
            Logging.w(TAG, "*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***");
            object = new StringBuilder();
            ((StringBuilder)object).append("pid: ");
            ((StringBuilder)object).append(Process.myPid());
            ((StringBuilder)object).append(", tid: ");
            ((StringBuilder)object).append(threadInfo.tid);
            ((StringBuilder)object).append(", name: ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("  >>> WebRTC <<<");
            Logging.w(TAG, ((StringBuilder)object).toString());
            PeerConnectionFactory.nativePrintStackTrace(threadInfo.tid);
        }
    }

    @Deprecated
    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(staticNetworkThread, false);
        PeerConnectionFactory.printStackTrace(staticWorkerThread, false);
        PeerConnectionFactory.printStackTrace(staticSignalingThread, false);
    }

    public static void shutdownInternalTracer() {
        internalTracerInitialized = false;
        PeerConnectionFactory.nativeShutdownInternalTracer();
    }

    public static boolean startInternalTracingCapture(String string2) {
        return PeerConnectionFactory.nativeStartInternalTracingCapture(string2);
    }

    public static void stopInternalTracingCapture() {
        PeerConnectionFactory.nativeStopInternalTracingCapture();
    }

    public AudioSource createAudioSource(MediaConstraints mediaConstraints) {
        this.checkPeerConnectionFactoryExists();
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, mediaConstraints));
    }

    public AudioTrack createAudioTrack(String string2, AudioSource audioSource) {
        this.checkPeerConnectionFactoryExists();
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, string2, audioSource.getNativeAudioSource()));
    }

    public MediaStream createLocalMediaStream(String string2) {
        this.checkPeerConnectionFactoryExists();
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, string2));
    }

    @Deprecated
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        return this.createPeerConnection(new PeerConnection.RTCConfiguration(list), mediaConstraints, observer);
    }

    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, PeerConnection.Observer observer) {
        return this.createPeerConnection(new PeerConnection.RTCConfiguration(list), observer);
    }

    @Deprecated
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        return this.createPeerConnectionInternal(rTCConfiguration, mediaConstraints, observer, null);
    }

    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, PeerConnection.Observer observer) {
        return this.createPeerConnection(rTCConfiguration, null, observer);
    }

    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, PeerConnectionDependencies peerConnectionDependencies) {
        return this.createPeerConnectionInternal(rTCConfiguration, null, peerConnectionDependencies.getObserver(), peerConnectionDependencies.getSSLCertificateVerifier());
    }

    PeerConnection createPeerConnectionInternal(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer, SSLCertificateVerifier sSLCertificateVerifier) {
        this.checkPeerConnectionFactoryExists();
        long l3 = PeerConnection.createNativePeerConnectionObserver(observer);
        if (l3 == 0L) {
            return null;
        }
        if ((l3 = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, rTCConfiguration, mediaConstraints, l3, sSLCertificateVerifier)) == 0L) {
            return null;
        }
        return new PeerConnection(l3);
    }

    public VideoSource createVideoSource(boolean bl) {
        return this.createVideoSource(bl, true);
    }

    public VideoSource createVideoSource(boolean bl, boolean bl2) {
        this.checkPeerConnectionFactoryExists();
        return new VideoSource(PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, bl, bl2));
    }

    public VideoTrack createVideoTrack(String string2, VideoSource videoSource) {
        this.checkPeerConnectionFactoryExists();
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, string2, videoSource.getNativeVideoTrackSource()));
    }

    public void dispose() {
        this.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeFreeFactory(this.nativeFactory);
        this.networkThread = null;
        this.workerThread = null;
        this.signalingThread = null;
        MediaCodecVideoEncoder.disposeEglContext();
        MediaCodecVideoDecoder.disposeEglContext();
        this.nativeFactory = 0L;
    }

    public long getNativeOwnedFactoryAndThreads() {
        this.checkPeerConnectionFactoryExists();
        return this.nativeFactory;
    }

    public long getNativePeerConnectionFactory() {
        this.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeGetNativePeerConnectionFactory(this.nativeFactory);
    }

    public void printInternalStackTraces(boolean bl) {
        PeerConnectionFactory.printStackTrace(this.signalingThread, bl);
        PeerConnectionFactory.printStackTrace(this.workerThread, bl);
        PeerConnectionFactory.printStackTrace(this.networkThread, bl);
        if (bl) {
            PeerConnectionFactory.nativePrintStackTracesOfRegisteredThreads();
        }
    }

    public boolean startAecDump(int n2, int n3) {
        this.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeStartAecDump(this.nativeFactory, n2, n3);
    }

    public void stopAecDump() {
        this.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeStopAecDump(this.nativeFactory);
    }

    public static class Builder {
        private AudioDecoderFactoryFactory audioDecoderFactoryFactory;
        private AudioDeviceModule audioDeviceModule;
        private AudioEncoderFactoryFactory audioEncoderFactoryFactory = new BuiltinAudioEncoderFactoryFactory();
        private AudioProcessingFactory audioProcessingFactory;
        private FecControllerFactoryFactoryInterface fecControllerFactoryFactory;
        private MediaTransportFactoryFactory mediaTransportFactoryFactory;
        private NetEqFactoryFactory neteqFactoryFactory;
        private NetworkControllerFactoryFactory networkControllerFactoryFactory;
        private NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory;
        private Options options;
        private VideoDecoderFactory videoDecoderFactory;
        private VideoEncoderFactory videoEncoderFactory;

        private Builder() {
            this.audioDecoderFactoryFactory = new BuiltinAudioDecoderFactoryFactory();
        }

        public PeerConnectionFactory createPeerConnectionFactory() {
            PeerConnectionFactory.checkInitializeHasBeenCalled();
            if (this.audioDeviceModule == null) {
                this.audioDeviceModule = JavaAudioDeviceModule.builder((Context)ContextUtils.getApplicationContext()).createAudioDeviceModule();
            }
            Context context = ContextUtils.getApplicationContext();
            Options options = this.options;
            long l3 = this.audioDeviceModule.getNativeAudioDeviceModulePointer();
            long l4 = this.audioEncoderFactoryFactory.createNativeAudioEncoderFactory();
            long l5 = this.audioDecoderFactoryFactory.createNativeAudioDecoderFactory();
            VideoEncoderFactory videoEncoderFactory = this.videoEncoderFactory;
            VideoDecoderFactory videoDecoderFactory = this.videoDecoderFactory;
            Object object = this.audioProcessingFactory;
            long l6 = 0L;
            long l7 = object == null ? 0L : object.createNative();
            object = this.fecControllerFactoryFactory;
            long l8 = object == null ? 0L : object.createNative();
            object = this.networkControllerFactoryFactory;
            long l9 = object == null ? 0L : object.createNativeNetworkControllerFactory();
            object = this.networkStatePredictorFactoryFactory;
            long l10 = object == null ? 0L : object.createNativeNetworkStatePredictorFactory();
            object = this.mediaTransportFactoryFactory;
            long l11 = object == null ? 0L : object.createNativeMediaTransportFactory();
            object = this.neteqFactoryFactory;
            if (object != null) {
                l6 = object.createNativeNetEqFactory();
            }
            return PeerConnectionFactory.nativeCreatePeerConnectionFactory(context, options, l3, l4, l5, videoEncoderFactory, videoDecoderFactory, l7, l8, l9, l10, l11, l6);
        }

        public Builder setAudioDecoderFactoryFactory(AudioDecoderFactoryFactory audioDecoderFactoryFactory) {
            if (audioDecoderFactoryFactory != null) {
                this.audioDecoderFactoryFactory = audioDecoderFactoryFactory;
                return this;
            }
            throw new IllegalArgumentException("PeerConnectionFactory.Builder does not accept a null AudioDecoderFactoryFactory.");
        }

        public Builder setAudioDeviceModule(AudioDeviceModule audioDeviceModule) {
            this.audioDeviceModule = audioDeviceModule;
            return this;
        }

        public Builder setAudioEncoderFactoryFactory(AudioEncoderFactoryFactory audioEncoderFactoryFactory) {
            if (audioEncoderFactoryFactory != null) {
                this.audioEncoderFactoryFactory = audioEncoderFactoryFactory;
                return this;
            }
            throw new IllegalArgumentException("PeerConnectionFactory.Builder does not accept a null AudioEncoderFactoryFactory.");
        }

        public Builder setAudioProcessingFactory(AudioProcessingFactory audioProcessingFactory) {
            if (audioProcessingFactory != null) {
                this.audioProcessingFactory = audioProcessingFactory;
                return this;
            }
            throw new NullPointerException("PeerConnectionFactory builder does not accept a null AudioProcessingFactory.");
        }

        public Builder setFecControllerFactoryFactoryInterface(FecControllerFactoryFactoryInterface fecControllerFactoryFactoryInterface) {
            this.fecControllerFactoryFactory = fecControllerFactoryFactoryInterface;
            return this;
        }

        public Builder setMediaTransportFactoryFactory(MediaTransportFactoryFactory mediaTransportFactoryFactory) {
            this.mediaTransportFactoryFactory = mediaTransportFactoryFactory;
            return this;
        }

        public Builder setNetEqFactoryFactory(NetEqFactoryFactory netEqFactoryFactory) {
            this.neteqFactoryFactory = netEqFactoryFactory;
            return this;
        }

        public Builder setNetworkControllerFactoryFactory(NetworkControllerFactoryFactory networkControllerFactoryFactory) {
            this.networkControllerFactoryFactory = networkControllerFactoryFactory;
            return this;
        }

        public Builder setNetworkStatePredictorFactoryFactory(NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory) {
            this.networkStatePredictorFactoryFactory = networkStatePredictorFactoryFactory;
            return this;
        }

        public Builder setOptions(Options options) {
            this.options = options;
            return this;
        }

        public Builder setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
            this.videoDecoderFactory = videoDecoderFactory;
            return this;
        }

        public Builder setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
            this.videoEncoderFactory = videoEncoderFactory;
            return this;
        }
    }

    public static class InitializationOptions {
        final Context applicationContext;
        final boolean enableInternalTracer;
        final String fieldTrials;
        Loggable loggable;
        Logging.Severity loggableSeverity;
        final NativeLibraryLoader nativeLibraryLoader;
        final String nativeLibraryName;

        private InitializationOptions(Context context, String string2, boolean bl, NativeLibraryLoader nativeLibraryLoader, String string3, Loggable loggable, Logging.Severity severity) {
            this.applicationContext = context;
            this.fieldTrials = string2;
            this.enableInternalTracer = bl;
            this.nativeLibraryLoader = nativeLibraryLoader;
            this.nativeLibraryName = string3;
            this.loggable = loggable;
            this.loggableSeverity = severity;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public static class Builder {
            private final Context applicationContext;
            private boolean enableInternalTracer;
            private String fieldTrials = "";
            private Loggable loggable;
            private Logging.Severity loggableSeverity;
            private NativeLibraryLoader nativeLibraryLoader = new NativeLibrary.DefaultLoader();
            private String nativeLibraryName = "jingle_peerconnection_so";

            Builder(Context context) {
                this.applicationContext = context;
            }

            public InitializationOptions createInitializationOptions() {
                return new InitializationOptions(this.applicationContext, this.fieldTrials, this.enableInternalTracer, this.nativeLibraryLoader, this.nativeLibraryName, this.loggable, this.loggableSeverity);
            }

            public Builder setEnableInternalTracer(boolean bl) {
                this.enableInternalTracer = bl;
                return this;
            }

            public Builder setFieldTrials(String string2) {
                this.fieldTrials = string2;
                return this;
            }

            public Builder setInjectableLogger(Loggable loggable, Logging.Severity severity) {
                this.loggable = loggable;
                this.loggableSeverity = severity;
                return this;
            }

            public Builder setNativeLibraryLoader(NativeLibraryLoader nativeLibraryLoader) {
                this.nativeLibraryLoader = nativeLibraryLoader;
                return this;
            }

            public Builder setNativeLibraryName(String string2) {
                this.nativeLibraryName = string2;
                return this;
            }
        }
    }

    public static class Options {
        static final int ADAPTER_TYPE_ANY = 32;
        static final int ADAPTER_TYPE_CELLULAR = 4;
        static final int ADAPTER_TYPE_ETHERNET = 1;
        static final int ADAPTER_TYPE_LOOPBACK = 16;
        static final int ADAPTER_TYPE_UNKNOWN = 0;
        static final int ADAPTER_TYPE_VPN = 8;
        static final int ADAPTER_TYPE_WIFI = 2;
        public boolean disableEncryption;
        public boolean disableNetworkMonitor;
        public int networkIgnoreMask;

        @CalledByNative(value="Options")
        boolean getDisableEncryption() {
            return this.disableEncryption;
        }

        @CalledByNative(value="Options")
        boolean getDisableNetworkMonitor() {
            return this.disableNetworkMonitor;
        }

        @CalledByNative(value="Options")
        int getNetworkIgnoreMask() {
            return this.networkIgnoreMask;
        }
    }

    private static class ThreadInfo {
        final Thread thread;
        final int tid;

        private ThreadInfo(Thread thread, int n2) {
            this.thread = thread;
            this.tid = n2;
        }

        public static ThreadInfo getCurrent() {
            return new ThreadInfo(Thread.currentThread(), Process.myTid());
        }
    }
}

