/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.webrtc.CalledByNative;
import org.webrtc.CandidatePairChangeEvent;
import org.webrtc.CryptoOptions;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.NativePeerConnectionFactory;
import org.webrtc.RTCStatsCollectorCallback;
import org.webrtc.RtcCertificatePem;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.StatsObserver;
import org.webrtc.TurnCustomizer;

public class PeerConnection {
    private final List<MediaStream> localStreams = new ArrayList<MediaStream>();
    private final long nativePeerConnection;
    private List<RtpReceiver> receivers;
    private List<RtpSender> senders = new ArrayList<RtpSender>();
    private List<RtpTransceiver> transceivers;

    PeerConnection(long l3) {
        this.receivers = new ArrayList<RtpReceiver>();
        this.transceivers = new ArrayList<RtpTransceiver>();
        this.nativePeerConnection = l3;
    }

    public PeerConnection(NativePeerConnectionFactory nativePeerConnectionFactory) {
        this(nativePeerConnectionFactory.createNativePeerConnection());
    }

    public static long createNativePeerConnectionObserver(Observer observer) {
        return PeerConnection.nativeCreatePeerConnectionObserver(observer);
    }

    private native boolean nativeAddIceCandidate(String var1, int var2, String var3);

    private native boolean nativeAddLocalStream(long var1);

    private native RtpSender nativeAddTrack(long var1, List<String> var3);

    private native RtpTransceiver nativeAddTransceiverOfType(MediaStreamTrack.MediaType var1, RtpTransceiver.RtpTransceiverInit var2);

    private native RtpTransceiver nativeAddTransceiverWithTrack(long var1, RtpTransceiver.RtpTransceiverInit var3);

    private native void nativeClose();

    private native PeerConnectionState nativeConnectionState();

    private native void nativeCreateAnswer(SdpObserver var1, MediaConstraints var2);

    private native DataChannel nativeCreateDataChannel(String var1, DataChannel.Init var2);

    private native void nativeCreateOffer(SdpObserver var1, MediaConstraints var2);

    private static native long nativeCreatePeerConnectionObserver(Observer var0);

    private native RtpSender nativeCreateSender(String var1, String var2);

    private static native void nativeFreeOwnedPeerConnection(long var0);

    private native RtcCertificatePem nativeGetCertificate();

    private native SessionDescription nativeGetLocalDescription();

    private native long nativeGetNativePeerConnection();

    private native List<RtpReceiver> nativeGetReceivers();

    private native SessionDescription nativeGetRemoteDescription();

    private native List<RtpSender> nativeGetSenders();

    private native List<RtpTransceiver> nativeGetTransceivers();

    private native IceConnectionState nativeIceConnectionState();

    private native IceGatheringState nativeIceGatheringState();

    private native void nativeNewGetStats(RTCStatsCollectorCallback var1);

    private native boolean nativeOldGetStats(StatsObserver var1, long var2);

    private native boolean nativeRemoveIceCandidates(IceCandidate[] var1);

    private native void nativeRemoveLocalStream(long var1);

    private native boolean nativeRemoveTrack(long var1);

    private native void nativeSetAudioPlayout(boolean var1);

    private native void nativeSetAudioRecording(boolean var1);

    private native boolean nativeSetBitrate(Integer var1, Integer var2, Integer var3);

    private native boolean nativeSetConfiguration(RTCConfiguration var1);

    private native void nativeSetLocalDescription(SdpObserver var1, SessionDescription var2);

    private native void nativeSetRemoteDescription(SdpObserver var1, SessionDescription var2);

    private native SignalingState nativeSignalingState();

    private native boolean nativeStartRtcEventLog(int var1, int var2);

    private native void nativeStopRtcEventLog();

    public boolean addIceCandidate(IceCandidate iceCandidate) {
        return this.nativeAddIceCandidate(iceCandidate.sdpMid, iceCandidate.sdpMLineIndex, iceCandidate.sdp);
    }

    public boolean addStream(MediaStream mediaStream) {
        if (!this.nativeAddLocalStream(mediaStream.getNativeMediaStream())) {
            return false;
        }
        this.localStreams.add(mediaStream);
        return true;
    }

    public RtpSender addTrack(MediaStreamTrack mediaStreamTrack) {
        return this.addTrack(mediaStreamTrack, Collections.<String>emptyList());
    }

    public RtpSender addTrack(MediaStreamTrack object, List<String> list) {
        if (object != null && list != null) {
            if ((object = this.nativeAddTrack(((MediaStreamTrack)object).getNativeMediaStreamTrack(), list)) != null) {
                this.senders.add((RtpSender)object);
                return object;
            }
            throw new IllegalStateException("C++ addTrack failed.");
        }
        throw new NullPointerException("No MediaStreamTrack specified in addTrack.");
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack.MediaType mediaType) {
        return this.addTransceiver(mediaType, new RtpTransceiver.RtpTransceiverInit());
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack.MediaType object, RtpTransceiver.RtpTransceiverInit rtpTransceiverInit) {
        if (object != null) {
            RtpTransceiver.RtpTransceiverInit rtpTransceiverInit2 = rtpTransceiverInit;
            if (rtpTransceiverInit == null) {
                rtpTransceiverInit2 = new RtpTransceiver.RtpTransceiverInit();
            }
            if ((object = this.nativeAddTransceiverOfType((MediaStreamTrack.MediaType)((Object)object), rtpTransceiverInit2)) != null) {
                this.transceivers.add((RtpTransceiver)object);
                return object;
            }
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        throw new NullPointerException("No MediaType specified for addTransceiver.");
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack mediaStreamTrack) {
        return this.addTransceiver(mediaStreamTrack, new RtpTransceiver.RtpTransceiverInit());
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack object, RtpTransceiver.RtpTransceiverInit rtpTransceiverInit) {
        if (object != null) {
            RtpTransceiver.RtpTransceiverInit rtpTransceiverInit2 = rtpTransceiverInit;
            if (rtpTransceiverInit == null) {
                rtpTransceiverInit2 = new RtpTransceiver.RtpTransceiverInit();
            }
            if ((object = this.nativeAddTransceiverWithTrack(((MediaStreamTrack)object).getNativeMediaStreamTrack(), rtpTransceiverInit2)) != null) {
                this.transceivers.add((RtpTransceiver)object);
                return object;
            }
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        throw new NullPointerException("No MediaStreamTrack specified for addTransceiver.");
    }

    public void close() {
        this.nativeClose();
    }

    public PeerConnectionState connectionState() {
        return this.nativeConnectionState();
    }

    public void createAnswer(SdpObserver sdpObserver, MediaConstraints mediaConstraints) {
        this.nativeCreateAnswer(sdpObserver, mediaConstraints);
    }

    public DataChannel createDataChannel(String string2, DataChannel.Init init) {
        return this.nativeCreateDataChannel(string2, init);
    }

    public void createOffer(SdpObserver sdpObserver, MediaConstraints mediaConstraints) {
        this.nativeCreateOffer(sdpObserver, mediaConstraints);
    }

    public RtpSender createSender(String object, String string2) {
        if ((object = this.nativeCreateSender((String)object, string2)) != null) {
            this.senders.add((RtpSender)object);
        }
        return object;
    }

    public void dispose() {
        this.close();
        for (MediaStream iterator2 : this.localStreams) {
            this.nativeRemoveLocalStream(iterator2.getNativeMediaStream());
            iterator2.dispose();
        }
        this.localStreams.clear();
        Iterator<RtpSender> iterator = this.senders.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        this.senders.clear();
        Iterator<RtpReceiver> iterator2 = this.receivers.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().dispose();
        }
        Iterator<RtpTransceiver> iterator3 = this.transceivers.iterator();
        while (iterator3.hasNext()) {
            iterator3.next().dispose();
        }
        this.transceivers.clear();
        this.receivers.clear();
        PeerConnection.nativeFreeOwnedPeerConnection(this.nativePeerConnection);
    }

    public RtcCertificatePem getCertificate() {
        return this.nativeGetCertificate();
    }

    public SessionDescription getLocalDescription() {
        return this.nativeGetLocalDescription();
    }

    @CalledByNative
    long getNativeOwnedPeerConnection() {
        return this.nativePeerConnection;
    }

    public long getNativePeerConnection() {
        return this.nativeGetNativePeerConnection();
    }

    public List<RtpReceiver> getReceivers() {
        Object object = this.receivers.iterator();
        while (object.hasNext()) {
            object.next().dispose();
        }
        this.receivers = object = this.nativeGetReceivers();
        return Collections.unmodifiableList(object);
    }

    public SessionDescription getRemoteDescription() {
        return this.nativeGetRemoteDescription();
    }

    public List<RtpSender> getSenders() {
        Object object = this.senders.iterator();
        while (object.hasNext()) {
            object.next().dispose();
        }
        this.senders = object = this.nativeGetSenders();
        return Collections.unmodifiableList(object);
    }

    public void getStats(RTCStatsCollectorCallback rTCStatsCollectorCallback) {
        this.nativeNewGetStats(rTCStatsCollectorCallback);
    }

    @Deprecated
    public boolean getStats(StatsObserver statsObserver, MediaStreamTrack mediaStreamTrack) {
        long l3 = mediaStreamTrack == null ? 0L : mediaStreamTrack.getNativeMediaStreamTrack();
        return this.nativeOldGetStats(statsObserver, l3);
    }

    public List<RtpTransceiver> getTransceivers() {
        Object object = this.transceivers.iterator();
        while (object.hasNext()) {
            object.next().dispose();
        }
        this.transceivers = object = this.nativeGetTransceivers();
        return Collections.unmodifiableList(object);
    }

    public IceConnectionState iceConnectionState() {
        return this.nativeIceConnectionState();
    }

    public IceGatheringState iceGatheringState() {
        return this.nativeIceGatheringState();
    }

    public boolean removeIceCandidates(IceCandidate[] iceCandidateArray) {
        return this.nativeRemoveIceCandidates(iceCandidateArray);
    }

    public void removeStream(MediaStream mediaStream) {
        this.nativeRemoveLocalStream(mediaStream.getNativeMediaStream());
        this.localStreams.remove(mediaStream);
    }

    public boolean removeTrack(RtpSender rtpSender) {
        if (rtpSender != null) {
            return this.nativeRemoveTrack(rtpSender.getNativeRtpSender());
        }
        throw new NullPointerException("No RtpSender specified for removeTrack.");
    }

    public void setAudioPlayout(boolean bl) {
        this.nativeSetAudioPlayout(bl);
    }

    public void setAudioRecording(boolean bl) {
        this.nativeSetAudioRecording(bl);
    }

    public boolean setBitrate(Integer n2, Integer n3, Integer n4) {
        return this.nativeSetBitrate(n2, n3, n4);
    }

    public boolean setConfiguration(RTCConfiguration rTCConfiguration) {
        return this.nativeSetConfiguration(rTCConfiguration);
    }

    public void setLocalDescription(SdpObserver sdpObserver, SessionDescription sessionDescription) {
        this.nativeSetLocalDescription(sdpObserver, sessionDescription);
    }

    public void setRemoteDescription(SdpObserver sdpObserver, SessionDescription sessionDescription) {
        this.nativeSetRemoteDescription(sdpObserver, sessionDescription);
    }

    public SignalingState signalingState() {
        return this.nativeSignalingState();
    }

    public boolean startRtcEventLog(int n2, int n3) {
        return this.nativeStartRtcEventLog(n2, n3);
    }

    public void stopRtcEventLog() {
        this.nativeStopRtcEventLog();
    }

    public static final class AdapterType
    extends Enum<AdapterType> {
        private static final /* synthetic */ AdapterType[] $VALUES;
        public static final /* enum */ AdapterType ADAPTER_TYPE_ANY;
        private static final Map<Integer, AdapterType> BY_BITMASK;
        public static final /* enum */ AdapterType CELLULAR;
        public static final /* enum */ AdapterType ETHERNET;
        public static final /* enum */ AdapterType LOOPBACK;
        public static final /* enum */ AdapterType UNKNOWN;
        public static final /* enum */ AdapterType VPN;
        public static final /* enum */ AdapterType WIFI;
        public final Integer bitMask;

        static {
            AdapterType adapterType2;
            UNKNOWN = new AdapterType(0);
            ETHERNET = new AdapterType(1);
            WIFI = new AdapterType(2);
            CELLULAR = new AdapterType(4);
            VPN = new AdapterType(8);
            LOOPBACK = new AdapterType(16);
            ADAPTER_TYPE_ANY = adapterType2 = new AdapterType(32);
            $VALUES = new AdapterType[]{UNKNOWN, ETHERNET, WIFI, CELLULAR, VPN, LOOPBACK, adapterType2};
            BY_BITMASK = new HashMap<Integer, AdapterType>();
            for (AdapterType adapterType2 : AdapterType.values()) {
                BY_BITMASK.put(adapterType2.bitMask, adapterType2);
            }
        }

        private AdapterType(Integer n3) {
            this.bitMask = n3;
        }

        @CalledByNative(value="AdapterType")
        static AdapterType fromNativeIndex(int n2) {
            return BY_BITMASK.get(n2);
        }

        public static AdapterType valueOf(String string2) {
            return Enum.valueOf(AdapterType.class, string2);
        }

        public static AdapterType[] values() {
            return (AdapterType[])$VALUES.clone();
        }
    }

    public static final class BundlePolicy
    extends Enum<BundlePolicy> {
        private static final /* synthetic */ BundlePolicy[] $VALUES;
        public static final /* enum */ BundlePolicy BALANCED;
        public static final /* enum */ BundlePolicy MAXBUNDLE;
        public static final /* enum */ BundlePolicy MAXCOMPAT;

        static {
            BundlePolicy bundlePolicy;
            BALANCED = new BundlePolicy();
            MAXBUNDLE = new BundlePolicy();
            MAXCOMPAT = bundlePolicy = new BundlePolicy();
            $VALUES = new BundlePolicy[]{BALANCED, MAXBUNDLE, bundlePolicy};
        }

        public static BundlePolicy valueOf(String string2) {
            return Enum.valueOf(BundlePolicy.class, string2);
        }

        public static BundlePolicy[] values() {
            return (BundlePolicy[])$VALUES.clone();
        }
    }

    public static final class CandidateNetworkPolicy
    extends Enum<CandidateNetworkPolicy> {
        private static final /* synthetic */ CandidateNetworkPolicy[] $VALUES;
        public static final /* enum */ CandidateNetworkPolicy ALL;
        public static final /* enum */ CandidateNetworkPolicy LOW_COST;

        static {
            CandidateNetworkPolicy candidateNetworkPolicy;
            ALL = new CandidateNetworkPolicy();
            LOW_COST = candidateNetworkPolicy = new CandidateNetworkPolicy();
            $VALUES = new CandidateNetworkPolicy[]{ALL, candidateNetworkPolicy};
        }

        public static CandidateNetworkPolicy valueOf(String string2) {
            return Enum.valueOf(CandidateNetworkPolicy.class, string2);
        }

        public static CandidateNetworkPolicy[] values() {
            return (CandidateNetworkPolicy[])$VALUES.clone();
        }
    }

    public static final class ContinualGatheringPolicy
    extends Enum<ContinualGatheringPolicy> {
        private static final /* synthetic */ ContinualGatheringPolicy[] $VALUES;
        public static final /* enum */ ContinualGatheringPolicy GATHER_CONTINUALLY;
        public static final /* enum */ ContinualGatheringPolicy GATHER_ONCE;

        static {
            ContinualGatheringPolicy continualGatheringPolicy;
            GATHER_ONCE = new ContinualGatheringPolicy();
            GATHER_CONTINUALLY = continualGatheringPolicy = new ContinualGatheringPolicy();
            $VALUES = new ContinualGatheringPolicy[]{GATHER_ONCE, continualGatheringPolicy};
        }

        public static ContinualGatheringPolicy valueOf(String string2) {
            return Enum.valueOf(ContinualGatheringPolicy.class, string2);
        }

        public static ContinualGatheringPolicy[] values() {
            return (ContinualGatheringPolicy[])$VALUES.clone();
        }
    }

    public static final class IceConnectionState
    extends Enum<IceConnectionState> {
        private static final /* synthetic */ IceConnectionState[] $VALUES;
        public static final /* enum */ IceConnectionState CHECKING;
        public static final /* enum */ IceConnectionState CLOSED;
        public static final /* enum */ IceConnectionState COMPLETED;
        public static final /* enum */ IceConnectionState CONNECTED;
        public static final /* enum */ IceConnectionState DISCONNECTED;
        public static final /* enum */ IceConnectionState FAILED;
        public static final /* enum */ IceConnectionState NEW;

        static {
            IceConnectionState iceConnectionState;
            NEW = new IceConnectionState();
            CHECKING = new IceConnectionState();
            CONNECTED = new IceConnectionState();
            COMPLETED = new IceConnectionState();
            FAILED = new IceConnectionState();
            DISCONNECTED = new IceConnectionState();
            CLOSED = iceConnectionState = new IceConnectionState();
            $VALUES = new IceConnectionState[]{NEW, CHECKING, CONNECTED, COMPLETED, FAILED, DISCONNECTED, iceConnectionState};
        }

        @CalledByNative(value="IceConnectionState")
        static IceConnectionState fromNativeIndex(int n2) {
            return IceConnectionState.values()[n2];
        }

        public static IceConnectionState valueOf(String string2) {
            return Enum.valueOf(IceConnectionState.class, string2);
        }

        public static IceConnectionState[] values() {
            return (IceConnectionState[])$VALUES.clone();
        }
    }

    public static final class IceGatheringState
    extends Enum<IceGatheringState> {
        private static final /* synthetic */ IceGatheringState[] $VALUES;
        public static final /* enum */ IceGatheringState COMPLETE;
        public static final /* enum */ IceGatheringState GATHERING;
        public static final /* enum */ IceGatheringState NEW;

        static {
            IceGatheringState iceGatheringState;
            NEW = new IceGatheringState();
            GATHERING = new IceGatheringState();
            COMPLETE = iceGatheringState = new IceGatheringState();
            $VALUES = new IceGatheringState[]{NEW, GATHERING, iceGatheringState};
        }

        @CalledByNative(value="IceGatheringState")
        static IceGatheringState fromNativeIndex(int n2) {
            return IceGatheringState.values()[n2];
        }

        public static IceGatheringState valueOf(String string2) {
            return Enum.valueOf(IceGatheringState.class, string2);
        }

        public static IceGatheringState[] values() {
            return (IceGatheringState[])$VALUES.clone();
        }
    }

    public static class IceServer {
        public final String hostname;
        public final String password;
        public final List<String> tlsAlpnProtocols;
        public final TlsCertPolicy tlsCertPolicy;
        public final List<String> tlsEllipticCurves;
        @Deprecated
        public final String uri;
        public final List<String> urls;
        public final String username;

        @Deprecated
        public IceServer(String string2) {
            this(string2, "", "");
        }

        @Deprecated
        public IceServer(String string2, String string3, String string4) {
            this(string2, string3, string4, TlsCertPolicy.TLS_CERT_POLICY_SECURE);
        }

        @Deprecated
        public IceServer(String string2, String string3, String string4, TlsCertPolicy tlsCertPolicy) {
            this(string2, string3, string4, tlsCertPolicy, "");
        }

        @Deprecated
        public IceServer(String string2, String string3, String string4, TlsCertPolicy tlsCertPolicy, String string5) {
            this(string2, Collections.singletonList(string2), string3, string4, tlsCertPolicy, string5, null, null);
        }

        private IceServer(String object, List<String> list, String string2, String string3, TlsCertPolicy tlsCertPolicy, String string4, List<String> list2, List<String> list3) {
            if (object != null && list != null && !list.isEmpty()) {
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("urls element is null: ");
                    ((StringBuilder)object).append(list);
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                if (string2 != null) {
                    if (string3 != null) {
                        if (string4 != null) {
                            this.uri = object;
                            this.urls = list;
                            this.username = string2;
                            this.password = string3;
                            this.tlsCertPolicy = tlsCertPolicy;
                            this.hostname = string4;
                            this.tlsAlpnProtocols = list2;
                            this.tlsEllipticCurves = list3;
                            return;
                        }
                        throw new IllegalArgumentException("hostname == null");
                    }
                    throw new IllegalArgumentException("password == null");
                }
                throw new IllegalArgumentException("username == null");
            }
            object = new IllegalArgumentException("uri == null || urls == null || urls.isEmpty()");
            throw object;
        }

        public static Builder builder(String string2) {
            return new Builder(Collections.singletonList(string2));
        }

        public static Builder builder(List<String> list) {
            return new Builder(list);
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof IceServer)) {
                return false;
            }
            object = (IceServer)object;
            boolean bl2 = bl;
            if (this.uri.equals(((IceServer)object).uri)) {
                bl2 = bl;
                if (this.urls.equals(((IceServer)object).urls)) {
                    bl2 = bl;
                    if (this.username.equals(((IceServer)object).username)) {
                        bl2 = bl;
                        if (this.password.equals(((IceServer)object).password)) {
                            bl2 = bl;
                            if (this.tlsCertPolicy.equals((Object)((IceServer)object).tlsCertPolicy)) {
                                bl2 = bl;
                                if (this.hostname.equals(((IceServer)object).hostname)) {
                                    bl2 = bl;
                                    if (this.tlsAlpnProtocols.equals(((IceServer)object).tlsAlpnProtocols)) {
                                        bl2 = bl;
                                        if (this.tlsEllipticCurves.equals(((IceServer)object).tlsEllipticCurves)) {
                                            bl2 = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return bl2;
        }

        @CalledByNative(value="IceServer")
        String getHostname() {
            return this.hostname;
        }

        @CalledByNative(value="IceServer")
        String getPassword() {
            return this.password;
        }

        @CalledByNative(value="IceServer")
        List<String> getTlsAlpnProtocols() {
            return this.tlsAlpnProtocols;
        }

        @CalledByNative(value="IceServer")
        TlsCertPolicy getTlsCertPolicy() {
            return this.tlsCertPolicy;
        }

        @CalledByNative(value="IceServer")
        List<String> getTlsEllipticCurves() {
            return this.tlsEllipticCurves;
        }

        @CalledByNative(value="IceServer")
        List<String> getUrls() {
            return this.urls;
        }

        @CalledByNative(value="IceServer")
        String getUsername() {
            return this.username;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.uri, this.urls, this.username, this.password, this.tlsCertPolicy, this.hostname, this.tlsAlpnProtocols, this.tlsEllipticCurves});
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.urls);
            stringBuilder.append(" [");
            stringBuilder.append(this.username);
            stringBuilder.append(":");
            stringBuilder.append(this.password);
            stringBuilder.append("] [");
            stringBuilder.append((Object)this.tlsCertPolicy);
            stringBuilder.append("] [");
            stringBuilder.append(this.hostname);
            stringBuilder.append("] [");
            stringBuilder.append(this.tlsAlpnProtocols);
            stringBuilder.append("] [");
            stringBuilder.append(this.tlsEllipticCurves);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public static class Builder {
            private String hostname = "";
            private String password = "";
            private List<String> tlsAlpnProtocols;
            private TlsCertPolicy tlsCertPolicy = TlsCertPolicy.TLS_CERT_POLICY_SECURE;
            private List<String> tlsEllipticCurves;
            private final List<String> urls;
            private String username = "";

            private Builder(List<String> list) {
                if (list != null && !list.isEmpty()) {
                    this.urls = list;
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("urls == null || urls.isEmpty(): ");
                stringBuilder.append(list);
                throw new IllegalArgumentException(stringBuilder.toString());
            }

            public IceServer createIceServer() {
                return new IceServer(this.urls.get(0), this.urls, this.username, this.password, this.tlsCertPolicy, this.hostname, this.tlsAlpnProtocols, this.tlsEllipticCurves);
            }

            public Builder setHostname(String string2) {
                this.hostname = string2;
                return this;
            }

            public Builder setPassword(String string2) {
                this.password = string2;
                return this;
            }

            public Builder setTlsAlpnProtocols(List<String> list) {
                this.tlsAlpnProtocols = list;
                return this;
            }

            public Builder setTlsCertPolicy(TlsCertPolicy tlsCertPolicy) {
                this.tlsCertPolicy = tlsCertPolicy;
                return this;
            }

            public Builder setTlsEllipticCurves(List<String> list) {
                this.tlsEllipticCurves = list;
                return this;
            }

            public Builder setUsername(String string2) {
                this.username = string2;
                return this;
            }
        }
    }

    public static final class IceTransportsType
    extends Enum<IceTransportsType> {
        private static final /* synthetic */ IceTransportsType[] $VALUES;
        public static final /* enum */ IceTransportsType ALL;
        public static final /* enum */ IceTransportsType NOHOST;
        public static final /* enum */ IceTransportsType NONE;
        public static final /* enum */ IceTransportsType RELAY;

        static {
            IceTransportsType iceTransportsType;
            NONE = new IceTransportsType();
            RELAY = new IceTransportsType();
            NOHOST = new IceTransportsType();
            ALL = iceTransportsType = new IceTransportsType();
            $VALUES = new IceTransportsType[]{NONE, RELAY, NOHOST, iceTransportsType};
        }

        public static IceTransportsType valueOf(String string2) {
            return Enum.valueOf(IceTransportsType.class, string2);
        }

        public static IceTransportsType[] values() {
            return (IceTransportsType[])$VALUES.clone();
        }
    }

    public static final class KeyType
    extends Enum<KeyType> {
        private static final /* synthetic */ KeyType[] $VALUES;
        public static final /* enum */ KeyType ECDSA;
        public static final /* enum */ KeyType RSA;

        static {
            KeyType keyType;
            RSA = new KeyType();
            ECDSA = keyType = new KeyType();
            $VALUES = new KeyType[]{RSA, keyType};
        }

        public static KeyType valueOf(String string2) {
            return Enum.valueOf(KeyType.class, string2);
        }

        public static KeyType[] values() {
            return (KeyType[])$VALUES.clone();
        }
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onAddStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onAddTrack(RtpReceiver var1, MediaStream[] var2);

        @CalledByNative(value="Observer")
        public void onConnectionChange(PeerConnectionState var1);

        @CalledByNative(value="Observer")
        public void onDataChannel(DataChannel var1);

        @CalledByNative(value="Observer")
        public void onIceCandidate(IceCandidate var1);

        @CalledByNative(value="Observer")
        public void onIceCandidatesRemoved(IceCandidate[] var1);

        @CalledByNative(value="Observer")
        public void onIceConnectionChange(IceConnectionState var1);

        @CalledByNative(value="Observer")
        public void onIceConnectionReceivingChange(boolean var1);

        @CalledByNative(value="Observer")
        public void onIceGatheringChange(IceGatheringState var1);

        @CalledByNative(value="Observer")
        public void onRemoveStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onRenegotiationNeeded();

        @CalledByNative(value="Observer")
        public void onSelectedCandidatePairChanged(CandidatePairChangeEvent var1);

        @CalledByNative(value="Observer")
        public void onSignalingChange(SignalingState var1);

        @CalledByNative(value="Observer")
        public void onStandardizedIceConnectionChange(IceConnectionState var1);

        @CalledByNative(value="Observer")
        public void onTrack(RtpTransceiver var1);
    }

    public static final class PeerConnectionState
    extends Enum<PeerConnectionState> {
        private static final /* synthetic */ PeerConnectionState[] $VALUES;
        public static final /* enum */ PeerConnectionState CLOSED;
        public static final /* enum */ PeerConnectionState CONNECTED;
        public static final /* enum */ PeerConnectionState CONNECTING;
        public static final /* enum */ PeerConnectionState DISCONNECTED;
        public static final /* enum */ PeerConnectionState FAILED;
        public static final /* enum */ PeerConnectionState NEW;

        static {
            PeerConnectionState peerConnectionState;
            NEW = new PeerConnectionState();
            CONNECTING = new PeerConnectionState();
            CONNECTED = new PeerConnectionState();
            DISCONNECTED = new PeerConnectionState();
            FAILED = new PeerConnectionState();
            CLOSED = peerConnectionState = new PeerConnectionState();
            $VALUES = new PeerConnectionState[]{NEW, CONNECTING, CONNECTED, DISCONNECTED, FAILED, peerConnectionState};
        }

        @CalledByNative(value="PeerConnectionState")
        static PeerConnectionState fromNativeIndex(int n2) {
            return PeerConnectionState.values()[n2];
        }

        public static PeerConnectionState valueOf(String string2) {
            return Enum.valueOf(PeerConnectionState.class, string2);
        }

        public static PeerConnectionState[] values() {
            return (PeerConnectionState[])$VALUES.clone();
        }
    }

    public static final class PortPrunePolicy
    extends Enum<PortPrunePolicy> {
        private static final /* synthetic */ PortPrunePolicy[] $VALUES;
        public static final /* enum */ PortPrunePolicy KEEP_FIRST_READY;
        public static final /* enum */ PortPrunePolicy NO_PRUNE;
        public static final /* enum */ PortPrunePolicy PRUNE_BASED_ON_PRIORITY;

        static {
            PortPrunePolicy portPrunePolicy;
            NO_PRUNE = new PortPrunePolicy();
            PRUNE_BASED_ON_PRIORITY = new PortPrunePolicy();
            KEEP_FIRST_READY = portPrunePolicy = new PortPrunePolicy();
            $VALUES = new PortPrunePolicy[]{NO_PRUNE, PRUNE_BASED_ON_PRIORITY, portPrunePolicy};
        }

        public static PortPrunePolicy valueOf(String string2) {
            return Enum.valueOf(PortPrunePolicy.class, string2);
        }

        public static PortPrunePolicy[] values() {
            return (PortPrunePolicy[])$VALUES.clone();
        }
    }

    public static class RTCConfiguration {
        public boolean activeResetSrtpParams;
        public Boolean allowCodecSwitching;
        public boolean audioJitterBufferFastAccelerate;
        public int audioJitterBufferMaxPackets;
        public BundlePolicy bundlePolicy;
        public CandidateNetworkPolicy candidateNetworkPolicy;
        public RtcCertificatePem certificate;
        public Boolean combinedAudioVideoBwe;
        public ContinualGatheringPolicy continualGatheringPolicy;
        public CryptoOptions cryptoOptions;
        public boolean disableIPv6OnWifi;
        public boolean disableIpv6;
        public boolean enableCpuOveruseDetection;
        public boolean enableDscp;
        public Boolean enableDtlsSrtp;
        public boolean enableRtpDataChannel;
        public int iceBackupCandidatePairPingInterval;
        public int iceCandidatePoolSize;
        public Integer iceCheckIntervalStrongConnectivityMs;
        public Integer iceCheckIntervalWeakConnectivityMs;
        public Integer iceCheckMinInterval;
        public int iceConnectionReceivingTimeout;
        public List<IceServer> iceServers;
        public IceTransportsType iceTransportsType = IceTransportsType.ALL;
        public Integer iceUnwritableMinChecks;
        public Integer iceUnwritableTimeMs;
        public KeyType keyType;
        public int maxIPv6Networks;
        public AdapterType networkPreference;
        public boolean presumeWritableWhenFullyRelayed;
        @Deprecated
        public boolean pruneTurnPorts;
        public RtcpMuxPolicy rtcpMuxPolicy;
        public Integer screencastMinBitrate;
        public SdpSemantics sdpSemantics;
        public Integer stunCandidateKeepaliveIntervalMs;
        public boolean surfaceIceCandidatesOnIceTransportTypeChanged;
        public boolean suspendBelowMinBitrate;
        public TcpCandidatePolicy tcpCandidatePolicy;
        public TurnCustomizer turnCustomizer;
        public String turnLoggingId;
        public PortPrunePolicy turnPortPrunePolicy;
        public boolean useMediaTransport;
        public boolean useMediaTransportForDataChannels;

        public RTCConfiguration(List<IceServer> list) {
            this.bundlePolicy = BundlePolicy.BALANCED;
            this.rtcpMuxPolicy = RtcpMuxPolicy.REQUIRE;
            this.tcpCandidatePolicy = TcpCandidatePolicy.ENABLED;
            this.candidateNetworkPolicy = CandidateNetworkPolicy.ALL;
            this.iceServers = list;
            this.audioJitterBufferMaxPackets = 50;
            this.audioJitterBufferFastAccelerate = false;
            this.iceConnectionReceivingTimeout = -1;
            this.iceBackupCandidatePairPingInterval = -1;
            this.keyType = KeyType.ECDSA;
            this.continualGatheringPolicy = ContinualGatheringPolicy.GATHER_ONCE;
            this.iceCandidatePoolSize = 0;
            this.pruneTurnPorts = false;
            this.turnPortPrunePolicy = PortPrunePolicy.NO_PRUNE;
            this.presumeWritableWhenFullyRelayed = false;
            this.surfaceIceCandidatesOnIceTransportTypeChanged = false;
            this.iceCheckIntervalStrongConnectivityMs = null;
            this.iceCheckIntervalWeakConnectivityMs = null;
            this.iceCheckMinInterval = null;
            this.iceUnwritableTimeMs = null;
            this.iceUnwritableMinChecks = null;
            this.stunCandidateKeepaliveIntervalMs = null;
            this.disableIPv6OnWifi = false;
            this.maxIPv6Networks = 5;
            this.disableIpv6 = false;
            this.enableDscp = false;
            this.enableCpuOveruseDetection = true;
            this.enableRtpDataChannel = false;
            this.suspendBelowMinBitrate = false;
            this.screencastMinBitrate = null;
            this.combinedAudioVideoBwe = null;
            this.enableDtlsSrtp = null;
            this.networkPreference = AdapterType.UNKNOWN;
            this.sdpSemantics = SdpSemantics.PLAN_B;
            this.activeResetSrtpParams = false;
            this.useMediaTransport = false;
            this.useMediaTransportForDataChannels = false;
            this.cryptoOptions = null;
            this.turnLoggingId = null;
            this.allowCodecSwitching = null;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getActiveResetSrtpParams() {
            return this.activeResetSrtpParams;
        }

        @CalledByNative(value="RTCConfiguration")
        Boolean getAllowCodecSwitching() {
            return this.allowCodecSwitching;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getAudioJitterBufferFastAccelerate() {
            return this.audioJitterBufferFastAccelerate;
        }

        @CalledByNative(value="RTCConfiguration")
        int getAudioJitterBufferMaxPackets() {
            return this.audioJitterBufferMaxPackets;
        }

        @CalledByNative(value="RTCConfiguration")
        BundlePolicy getBundlePolicy() {
            return this.bundlePolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        CandidateNetworkPolicy getCandidateNetworkPolicy() {
            return this.candidateNetworkPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        RtcCertificatePem getCertificate() {
            return this.certificate;
        }

        @CalledByNative(value="RTCConfiguration")
        Boolean getCombinedAudioVideoBwe() {
            return this.combinedAudioVideoBwe;
        }

        @CalledByNative(value="RTCConfiguration")
        ContinualGatheringPolicy getContinualGatheringPolicy() {
            return this.continualGatheringPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        CryptoOptions getCryptoOptions() {
            return this.cryptoOptions;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getDisableIPv6OnWifi() {
            return this.disableIPv6OnWifi;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getDisableIpv6() {
            return this.disableIpv6;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableCpuOveruseDetection() {
            return this.enableCpuOveruseDetection;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableDscp() {
            return this.enableDscp;
        }

        @CalledByNative(value="RTCConfiguration")
        Boolean getEnableDtlsSrtp() {
            return this.enableDtlsSrtp;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableRtpDataChannel() {
            return this.enableRtpDataChannel;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceBackupCandidatePairPingInterval() {
            return this.iceBackupCandidatePairPingInterval;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceCandidatePoolSize() {
            return this.iceCandidatePoolSize;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckIntervalStrongConnectivity() {
            return this.iceCheckIntervalStrongConnectivityMs;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckIntervalWeakConnectivity() {
            return this.iceCheckIntervalWeakConnectivityMs;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckMinInterval() {
            return this.iceCheckMinInterval;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceConnectionReceivingTimeout() {
            return this.iceConnectionReceivingTimeout;
        }

        @CalledByNative(value="RTCConfiguration")
        List<IceServer> getIceServers() {
            return this.iceServers;
        }

        @CalledByNative(value="RTCConfiguration")
        IceTransportsType getIceTransportsType() {
            return this.iceTransportsType;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getIceUnwritableMinChecks() {
            return this.iceUnwritableMinChecks;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getIceUnwritableTimeout() {
            return this.iceUnwritableTimeMs;
        }

        @CalledByNative(value="RTCConfiguration")
        KeyType getKeyType() {
            return this.keyType;
        }

        @CalledByNative(value="RTCConfiguration")
        int getMaxIPv6Networks() {
            return this.maxIPv6Networks;
        }

        @CalledByNative(value="RTCConfiguration")
        AdapterType getNetworkPreference() {
            return this.networkPreference;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getPresumeWritableWhenFullyRelayed() {
            return this.presumeWritableWhenFullyRelayed;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getPruneTurnPorts() {
            return this.pruneTurnPorts;
        }

        @CalledByNative(value="RTCConfiguration")
        RtcpMuxPolicy getRtcpMuxPolicy() {
            return this.rtcpMuxPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getScreencastMinBitrate() {
            return this.screencastMinBitrate;
        }

        @CalledByNative(value="RTCConfiguration")
        SdpSemantics getSdpSemantics() {
            return this.sdpSemantics;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getStunCandidateKeepaliveInterval() {
            return this.stunCandidateKeepaliveIntervalMs;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getSurfaceIceCandidatesOnIceTransportTypeChanged() {
            return this.surfaceIceCandidatesOnIceTransportTypeChanged;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getSuspendBelowMinBitrate() {
            return this.suspendBelowMinBitrate;
        }

        @CalledByNative(value="RTCConfiguration")
        TcpCandidatePolicy getTcpCandidatePolicy() {
            return this.tcpCandidatePolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        TurnCustomizer getTurnCustomizer() {
            return this.turnCustomizer;
        }

        @CalledByNative(value="RTCConfiguration")
        String getTurnLoggingId() {
            return this.turnLoggingId;
        }

        @CalledByNative(value="RTCConfiguration")
        PortPrunePolicy getTurnPortPrunePolicy() {
            return this.turnPortPrunePolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getUseMediaTransport() {
            return this.useMediaTransport;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getUseMediaTransportForDataChannels() {
            return this.useMediaTransportForDataChannels;
        }
    }

    public static final class RtcpMuxPolicy
    extends Enum<RtcpMuxPolicy> {
        private static final /* synthetic */ RtcpMuxPolicy[] $VALUES;
        public static final /* enum */ RtcpMuxPolicy NEGOTIATE;
        public static final /* enum */ RtcpMuxPolicy REQUIRE;

        static {
            RtcpMuxPolicy rtcpMuxPolicy;
            NEGOTIATE = new RtcpMuxPolicy();
            REQUIRE = rtcpMuxPolicy = new RtcpMuxPolicy();
            $VALUES = new RtcpMuxPolicy[]{NEGOTIATE, rtcpMuxPolicy};
        }

        public static RtcpMuxPolicy valueOf(String string2) {
            return Enum.valueOf(RtcpMuxPolicy.class, string2);
        }

        public static RtcpMuxPolicy[] values() {
            return (RtcpMuxPolicy[])$VALUES.clone();
        }
    }

    public static final class SdpSemantics
    extends Enum<SdpSemantics> {
        private static final /* synthetic */ SdpSemantics[] $VALUES;
        public static final /* enum */ SdpSemantics PLAN_B;
        public static final /* enum */ SdpSemantics UNIFIED_PLAN;

        static {
            SdpSemantics sdpSemantics;
            PLAN_B = new SdpSemantics();
            UNIFIED_PLAN = sdpSemantics = new SdpSemantics();
            $VALUES = new SdpSemantics[]{PLAN_B, sdpSemantics};
        }

        public static SdpSemantics valueOf(String string2) {
            return Enum.valueOf(SdpSemantics.class, string2);
        }

        public static SdpSemantics[] values() {
            return (SdpSemantics[])$VALUES.clone();
        }
    }

    public static final class SignalingState
    extends Enum<SignalingState> {
        private static final /* synthetic */ SignalingState[] $VALUES;
        public static final /* enum */ SignalingState CLOSED;
        public static final /* enum */ SignalingState HAVE_LOCAL_OFFER;
        public static final /* enum */ SignalingState HAVE_LOCAL_PRANSWER;
        public static final /* enum */ SignalingState HAVE_REMOTE_OFFER;
        public static final /* enum */ SignalingState HAVE_REMOTE_PRANSWER;
        public static final /* enum */ SignalingState STABLE;

        static {
            SignalingState signalingState;
            STABLE = new SignalingState();
            HAVE_LOCAL_OFFER = new SignalingState();
            HAVE_LOCAL_PRANSWER = new SignalingState();
            HAVE_REMOTE_OFFER = new SignalingState();
            HAVE_REMOTE_PRANSWER = new SignalingState();
            CLOSED = signalingState = new SignalingState();
            $VALUES = new SignalingState[]{STABLE, HAVE_LOCAL_OFFER, HAVE_LOCAL_PRANSWER, HAVE_REMOTE_OFFER, HAVE_REMOTE_PRANSWER, signalingState};
        }

        @CalledByNative(value="SignalingState")
        static SignalingState fromNativeIndex(int n2) {
            return SignalingState.values()[n2];
        }

        public static SignalingState valueOf(String string2) {
            return Enum.valueOf(SignalingState.class, string2);
        }

        public static SignalingState[] values() {
            return (SignalingState[])$VALUES.clone();
        }
    }

    public static final class TcpCandidatePolicy
    extends Enum<TcpCandidatePolicy> {
        private static final /* synthetic */ TcpCandidatePolicy[] $VALUES;
        public static final /* enum */ TcpCandidatePolicy DISABLED;
        public static final /* enum */ TcpCandidatePolicy ENABLED;

        static {
            TcpCandidatePolicy tcpCandidatePolicy;
            ENABLED = new TcpCandidatePolicy();
            DISABLED = tcpCandidatePolicy = new TcpCandidatePolicy();
            $VALUES = new TcpCandidatePolicy[]{ENABLED, tcpCandidatePolicy};
        }

        public static TcpCandidatePolicy valueOf(String string2) {
            return Enum.valueOf(TcpCandidatePolicy.class, string2);
        }

        public static TcpCandidatePolicy[] values() {
            return (TcpCandidatePolicy[])$VALUES.clone();
        }
    }

    public static final class TlsCertPolicy
    extends Enum<TlsCertPolicy> {
        private static final /* synthetic */ TlsCertPolicy[] $VALUES;
        public static final /* enum */ TlsCertPolicy TLS_CERT_POLICY_INSECURE_NO_CHECK;
        public static final /* enum */ TlsCertPolicy TLS_CERT_POLICY_SECURE;

        static {
            TlsCertPolicy tlsCertPolicy;
            TLS_CERT_POLICY_SECURE = new TlsCertPolicy();
            TLS_CERT_POLICY_INSECURE_NO_CHECK = tlsCertPolicy = new TlsCertPolicy();
            $VALUES = new TlsCertPolicy[]{TLS_CERT_POLICY_SECURE, tlsCertPolicy};
        }

        public static TlsCertPolicy valueOf(String string2) {
            return Enum.valueOf(TlsCertPolicy.class, string2);
        }

        public static TlsCertPolicy[] values() {
            return (TlsCertPolicy[])$VALUES.clone();
        }
    }
}

