/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Build;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.Logging;
import org.webrtc.PeerConnectionFactory;
import org.webrtc._$;

public class NetworkMonitorAutoDetect
extends BroadcastReceiver {
    static final long INVALID_NET_ID = -1L;
    private static final String TAG = "NetworkMonitorAutoDetect";
    private final ConnectivityManager.NetworkCallback allNetworkCallback;
    private ConnectionType connectionType;
    private ConnectivityManagerDelegate connectivityManagerDelegate;
    private final Context context;
    private final IntentFilter intentFilter;
    private boolean isRegistered;
    private final ConnectivityManager.NetworkCallback mobileNetworkCallback;
    private final Observer observer;
    private WifiDirectManagerDelegate wifiDirectManagerDelegate;
    private WifiManagerDelegate wifiManagerDelegate;
    private String wifiSSID;

    @SuppressLint(value={"NewApi"})
    public NetworkMonitorAutoDetect(Observer object, Context context) {
        this.observer = object;
        this.context = context;
        this.connectivityManagerDelegate = new ConnectivityManagerDelegate(context);
        this.wifiManagerDelegate = new WifiManagerDelegate(context);
        NetworkState networkState = this.connectivityManagerDelegate.getNetworkState();
        this.connectionType = NetworkMonitorAutoDetect.getConnectionType(networkState);
        this.wifiSSID = this.getWifiSSID(networkState);
        this.intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        if (PeerConnectionFactory.fieldTrialsFindFullName("IncludeWifiDirect").equals("Enabled")) {
            this.wifiDirectManagerDelegate = new WifiDirectManagerDelegate((Observer)object, context);
        }
        this.registerReceiver();
        if (this.connectivityManagerDelegate.supportNetworkCallback()) {
            object = new ConnectivityManager.NetworkCallback();
            try {
                this.connectivityManagerDelegate.requestMobileNetwork((ConnectivityManager.NetworkCallback)object);
            }
            catch (SecurityException securityException) {
                Logging.w(TAG, "Unable to obtain permission to request a cellular network.");
                object = null;
            }
            this.mobileNetworkCallback = object;
            object = new SimpleNetworkCallback();
            this.allNetworkCallback = object;
            this.connectivityManagerDelegate.registerNetworkCallback((ConnectivityManager.NetworkCallback)object);
        } else {
            this.mobileNetworkCallback = null;
            this.allNetworkCallback = null;
        }
    }

    private void connectionTypeChanged(NetworkState object) {
        ConnectionType connectionType = NetworkMonitorAutoDetect.getConnectionType((NetworkState)object);
        object = this.getWifiSSID((NetworkState)object);
        if (connectionType == this.connectionType && ((String)object).equals(this.wifiSSID)) {
            return;
        }
        this.connectionType = connectionType;
        this.wifiSSID = object;
        object = new StringBuilder();
        ((StringBuilder)object).append("Network connectivity changed, type is: ");
        ((StringBuilder)object).append((Object)this.connectionType);
        Logging.d(TAG, ((StringBuilder)object).toString());
        this.observer.onConnectionTypeChanged(connectionType);
    }

    public static ConnectionType getConnectionType(NetworkState networkState) {
        return NetworkMonitorAutoDetect.getConnectionType(networkState.isConnected(), networkState.getNetworkType(), networkState.getNetworkSubType());
    }

    private static ConnectionType getConnectionType(boolean bl, int n2, int n3) {
        if (!bl) {
            return ConnectionType.CONNECTION_NONE;
        }
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 6) {
                    if (n2 != 7) {
                        if (n2 != 9) {
                            if (n2 != 17) {
                                return ConnectionType.CONNECTION_UNKNOWN;
                            }
                            return ConnectionType.CONNECTION_VPN;
                        }
                        return ConnectionType.CONNECTION_ETHERNET;
                    }
                    return ConnectionType.CONNECTION_BLUETOOTH;
                }
                return ConnectionType.CONNECTION_4G;
            }
            return ConnectionType.CONNECTION_WIFI;
        }
        switch (n3) {
            default: {
                return ConnectionType.CONNECTION_UNKNOWN_CELLULAR;
            }
            case 13: {
                return ConnectionType.CONNECTION_4G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return ConnectionType.CONNECTION_3G;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
        }
        return ConnectionType.CONNECTION_2G;
    }

    private static ConnectionType getUnderlyingConnectionTypeForVpn(NetworkState networkState) {
        if (networkState.getNetworkType() != 17) {
            return ConnectionType.CONNECTION_NONE;
        }
        return NetworkMonitorAutoDetect.getConnectionType(networkState.isConnected(), networkState.getUnderlyingNetworkTypeForVpn(), networkState.getUnderlyingNetworkSubtypeForVpn());
    }

    private String getWifiSSID(NetworkState networkState) {
        if (NetworkMonitorAutoDetect.getConnectionType(networkState) != ConnectionType.CONNECTION_WIFI) {
            return "";
        }
        return this.wifiManagerDelegate.getWifiSSID();
    }

    @SuppressLint(value={"NewApi"})
    private static long networkToNetId(Network network) {
        if (Build.VERSION.SDK_INT >= 23) {
            return network.getNetworkHandle();
        }
        return Integer.parseInt(network.toString());
    }

    private void registerReceiver() {
        if (this.isRegistered) {
            return;
        }
        this.isRegistered = true;
        this.context.registerReceiver((BroadcastReceiver)this, this.intentFilter);
    }

    private void unregisterReceiver() {
        if (!this.isRegistered) {
            return;
        }
        this.isRegistered = false;
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    public void destroy() {
        Object object = this.allNetworkCallback;
        if (object != null) {
            this.connectivityManagerDelegate.releaseCallback((ConnectivityManager.NetworkCallback)object);
        }
        if ((object = this.mobileNetworkCallback) != null) {
            this.connectivityManagerDelegate.releaseCallback((ConnectivityManager.NetworkCallback)object);
        }
        if ((object = this.wifiDirectManagerDelegate) != null) {
            ((WifiDirectManagerDelegate)((Object)object)).release();
        }
        this.unregisterReceiver();
    }

    List<NetworkInformation> getActiveNetworkList() {
        List<NetworkInformation> list = this.connectivityManagerDelegate.getActiveNetworkList();
        if (list == null) {
            return null;
        }
        list = new ArrayList<NetworkInformation>(list);
        WifiDirectManagerDelegate wifiDirectManagerDelegate = this.wifiDirectManagerDelegate;
        if (wifiDirectManagerDelegate != null) {
            ((ArrayList)list).addAll(wifiDirectManagerDelegate.getActiveNetworkList());
        }
        return list;
    }

    public NetworkState getCurrentNetworkState() {
        return this.connectivityManagerDelegate.getNetworkState();
    }

    public long getDefaultNetId() {
        return this.connectivityManagerDelegate.getDefaultNetId();
    }

    boolean isReceiverRegisteredForTesting() {
        return this.isRegistered;
    }

    public void onReceive(Context object, Intent intent) {
        object = this.getCurrentNetworkState();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            this.connectionTypeChanged((NetworkState)object);
        }
    }

    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate connectivityManagerDelegate) {
        this.connectivityManagerDelegate = connectivityManagerDelegate;
    }

    void setWifiManagerDelegateForTests(WifiManagerDelegate wifiManagerDelegate) {
        this.wifiManagerDelegate = wifiManagerDelegate;
    }

    public boolean supportNetworkCallback() {
        return this.connectivityManagerDelegate.supportNetworkCallback();
    }

    public static final class ConnectionType
    extends Enum<ConnectionType> {
        private static final /* synthetic */ ConnectionType[] $VALUES;
        public static final /* enum */ ConnectionType CONNECTION_2G;
        public static final /* enum */ ConnectionType CONNECTION_3G;
        public static final /* enum */ ConnectionType CONNECTION_4G;
        public static final /* enum */ ConnectionType CONNECTION_BLUETOOTH;
        public static final /* enum */ ConnectionType CONNECTION_ETHERNET;
        public static final /* enum */ ConnectionType CONNECTION_NONE;
        public static final /* enum */ ConnectionType CONNECTION_UNKNOWN;
        public static final /* enum */ ConnectionType CONNECTION_UNKNOWN_CELLULAR;
        public static final /* enum */ ConnectionType CONNECTION_VPN;
        public static final /* enum */ ConnectionType CONNECTION_WIFI;

        static {
            ConnectionType connectionType;
            CONNECTION_UNKNOWN = new ConnectionType();
            CONNECTION_ETHERNET = new ConnectionType();
            CONNECTION_WIFI = new ConnectionType();
            CONNECTION_4G = new ConnectionType();
            CONNECTION_3G = new ConnectionType();
            CONNECTION_2G = new ConnectionType();
            CONNECTION_UNKNOWN_CELLULAR = new ConnectionType();
            CONNECTION_BLUETOOTH = new ConnectionType();
            CONNECTION_VPN = new ConnectionType();
            CONNECTION_NONE = connectionType = new ConnectionType();
            $VALUES = new ConnectionType[]{CONNECTION_UNKNOWN, CONNECTION_ETHERNET, CONNECTION_WIFI, CONNECTION_4G, CONNECTION_3G, CONNECTION_2G, CONNECTION_UNKNOWN_CELLULAR, CONNECTION_BLUETOOTH, CONNECTION_VPN, connectionType};
        }

        public static ConnectionType valueOf(String string2) {
            return Enum.valueOf(ConnectionType.class, string2);
        }

        public static ConnectionType[] values() {
            return (ConnectionType[])$VALUES.clone();
        }
    }

    static class ConnectivityManagerDelegate {
        private final ConnectivityManager connectivityManager;

        ConnectivityManagerDelegate() {
            this.connectivityManager = null;
        }

        ConnectivityManagerDelegate(Context context) {
            this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        private NetworkState getNetworkState(NetworkInfo networkInfo) {
            if (networkInfo != null && networkInfo.isConnected()) {
                return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), -1, -1);
            }
            return new NetworkState(false, -1, -1, -1, -1);
        }

        @SuppressLint(value={"NewApi"})
        private NetworkInformation networkToInfo(Network network) {
            ConnectivityManager connectivityManager = null;
            Object object = connectivityManager;
            if (network != null) {
                object = this.connectivityManager;
                if (object == null) {
                    object = connectivityManager;
                } else {
                    connectivityManager = object.getLinkProperties(network);
                    if (connectivityManager == null) {
                        object = new StringBuilder();
                        object.append("Detected unknown network: ");
                        object.append(network.toString());
                        Logging.w(NetworkMonitorAutoDetect.TAG, object.toString());
                        return null;
                    }
                    if (connectivityManager.getInterfaceName() == null) {
                        object = new StringBuilder();
                        object.append("Null interface name for network ");
                        object.append(network.toString());
                        Logging.w(NetworkMonitorAutoDetect.TAG, object.toString());
                        return null;
                    }
                    Object object2 = this.getNetworkState(network);
                    object = NetworkMonitorAutoDetect.getConnectionType((NetworkState)object2);
                    if (object == ConnectionType.CONNECTION_NONE) {
                        object = new StringBuilder();
                        object.append("Network ");
                        object.append(network.toString());
                        object.append(" is disconnected");
                        Logging.d(NetworkMonitorAutoDetect.TAG, object.toString());
                        return null;
                    }
                    if (object == ConnectionType.CONNECTION_UNKNOWN || object == ConnectionType.CONNECTION_UNKNOWN_CELLULAR) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Network ");
                        stringBuilder.append(network.toString());
                        stringBuilder.append(" connection type is ");
                        stringBuilder.append(object);
                        stringBuilder.append(" because it has type ");
                        stringBuilder.append(((NetworkState)object2).getNetworkType());
                        stringBuilder.append(" and subtype ");
                        stringBuilder.append(((NetworkState)object2).getNetworkSubType());
                        Logging.d(NetworkMonitorAutoDetect.TAG, stringBuilder.toString());
                    }
                    object2 = NetworkMonitorAutoDetect.getUnderlyingConnectionTypeForVpn((NetworkState)object2);
                    object = new NetworkInformation(connectivityManager.getInterfaceName(), (ConnectionType)((Object)object), (ConnectionType)((Object)object2), NetworkMonitorAutoDetect.networkToNetId(network), this.getIPAddresses((LinkProperties)connectivityManager));
                }
            }
            return object;
        }

        List<NetworkInformation> getActiveNetworkList() {
            if (!this.supportNetworkCallback()) {
                return null;
            }
            ArrayList<NetworkInformation> arrayList = new ArrayList<NetworkInformation>();
            Network[] networkArray = this.getAllNetworks();
            int n2 = networkArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                NetworkInformation networkInformation = this.networkToInfo(networkArray[i3]);
                if (networkInformation == null) continue;
                arrayList.add(networkInformation);
            }
            return arrayList;
        }

        @SuppressLint(value={"NewApi"})
        Network[] getAllNetworks() {
            ConnectivityManager connectivityManager = this.connectivityManager;
            if (connectivityManager == null) {
                return new Network[0];
            }
            return connectivityManager.getAllNetworks();
        }

        @SuppressLint(value={"NewApi"})
        long getDefaultNetId() {
            if (!this.supportNetworkCallback()) {
                return -1L;
            }
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return -1L;
            }
            Network[] networkArray = this.getAllNetworks();
            int n2 = networkArray.length;
            long l3 = -1L;
            for (int i3 = 0; i3 < n2; ++i3) {
                long l4;
                Network network = networkArray[i3];
                if (!this.hasInternetCapability(network)) {
                    l4 = l3;
                } else {
                    NetworkInfo networkInfo2 = this.connectivityManager.getNetworkInfo(network);
                    l4 = l3;
                    if (networkInfo2 != null) {
                        l4 = l3;
                        if (networkInfo2.getType() == networkInfo.getType()) {
                            if (l3 == -1L) {
                                l4 = NetworkMonitorAutoDetect.networkToNetId(network);
                            } else {
                                throw new RuntimeException("Multiple connected networks of same type are not supported.");
                            }
                        }
                    }
                }
                l3 = l4;
            }
            return l3;
        }

        @SuppressLint(value={"NewApi"})
        IPAddress[] getIPAddresses(LinkProperties object) {
            IPAddress[] iPAddressArray = new IPAddress[object.getLinkAddresses().size()];
            object = object.getLinkAddresses().iterator();
            int n2 = 0;
            while (object.hasNext()) {
                iPAddressArray[n2] = new IPAddress(((LinkAddress)object.next()).getAddress().getAddress());
                ++n2;
            }
            return iPAddressArray;
        }

        NetworkState getNetworkState() {
            ConnectivityManager connectivityManager = this.connectivityManager;
            if (connectivityManager == null) {
                return new NetworkState(false, -1, -1, -1, -1);
            }
            return this.getNetworkState(connectivityManager.getActiveNetworkInfo());
        }

        @SuppressLint(value={"NewApi"})
        NetworkState getNetworkState(Network network) {
            Object object;
            if (network != null && (object = this.connectivityManager) != null) {
                if ((object = object.getNetworkInfo(network)) == null) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Couldn't retrieve information from network ");
                    ((StringBuilder)object).append(network.toString());
                    Logging.w(NetworkMonitorAutoDetect.TAG, ((StringBuilder)object).toString());
                    return new NetworkState(false, -1, -1, -1, -1);
                }
                if (object.getType() != 17) {
                    if ((network = this.connectivityManager.getNetworkCapabilities(network)) != null && network.hasTransport(4)) {
                        return new NetworkState(object.isConnected(), 17, -1, object.getType(), object.getSubtype());
                    }
                    return this.getNetworkState((NetworkInfo)object);
                }
                if (object.getType() == 17) {
                    if (Build.VERSION.SDK_INT >= 23 && network.equals((Object)this.connectivityManager.getActiveNetwork()) && (network = this.connectivityManager.getActiveNetworkInfo()) != null && network.getType() != 17) {
                        return new NetworkState(object.isConnected(), 17, -1, network.getType(), network.getSubtype());
                    }
                    return new NetworkState(object.isConnected(), 17, -1, -1, -1);
                }
                return this.getNetworkState((NetworkInfo)object);
            }
            return new NetworkState(false, -1, -1, -1, -1);
        }

        @SuppressLint(value={"NewApi"})
        boolean hasInternetCapability(Network network) {
            ConnectivityManager connectivityManager = this.connectivityManager;
            boolean bl = false;
            if (connectivityManager == null) {
                return false;
            }
            network = connectivityManager.getNetworkCapabilities(network);
            boolean bl2 = bl;
            if (network != null) {
                bl2 = bl;
                if (network.hasCapability(12)) {
                    bl2 = true;
                }
            }
            return bl2;
        }

        @SuppressLint(value={"NewApi"})
        public void registerNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
            this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().addCapability(12).build(), networkCallback);
        }

        @SuppressLint(value={"NewApi"})
        public void releaseCallback(ConnectivityManager.NetworkCallback networkCallback) {
            if (this.supportNetworkCallback()) {
                Logging.d(NetworkMonitorAutoDetect.TAG, "Unregister network callback");
                this.connectivityManager.unregisterNetworkCallback(networkCallback);
            }
        }

        @SuppressLint(value={"NewApi"})
        public void requestMobileNetwork(ConnectivityManager.NetworkCallback networkCallback) {
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            builder.addCapability(12).addTransportType(0);
            this.connectivityManager.requestNetwork(builder.build(), networkCallback);
        }

        public boolean supportNetworkCallback() {
            boolean bl = Build.VERSION.SDK_INT >= 21 && this.connectivityManager != null;
            return bl;
        }
    }

    public static class IPAddress {
        public final byte[] address;

        public IPAddress(byte[] byArray) {
            this.address = byArray;
        }

        @CalledByNative(value="IPAddress")
        private byte[] getAddress() {
            return this.address;
        }
    }

    public static class NetworkInformation {
        public final long handle;
        public final IPAddress[] ipAddresses;
        public final String name;
        public final ConnectionType type;
        public final ConnectionType underlyingTypeForVpn;

        public NetworkInformation(String string2, ConnectionType connectionType, ConnectionType connectionType2, long l3, IPAddress[] iPAddressArray) {
            this.name = string2;
            this.type = connectionType;
            this.underlyingTypeForVpn = connectionType2;
            this.handle = l3;
            this.ipAddresses = iPAddressArray;
        }

        @CalledByNative(value="NetworkInformation")
        private ConnectionType getConnectionType() {
            return this.type;
        }

        @CalledByNative(value="NetworkInformation")
        private long getHandle() {
            return this.handle;
        }

        @CalledByNative(value="NetworkInformation")
        private IPAddress[] getIpAddresses() {
            return this.ipAddresses;
        }

        @CalledByNative(value="NetworkInformation")
        private String getName() {
            return this.name;
        }

        @CalledByNative(value="NetworkInformation")
        private ConnectionType getUnderlyingConnectionTypeForVpn() {
            return this.underlyingTypeForVpn;
        }
    }

    static class NetworkState {
        private final boolean connected;
        private final int subtype;
        private final int type;
        private final int underlyingNetworkSubtypeForVpn;
        private final int underlyingNetworkTypeForVpn;

        public NetworkState(boolean bl, int n2, int n3, int n4, int n5) {
            this.connected = bl;
            this.type = n2;
            this.subtype = n3;
            this.underlyingNetworkTypeForVpn = n4;
            this.underlyingNetworkSubtypeForVpn = n5;
        }

        public int getNetworkSubType() {
            return this.subtype;
        }

        public int getNetworkType() {
            return this.type;
        }

        public int getUnderlyingNetworkSubtypeForVpn() {
            return this.underlyingNetworkSubtypeForVpn;
        }

        public int getUnderlyingNetworkTypeForVpn() {
            return this.underlyingNetworkTypeForVpn;
        }

        public boolean isConnected() {
            return this.connected;
        }
    }

    public static interface Observer {
        public void onConnectionTypeChanged(ConnectionType var1);

        public void onNetworkConnect(NetworkInformation var1);

        public void onNetworkDisconnect(long var1);
    }

    @SuppressLint(value={"NewApi"})
    private class SimpleNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private SimpleNetworkCallback() {
        }

        private void onNetworkChanged(Network object) {
            object = NetworkMonitorAutoDetect.this.connectivityManagerDelegate.networkToInfo(object);
            if (object != null) {
                NetworkMonitorAutoDetect.this.observer.onNetworkConnect((NetworkInformation)object);
            }
        }

        public void onAvailable(Network network) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Network becomes available: ");
            stringBuilder.append(network.toString());
            Logging.d(NetworkMonitorAutoDetect.TAG, stringBuilder.toString());
            this.onNetworkChanged(network);
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("capabilities changed: ");
            stringBuilder.append(networkCapabilities.toString());
            Logging.d(NetworkMonitorAutoDetect.TAG, stringBuilder.toString());
            this.onNetworkChanged(network);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("link properties changed: ");
            stringBuilder.append(linkProperties.toString());
            Logging.d(NetworkMonitorAutoDetect.TAG, stringBuilder.toString());
            this.onNetworkChanged(network);
        }

        public void onLosing(Network network, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Network ");
            stringBuilder.append(network.toString());
            stringBuilder.append(" is about to lose in ");
            stringBuilder.append(n2);
            stringBuilder.append("ms");
            Logging.d(NetworkMonitorAutoDetect.TAG, stringBuilder.toString());
        }

        public void onLost(Network network) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Network ");
            stringBuilder.append(network.toString());
            stringBuilder.append(" is disconnected");
            Logging.d(NetworkMonitorAutoDetect.TAG, stringBuilder.toString());
            NetworkMonitorAutoDetect.this.observer.onNetworkDisconnect(NetworkMonitorAutoDetect.networkToNetId(network));
        }
    }

    static class WifiDirectManagerDelegate
    extends BroadcastReceiver {
        private static final int WIFI_P2P_NETWORK_HANDLE = 0;
        private final Context context;
        private final Observer observer;
        private NetworkInformation wifiP2pNetworkInfo;

        WifiDirectManagerDelegate(Observer observer, Context context) {
            this.context = context;
            this.observer = observer;
            observer = new IntentFilter();
            observer.addAction("android.net.wifi.p2p.STATE_CHANGED");
            observer.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
            context.registerReceiver((BroadcastReceiver)this, (IntentFilter)observer);
            if (Build.VERSION.SDK_INT > 28) {
                observer = (WifiP2pManager)context.getSystemService("wifip2p");
                observer.requestGroupInfo(observer.initialize(context, context.getMainLooper(), null), (WifiP2pManager.GroupInfoListener)new _$.Lambda.NetworkMonitorAutoDetect.WifiDirectManagerDelegate.PAAk_X_hIXqIjU2H1jOXAR0m8dY(this));
            }
        }

        private void onWifiP2pGroupChange(WifiP2pGroup object) {
            if (object != null && object.getInterface() != null) {
                IPAddress[] iPAddressArray;
                try {
                    iPAddressArray = NetworkInterface.getByName(object.getInterface());
                }
                catch (SocketException socketException) {
                    Logging.e(NetworkMonitorAutoDetect.TAG, "Unable to get WifiP2p network interface", socketException);
                }
                ArrayList<InetAddress> arrayList = Collections.list(iPAddressArray.getInetAddresses());
                iPAddressArray = new IPAddress[arrayList.size()];
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    iPAddressArray[i3] = new IPAddress(((InetAddress)arrayList.get(i3)).getAddress());
                }
                object = new NetworkInformation(object.getInterface(), ConnectionType.CONNECTION_WIFI, ConnectionType.CONNECTION_NONE, 0L, iPAddressArray);
                this.wifiP2pNetworkInfo = object;
                this.observer.onNetworkConnect((NetworkInformation)object);
                return;
            }
        }

        private void onWifiP2pStateChange(int n2) {
            if (n2 == 1) {
                this.wifiP2pNetworkInfo = null;
                this.observer.onNetworkDisconnect(0L);
            }
        }

        public List<NetworkInformation> getActiveNetworkList() {
            NetworkInformation networkInformation = this.wifiP2pNetworkInfo;
            if (networkInformation != null) {
                return Collections.singletonList(networkInformation);
            }
            return Collections.emptyList();
        }

        public /* synthetic */ void lambda$new$0$NetworkMonitorAutoDetect$WifiDirectManagerDelegate(WifiP2pGroup wifiP2pGroup) {
            this.onWifiP2pGroupChange(wifiP2pGroup);
        }

        @SuppressLint(value={"InlinedApi"})
        public void onReceive(Context context, Intent intent) {
            if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(intent.getAction())) {
                this.onWifiP2pGroupChange((WifiP2pGroup)intent.getParcelableExtra("p2pGroupInfo"));
            } else if ("android.net.wifi.p2p.STATE_CHANGED".equals(intent.getAction())) {
                this.onWifiP2pStateChange(intent.getIntExtra("wifi_p2p_state", 0));
            }
        }

        public void release() {
            this.context.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    static class WifiManagerDelegate {
        private final Context context;

        WifiManagerDelegate() {
            this.context = null;
        }

        WifiManagerDelegate(Context context) {
            this.context = context;
        }

        String getWifiSSID() {
            Object object = this.context.registerReceiver(null, new IntentFilter("android.net.wifi.STATE_CHANGE"));
            if (object != null && (object = (WifiInfo)object.getParcelableExtra("wifiInfo")) != null && (object = object.getSSID()) != null) {
                return object;
            }
            return "";
        }
    }
}

