/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.Build;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.ContextUtils;
import org.webrtc.Logging;
import org.webrtc.NetworkMonitorAutoDetect;

public class NetworkMonitor {
    private static final String TAG = "NetworkMonitor";
    private NetworkMonitorAutoDetect autoDetect;
    private final Object autoDetectLock = new Object();
    private volatile NetworkMonitorAutoDetect.ConnectionType currentConnectionType;
    private final ArrayList<Long> nativeNetworkObservers = new ArrayList();
    private final ArrayList<NetworkObserver> networkObservers = new ArrayList();
    private int numObservers = 0;

    private NetworkMonitor() {
        this.currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;
    }

    @Deprecated
    public static void addNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().addObserver(networkObserver);
    }

    @CalledByNative
    private static int androidSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    private static void assertIsTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected to be true");
    }

    static NetworkMonitorAutoDetect createAndSetAutoDetectForTest(Context object) {
        NetworkMonitor networkMonitor = NetworkMonitor.getInstance();
        object = networkMonitor.createAutoDetect((Context)object);
        networkMonitor.autoDetect = object;
        return object;
    }

    private NetworkMonitorAutoDetect createAutoDetect(Context context) {
        return new NetworkMonitorAutoDetect(new NetworkMonitorAutoDetect.Observer(){

            @Override
            public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType connectionType) {
                NetworkMonitor.this.updateCurrentConnectionType(connectionType);
            }

            @Override
            public void onNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
                NetworkMonitor.this.notifyObserversOfNetworkConnect(networkInformation);
            }

            @Override
            public void onNetworkDisconnect(long l3) {
                NetworkMonitor.this.notifyObserversOfNetworkDisconnect(l3);
            }
        }, context);
    }

    private NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getCurrentDefaultNetId() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            if (this.autoDetect != null) return this.autoDetect.getDefaultNetId();
            return -1L;
        }
    }

    @CalledByNative
    public static NetworkMonitor getInstance() {
        return InstanceHolder.instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Long> getNativeNetworkObserversSync() {
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            return new ArrayList<Long>(this.nativeNetworkObservers);
        }
    }

    @Deprecated
    public static void init(Context context) {
    }

    public static boolean isOnline() {
        boolean bl = NetworkMonitor.getInstance().getCurrentConnectionType() != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE;
        return bl;
    }

    private native void nativeNotifyConnectionTypeChanged(long var1);

    private native void nativeNotifyOfActiveNetworkList(long var1, NetworkMonitorAutoDetect.NetworkInformation[] var3);

    private native void nativeNotifyOfNetworkConnect(long var1, NetworkMonitorAutoDetect.NetworkInformation var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNative
    private boolean networkBindingSupported() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            if (this.autoDetect == null) return false;
            if (!this.autoDetect.supportNetworkCallback()) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        Iterator iterator = this.getNativeNetworkObserversSync().iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyConnectionTypeChanged(iterator.next());
        }
        iterator = this.networkObservers;
        synchronized (iterator) {
            ArrayList<NetworkObserver> arrayList = new ArrayList<NetworkObserver>(this.networkObservers);
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_3
            iterator = arrayList.iterator();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        while (iterator.hasNext()) {
            ((NetworkObserver)iterator.next()).onConnectionTypeChanged(connectionType);
        }
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
        Iterator<Long> iterator = this.getNativeNetworkObserversSync().iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkConnect(iterator.next(), networkInformation);
        }
    }

    private void notifyObserversOfNetworkDisconnect(long l3) {
        Iterator<Long> iterator = this.getNativeNetworkObserversSync().iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkDisconnect(iterator.next(), l3);
        }
    }

    @Deprecated
    public static void removeNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().removeObserver(networkObserver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNative
    private void startMonitoring(Context context, long l3) {
        Serializable serializable = new StringBuilder();
        serializable.append("Start monitoring with native observer ");
        serializable.append(l3);
        Logging.d(TAG, serializable.toString());
        if (context == null) {
            context = ContextUtils.getApplicationContext();
        }
        this.startMonitoring(context);
        serializable = this.nativeNetworkObservers;
        synchronized (serializable) {
            this.nativeNetworkObservers.add(l3);
        }
        this.updateObserverActiveNetworkList(l3);
        this.notifyObserversOfConnectionTypeChange(this.currentConnectionType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNative
    private void stopMonitoring(long l3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Stop monitoring with native observer ");
        stringBuilder.append(l3);
        Logging.d(TAG, stringBuilder.toString());
        this.stopMonitoring();
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            this.nativeNetworkObservers.remove(l3);
            return;
        }
    }

    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        this.currentConnectionType = connectionType;
        this.notifyObserversOfConnectionTypeChange(connectionType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateObserverActiveNetworkList(long l3) {
        List<NetworkMonitorAutoDetect.NetworkInformation> list;
        Object object = this.autoDetectLock;
        synchronized (object) {
            list = this.autoDetect == null ? null : this.autoDetect.getActiveNetworkList();
        }
        if (list == null) return;
        if (list.size() == 0) {
            return;
        }
        this.nativeNotifyOfActiveNetworkList(l3, list.toArray(new NetworkMonitorAutoDetect.NetworkInformation[list.size()]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addObserver(NetworkObserver networkObserver) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.add(networkObserver);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    NetworkMonitorAutoDetect getNetworkMonitorAutoDetect() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getNumObservers() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.numObservers;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeObserver(NetworkObserver networkObserver) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.remove(networkObserver);
            return;
        }
    }

    @Deprecated
    public void startMonitoring() {
        this.startMonitoring(ContextUtils.getApplicationContext());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startMonitoring(Context context) {
        Object object = this.autoDetectLock;
        synchronized (object) {
            ++this.numObservers;
            if (this.autoDetect == null) {
                this.autoDetect = this.createAutoDetect(context);
            }
            this.currentConnectionType = NetworkMonitorAutoDetect.getConnectionType(this.autoDetect.getCurrentNetworkState());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopMonitoring() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            int n2;
            this.numObservers = n2 = this.numObservers - 1;
            if (n2 == 0) {
                this.autoDetect.destroy();
                this.autoDetect = null;
            }
            return;
        }
    }

    private static class InstanceHolder {
        static final NetworkMonitor instance = new NetworkMonitor();

        private InstanceHolder() {
        }
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);
    }
}

