/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.Logging;
import org.webrtc.NativeLibraryLoader;

class NativeLibrary {
    private static String TAG = "NativeLibrary";
    private static boolean libraryLoaded;
    private static Object lock;

    static {
        lock = new Object();
    }

    NativeLibrary() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void initialize(NativeLibraryLoader nativeLibraryLoader, String string2) {
        Object object = lock;
        synchronized (object) {
            if (libraryLoaded) {
                Logging.d(TAG, "Native library has already been loaded.");
                return;
            }
            String string3 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Loading native library: ");
            stringBuilder.append(string2);
            Logging.d(string3, stringBuilder.toString());
            libraryLoaded = nativeLibraryLoader.load(string2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isLoaded() {
        Object object = lock;
        synchronized (object) {
            return libraryLoaded;
        }
    }

    static class DefaultLoader
    implements NativeLibraryLoader {
        DefaultLoader() {
        }

        @Override
        public boolean load(String string2) {
            String string3 = TAG;
            CharSequence charSequence = new StringBuilder();
            charSequence.append("Loading library: ");
            charSequence.append(string2);
            Logging.d(string3, charSequence.toString());
            try {
                System.loadLibrary(string2);
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                charSequence = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Failed to load native library: ");
                stringBuilder.append(string2);
                Logging.e((String)charSequence, stringBuilder.toString(), unsatisfiedLinkError);
                return false;
            }
        }
    }
}

