/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.CapturerObserver;
import org.webrtc.NativeAndroidVideoTrackSource;
import org.webrtc.VideoFrame;
import org.webrtc.VideoProcessor;

class NativeCapturerObserver
implements CapturerObserver {
    private final NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource;

    @CalledByNative
    public NativeCapturerObserver(long l3) {
        this.nativeAndroidVideoTrackSource = new NativeAndroidVideoTrackSource(l3);
    }

    public void onCapturerStarted(boolean bl) {
        this.nativeAndroidVideoTrackSource.setState(bl);
    }

    public void onCapturerStopped() {
        this.nativeAndroidVideoTrackSource.setState(false);
    }

    public void onFrameCaptured(VideoFrame videoFrame) {
        VideoProcessor.FrameAdaptationParameters frameAdaptationParameters = this.nativeAndroidVideoTrackSource.adaptFrame(videoFrame);
        if (frameAdaptationParameters == null) {
            return;
        }
        VideoFrame.Buffer buffer = videoFrame.getBuffer().cropAndScale(frameAdaptationParameters.cropX, frameAdaptationParameters.cropY, frameAdaptationParameters.cropWidth, frameAdaptationParameters.cropHeight, frameAdaptationParameters.scaleWidth, frameAdaptationParameters.scaleHeight);
        this.nativeAndroidVideoTrackSource.onFrameCaptured(new VideoFrame(buffer, videoFrame.getRotation(), frameAdaptationParameters.timestampNs));
        buffer.release();
    }
}

