/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.AudioTrack;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;
import org.webrtc.VideoTrack;

public class MediaStreamTrack {
    public static final String AUDIO_TRACK_KIND = "audio";
    public static final String VIDEO_TRACK_KIND = "video";
    private long nativeTrack;

    public MediaStreamTrack(long l3) {
        if (l3 != 0L) {
            this.nativeTrack = l3;
            return;
        }
        throw new IllegalArgumentException("nativeTrack may not be null");
    }

    private void checkMediaStreamTrackExists() {
        if (this.nativeTrack != 0L) {
            return;
        }
        throw new IllegalStateException("MediaStreamTrack has been disposed.");
    }

    static MediaStreamTrack createMediaStreamTrack(long l3) {
        VideoTrack videoTrack = null;
        if (l3 == 0L) {
            return null;
        }
        String string2 = MediaStreamTrack.nativeGetKind(l3);
        if (string2.equals(AUDIO_TRACK_KIND)) {
            return new AudioTrack(l3);
        }
        if (string2.equals(VIDEO_TRACK_KIND)) {
            videoTrack = new VideoTrack(l3);
        }
        return videoTrack;
    }

    private static native boolean nativeGetEnabled(long var0);

    private static native String nativeGetId(long var0);

    private static native String nativeGetKind(long var0);

    private static native State nativeGetState(long var0);

    private static native boolean nativeSetEnabled(long var0, boolean var2);

    public void dispose() {
        this.checkMediaStreamTrackExists();
        JniCommon.nativeReleaseRef(this.nativeTrack);
        this.nativeTrack = 0L;
    }

    public boolean enabled() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetEnabled(this.nativeTrack);
    }

    long getNativeMediaStreamTrack() {
        this.checkMediaStreamTrackExists();
        return this.nativeTrack;
    }

    public String id() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetId(this.nativeTrack);
    }

    public String kind() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetKind(this.nativeTrack);
    }

    public boolean setEnabled(boolean bl) {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeSetEnabled(this.nativeTrack, bl);
    }

    public State state() {
        this.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetState(this.nativeTrack);
    }

    public static final class MediaType
    extends Enum<MediaType> {
        private static final /* synthetic */ MediaType[] $VALUES;
        public static final /* enum */ MediaType MEDIA_TYPE_AUDIO;
        public static final /* enum */ MediaType MEDIA_TYPE_VIDEO;
        private final int nativeIndex;

        static {
            MediaType mediaType;
            MEDIA_TYPE_AUDIO = new MediaType(0);
            MEDIA_TYPE_VIDEO = mediaType = new MediaType(1);
            $VALUES = new MediaType[]{MEDIA_TYPE_AUDIO, mediaType};
        }

        private MediaType(int n3) {
            this.nativeIndex = n3;
        }

        @CalledByNative(value="MediaType")
        static MediaType fromNativeIndex(int n2) {
            Object object2;
            for (Object object2 : MediaType.values()) {
                if (object2.getNative() != n2) continue;
                return object2;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Unknown native media type: ");
            ((StringBuilder)object2).append(n2);
            object2 = new IllegalArgumentException(((StringBuilder)object2).toString());
            throw object2;
        }

        public static MediaType valueOf(String string2) {
            return Enum.valueOf(MediaType.class, string2);
        }

        public static MediaType[] values() {
            return (MediaType[])$VALUES.clone();
        }

        @CalledByNative(value="MediaType")
        int getNative() {
            return this.nativeIndex;
        }
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ENDED;
        public static final /* enum */ State LIVE;

        static {
            State state;
            LIVE = new State();
            ENDED = state = new State();
            $VALUES = new State[]{LIVE, state};
        }

        @CalledByNative(value="State")
        static State fromNativeIndex(int n2) {
            return State.values()[n2];
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

