/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.webrtc.AudioTrack;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;
import org.webrtc.Logging;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoTrack;

public class MediaStream {
    private static final String TAG = "MediaStream";
    public final List<AudioTrack> audioTracks = new ArrayList<AudioTrack>();
    private long nativeStream;
    public final List<VideoTrack> preservedVideoTracks;
    public final List<VideoTrack> videoTracks = new ArrayList<VideoTrack>();

    @CalledByNative
    public MediaStream(long l3) {
        this.preservedVideoTracks = new ArrayList<VideoTrack>();
        this.nativeStream = l3;
    }

    private void checkMediaStreamExists() {
        if (this.nativeStream != 0L) {
            return;
        }
        throw new IllegalStateException("MediaStream has been disposed.");
    }

    private static native boolean nativeAddAudioTrackToNativeStream(long var0, long var2);

    private static native boolean nativeAddVideoTrackToNativeStream(long var0, long var2);

    private static native String nativeGetId(long var0);

    private static native boolean nativeRemoveAudioTrack(long var0, long var2);

    private static native boolean nativeRemoveVideoTrack(long var0, long var2);

    private static void removeMediaStreamTrack(List<? extends MediaStreamTrack> object, long l3) {
        Iterator<? extends MediaStreamTrack> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((MediaStreamTrack)object).getNativeMediaStreamTrack() != l3) continue;
            ((MediaStreamTrack)object).dispose();
            iterator.remove();
            return;
        }
        Logging.e(TAG, "Couldn't not find track");
    }

    @CalledByNative
    void addNativeAudioTrack(long l3) {
        this.audioTracks.add(new AudioTrack(l3));
    }

    @CalledByNative
    void addNativeVideoTrack(long l3) {
        this.videoTracks.add(new VideoTrack(l3));
    }

    public boolean addPreservedTrack(VideoTrack videoTrack) {
        this.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(this.nativeStream, videoTrack.getNativeVideoTrack())) {
            this.preservedVideoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean addTrack(AudioTrack audioTrack) {
        this.checkMediaStreamExists();
        if (MediaStream.nativeAddAudioTrackToNativeStream(this.nativeStream, audioTrack.getNativeAudioTrack())) {
            this.audioTracks.add(audioTrack);
            return true;
        }
        return false;
    }

    public boolean addTrack(VideoTrack videoTrack) {
        this.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(this.nativeStream, videoTrack.getNativeVideoTrack())) {
            this.videoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    @CalledByNative
    public void dispose() {
        Object object;
        this.checkMediaStreamExists();
        while (!this.audioTracks.isEmpty()) {
            object = this.audioTracks.get(0);
            this.removeTrack((AudioTrack)object);
            ((MediaStreamTrack)object).dispose();
        }
        while (!this.videoTracks.isEmpty()) {
            object = this.videoTracks.get(0);
            this.removeTrack((VideoTrack)object);
            ((VideoTrack)object).dispose();
        }
        while (!this.preservedVideoTracks.isEmpty()) {
            this.removeTrack(this.preservedVideoTracks.get(0));
        }
        JniCommon.nativeReleaseRef(this.nativeStream);
        this.nativeStream = 0L;
    }

    public String getId() {
        this.checkMediaStreamExists();
        return MediaStream.nativeGetId(this.nativeStream);
    }

    long getNativeMediaStream() {
        this.checkMediaStreamExists();
        return this.nativeStream;
    }

    @CalledByNative
    void removeAudioTrack(long l3) {
        MediaStream.removeMediaStreamTrack(this.audioTracks, l3);
    }

    public boolean removeTrack(AudioTrack audioTrack) {
        this.checkMediaStreamExists();
        this.audioTracks.remove(audioTrack);
        return MediaStream.nativeRemoveAudioTrack(this.nativeStream, audioTrack.getNativeAudioTrack());
    }

    public boolean removeTrack(VideoTrack videoTrack) {
        this.checkMediaStreamExists();
        this.videoTracks.remove(videoTrack);
        this.preservedVideoTracks.remove(videoTrack);
        return MediaStream.nativeRemoveVideoTrack(this.nativeStream, videoTrack.getNativeVideoTrack());
    }

    @CalledByNative
    void removeVideoTrack(long l3) {
        MediaStream.removeMediaStreamTrack(this.videoTracks, l3);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.getId());
        stringBuilder.append(":A=");
        stringBuilder.append(this.audioTracks.size());
        stringBuilder.append(":V=");
        stringBuilder.append(this.videoTracks.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

