/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;

public class MediaSource {
    private long nativeSource;

    public MediaSource(long l3) {
        this.nativeSource = l3;
    }

    private void checkMediaSourceExists() {
        if (this.nativeSource != 0L) {
            return;
        }
        throw new IllegalStateException("MediaSource has been disposed.");
    }

    private static native State nativeGetState(long var0);

    public void dispose() {
        this.checkMediaSourceExists();
        JniCommon.nativeReleaseRef(this.nativeSource);
        this.nativeSource = 0L;
    }

    protected long getNativeMediaSource() {
        this.checkMediaSourceExists();
        return this.nativeSource;
    }

    public State state() {
        this.checkMediaSourceExists();
        return MediaSource.nativeGetState(this.nativeSource);
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ENDED;
        public static final /* enum */ State INITIALIZING;
        public static final /* enum */ State LIVE;
        public static final /* enum */ State MUTED;

        static {
            State state;
            INITIALIZING = new State();
            LIVE = new State();
            ENDED = new State();
            MUTED = state = new State();
            $VALUES = new State[]{INITIALIZING, LIVE, ENDED, state};
        }

        @CalledByNative(value="State")
        static State fromNativeIndex(int n2) {
            return State.values()[n2];
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

