/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.List;
import org.webrtc.CalledByNative;

public class MediaConstraints {
    public final List<KeyValuePair> mandatory = new ArrayList<KeyValuePair>();
    public final List<KeyValuePair> optional = new ArrayList<KeyValuePair>();

    private static String stringifyKeyValuePairList(List<KeyValuePair> object) {
        StringBuilder stringBuilder = new StringBuilder("[");
        object = object.iterator();
        while (object.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)object.next();
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(keyValuePair.toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @CalledByNative
    List<KeyValuePair> getMandatory() {
        return this.mandatory;
    }

    @CalledByNative
    List<KeyValuePair> getOptional() {
        return this.optional;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mandatory: ");
        stringBuilder.append(MediaConstraints.stringifyKeyValuePairList(this.mandatory));
        stringBuilder.append(", optional: ");
        stringBuilder.append(MediaConstraints.stringifyKeyValuePairList(this.optional));
        return stringBuilder.toString();
    }

    public static class KeyValuePair {
        private final String key;
        private final String value;

        public KeyValuePair(String string2, String string3) {
            this.key = string2;
            this.value = string3;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && KeyValuePair.class == object.getClass()) {
                object = (KeyValuePair)object;
                if (!this.key.equals(((KeyValuePair)object).key) || !this.value.equals(((KeyValuePair)object).value)) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        @CalledByNative(value="KeyValuePair")
        public String getKey() {
            return this.key;
        }

        @CalledByNative(value="KeyValuePair")
        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.key.hashCode() + this.value.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append(": ");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }
}

