/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.webrtc.CalledByNative;
import org.webrtc.CalledByNativeUnchecked;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.EglBase$_CC;
import org.webrtc.EglBase14;
import org.webrtc.GlRectDrawer;
import org.webrtc.H264Utils;
import org.webrtc.Logging;
import org.webrtc.MediaCodecVideoDecoder;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoEncoderFactory$_CC;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc.WrappedNativeVideoEncoder;

@Deprecated
@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    private static final int BITRATE_ADJUSTMENT_FPS = 30;
    private static final double BITRATE_CORRECTION_MAX_SCALE = 4.0;
    private static final double BITRATE_CORRECTION_SEC = 3.0;
    private static final int BITRATE_CORRECTION_STEPS = 20;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static final String[] H264_HW_EXCEPTION_MODELS;
    private static final String H264_MIME_TYPE = "video/avc";
    private static final int MAXIMUM_INITIAL_FPS = 30;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000L;
    private static final String TAG = "MediaCodecVideoEncoder";
    private static final int VIDEO_AVCLevel3 = 256;
    private static final int VIDEO_AVCProfileHigh = 8;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static int codecErrors;
    private static MediaCodecVideoEncoderErrorCallback errorCallback;
    private static final MediaCodecProperties exynosH264HighProfileHwProperties;
    private static final MediaCodecProperties exynosH264HwProperties;
    private static final MediaCodecProperties exynosVp8HwProperties;
    private static final MediaCodecProperties exynosVp9HwProperties;
    private static final MediaCodecProperties[] h264HighProfileHwList;
    private static Set<String> hwEncoderDisabledTypes;
    private static final MediaCodecProperties intelVp8HwProperties;
    private static final MediaCodecProperties mediatekH264HwProperties;
    private static final MediaCodecProperties qcomH264HwProperties;
    private static final MediaCodecProperties qcomVp8HwProperties;
    private static final MediaCodecProperties qcomVp9HwProperties;
    private static MediaCodecVideoEncoder runningInstance;
    private static EglBase staticEglBase;
    private static final int[] supportedColorList;
    private static final int[] supportedSurfaceColorList;
    private static final MediaCodecProperties[] vp9HwList;
    private double bitrateAccumulator;
    private double bitrateAccumulatorMax;
    private int bitrateAdjustmentScaleExp;
    private BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
    private double bitrateObservationTimeMs;
    private int colorFormat;
    private ByteBuffer configData;
    private GlRectDrawer drawer;
    private EglBase14 eglBase;
    private long forcedKeyFrameMs;
    private int height;
    private Surface inputSurface;
    private long lastKeyFrameMs;
    private MediaCodec mediaCodec;
    private Thread mediaCodecThread;
    private ByteBuffer[] outputBuffers;
    private int profile;
    private int targetBitrateBps;
    private int targetFps;
    private VideoCodecType type;
    private int width;

    static {
        MediaCodecProperties mediaCodecProperties;
        hwEncoderDisabledTypes = new HashSet<String>();
        qcomVp8HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosVp8HwProperties = new MediaCodecProperties("OMX.Exynos.", 23, BitrateAdjustmentType.DYNAMIC_ADJUSTMENT);
        intelVp8HwProperties = new MediaCodecProperties("OMX.Intel.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
        qcomVp9HwProperties = new MediaCodecProperties("OMX.qcom.", 24, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosVp9HwProperties = mediaCodecProperties = new MediaCodecProperties("OMX.Exynos.", 24, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        vp9HwList = new MediaCodecProperties[]{qcomVp9HwProperties, mediaCodecProperties};
        qcomH264HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosH264HwProperties = new MediaCodecProperties("OMX.Exynos.", 21, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        mediatekH264HwProperties = new MediaCodecProperties("OMX.MTK.", 27, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        exynosH264HighProfileHwProperties = mediaCodecProperties = new MediaCodecProperties("OMX.Exynos.", 23, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        h264HighProfileHwList = new MediaCodecProperties[]{mediaCodecProperties};
        H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
        supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
        supportedSurfaceColorList = new int[]{2130708361};
    }

    @CalledByNative
    MediaCodecVideoEncoder() {
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() == Thread.currentThread().getId()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MediaCodecVideoEncoder previously operated on ");
        stringBuilder.append(this.mediaCodecThread);
        stringBuilder.append(" but is now called on ");
        stringBuilder.append(Thread.currentThread());
        throw new RuntimeException(stringBuilder.toString());
    }

    static MediaCodec createByCodecName(String string2) {
        try {
            string2 = MediaCodec.createByCodecName((String)string2);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static VideoEncoderFactory createFactory() {
        return new DefaultVideoEncoderFactory(new HwEncoderFactory());
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disposeEglContext() {
        EglBase eglBase = staticEglBase;
        if (eglBase != null) {
            eglBase.release();
            staticEglBase = null;
        }
    }

    private static EncoderProperties findHwEncoder(String charSequence, MediaCodecProperties[] object, int[] nArray) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if (((String)charSequence).equals(H264_MIME_TYPE) && Arrays.asList(H264_HW_EXCEPTION_MODELS).contains(Build.MODEL)) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Model: ");
            ((StringBuilder)charSequence).append(Build.MODEL);
            ((StringBuilder)charSequence).append(" has black listed H.264 encoder.");
            Logging.w(TAG, ((StringBuilder)charSequence).toString());
            return null;
        }
        for (int i3 = 0; i3 < MediaCodecList.getCodecCount(); ++i3) {
            int n2;
            String string2;
            int n3;
            int n4;
            Object object3;
            MediaCodecInfo mediaCodecInfo;
            block15: {
                block14: {
                    try {
                        mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
                        mediaCodecInfo = null;
                    }
                    if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder()) continue;
                    object3 = mediaCodecInfo.getSupportedTypes();
                    n4 = ((String[])object3).length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (!object3[n3].equals(charSequence)) continue;
                        string2 = mediaCodecInfo.getName();
                        break block14;
                    }
                    string2 = null;
                }
                if (string2 == null) continue;
                object3 = new StringBuilder();
                object3.append("Found candidate encoder ");
                object3.append(string2);
                Logging.v(TAG, object3.toString());
                object3 = BitrateAdjustmentType.NO_ADJUSTMENT;
                n4 = ((Object)object).length;
                for (n3 = 0; n3 < n4; ++n3) {
                    Object object2 = object[n3];
                    if (!string2.startsWith(((MediaCodecProperties)object2).codecPrefix)) continue;
                    if (Build.VERSION.SDK_INT < ((MediaCodecProperties)object2).minSdk) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Codec ");
                        stringBuilder.append(string2);
                        stringBuilder.append(" is disabled due to SDK version ");
                        stringBuilder.append(Build.VERSION.SDK_INT);
                        Logging.w(TAG, stringBuilder.toString());
                        continue;
                    }
                    BitrateAdjustmentType bitrateAdjustmentType = ((MediaCodecProperties)object2).bitrateAdjustmentType;
                    if (bitrateAdjustmentType != BitrateAdjustmentType.NO_ADJUSTMENT) {
                        object3 = new StringBuilder();
                        object3.append("Codec ");
                        object3.append(string2);
                        object3.append(" requires bitrate adjustment: ");
                        object3.append((Object)bitrateAdjustmentType);
                        Logging.w(TAG, object3.toString());
                        object3 = bitrateAdjustmentType;
                    }
                    n3 = 1;
                    break block15;
                }
                n3 = 0;
            }
            if (n3 == 0) continue;
            try {
                mediaCodecInfo = mediaCodecInfo.getCapabilitiesForType((String)charSequence);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder capabilities", illegalArgumentException);
            }
            int[] nArray2 = mediaCodecInfo.colorFormats;
            n4 = nArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray2[n3];
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("   Color: 0x");
                stringBuilder.append(Integer.toHexString(n2));
                Logging.v(TAG, stringBuilder.toString());
            }
            n2 = nArray.length;
            for (n3 = 0; n3 < n2; ++n3) {
                int n5 = nArray[n3];
                for (int n6 : mediaCodecInfo.colorFormats) {
                    if (n6 != n5) continue;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Found target encoder for mime ");
                    ((StringBuilder)object).append((String)charSequence);
                    ((StringBuilder)object).append(" : ");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append(". Color: 0x");
                    ((StringBuilder)object).append(Integer.toHexString(n6));
                    ((StringBuilder)object).append(". Bitrate adjustment: ");
                    ((StringBuilder)object).append(object3);
                    Logging.d(TAG, ((StringBuilder)object).toString());
                    return new EncoderProperties(string2, n6, (BitrateAdjustmentType)((Object)object3));
                }
            }
            continue;
        }
        return null;
    }

    private double getBitrateScale(int n2) {
        double d3 = n2;
        Double.isNaN(d3);
        return Math.pow(4.0, d3 / 20.0);
    }

    static EglBase.Context getEglContext() {
        Object object = staticEglBase;
        object = object == null ? null : object.getEglBaseContext();
        return object;
    }

    private static final MediaCodecProperties[] h264HwList() {
        ArrayList<MediaCodecProperties> arrayList = new ArrayList<MediaCodecProperties>();
        arrayList.add(qcomH264HwProperties);
        arrayList.add(exynosH264HwProperties);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled")) {
            arrayList.add(mediatekH264HwProperties);
        }
        return arrayList.toArray(new MediaCodecProperties[arrayList.size()]);
    }

    public static boolean isH264HighProfileHwSupported() {
        boolean bl = !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HighProfileHwList, supportedColorList) != null;
        return bl;
    }

    public static boolean isH264HwSupported() {
        boolean bl = !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, MediaCodecVideoEncoder.h264HwList(), supportedColorList) != null;
        return bl;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        boolean bl = !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, MediaCodecVideoEncoder.h264HwList(), supportedSurfaceColorList) != null;
        return bl;
    }

    @CalledByNative
    static boolean isTextureBuffer(VideoFrame.Buffer buffer) {
        return buffer instanceof VideoFrame.TextureBuffer;
    }

    public static boolean isVp8HwSupported() {
        boolean bl = !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), supportedColorList) != null;
        return bl;
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        boolean bl = !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), supportedSurfaceColorList) != null;
        return bl;
    }

    public static boolean isVp9HwSupported() {
        boolean bl = !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, supportedColorList) != null;
        return bl;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        boolean bl = !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, supportedSurfaceColorList) != null;
        return bl;
    }

    private static native long nativeCreateEncoder(VideoCodecInfo var0, boolean var1);

    private static native void nativeFillInputBuffer(long var0, int var2, ByteBuffer var3, int var4, ByteBuffer var5, int var6, ByteBuffer var7, int var8);

    public static void printStackTrace() {
        Object object = runningInstance;
        if (object != null && (object = object.mediaCodecThread) != null && ((StackTraceElement[])(object = object.getStackTrace())).length > 0) {
            Logging.d(TAG, "MediaCodecVideoEncoder stacks trace:");
            int n2 = ((StackTraceElement[])object).length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Logging.d(TAG, object[i3].toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void reportEncodedFrame(int n2) {
        StringBuilder stringBuilder;
        block7: {
            block6: {
                double d3;
                double d4;
                block5: {
                    int n3 = this.targetFps;
                    if (n3 == 0) return;
                    if (this.bitrateAdjustmentType != BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
                        return;
                    }
                    d4 = this.targetBitrateBps;
                    d3 = n3;
                    Double.isNaN(d3);
                    Double.isNaN(d4);
                    double d5 = d4 / (d3 * 8.0);
                    d4 = this.bitrateAccumulator;
                    d3 = n2;
                    Double.isNaN(d3);
                    this.bitrateAccumulator = d4 += d3 - d5;
                    d5 = this.bitrateObservationTimeMs;
                    d3 = n3;
                    Double.isNaN(d3);
                    this.bitrateObservationTimeMs = d5 + 1000.0 / d3;
                    d3 = this.bitrateAccumulatorMax * 3.0;
                    this.bitrateAccumulator = d4 = Math.min(d4, d3);
                    this.bitrateAccumulator = Math.max(d4, -d3);
                    if (!(this.bitrateObservationTimeMs > 3000.0)) return;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Acc: ");
                    stringBuilder.append((int)this.bitrateAccumulator);
                    stringBuilder.append(". Max: ");
                    stringBuilder.append((int)this.bitrateAccumulatorMax);
                    stringBuilder.append(". ExpScale: ");
                    stringBuilder.append(this.bitrateAdjustmentScaleExp);
                    Logging.d(TAG, stringBuilder.toString());
                    n2 = 0;
                    d3 = this.bitrateAccumulator;
                    d4 = this.bitrateAccumulatorMax;
                    if (!(d3 > d4)) break block5;
                    n2 = (int)(d3 / d4 + 0.5);
                    this.bitrateAdjustmentScaleExp -= n2;
                    this.bitrateAccumulator = d4;
                    break block6;
                }
                if (!(d3 < -d4)) break block7;
                n2 = (int)(-d3 / d4 + 0.5);
                this.bitrateAdjustmentScaleExp += n2;
                this.bitrateAccumulator = -d4;
            }
            n2 = 1;
        }
        if (n2 != 0) {
            this.bitrateAdjustmentScaleExp = n2 = Math.min(this.bitrateAdjustmentScaleExp, 20);
            this.bitrateAdjustmentScaleExp = Math.max(n2, -20);
            stringBuilder = new StringBuilder();
            stringBuilder.append("Adjusting bitrate scale to ");
            stringBuilder.append(this.bitrateAdjustmentScaleExp);
            stringBuilder.append(". Value: ");
            stringBuilder.append(this.getBitrateScale(this.bitrateAdjustmentScaleExp));
            Logging.d(TAG, stringBuilder.toString());
            this.setRates(this.targetBitrateBps / 1000, this.targetFps);
        }
        this.bitrateObservationTimeMs = 0.0;
    }

    public static void setEglContext(EglBase.Context context) {
        if (staticEglBase != null) {
            Logging.w(TAG, "Egl context already set.");
            staticEglBase.release();
        }
        staticEglBase = EglBase$_CC.create(context);
    }

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    @CalledByNativeUnchecked
    private boolean setRates(int n2, int n3) {
        StringBuilder stringBuilder;
        double d3;
        double d4;
        this.checkOnMediaCodecThread();
        int n4 = n2 * 1000;
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            double d5 = n4;
            Double.isNaN(d5);
            this.bitrateAccumulatorMax = d5 / 8.0;
            int n5 = this.targetBitrateBps;
            if (n5 > 0 && n4 < n5) {
                d4 = this.bitrateAccumulator;
                Double.isNaN(d5);
                d3 = n5;
                Double.isNaN(d3);
                this.bitrateAccumulator = d4 * d5 / d3;
            }
        }
        this.targetBitrateBps = n4;
        this.targetFps = n3;
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT && n3 > 0) {
            n3 = n4 * 30 / n3;
            stringBuilder = new StringBuilder();
            stringBuilder.append("setRates: ");
            stringBuilder.append(n2);
            stringBuilder.append(" -> ");
            stringBuilder.append(n3 / 1000);
            stringBuilder.append(" kbps. Fps: ");
            stringBuilder.append(this.targetFps);
            Logging.v(TAG, stringBuilder.toString());
            n2 = n3;
        } else if (this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("setRates: ");
            stringBuilder.append(n2);
            stringBuilder.append(" kbps. Fps: ");
            stringBuilder.append(this.targetFps);
            stringBuilder.append(". ExpScale: ");
            stringBuilder.append(this.bitrateAdjustmentScaleExp);
            Logging.v(TAG, stringBuilder.toString());
            n3 = this.bitrateAdjustmentScaleExp;
            n2 = n4;
            if (n3 != 0) {
                d4 = n4;
                d3 = this.getBitrateScale(n3);
                Double.isNaN(d4);
                n2 = (int)(d4 * d3);
            }
        } else {
            stringBuilder = new StringBuilder();
            stringBuilder.append("setRates: ");
            stringBuilder.append(n2);
            stringBuilder.append(" kbps. Fps: ");
            stringBuilder.append(this.targetFps);
            Logging.v(TAG, stringBuilder.toString());
            n2 = n4;
        }
        try {
            stringBuilder = new Bundle();
            stringBuilder.putInt("video-bitrate", n2);
            this.mediaCodec.setParameters((Bundle)stringBuilder);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "setRates failed", illegalStateException);
            return false;
        }
    }

    public static EncoderProperties vp8HwEncoderProperties() {
        if (hwEncoderDisabledTypes.contains(VP8_MIME_TYPE)) {
            return null;
        }
        return MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), supportedColorList);
    }

    private static MediaCodecProperties[] vp8HwList() {
        ArrayList<MediaCodecProperties> arrayList = new ArrayList<MediaCodecProperties>();
        arrayList.add(qcomVp8HwProperties);
        arrayList.add(exynosVp8HwProperties);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-IntelVP8").equals("Enabled")) {
            arrayList.add(intelVp8HwProperties);
        }
        return arrayList.toArray(new MediaCodecProperties[arrayList.size()]);
    }

    void checkKeyFrameRequired(boolean bl, long l3) {
        long l4 = (l3 + 500L) / 1000L;
        if (this.lastKeyFrameMs < 0L) {
            this.lastKeyFrameMs = l4;
        }
        boolean bl2 = !bl && (l3 = this.forcedKeyFrameMs) > 0L && l4 > this.lastKeyFrameMs + l3;
        if (bl || bl2) {
            if (bl) {
                Logging.d(TAG, "Sync frame request");
            } else {
                Logging.d(TAG, "Sync frame forced");
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request-sync", 0);
            this.mediaCodec.setParameters(bundle);
            this.lastKeyFrameMs = l4;
        }
    }

    @CalledByNativeUnchecked
    int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            int n2 = this.mediaCodec.dequeueInputBuffer(0L);
            return n2;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CalledByNativeUnchecked
    OutputBufferInfo dequeueOutputBuffer() {
        Comparable<StringBuilder> comparable;
        Object object;
        int n2;
        boolean bl;
        MediaCodec.BufferInfo bufferInfo;
        block20: {
            this.checkOnMediaCodecThread();
            bufferInfo = new MediaCodec.BufferInfo();
            int n3 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            bl = true;
            n2 = n3;
            if (n3 < 0) break block20;
            int n4 = (bufferInfo.flags & 2) != 0 ? 1 : 0;
            n2 = n3;
            if (n4 == 0) break block20;
            object = new StringBuilder();
            ((StringBuilder)object).append("Config frame generated. Offset: ");
            ((StringBuilder)object).append(bufferInfo.offset);
            ((StringBuilder)object).append(". Size: ");
            ((StringBuilder)object).append(bufferInfo.size);
            Logging.d(TAG, ((StringBuilder)object).toString());
            this.configData = ByteBuffer.allocateDirect(bufferInfo.size);
            this.outputBuffers[n3].position(bufferInfo.offset);
            this.outputBuffers[n3].limit(bufferInfo.offset + bufferInfo.size);
            this.configData.put(this.outputBuffers[n3]);
            object = "";
            n2 = 0;
            while (true) {
                block21: {
                    int n5 = bufferInfo.size;
                    n4 = 8;
                    if (n5 >= 8) break block21;
                    n4 = bufferInfo.size;
                }
                if (n2 >= n4) break;
                comparable = new Comparable<StringBuilder>();
                ((StringBuilder)comparable).append((String)object);
                ((StringBuilder)comparable).append(Integer.toHexString(this.configData.get(n2) & 0xFF));
                ((StringBuilder)comparable).append(" ");
                object = ((StringBuilder)comparable).toString();
                ++n2;
                continue;
                break;
            }
            try {
                Logging.d(TAG, (String)object);
                this.mediaCodec.releaseOutputBuffer(n3, false);
                n2 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "dequeueOutputBuffer failed", illegalStateException);
                return new OutputBufferInfo(-1, null, false, -1L);
            }
        }
        if (n2 >= 0) {
            block22: {
                object = this.outputBuffers[n2].duplicate();
                ((ByteBuffer)object).position(bufferInfo.offset);
                ((ByteBuffer)object).limit(bufferInfo.offset + bufferInfo.size);
                this.reportEncodedFrame(bufferInfo.size);
                if ((bufferInfo.flags & 1) == 0) {
                    bl = false;
                }
                if (!bl) break block22;
                Logging.d(TAG, "Sync frame generated");
            }
            if (!bl) return new OutputBufferInfo(n2, ((ByteBuffer)object).slice(), bl, bufferInfo.presentationTimeUs);
            if (this.type != VideoCodecType.VIDEO_CODEC_H264) return new OutputBufferInfo(n2, ((ByteBuffer)object).slice(), bl, bufferInfo.presentationTimeUs);
            comparable = new Comparable<StringBuilder>();
            ((StringBuilder)comparable).append("Appending config frame of size ");
            ((StringBuilder)comparable).append(this.configData.capacity());
            ((StringBuilder)comparable).append(" to output buffer with offset ");
            ((StringBuilder)comparable).append(bufferInfo.offset);
            ((StringBuilder)comparable).append(", size ");
            ((StringBuilder)comparable).append(bufferInfo.size);
            Logging.d(TAG, ((StringBuilder)comparable).toString());
            comparable = ByteBuffer.allocateDirect(this.configData.capacity() + bufferInfo.size);
            this.configData.rewind();
            ((ByteBuffer)comparable).put(this.configData);
            ((ByteBuffer)comparable).put((ByteBuffer)object);
            ((ByteBuffer)comparable).position(0);
            return new OutputBufferInfo(n2, (ByteBuffer)comparable, bl, bufferInfo.presentationTimeUs);
        }
        if (n2 == -3) {
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            return this.dequeueOutputBuffer();
        }
        if (n2 == -2) {
            return this.dequeueOutputBuffer();
        }
        if (n2 == -1) {
            return null;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("dequeueOutputBuffer: ");
        ((StringBuilder)object).append(n2);
        RuntimeException runtimeException = new RuntimeException(((StringBuilder)object).toString());
        throw runtimeException;
    }

    @CalledByNativeUnchecked
    boolean encodeBuffer(boolean bl, int n2, int n3, long l3) {
        this.checkOnMediaCodecThread();
        try {
            this.checkKeyFrameRequired(bl, l3);
            this.mediaCodec.queueInputBuffer(n2, 0, n3, l3, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "encodeBuffer failed", illegalStateException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNativeUnchecked
    boolean encodeFrame(long l3, boolean bl, VideoFrame object, int n2, long l4) {
        this.checkOnMediaCodecThread();
        try {
            this.checkKeyFrameRequired(bl, l4);
            object = ((VideoFrame)object).getBuffer();
            if (object instanceof VideoFrame.TextureBuffer) {
                VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)object;
                this.eglBase.makeCurrent();
                GLES20.glClear((int)16384);
                GlRectDrawer glRectDrawer = this.drawer;
                object = new Matrix();
                VideoFrameDrawer.drawTexture(glRectDrawer, textureBuffer, (Matrix)object, this.width, this.height, 0, 0, this.width, this.height);
                this.eglBase.swapBuffers(TimeUnit.MICROSECONDS.toNanos(l4));
                return true;
            }
            VideoFrame.I420Buffer i420Buffer = object.toI420();
            int n3 = (this.height + 1) / 2;
            object = i420Buffer.getDataY();
            ByteBuffer byteBuffer = i420Buffer.getDataU();
            ByteBuffer byteBuffer2 = i420Buffer.getDataV();
            int n4 = i420Buffer.getStrideY();
            int n5 = i420Buffer.getStrideU();
            int n6 = i420Buffer.getStrideV();
            if (((Buffer)object).capacity() < this.height * n4) {
                object = new RuntimeException("Y-plane buffer size too small.");
                throw object;
            }
            if (byteBuffer.capacity() < n5 * n3) {
                object = new RuntimeException("U-plane buffer size too small.");
                throw object;
            }
            if (byteBuffer2.capacity() >= n3 * n6) {
                MediaCodecVideoEncoder.nativeFillInputBuffer(l3, n2, (ByteBuffer)object, n4, byteBuffer, n5, byteBuffer2, n6);
                i420Buffer.release();
                n5 = this.width * this.height * 3 / 2;
                this.mediaCodec.queueInputBuffer(n2, 0, n5, l4, 0);
                return true;
            }
            object = new RuntimeException("V-plane buffer size too small.");
            throw object;
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeFrame failed", runtimeException);
            return false;
        }
    }

    @CalledByNative
    int getColorFormat() {
        return this.colorFormat;
    }

    @CalledByNativeUnchecked
    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = this.mediaCodec.getInputBuffers();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Input buffers: ");
        stringBuilder.append(byteBufferArray.length);
        Logging.d(TAG, stringBuilder.toString());
        return byteBufferArray;
    }

    /*
     * Unable to fully structure code
     */
    @CalledByNativeUnchecked
    boolean initEncode(VideoCodecType var1_1, int var2_3, int var3_4, int var4_5, int var5_6, int var6_7, boolean var7_8) {
        block19: {
            block20: {
                block21: {
                    block18: {
                        block17: {
                            var8_9 = new StringBuilder();
                            var8_9.append("Java initEncode: ");
                            var8_9.append(var1_1);
                            var8_9.append(". Profile: ");
                            var8_9.append(var2_3);
                            var8_9.append(" : ");
                            var8_9.append(var3_4);
                            var8_9.append(" x ");
                            var8_9.append(var4_5);
                            var8_9.append(". @ ");
                            var8_9.append(var5_6);
                            var8_9.append(" kbps. Fps: ");
                            var8_9.append(var6_7);
                            var8_9.append(". Encode from texture : ");
                            var8_9.append(var7_8);
                            Logging.d("MediaCodecVideoEncoder", var8_9.toString());
                            this.profile = var2_3;
                            this.width = var3_4;
                            this.height = var4_5;
                            if (this.mediaCodecThread != null) break block19;
                            var8_9 = VideoCodecType.VIDEO_CODEC_VP8;
                            var9_10 = 100;
                            var10_11 = "video/x-vnd.on2.vp9";
                            if (var1_1 == var8_9) {
                                var10_11 = MediaCodecVideoEncoder.vp8HwList();
                                var8_9 = var7_8 != false ? (Object)MediaCodecVideoEncoder.supportedSurfaceColorList : (Object)MediaCodecVideoEncoder.supportedColorList;
                                var8_9 = MediaCodecVideoEncoder.findHwEncoder("video/x-vnd.on2.vp8", (MediaCodecProperties[])var10_11, (int[])var8_9);
                                var10_11 = "video/x-vnd.on2.vp8";
lbl43:
                                // 2 sources

                                while (true) {
                                    var2_3 = 0;
                                    break block17;
                                    break;
                                }
                            }
                            if (var1_1 == VideoCodecType.VIDEO_CODEC_VP9) {
                                var11_12 = MediaCodecVideoEncoder.vp9HwList;
                                var8_9 = var7_8 != false ? (Object)MediaCodecVideoEncoder.supportedSurfaceColorList : (Object)MediaCodecVideoEncoder.supportedColorList;
                                var8_9 = MediaCodecVideoEncoder.findHwEncoder("video/x-vnd.on2.vp9", (MediaCodecProperties[])var11_12, (int[])var8_9);
                                ** continue;
                            }
                            if (var1_1 != VideoCodecType.VIDEO_CODEC_H264) break block20;
                            var10_11 = MediaCodecVideoEncoder.h264HwList();
                            var8_9 = var7_8 != false ? (Object)MediaCodecVideoEncoder.supportedSurfaceColorList : (Object)MediaCodecVideoEncoder.supportedColorList;
                            var10_11 = MediaCodecVideoEncoder.findHwEncoder("video/avc", (MediaCodecProperties[])var10_11, (int[])var8_9);
                            if (var2_3 != H264Profile.CONSTRAINED_HIGH.getValue()) ** GOTO lbl63
                            var11_12 = MediaCodecVideoEncoder.h264HighProfileHwList;
                            var8_9 = var7_8 != false ? (Object)MediaCodecVideoEncoder.supportedSurfaceColorList : (Object)MediaCodecVideoEncoder.supportedColorList;
                            if (MediaCodecVideoEncoder.findHwEncoder("video/avc", (MediaCodecProperties[])var11_12, (int[])var8_9) != null) {
                                Logging.d("MediaCodecVideoEncoder", "High profile H.264 encoder supported.");
                                var2_3 = 1;
                            } else {
                                Logging.d("MediaCodecVideoEncoder", "High profile H.264 encoder requested, but not supported. Use baseline.");
lbl63:
                                // 2 sources

                                var2_3 = 0;
                            }
                            var9_10 = 20;
                            var11_12 = "video/avc";
                            var8_9 = var10_11;
                            var10_11 = var11_12;
                        }
                        if (var8_9 == null) break block21;
                        MediaCodecVideoEncoder.runningInstance = this;
                        this.colorFormat = var8_9.colorFormat;
                        var11_12 = var8_9.bitrateAdjustmentType;
                        this.bitrateAdjustmentType = var11_12;
                        var12_13 = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
                        var13_14 = 30;
                        var6_7 = var11_12 == var12_13 ? var13_14 : Math.min(var6_7, 30);
                        this.forcedKeyFrameMs = 0L;
                        this.lastKeyFrameMs = -1L;
                        if (var1_1 == VideoCodecType.VIDEO_CODEC_VP8 && var8_9.codecName.startsWith(MediaCodecVideoEncoder.qcomVp8HwProperties.codecPrefix)) {
                            var13_14 = Build.VERSION.SDK_INT;
                            if (var13_14 != 21 && var13_14 != 22) {
                                if (var13_14 == 23) {
                                    this.forcedKeyFrameMs = 20000L;
                                } else if (var13_14 > 23) {
                                    this.forcedKeyFrameMs = 15000L;
                                }
                            } else {
                                this.forcedKeyFrameMs = 15000L;
                            }
                        }
                        var11_12 = new StringBuilder();
                        var11_12.append("Color format: ");
                        var11_12.append(this.colorFormat);
                        var11_12.append(". Bitrate adjustment: ");
                        var11_12.append((Object)this.bitrateAdjustmentType);
                        var11_12.append(". Key frame interval: ");
                        var11_12.append(this.forcedKeyFrameMs);
                        var11_12.append(" . Initial fps: ");
                        var11_12.append(var6_7);
                        Logging.d("MediaCodecVideoEncoder", var11_12.toString());
                        this.targetBitrateBps = var5_6 *= 1000;
                        this.targetFps = var6_7;
                        var14_15 = var5_6;
                        Double.isNaN(var14_15);
                        this.bitrateAccumulatorMax = var14_15 / 8.0;
                        this.bitrateAccumulator = 0.0;
                        this.bitrateObservationTimeMs = 0.0;
                        this.bitrateAdjustmentScaleExp = 0;
                        this.mediaCodecThread = Thread.currentThread();
                        try {
                            var10_11 = MediaFormat.createVideoFormat((String)var10_11, (int)var3_4, (int)var4_5);
                            var10_11.setInteger("bitrate", this.targetBitrateBps);
                            var10_11.setInteger("bitrate-mode", 2);
                            var10_11.setInteger("color-format", var8_9.colorFormat);
                            var10_11.setInteger("frame-rate", this.targetFps);
                            var10_11.setInteger("i-frame-interval", var9_10);
                            if (var2_3 == 0) ** GOTO lbl132
                        }
                        catch (IllegalStateException var1_2) {
                            Logging.e("MediaCodecVideoEncoder", "initEncode failed", var1_2);
                            this.release();
                            return false;
                        }
                        var10_11.setInteger("profile", 8);
                        var10_11.setInteger("level", 256);
lbl132:
                        // 2 sources

                        var11_12 = new StringBuilder();
                        var11_12.append("  Format: ");
                        var11_12.append(var10_11);
                        Logging.d("MediaCodecVideoEncoder", var11_12.toString());
                        var8_9 = MediaCodecVideoEncoder.createByCodecName(var8_9.codecName);
                        this.mediaCodec = var8_9;
                        this.type = var1_1;
                        if (var8_9 != null) break block18;
                        Logging.e("MediaCodecVideoEncoder", "Can not create media encoder");
                        this.release();
                        return false;
                    }
                    var8_9.configure((MediaFormat)var10_11, null, null, 1);
                    if (!var7_8) ** GOTO lbl156
                    this.eglBase = EglBase$_CC.createEgl14((EglBase14.Context)MediaCodecVideoEncoder.getEglContext(), EglBase.CONFIG_RECORDABLE);
                    var1_1 = this.mediaCodec.createInputSurface();
                    this.inputSurface = var1_1;
                    this.eglBase.createSurface((Surface)var1_1);
                    this.drawer = var1_1 = new GlRectDrawer();
lbl156:
                    // 2 sources

                    this.mediaCodec.start();
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    var1_1 = new StringBuilder();
                    var1_1.append("Output buffers: ");
                    var1_1.append(this.outputBuffers.length);
                    Logging.d("MediaCodecVideoEncoder", var1_1.toString());
                    return true;
                }
                var8_9 = new StringBuilder();
                var8_9.append("Can not find HW encoder for ");
                var8_9.append(var1_1);
                throw new RuntimeException(var8_9.toString());
            }
            var8_9 = new StringBuilder();
            var8_9.append("initEncode: Non-supported codec ");
            var8_9.append(var1_1);
            throw new RuntimeException(var8_9.toString());
        }
        var1_1 = new RuntimeException("Forgot to release()?");
        throw var1_1;
    }

    @CalledByNativeUnchecked
    void release() {
        Logging.d(TAG, "Java releaseEncoder");
        this.checkOnMediaCodecThread();
        Object object = new Object(){
            Exception e;
        };
        Object object2 = this.mediaCodec;
        boolean bl = false;
        boolean bl2 = false;
        if (object2 != null) {
            object2 = new CountDownLatch(1);
            new Thread(new Runnable(object, (CountDownLatch)object2){
                final /* synthetic */ 1CaughtException val$caughtException;
                final /* synthetic */ CountDownLatch val$releaseDone;
                {
                    this.val$caughtException = caughtException;
                    this.val$releaseDone = countDownLatch;
                }

                @Override
                public void run() {
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread");
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.stop();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder stop failed", exception);
                    }
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.release();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder release failed", exception);
                        this.val$caughtException.e = exception;
                    }
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread done");
                    this.val$releaseDone.countDown();
                }
            }).start();
            bl = bl2;
            if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)object2, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                bl = true;
            }
            this.mediaCodec = null;
        }
        this.mediaCodecThread = null;
        object2 = this.drawer;
        if (object2 != null) {
            ((GlRectDrawer)object2).release();
            this.drawer = null;
        }
        if ((object2 = this.eglBase) != null) {
            object2.release();
            this.eglBase = null;
        }
        if ((object2 = this.inputSurface) != null) {
            object2.release();
            this.inputSurface = null;
        }
        runningInstance = null;
        if (bl) {
            ++codecErrors;
            if (errorCallback != null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Invoke codec error callback. Errors: ");
                ((StringBuilder)object).append(codecErrors);
                Logging.e(TAG, ((StringBuilder)object).toString());
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
            throw new RuntimeException("Media encoder release timeout.");
        }
        if (object.e == null) {
            Logging.d(TAG, "Java releaseEncoder done");
            return;
        }
        object2 = new RuntimeException(object.e);
        ((Throwable)object2).setStackTrace(ThreadUtils.concatStackTraces(object.e.getStackTrace(), ((Throwable)object2).getStackTrace()));
        throw object2;
    }

    @CalledByNativeUnchecked
    boolean releaseOutputBuffer(int n2) {
        this.checkOnMediaCodecThread();
        try {
            this.mediaCodec.releaseOutputBuffer(n2, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "releaseOutputBuffer failed", illegalStateException);
            return false;
        }
    }

    public static final class BitrateAdjustmentType
    extends Enum<BitrateAdjustmentType> {
        private static final /* synthetic */ BitrateAdjustmentType[] $VALUES;
        public static final /* enum */ BitrateAdjustmentType DYNAMIC_ADJUSTMENT;
        public static final /* enum */ BitrateAdjustmentType FRAMERATE_ADJUSTMENT;
        public static final /* enum */ BitrateAdjustmentType NO_ADJUSTMENT;

        static {
            BitrateAdjustmentType bitrateAdjustmentType;
            NO_ADJUSTMENT = new BitrateAdjustmentType();
            FRAMERATE_ADJUSTMENT = new BitrateAdjustmentType();
            DYNAMIC_ADJUSTMENT = bitrateAdjustmentType = new BitrateAdjustmentType();
            $VALUES = new BitrateAdjustmentType[]{NO_ADJUSTMENT, FRAMERATE_ADJUSTMENT, bitrateAdjustmentType};
        }

        public static BitrateAdjustmentType valueOf(String string2) {
            return Enum.valueOf(BitrateAdjustmentType.class, string2);
        }

        public static BitrateAdjustmentType[] values() {
            return (BitrateAdjustmentType[])$VALUES.clone();
        }
    }

    public static class EncoderProperties {
        public final BitrateAdjustmentType bitrateAdjustmentType;
        public final String codecName;
        public final int colorFormat;

        public EncoderProperties(String string2, int n2, BitrateAdjustmentType bitrateAdjustmentType) {
            this.codecName = string2;
            this.colorFormat = n2;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
        }
    }

    public static final class H264Profile
    extends Enum<H264Profile> {
        private static final /* synthetic */ H264Profile[] $VALUES;
        public static final /* enum */ H264Profile BASELINE;
        public static final /* enum */ H264Profile CONSTRAINED_BASELINE;
        public static final /* enum */ H264Profile CONSTRAINED_HIGH;
        public static final /* enum */ H264Profile HIGH;
        public static final /* enum */ H264Profile MAIN;
        private final int value;

        static {
            H264Profile h264Profile;
            CONSTRAINED_BASELINE = new H264Profile(0);
            BASELINE = new H264Profile(1);
            MAIN = new H264Profile(2);
            CONSTRAINED_HIGH = new H264Profile(3);
            HIGH = h264Profile = new H264Profile(4);
            $VALUES = new H264Profile[]{CONSTRAINED_BASELINE, BASELINE, MAIN, CONSTRAINED_HIGH, h264Profile};
        }

        private H264Profile(int n3) {
            this.value = n3;
        }

        public static H264Profile valueOf(String string2) {
            return Enum.valueOf(H264Profile.class, string2);
        }

        public static H264Profile[] values() {
            return (H264Profile[])$VALUES.clone();
        }

        public int getValue() {
            return this.value;
        }
    }

    static class HwEncoderFactory
    implements VideoEncoderFactory {
        private final VideoCodecInfo[] supportedHardwareCodecs = HwEncoderFactory.getSupportedHardwareCodecs();

        HwEncoderFactory() {
        }

        private static VideoCodecInfo[] getSupportedHardwareCodecs() {
            ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
            if (MediaCodecVideoEncoder.isVp8HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "VP8 HW Encoder supported.");
                arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
            }
            if (MediaCodecVideoEncoder.isVp9HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "VP9 HW Encoder supported.");
                arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isH264HighProfileHwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "H.264 High Profile HW Encoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_HIGH_PROFILE_CODEC);
            }
            if (MediaCodecVideoEncoder.isH264HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "H.264 HW Encoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
            }
            return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
        }

        private static boolean isCodecSupported(VideoCodecInfo[] videoCodecInfoArray, VideoCodecInfo videoCodecInfo) {
            int n2 = videoCodecInfoArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!HwEncoderFactory.isSameCodec(videoCodecInfoArray[i3], videoCodecInfo)) continue;
                return true;
            }
            return false;
        }

        private static boolean isSameCodec(VideoCodecInfo videoCodecInfo, VideoCodecInfo videoCodecInfo2) {
            if (!videoCodecInfo.name.equalsIgnoreCase(videoCodecInfo2.name)) {
                return false;
            }
            boolean bl = videoCodecInfo.name.equalsIgnoreCase("H264") ? H264Utils.isSameH264Profile(videoCodecInfo.params, videoCodecInfo2.params) : true;
            return bl;
        }

        @Override
        public VideoEncoder createEncoder(final VideoCodecInfo videoCodecInfo) {
            if (!HwEncoderFactory.isCodecSupported(this.supportedHardwareCodecs, videoCodecInfo)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("No HW video encoder for codec ");
                stringBuilder.append(videoCodecInfo.name);
                Logging.d(MediaCodecVideoEncoder.TAG, stringBuilder.toString());
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Create HW video encoder for ");
            stringBuilder.append(videoCodecInfo.name);
            Logging.d(MediaCodecVideoEncoder.TAG, stringBuilder.toString());
            return new WrappedNativeVideoEncoder(){

                @Override
                public long createNativeVideoEncoder() {
                    return MediaCodecVideoEncoder.nativeCreateEncoder(videoCodecInfo, staticEglBase instanceof EglBase14);
                }

                @Override
                public boolean isHardwareEncoder() {
                    return true;
                }
            };
        }

        @Override
        @CalledByNative
        public /* synthetic */ VideoCodecInfo[] getImplementations() {
            return VideoEncoderFactory$_CC.$default$getImplementations(this);
        }

        @Override
        public VideoCodecInfo[] getSupportedCodecs() {
            return this.supportedHardwareCodecs;
        }
    }

    private static class MediaCodecProperties {
        public final BitrateAdjustmentType bitrateAdjustmentType;
        public final String codecPrefix;
        public final int minSdk;

        MediaCodecProperties(String string2, int n2, BitrateAdjustmentType bitrateAdjustmentType) {
            this.codecPrefix = string2;
            this.minSdk = n2;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    static class OutputBufferInfo {
        public final ByteBuffer buffer;
        public final int index;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n2, ByteBuffer byteBuffer, boolean bl, long l3) {
            this.index = n2;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l3;
        }

        @CalledByNative(value="OutputBufferInfo")
        ByteBuffer getBuffer() {
            return this.buffer;
        }

        @CalledByNative(value="OutputBufferInfo")
        int getIndex() {
            return this.index;
        }

        @CalledByNative(value="OutputBufferInfo")
        long getPresentationTimestampUs() {
            return this.presentationTimestampUs;
        }

        @CalledByNative(value="OutputBufferInfo")
        boolean isKeyFrame() {
            return this.isKeyFrame;
        }
    }

    public static final class VideoCodecType
    extends Enum<VideoCodecType> {
        private static final /* synthetic */ VideoCodecType[] $VALUES;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_AV1;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_H264;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_UNKNOWN;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP8;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP9;

        static {
            VideoCodecType videoCodecType;
            VIDEO_CODEC_UNKNOWN = new VideoCodecType();
            VIDEO_CODEC_VP8 = new VideoCodecType();
            VIDEO_CODEC_VP9 = new VideoCodecType();
            VIDEO_CODEC_AV1 = new VideoCodecType();
            VIDEO_CODEC_H264 = videoCodecType = new VideoCodecType();
            $VALUES = new VideoCodecType[]{VIDEO_CODEC_UNKNOWN, VIDEO_CODEC_VP8, VIDEO_CODEC_VP9, VIDEO_CODEC_AV1, videoCodecType};
        }

        @CalledByNative(value="VideoCodecType")
        static VideoCodecType fromNativeIndex(int n2) {
            return VideoCodecType.values()[n2];
        }

        public static VideoCodecType valueOf(String string2) {
            return Enum.valueOf(VideoCodecType.class, string2);
        }

        public static VideoCodecType[] values() {
            return (VideoCodecType[])$VALUES.clone();
        }
    }
}

