/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import java.util.ArrayList;
import org.webrtc.AndroidVideoDecoder;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.MediaCodecWrapperFactory;
import org.webrtc.MediaCodecWrapperFactoryImpl;
import org.webrtc.Predicate;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoDecoderFactory$_CC;

class MediaCodecVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "MediaCodecVideoDecoderFactory";
    private final Predicate<MediaCodecInfo> codecAllowedPredicate;
    private final EglBase.Context sharedContext;

    public MediaCodecVideoDecoderFactory(EglBase.Context context, Predicate<MediaCodecInfo> predicate) {
        this.sharedContext = context;
        this.codecAllowedPredicate = predicate;
    }

    private MediaCodecInfo findCodecForType(VideoCodecType videoCodecType) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i3 = 0; i3 < MediaCodecList.getCodecCount(); ++i3) {
            MediaCodecInfo mediaCodecInfo;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
                mediaCodecInfo = null;
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, videoCodecType)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    private boolean isCodecAllowed(MediaCodecInfo mediaCodecInfo) {
        Predicate<MediaCodecInfo> predicate = this.codecAllowedPredicate;
        if (predicate == null) {
            return true;
        }
        return predicate.test(mediaCodecInfo);
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo object) {
        object = object.getName();
        if (Build.VERSION.SDK_INT >= 21 && ((String)object).startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && ((String)object).startsWith("OMX.Exynos.");
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        mediaCodecInfo.getName();
        if (!MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecType)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType())) == null) {
            return false;
        }
        return this.isCodecAllowed(mediaCodecInfo);
    }

    @Override
    @Deprecated
    public /* synthetic */ VideoDecoder createDecoder(String string2) {
        return VideoDecoderFactory$_CC.$default$createDecoder((VideoDecoderFactory)this, string2);
    }

    @Override
    public VideoDecoder createDecoder(VideoCodecInfo videoCodecInfo) {
        VideoCodecType videoCodecType = VideoCodecType.valueOf(videoCodecInfo.getName());
        MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
        if (mediaCodecInfo == null) {
            return null;
        }
        videoCodecInfo = mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType());
        return new AndroidVideoDecoder((MediaCodecWrapperFactory)new MediaCodecWrapperFactoryImpl(), mediaCodecInfo.getName(), videoCodecType, MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, (MediaCodecInfo.CodecCapabilities)videoCodecInfo).intValue(), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        VideoCodecType videoCodecType = VideoCodecType.VP8;
        VideoCodecType videoCodecType2 = VideoCodecType.VP9;
        VideoCodecType videoCodecType3 = VideoCodecType.H264;
        for (int i3 = 0; i3 < 3; ++i3) {
            VideoCodecType videoCodecType4 = (new VideoCodecType[]{videoCodecType, videoCodecType2, videoCodecType3})[i3];
            MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType4);
            if (mediaCodecInfo == null) continue;
            String string2 = videoCodecType4.name();
            if (videoCodecType4 == VideoCodecType.H264 && this.isH264HighProfileSupported(mediaCodecInfo)) {
                arrayList.add(new VideoCodecInfo(string2, MediaCodecUtils.getCodecProperties(videoCodecType4, true)));
            }
            arrayList.add(new VideoCodecInfo(string2, MediaCodecUtils.getCodecProperties(videoCodecType4, false)));
        }
        return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
    }
}

