/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.webrtc.CalledByNative;
import org.webrtc.CalledByNativeUnchecked;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.EglBase;
import org.webrtc.EglBase$_CC;
import org.webrtc.H264Utils;
import org.webrtc.Logging;
import org.webrtc.MediaCodecVideoEncoder;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoDecoderFactory$_CC;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.WrappedNativeVideoDecoder;

@Deprecated
public class MediaCodecVideoDecoder {
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String FORMAT_KEY_STRIDE = "stride";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final long MAX_DECODE_TIME_MS = 200L;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static int codecErrors = 0;
    private static EglBase eglBase;
    private static MediaCodecVideoDecoderErrorCallback errorCallback;
    private static Set<String> hwDecoderDisabledTypes;
    private static MediaCodecVideoDecoder runningInstance;
    private static final List<Integer> supportedColorList;
    private static final String supportedExynosH264HighProfileHwCodecPrefix = "OMX.Exynos.";
    private static final String supportedMediaTekH264HighProfileHwCodecPrefix = "OMX.MTK.";
    private static final String supportedQcomH264HighProfileHwCodecPrefix = "OMX.qcom.";
    private static final String[] supportedVp9HwCodecPrefixes;
    private int colorFormat;
    private final Queue<TimeStamps> decodeStartTimeMs = new ArrayDeque<TimeStamps>();
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new ArrayDeque<DecodedOutputBuffer>();
    private int droppedFrames;
    private boolean hasDecodedFirstFrame;
    private int height;
    private ByteBuffer[] inputBuffers;
    private MediaCodec mediaCodec;
    private Thread mediaCodecThread;
    private ByteBuffer[] outputBuffers;
    private int sliceHeight;
    private int stride;
    private Surface surface;
    private TextureListener textureListener;
    private int width;

    static {
        hwDecoderDisabledTypes = new HashSet<String>();
        supportedVp9HwCodecPrefixes = new String[]{supportedQcomH264HighProfileHwCodecPrefix, supportedExynosH264HighProfileHwCodecPrefix};
        supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    }

    @CalledByNative
    MediaCodecVideoDecoder() {
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (!this.dequeuedSurfaceOutputBuffers.isEmpty() && !this.textureListener.isWaitingForTexture()) {
            DecodedOutputBuffer decodedOutputBuffer = this.dequeuedSurfaceOutputBuffers.remove();
            this.textureListener.addBufferToRender(decodedOutputBuffer);
            this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
        }
    }

    private void checkOnMediaCodecThread() throws IllegalStateException {
        if (this.mediaCodecThread.getId() == Thread.currentThread().getId()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MediaCodecVideoDecoder previously operated on ");
        stringBuilder.append(this.mediaCodecThread);
        stringBuilder.append(" but is now called on ");
        stringBuilder.append(Thread.currentThread());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public static VideoDecoderFactory createFactory() {
        return new DefaultVideoDecoderFactory(new HwDecoderFactory());
    }

    @CalledByNativeUnchecked
    private int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            int n2 = this.mediaCodec.dequeueInputBuffer(500000L);
            return n2;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    @CalledByNativeUnchecked
    private DecodedOutputBuffer dequeueOutputBuffer(int n2) {
        this.checkOnMediaCodecThread();
        if (this.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        Object object = new MediaCodec.BufferInfo();
        while (true) {
            Object object2;
            int n3;
            if ((n3 = this.mediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)object, TimeUnit.MILLISECONDS.toMicros(n2))) != -3) {
                int n4;
                Object object3;
                if (n3 != -2) {
                    if (n3 != -1) {
                        this.hasDecodedFirstFrame = true;
                        object3 = this.decodeStartTimeMs.remove();
                        long l3 = SystemClock.elapsedRealtime() - ((TimeStamps)object3).decodeStartTimeMs;
                        if (l3 > 200L) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Very high decode time: ");
                            ((StringBuilder)object2).append(l3);
                            ((StringBuilder)object2).append("ms. Q size: ");
                            ((StringBuilder)object2).append(this.decodeStartTimeMs.size());
                            ((StringBuilder)object2).append(". Might be caused by resuming H264 decoding after a pause.");
                            Logging.e(TAG, ((StringBuilder)object2).toString());
                            l3 = 200L;
                        }
                        return new DecodedOutputBuffer(n3, ((MediaCodec.BufferInfo)object).offset, ((MediaCodec.BufferInfo)object).size, TimeUnit.MICROSECONDS.toMillis(((MediaCodec.BufferInfo)object).presentationTimeUs), ((TimeStamps)object3).timeStampMs, ((TimeStamps)object3).ntpTimeStampMs, l3, SystemClock.elapsedRealtime());
                    }
                    return null;
                }
                object2 = this.mediaCodec.getOutputFormat();
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("Decoder format changed: ");
                ((StringBuilder)object3).append(object2.toString());
                Logging.d(TAG, ((StringBuilder)object3).toString());
                if (object2.containsKey(FORMAT_KEY_CROP_LEFT) && object2.containsKey(FORMAT_KEY_CROP_RIGHT) && object2.containsKey(FORMAT_KEY_CROP_BOTTOM) && object2.containsKey(FORMAT_KEY_CROP_TOP)) {
                    n4 = object2.getInteger(FORMAT_KEY_CROP_RIGHT) + 1 - object2.getInteger(FORMAT_KEY_CROP_LEFT);
                    n3 = object2.getInteger(FORMAT_KEY_CROP_BOTTOM) + 1 - object2.getInteger(FORMAT_KEY_CROP_TOP);
                } else {
                    n4 = object2.getInteger("width");
                    n3 = object2.getInteger("height");
                }
                if (this.hasDecodedFirstFrame && (n4 != this.width || n3 != this.height)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unexpected size change. Configured ");
                    ((StringBuilder)object).append(this.width);
                    ((StringBuilder)object).append("*");
                    ((StringBuilder)object).append(this.height);
                    ((StringBuilder)object).append(". New ");
                    ((StringBuilder)object).append(n4);
                    ((StringBuilder)object).append("*");
                    ((StringBuilder)object).append(n3);
                    throw new RuntimeException(((StringBuilder)object).toString());
                }
                this.width = n4;
                this.height = n3;
                object3 = this.textureListener;
                if (object3 != null) {
                    ((TextureListener)object3).setSize(n4, n3);
                }
                if (!MediaCodecVideoDecoder.useSurface() && object2.containsKey("color-format")) {
                    this.colorFormat = object2.getInteger("color-format");
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("Color: 0x");
                    ((StringBuilder)object3).append(Integer.toHexString(this.colorFormat));
                    Logging.d(TAG, ((StringBuilder)object3).toString());
                    if (!supportedColorList.contains(this.colorFormat)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Non supported color format: ");
                        ((StringBuilder)object).append(this.colorFormat);
                        throw new IllegalStateException(((StringBuilder)object).toString());
                    }
                }
                if (object2.containsKey(FORMAT_KEY_STRIDE)) {
                    this.stride = object2.getInteger(FORMAT_KEY_STRIDE);
                }
                if (object2.containsKey(FORMAT_KEY_SLICE_HEIGHT)) {
                    this.sliceHeight = object2.getInteger(FORMAT_KEY_SLICE_HEIGHT);
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Frame stride and slice height: ");
                ((StringBuilder)object2).append(this.stride);
                ((StringBuilder)object2).append(" x ");
                ((StringBuilder)object2).append(this.sliceHeight);
                Logging.d(TAG, ((StringBuilder)object2).toString());
                this.stride = Math.max(this.width, this.stride);
                this.sliceHeight = Math.max(this.height, this.sliceHeight);
                continue;
            }
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Decoder output buffers changed: ");
            ((StringBuilder)object2).append(this.outputBuffers.length);
            Logging.d(TAG, ((StringBuilder)object2).toString());
            if (this.hasDecodedFirstFrame) break;
        }
        object = new RuntimeException("Unexpected output buffer change event.");
        throw object;
    }

    @CalledByNativeUnchecked
    private DecodedTextureBuffer dequeueTextureBuffer(int n2) {
        this.checkOnMediaCodecThread();
        if (MediaCodecVideoDecoder.useSurface()) {
            Object object = this.dequeueOutputBuffer(n2);
            if (object != null) {
                this.dequeuedSurfaceOutputBuffers.add((DecodedOutputBuffer)object);
            }
            this.MaybeRenderDecodedTextureBuffer();
            object = this.textureListener.dequeueTextureBuffer(n2);
            if (object != null) {
                this.MaybeRenderDecodedTextureBuffer();
                return object;
            }
            if (this.dequeuedSurfaceOutputBuffers.size() < Math.min(3, this.outputBuffers.length) && (n2 <= 0 || this.dequeuedSurfaceOutputBuffers.isEmpty())) {
                return null;
            }
            ++this.droppedFrames;
            object = this.dequeuedSurfaceOutputBuffers.remove();
            if (n2 > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Draining decoder. Dropping frame with TS: ");
                stringBuilder.append(((DecodedOutputBuffer)object).presentationTimeStampMs);
                stringBuilder.append(". Total number of dropped frames: ");
                stringBuilder.append(this.droppedFrames);
                Logging.w(TAG, stringBuilder.toString());
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Too many output buffers ");
                stringBuilder.append(this.dequeuedSurfaceOutputBuffers.size());
                stringBuilder.append(". Dropping frame with TS: ");
                stringBuilder.append(((DecodedOutputBuffer)object).presentationTimeStampMs);
                stringBuilder.append(". Total number of dropped frames: ");
                stringBuilder.append(this.droppedFrames);
                Logging.w(TAG, stringBuilder.toString());
            }
            this.mediaCodec.releaseOutputBuffer(((DecodedOutputBuffer)object).index, false);
            return new DecodedTextureBuffer(null, ((DecodedOutputBuffer)object).presentationTimeStampMs, ((DecodedOutputBuffer)object).timeStampMs, ((DecodedOutputBuffer)object).ntpTimeStampMs, ((DecodedOutputBuffer)object).decodeTimeMs, SystemClock.elapsedRealtime() - ((DecodedOutputBuffer)object).endDecodeTimeMs);
        }
        throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disposeEglContext() {
        EglBase eglBase = MediaCodecVideoDecoder.eglBase;
        if (eglBase != null) {
            eglBase.release();
            MediaCodecVideoDecoder.eglBase = null;
        }
    }

    private static DecoderProperties findDecoder(String charSequence, String[] object) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append("Trying to find HW decoder for mime ");
        ((StringBuilder)object2).append((String)charSequence);
        Logging.d(TAG, ((StringBuilder)object2).toString());
        for (int i3 = 0; i3 < MediaCodecList.getCodecCount(); ++i3) {
            Object object3;
            int n2;
            int n3;
            MediaCodecInfo mediaCodecInfo;
            block12: {
                block11: {
                    try {
                        mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
                        mediaCodecInfo = null;
                    }
                    if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
                    object2 = mediaCodecInfo.getSupportedTypes();
                    n3 = ((String[])object2).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (!object2[n2].equals(charSequence)) continue;
                        object2 = mediaCodecInfo.getName();
                        break block11;
                    }
                    object2 = null;
                }
                if (object2 == null) continue;
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("Found candidate decoder ");
                ((StringBuilder)object3).append((String)object2);
                Logging.d(TAG, ((StringBuilder)object3).toString());
                n3 = ((Object)object).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!((String)object2).startsWith((String)object[n2])) continue;
                    n2 = 1;
                    break block12;
                }
                n2 = 0;
            }
            if (n2 == 0) continue;
            try {
                mediaCodecInfo = mediaCodecInfo.getCapabilitiesForType((String)charSequence);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder capabilities", illegalArgumentException);
            }
            for (int n4 : mediaCodecInfo.colorFormats) {
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("   Color: 0x");
                ((StringBuilder)object3).append(Integer.toHexString(n4));
                Logging.v(TAG, ((StringBuilder)object3).toString());
            }
            object3 = supportedColorList.iterator();
            while (object3.hasNext()) {
                int n4;
                n3 = (Integer)object3.next();
                int[] nArray = mediaCodecInfo.colorFormats;
                n4 = nArray.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    int n5 = nArray[n2];
                    if (n5 != n3) continue;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("Found target decoder ");
                    ((StringBuilder)charSequence).append((String)object2);
                    ((StringBuilder)charSequence).append(". Color: 0x");
                    ((StringBuilder)charSequence).append(Integer.toHexString(n5));
                    Logging.d(TAG, ((StringBuilder)charSequence).toString());
                    return new DecoderProperties((String)object2, n5);
                }
            }
            continue;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("No HW decoder found for mime ");
        ((StringBuilder)object).append((String)charSequence);
        Logging.d(TAG, ((StringBuilder)object).toString());
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNativeUnchecked
    private boolean initDecode(VideoCodecType object, int n2, int n3) {
        void var4_8;
        CharSequence charSequence;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        if (object == VideoCodecType.VIDEO_CODEC_VP8) {
            String[] stringArray = MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes();
            charSequence = VP8_MIME_TYPE;
        } else if (object == VideoCodecType.VIDEO_CODEC_VP9) {
            String[] stringArray = supportedVp9HwCodecPrefixes;
            charSequence = VP9_MIME_TYPE;
        } else {
            if (object != VideoCodecType.VIDEO_CODEC_H264) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("initDecode: Non-supported codec ");
                stringBuilder.append(object);
                throw new RuntimeException(stringBuilder.toString());
            }
            String[] stringArray = MediaCodecVideoDecoder.supportedH264HwCodecPrefixes();
            charSequence = H264_MIME_TYPE;
        }
        DecoderProperties decoderProperties = MediaCodecVideoDecoder.findDecoder((String)charSequence, (String[])var4_8);
        if (decoderProperties == null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Cannot find HW decoder for ");
            ((StringBuilder)charSequence).append(object);
            throw new RuntimeException(((StringBuilder)charSequence).toString());
        }
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append("Java initDecode: ");
        ((StringBuilder)object2).append(object);
        ((StringBuilder)object2).append(" : ");
        ((StringBuilder)object2).append(n2);
        ((StringBuilder)object2).append(" x ");
        ((StringBuilder)object2).append(n3);
        ((StringBuilder)object2).append(". Color: 0x");
        ((StringBuilder)object2).append(Integer.toHexString(decoderProperties.colorFormat));
        ((StringBuilder)object2).append(". Use Surface: ");
        ((StringBuilder)object2).append(MediaCodecVideoDecoder.useSurface());
        Logging.d(TAG, ((StringBuilder)object2).toString());
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            this.width = n2;
            this.height = n3;
            this.stride = n2;
            this.sliceHeight = n3;
            if (MediaCodecVideoDecoder.useSurface() && (object = SurfaceTextureHelper.create("Decoder SurfaceTextureHelper", eglBase.getEglBaseContext())) != null) {
                this.textureListener = object2 = new TextureListener((SurfaceTextureHelper)object);
                ((TextureListener)object2).setSize(n2, n3);
                object2 = new Surface(((SurfaceTextureHelper)object).getSurfaceTexture());
                this.surface = object2;
            }
            object = MediaFormat.createVideoFormat((String)charSequence, (int)n2, (int)n3);
            if (!MediaCodecVideoDecoder.useSurface()) {
                object.setInteger("color-format", decoderProperties.colorFormat);
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("  Format: ");
            ((StringBuilder)charSequence).append(object);
            Logging.d(TAG, ((StringBuilder)charSequence).toString());
            charSequence = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
            this.mediaCodec = charSequence;
            if (charSequence == null) {
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            charSequence.configure((MediaFormat)object, this.surface, null, 0);
            this.mediaCodec.start();
            this.colorFormat = decoderProperties.colorFormat;
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            this.inputBuffers = this.mediaCodec.getInputBuffers();
            this.decodeStartTimeMs.clear();
            this.hasDecodedFirstFrame = false;
            this.dequeuedSurfaceOutputBuffers.clear();
            this.droppedFrames = 0;
            object = new StringBuilder();
            ((StringBuilder)object).append("Input buffers: ");
            ((StringBuilder)object).append(this.inputBuffers.length);
            ((StringBuilder)object).append(". Output buffers: ");
            ((StringBuilder)object).append(this.outputBuffers.length);
            Logging.d(TAG, ((StringBuilder)object).toString());
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            return false;
        }
    }

    public static boolean isH264HighProfileHwSupported() {
        if (hwDecoderDisabledTypes.contains(H264_MIME_TYPE)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedQcomH264HighProfileHwCodecPrefix}) != null) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedExynosH264HighProfileHwCodecPrefix}) != null) {
            return true;
        }
        return PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled") && Build.VERSION.SDK_INT >= 27 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedMediaTekH264HighProfileHwCodecPrefix}) != null;
    }

    public static boolean isH264HwSupported() {
        boolean bl = !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, MediaCodecVideoDecoder.supportedH264HwCodecPrefixes()) != null;
        return bl;
    }

    public static boolean isVp8HwSupported() {
        boolean bl = !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes()) != null;
        return bl;
    }

    public static boolean isVp9HwSupported() {
        boolean bl = !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
        return bl;
    }

    private static native long nativeCreateDecoder(String var0, boolean var1);

    public static void printStackTrace() {
        Object object = runningInstance;
        if (object != null && (object = object.mediaCodecThread) != null && ((StackTraceElement[])(object = object.getStackTrace())).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            int n2 = ((StackTraceElement[])object).length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Logging.d(TAG, object[i3].toString());
            }
        }
    }

    @CalledByNativeUnchecked
    private boolean queueInputBuffer(int n2, int n3, long l3, long l4, long l5) {
        this.checkOnMediaCodecThread();
        try {
            this.inputBuffers[n2].position(0);
            this.inputBuffers[n2].limit(n3);
            Queue<TimeStamps> queue = this.decodeStartTimeMs;
            TimeStamps timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), l4, l5);
            queue.add(timeStamps);
            this.mediaCodec.queueInputBuffer(n2, 0, n3, l3, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "decode failed", illegalStateException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    private void release() {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("Java releaseDecoder. Total number of dropped frames: ");
        ((StringBuilder)object).append(this.droppedFrames);
        Logging.d(TAG, ((StringBuilder)object).toString());
        this.checkOnMediaCodecThread();
        object = new CountDownLatch(1);
        new Thread(new Runnable((CountDownLatch)object){
            final /* synthetic */ CountDownLatch val$releaseDone;
            {
                this.val$releaseDone = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    MediaCodecVideoDecoder.this.mediaCodec.stop();
                    MediaCodecVideoDecoder.this.mediaCodec.release();
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", exception);
                }
                this.val$releaseDone.countDown();
            }
        }).start();
        if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)object, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Invoke codec error callback. Errors: ");
                ((StringBuilder)object).append(codecErrors);
                Logging.e(TAG, ((StringBuilder)object).toString());
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        if (MediaCodecVideoDecoder.useSurface()) {
            this.surface.release();
            this.surface = null;
            this.textureListener.release();
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    @CalledByNativeUnchecked
    private void reset(int n2, int n3) {
        if (this.mediaCodecThread != null && this.mediaCodec != null) {
            Object object = new StringBuilder();
            ((StringBuilder)object).append("Java reset: ");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(" x ");
            ((StringBuilder)object).append(n3);
            Logging.d(TAG, ((StringBuilder)object).toString());
            this.mediaCodec.flush();
            this.width = n2;
            this.height = n3;
            object = this.textureListener;
            if (object != null) {
                ((TextureListener)object).setSize(n2, n3);
            }
            this.decodeStartTimeMs.clear();
            this.dequeuedSurfaceOutputBuffers.clear();
            this.hasDecodedFirstFrame = false;
            this.droppedFrames = 0;
            return;
        }
        throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
    }

    @CalledByNativeUnchecked
    private void returnDecodedOutputBuffer(int n2) throws IllegalStateException, MediaCodec.CodecException {
        this.checkOnMediaCodecThread();
        if (!MediaCodecVideoDecoder.useSurface()) {
            this.mediaCodec.releaseOutputBuffer(n2, false);
            return;
        }
        throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
    }

    public static void setEglContext(EglBase.Context context) {
        if (eglBase != null) {
            Logging.w(TAG, "Egl context already set.");
            eglBase.release();
        }
        eglBase = EglBase$_CC.create(context);
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    private static final String[] supportedH264HwCodecPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Intel.");
        arrayList.add(supportedExynosH264HighProfileHwCodecPrefix);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled") && Build.VERSION.SDK_INT >= 27) {
            arrayList.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static final String[] supportedVp8HwCodecPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Nvidia.");
        arrayList.add(supportedExynosH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Intel.");
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekVP8").equals("Enabled") && Build.VERSION.SDK_INT >= 24) {
            arrayList.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static boolean useSurface() {
        boolean bl = eglBase != null;
        return bl;
    }

    @CalledByNative
    int getColorFormat() {
        return this.colorFormat;
    }

    @CalledByNative
    int getHeight() {
        return this.height;
    }

    @CalledByNative
    ByteBuffer[] getInputBuffers() {
        return this.inputBuffers;
    }

    @CalledByNative
    ByteBuffer[] getOutputBuffers() {
        return this.outputBuffers;
    }

    @CalledByNative
    int getSliceHeight() {
        return this.sliceHeight;
    }

    @CalledByNative
    int getStride() {
        return this.stride;
    }

    @CalledByNative
    int getWidth() {
        return this.width;
    }

    private static class DecodedOutputBuffer {
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;
        private final int index;
        private final long ntpTimeStampMs;
        private final int offset;
        private final long presentationTimeStampMs;
        private final int size;
        private final long timeStampMs;

        public DecodedOutputBuffer(int n2, int n3, int n4, long l3, long l4, long l5, long l6, long l7) {
            this.index = n2;
            this.offset = n3;
            this.size = n4;
            this.presentationTimeStampMs = l3;
            this.timeStampMs = l4;
            this.ntpTimeStampMs = l5;
            this.decodeTimeMs = l6;
            this.endDecodeTimeMs = l7;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getIndex() {
            return this.index;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getOffset() {
            return this.offset;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getSize() {
            return this.size;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getTimestampMs() {
            return this.timeStampMs;
        }
    }

    private static class DecodedTextureBuffer {
        private final long decodeTimeMs;
        private final long frameDelayMs;
        private final long ntpTimeStampMs;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final VideoFrame.Buffer videoFrameBuffer;

        public DecodedTextureBuffer(VideoFrame.Buffer buffer, long l3, long l4, long l5, long l6, long l7) {
            this.videoFrameBuffer = buffer;
            this.presentationTimeStampMs = l3;
            this.timeStampMs = l4;
            this.ntpTimeStampMs = l5;
            this.decodeTimeMs = l6;
            this.frameDelayMs = l7;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getFrameDelayMs() {
            return this.frameDelayMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getTimeStampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        VideoFrame.Buffer getVideoFrameBuffer() {
            return this.videoFrameBuffer;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string2, int n2) {
            this.codecName = string2;
            this.colorFormat = n2;
        }
    }

    static class HwDecoderFactory
    implements VideoDecoderFactory {
        private final VideoCodecInfo[] supportedHardwareCodecs = HwDecoderFactory.getSupportedHardwareCodecs();

        HwDecoderFactory() {
        }

        private static VideoCodecInfo[] getSupportedHardwareCodecs() {
            ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
            if (MediaCodecVideoDecoder.isVp8HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "VP8 HW Decoder supported.");
                arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isVp9HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "VP9 HW Decoder supported.");
                arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isH264HighProfileHwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 High Profile HW Decoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_HIGH_PROFILE_CODEC);
            }
            if (MediaCodecVideoDecoder.isH264HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 HW Decoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
            }
            return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
        }

        private static boolean isCodecSupported(VideoCodecInfo[] videoCodecInfoArray, VideoCodecInfo videoCodecInfo) {
            int n2 = videoCodecInfoArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!HwDecoderFactory.isSameCodec(videoCodecInfoArray[i3], videoCodecInfo)) continue;
                return true;
            }
            return false;
        }

        private static boolean isSameCodec(VideoCodecInfo videoCodecInfo, VideoCodecInfo videoCodecInfo2) {
            if (!videoCodecInfo.name.equalsIgnoreCase(videoCodecInfo2.name)) {
                return false;
            }
            boolean bl = videoCodecInfo.name.equalsIgnoreCase("H264") ? H264Utils.isSameH264Profile(videoCodecInfo.params, videoCodecInfo2.params) : true;
            return bl;
        }

        @Override
        @Deprecated
        public /* synthetic */ VideoDecoder createDecoder(String string2) {
            return VideoDecoderFactory$_CC.$default$createDecoder((VideoDecoderFactory)this, string2);
        }

        @Override
        public VideoDecoder createDecoder(final VideoCodecInfo videoCodecInfo) {
            if (!HwDecoderFactory.isCodecSupported(this.supportedHardwareCodecs, videoCodecInfo)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("No HW video decoder for codec ");
                stringBuilder.append(videoCodecInfo.name);
                Logging.d(MediaCodecVideoDecoder.TAG, stringBuilder.toString());
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Create HW video decoder for ");
            stringBuilder.append(videoCodecInfo.name);
            Logging.d(MediaCodecVideoDecoder.TAG, stringBuilder.toString());
            return new WrappedNativeVideoDecoder(){

                @Override
                public long createNativeVideoDecoder() {
                    return MediaCodecVideoDecoder.nativeCreateDecoder(videoCodecInfo.name, MediaCodecVideoDecoder.useSurface());
                }
            };
        }

        @Override
        public VideoCodecInfo[] getSupportedCodecs() {
            return this.supportedHardwareCodecs;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    private class TextureListener
    implements VideoSink {
        private DecodedOutputBuffer bufferToRender;
        private final Object newFrameLock = new Object();
        private DecodedTextureBuffer renderedBuffer;
        private final SurfaceTextureHelper surfaceTextureHelper;

        public TextureListener(SurfaceTextureHelper surfaceTextureHelper) {
            this.surfaceTextureHelper = surfaceTextureHelper;
            surfaceTextureHelper.startListening(this);
        }

        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            if (this.bufferToRender == null) {
                this.bufferToRender = decodedOutputBuffer;
                return;
            }
            Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected addBufferToRender() called while waiting for a texture.");
            throw new IllegalStateException("Waiting for a texture.");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public DecodedTextureBuffer dequeueTextureBuffer(int n2) {
            Object object = this.newFrameLock;
            synchronized (object) {
                boolean bl;
                if (this.renderedBuffer == null && n2 > 0 && (bl = this.isWaitingForTexture())) {
                    try {
                        this.newFrameLock.wait(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                DecodedTextureBuffer decodedTextureBuffer = this.renderedBuffer;
                this.renderedBuffer = null;
                return decodedTextureBuffer;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isWaitingForTexture() {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.bufferToRender == null) return false;
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onFrame(VideoFrame object) {
            Object object2 = this.newFrameLock;
            synchronized (object2) {
                if (this.renderedBuffer == null) {
                    DecodedTextureBuffer decodedTextureBuffer;
                    object = ((VideoFrame)object).getBuffer();
                    object.retain();
                    this.renderedBuffer = decodedTextureBuffer = new DecodedTextureBuffer((VideoFrame.Buffer)object, this.bufferToRender.presentationTimeStampMs, this.bufferToRender.timeStampMs, this.bufferToRender.ntpTimeStampMs, this.bufferToRender.decodeTimeMs, SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs);
                    this.bufferToRender = null;
                    this.newFrameLock.notifyAll();
                    return;
                }
                Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected onFrame() called while already holding a texture.");
                object = new IllegalStateException("Already holding a texture.");
                throw object;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release() {
            this.surfaceTextureHelper.stopListening();
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    this.renderedBuffer.getVideoFrameBuffer().release();
                    this.renderedBuffer = null;
                }
            }
            this.surfaceTextureHelper.dispose();
        }

        public void setSize(int n2, int n3) {
            this.surfaceTextureHelper.setTextureSize(n2, n3);
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long ntpTimeStampMs;
        private final long timeStampMs;

        public TimeStamps(long l3, long l4, long l5) {
            this.decodeStartTimeMs = l3;
            this.timeStampMs = l4;
            this.ntpTimeStampMs = l5;
        }
    }

    public static final class VideoCodecType
    extends Enum<VideoCodecType> {
        private static final /* synthetic */ VideoCodecType[] $VALUES;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_AV1;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_H264;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_UNKNOWN;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP8;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP9;

        static {
            VideoCodecType videoCodecType;
            VIDEO_CODEC_UNKNOWN = new VideoCodecType();
            VIDEO_CODEC_VP8 = new VideoCodecType();
            VIDEO_CODEC_VP9 = new VideoCodecType();
            VIDEO_CODEC_AV1 = new VideoCodecType();
            VIDEO_CODEC_H264 = videoCodecType = new VideoCodecType();
            $VALUES = new VideoCodecType[]{VIDEO_CODEC_UNKNOWN, VIDEO_CODEC_VP8, VIDEO_CODEC_VP9, VIDEO_CODEC_AV1, videoCodecType};
        }

        @CalledByNative(value="VideoCodecType")
        static VideoCodecType fromNativeIndex(int n2) {
            return VideoCodecType.values()[n2];
        }

        public static VideoCodecType valueOf(String string2) {
            return Enum.valueOf(VideoCodecType.class, string2);
        }

        public static VideoCodecType[] values() {
            return (VideoCodecType[])$VALUES.clone();
        }
    }
}

