/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.os.Build;
import java.util.HashMap;
import java.util.Map;
import org.webrtc.H264Utils;
import org.webrtc.VideoCodecType;

class MediaCodecUtils {
    static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    static final int[] DECODER_COLOR_FORMATS;
    static final int[] ENCODER_COLOR_FORMATS;
    static final String EXYNOS_PREFIX = "OMX.Exynos.";
    static final String INTEL_PREFIX = "OMX.Intel.";
    static final String NVIDIA_PREFIX = "OMX.Nvidia.";
    static final String QCOM_PREFIX = "OMX.qcom.";
    static final String[] SOFTWARE_IMPLEMENTATION_PREFIXES;
    private static final String TAG = "MediaCodecUtils";
    static final int[] TEXTURE_COLOR_FORMATS;

    static {
        SOFTWARE_IMPLEMENTATION_PREFIXES = new String[]{"OMX.google.", "OMX.SEC."};
        DECODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876};
        ENCODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391876};
        TEXTURE_COLOR_FORMATS = MediaCodecUtils.getTextureColorFormats();
    }

    private MediaCodecUtils() {
    }

    /*
     * WARNING - void declaration
     */
    static boolean codecSupportsType(MediaCodecInfo object2, VideoCodecType videoCodecType) {
        for (String string2 : object2.getSupportedTypes()) {
            void var1_3;
            if (!var1_3.mimeType().equals(string2)) continue;
            return true;
        }
        return false;
    }

    static Map<String, String> getCodecProperties(VideoCodecType videoCodecType, boolean bl) {
        int n2 = 1.$SwitchMap$org$webrtc$VideoCodecType[videoCodecType.ordinal()];
        if (n2 != 1 && n2 != 2) {
            if (n2 == 3) {
                return H264Utils.getDefaultH264Params(bl);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unsupported codec: ");
            stringBuilder.append((Object)videoCodecType);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return new HashMap<String, String>();
    }

    private static int[] getTextureColorFormats() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new int[]{2130708361};
        }
        return new int[0];
    }

    static Integer selectColorFormat(int[] nArray, MediaCodecInfo.CodecCapabilities codecCapabilities) {
        for (int n2 : nArray) {
            for (int n3 : codecCapabilities.colorFormats) {
                if (n3 != n2) continue;
                return n3;
            }
        }
        return null;
    }
}

