/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.webrtc.Loggable;

public class Logging {
    private static final Logger fallbackLogger = Logging.createFallbackLogger();
    private static Loggable loggable;
    private static Severity loggableSeverity;
    private static volatile boolean loggingEnabled;

    private static Logger createFallbackLogger() {
        Logger logger = Logger.getLogger("org.webrtc.Logging");
        logger.setLevel(Level.ALL);
        return logger;
    }

    public static void d(String string2, String string3) {
        Logging.log(Severity.LS_INFO, string2, string3);
    }

    static void deleteInjectedLoggable() {
        loggable = null;
    }

    public static void e(String string2, String string3) {
        Logging.log(Severity.LS_ERROR, string2, string3);
    }

    public static void e(String string2, String string3, Throwable throwable) {
        Logging.log(Severity.LS_ERROR, string2, string3);
        Logging.log(Severity.LS_ERROR, string2, throwable.toString());
        Logging.log(Severity.LS_ERROR, string2, Logging.getStackTraceString(throwable));
    }

    public static void enableLogThreads() {
        Logging.nativeEnableLogThreads();
    }

    public static void enableLogTimeStamps() {
        Logging.nativeEnableLogTimeStamps();
    }

    public static void enableLogToDebugOutput(Severity object) {
        synchronized (Logging.class) {
            if (loggable == null) {
                Logging.nativeEnableLogToDebugOutput(object.ordinal());
                loggingEnabled = true;
                return;
            }
            object = new IllegalStateException("Logging to native debug output not supported while Loggable is injected. Delete the Loggable before calling this method.");
            throw object;
        }
    }

    @Deprecated
    public static void enableTracing(String string2, EnumSet<TraceLevel> enumSet) {
    }

    private static String getStackTraceString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    static void injectLoggable(Loggable loggable, Severity severity) {
        if (loggable != null) {
            Logging.loggable = loggable;
            loggableSeverity = severity;
        }
    }

    public static void log(Severity object, String string2, String string3) {
        if (string2 != null && string3 != null) {
            if (loggable != null) {
                if (object.ordinal() < loggableSeverity.ordinal()) {
                    return;
                }
                loggable.onLogMessage(string3, (Severity)((Object)object), string2);
                return;
            }
            if (loggingEnabled) {
                Logging.nativeLog(object.ordinal(), string2, string3);
                return;
            }
            int n2 = 1.$SwitchMap$org$webrtc$Logging$Severity[object.ordinal()];
            object = n2 != 1 ? (n2 != 2 ? (n2 != 3 ? Level.FINE : Level.INFO) : Level.WARNING) : Level.SEVERE;
            Logger logger = fallbackLogger;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(": ");
            stringBuilder.append(string3);
            logger.log((Level)object, stringBuilder.toString());
            return;
        }
        throw new IllegalArgumentException("Logging tag or message may not be null.");
    }

    private static native void nativeEnableLogThreads();

    private static native void nativeEnableLogTimeStamps();

    private static native void nativeEnableLogToDebugOutput(int var0);

    private static native void nativeLog(int var0, String var1, String var2);

    public static void v(String string2, String string3) {
        Logging.log(Severity.LS_VERBOSE, string2, string3);
    }

    public static void w(String string2, String string3) {
        Logging.log(Severity.LS_WARNING, string2, string3);
    }

    public static void w(String string2, String string3, Throwable throwable) {
        Logging.log(Severity.LS_WARNING, string2, string3);
        Logging.log(Severity.LS_WARNING, string2, throwable.toString());
        Logging.log(Severity.LS_WARNING, string2, Logging.getStackTraceString(throwable));
    }

    public static final class Severity
    extends Enum<Severity> {
        private static final /* synthetic */ Severity[] $VALUES;
        public static final /* enum */ Severity LS_ERROR;
        public static final /* enum */ Severity LS_INFO;
        public static final /* enum */ Severity LS_NONE;
        public static final /* enum */ Severity LS_VERBOSE;
        public static final /* enum */ Severity LS_WARNING;

        static {
            Severity severity;
            LS_VERBOSE = new Severity();
            LS_INFO = new Severity();
            LS_WARNING = new Severity();
            LS_ERROR = new Severity();
            LS_NONE = severity = new Severity();
            $VALUES = new Severity[]{LS_VERBOSE, LS_INFO, LS_WARNING, LS_ERROR, severity};
        }

        public static Severity valueOf(String string2) {
            return Enum.valueOf(Severity.class, string2);
        }

        public static Severity[] values() {
            return (Severity[])$VALUES.clone();
        }
    }

    @Deprecated
    public static final class TraceLevel
    extends Enum<TraceLevel> {
        private static final /* synthetic */ TraceLevel[] $VALUES;
        public static final /* enum */ TraceLevel TRACE_ALL;
        public static final /* enum */ TraceLevel TRACE_APICALL;
        public static final /* enum */ TraceLevel TRACE_CRITICAL;
        public static final /* enum */ TraceLevel TRACE_DEBUG;
        public static final /* enum */ TraceLevel TRACE_DEFAULT;
        public static final /* enum */ TraceLevel TRACE_ERROR;
        public static final /* enum */ TraceLevel TRACE_INFO;
        public static final /* enum */ TraceLevel TRACE_MEMORY;
        public static final /* enum */ TraceLevel TRACE_MODULECALL;
        public static final /* enum */ TraceLevel TRACE_NONE;
        public static final /* enum */ TraceLevel TRACE_STATEINFO;
        public static final /* enum */ TraceLevel TRACE_STREAM;
        public static final /* enum */ TraceLevel TRACE_TERSEINFO;
        public static final /* enum */ TraceLevel TRACE_TIMER;
        public static final /* enum */ TraceLevel TRACE_WARNING;
        public final int level;

        static {
            TraceLevel traceLevel;
            TRACE_NONE = new TraceLevel(0);
            TRACE_STATEINFO = new TraceLevel(1);
            TRACE_WARNING = new TraceLevel(2);
            TRACE_ERROR = new TraceLevel(4);
            TRACE_CRITICAL = new TraceLevel(8);
            TRACE_APICALL = new TraceLevel(16);
            TRACE_DEFAULT = new TraceLevel(255);
            TRACE_MODULECALL = new TraceLevel(32);
            TRACE_MEMORY = new TraceLevel(256);
            TRACE_TIMER = new TraceLevel(512);
            TRACE_STREAM = new TraceLevel(1024);
            TRACE_DEBUG = new TraceLevel(2048);
            TRACE_INFO = new TraceLevel(4096);
            TRACE_TERSEINFO = new TraceLevel(8192);
            TRACE_ALL = traceLevel = new TraceLevel(65535);
            $VALUES = new TraceLevel[]{TRACE_NONE, TRACE_STATEINFO, TRACE_WARNING, TRACE_ERROR, TRACE_CRITICAL, TRACE_APICALL, TRACE_DEFAULT, TRACE_MODULECALL, TRACE_MEMORY, TRACE_TIMER, TRACE_STREAM, TRACE_DEBUG, TRACE_INFO, TRACE_TERSEINFO, traceLevel};
        }

        private TraceLevel(int n3) {
            this.level = n3;
        }

        public static TraceLevel valueOf(String string2) {
            return Enum.valueOf(TraceLevel.class, string2);
        }

        public static TraceLevel[] values() {
            return (TraceLevel[])$VALUES.clone();
        }
    }
}

