/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.webrtc.JniCommon;
import org.webrtc.RefCountDelegate;
import org.webrtc.VideoFrame;
import org.webrtc._$;

public class JavaI420Buffer
implements VideoFrame.I420Buffer {
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final ByteBuffer dataY;
    private final int height;
    private final RefCountDelegate refCountDelegate;
    private final int strideU;
    private final int strideV;
    private final int strideY;
    private final int width;

    private JavaI420Buffer(int n2, int n3, ByteBuffer byteBuffer, int n4, ByteBuffer byteBuffer2, int n5, ByteBuffer byteBuffer3, int n6, Runnable runnable) {
        this.width = n2;
        this.height = n3;
        this.dataY = byteBuffer;
        this.dataU = byteBuffer2;
        this.dataV = byteBuffer3;
        this.strideY = n4;
        this.strideU = n5;
        this.strideV = n6;
        this.refCountDelegate = new RefCountDelegate(runnable);
    }

    public static JavaI420Buffer allocate(int n2, int n3) {
        int n4 = (n3 + 1) / 2;
        int n5 = (n2 + 1) / 2;
        int n6 = n2 * n3;
        int n7 = n6 + 0;
        int n8 = n5 * n4;
        int n9 = n7 + n8;
        ByteBuffer byteBuffer = JniCommon.nativeAllocateByteBuffer(n6 + n5 * 2 * n4);
        byteBuffer.position(0);
        byteBuffer.limit(n7);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n7);
        byteBuffer.limit(n9);
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        byteBuffer.position(n9);
        byteBuffer.limit(n9 + n8);
        return new JavaI420Buffer(n2, n3, byteBuffer2, n2, byteBuffer3, n5, byteBuffer.slice(), n5, (Runnable)new _$.Lambda.JavaI420Buffer._Oc35sRrucoGcYlFFmf5S_RP8fI(byteBuffer));
    }

    private static void checkCapacity(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        n2 = n4 * (n3 - 1) + n2;
        if (byteBuffer.capacity() >= n2) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Buffer must be at least ");
        stringBuilder.append(n2);
        stringBuilder.append(" bytes, but was ");
        stringBuilder.append(byteBuffer.capacity());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static VideoFrame.Buffer cropAndScaleI420(VideoFrame.I420Buffer i420Buffer, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n4 == n6 && n5 == n7) {
            ByteBuffer byteBuffer = i420Buffer.getDataY();
            ByteBuffer byteBuffer2 = i420Buffer.getDataU();
            ByteBuffer byteBuffer3 = i420Buffer.getDataV();
            byteBuffer.position(n2 + i420Buffer.getStrideY() * n3);
            byteBuffer2.position(i420Buffer.getStrideU() * (n3 /= 2) + (n2 /= 2));
            byteBuffer3.position(n2 + n3 * i420Buffer.getStrideV());
            i420Buffer.retain();
            byteBuffer = byteBuffer.slice();
            n3 = i420Buffer.getStrideY();
            byteBuffer2 = byteBuffer2.slice();
            n4 = i420Buffer.getStrideU();
            byteBuffer3 = byteBuffer3.slice();
            n2 = i420Buffer.getStrideV();
            Objects.requireNonNull(i420Buffer);
            return JavaI420Buffer.wrap(n6, n7, byteBuffer, n3, byteBuffer2, n4, byteBuffer3, n2, (Runnable)new _$.Lambda.cpstbe6pEi_a9uN5WMp_TN86PFo(i420Buffer));
        }
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n6, n7);
        JavaI420Buffer.nativeCropAndScaleI420(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), n2, n3, n4, n5, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV(), n6, n7);
        return javaI420Buffer;
    }

    static /* synthetic */ void lambda$allocate$0(ByteBuffer byteBuffer) {
        JniCommon.nativeFreeByteBuffer(byteBuffer);
    }

    private static native void nativeCropAndScaleI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8, int var9, ByteBuffer var10, int var11, ByteBuffer var12, int var13, ByteBuffer var14, int var15, int var16, int var17);

    public static JavaI420Buffer wrap(int n2, int n3, ByteBuffer byteBuffer, int n4, ByteBuffer byteBuffer2, int n5, ByteBuffer byteBuffer3, int n6, Runnable runnable) {
        if (byteBuffer != null && byteBuffer2 != null && byteBuffer3 != null) {
            if (byteBuffer.isDirect() && byteBuffer2.isDirect() && byteBuffer3.isDirect()) {
                byteBuffer = byteBuffer.slice();
                byteBuffer2 = byteBuffer2.slice();
                byteBuffer3 = byteBuffer3.slice();
                int n7 = (n2 + 1) / 2;
                int n8 = (n3 + 1) / 2;
                JavaI420Buffer.checkCapacity(byteBuffer, n2, n3, n4);
                JavaI420Buffer.checkCapacity(byteBuffer2, n7, n8, n5);
                JavaI420Buffer.checkCapacity(byteBuffer3, n7, n8, n6);
                return new JavaI420Buffer(n2, n3, byteBuffer, n4, byteBuffer2, n5, byteBuffer3, n6, runnable);
            }
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        throw new IllegalArgumentException("Data buffers cannot be null.");
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        return JavaI420Buffer.cropAndScaleI420(this, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        this.retain();
        return this;
    }
}

