/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.webrtc.BaseBitrateAdjuster;
import org.webrtc.BitrateAdjuster;
import org.webrtc.CalledByNative;
import org.webrtc.DynamicBitrateAdjuster;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.FramerateBitrateAdjuster;
import org.webrtc.H264Utils;
import org.webrtc.HardwareVideoEncoder;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.MediaCodecWrapperFactoryImpl;
import org.webrtc.Predicate;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoEncoderFactory$_CC;

public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4");
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    private static final String TAG = "HardwareVideoEncoderFactory";
    private final Predicate<MediaCodecInfo> codecAllowedPredicate;
    private final boolean enableH264HighProfile;
    private final boolean enableIntelVp8Encoder;
    private final EglBase14.Context sharedContext;

    public HardwareVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2) {
        this(context, bl, bl2, null);
    }

    public HardwareVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2, Predicate<MediaCodecInfo> predicate) {
        if (context instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)context;
        } else {
            Logging.w(TAG, "No shared EglBase.Context.  Encoders will not use texture mode.");
            this.sharedContext = null;
        }
        this.enableIntelVp8Encoder = bl;
        this.enableH264HighProfile = bl2;
        this.codecAllowedPredicate = predicate;
    }

    @Deprecated
    public HardwareVideoEncoderFactory(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecType videoCodecType, String string2) {
        if (string2.startsWith("OMX.Exynos.")) {
            if (videoCodecType == VideoCodecType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            return new FramerateBitrateAdjuster();
        }
        return new BaseBitrateAdjuster();
    }

    private MediaCodecInfo findCodecForType(VideoCodecType videoCodecType) {
        int n2 = 0;
        while (true) {
            int n3 = MediaCodecList.getCodecCount();
            MediaCodecInfo mediaCodecInfo = null;
            if (n2 >= n3) break;
            try {
                MediaCodecInfo mediaCodecInfo2;
                mediaCodecInfo = mediaCodecInfo2 = MediaCodecList.getCodecInfoAt((int)n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo != null && mediaCodecInfo.isEncoder() && this.isSupportedCodec(mediaCodecInfo, videoCodecType)) {
                return mediaCodecInfo;
            }
            ++n2;
        }
        return null;
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecType videoCodecType, String string2) {
        block4: {
            block5: {
                if (videoCodecType != VideoCodecType.VP8 || !string2.startsWith("OMX.qcom.")) break block4;
                int n2 = Build.VERSION.SDK_INT;
                if (n2 == 21 || n2 == 22) break block5;
                if (n2 == 23) {
                    return 20000;
                }
                if (n2 <= 23) break block4;
            }
            return 15000;
        }
        return 0;
    }

    private int getKeyFrameIntervalSec(VideoCodecType videoCodecType) {
        int n2 = 1.$SwitchMap$org$webrtc$VideoCodecType[videoCodecType.ordinal()];
        if (n2 != 1 && n2 != 2) {
            if (n2 == 3) {
                return 20;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unsupported VideoCodecType ");
            stringBuilder.append((Object)videoCodecType);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return 100;
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo mediaCodecInfo) {
        boolean bl = this.enableH264HighProfile && Build.VERSION.SDK_INT > 23 && mediaCodecInfo.getName().startsWith("OMX.Exynos.");
        return bl;
    }

    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        int n2 = 1.$SwitchMap$org$webrtc$VideoCodecType[videoCodecType.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    return false;
                }
                return this.isHardwareSupportedInCurrentSdkH264(mediaCodecInfo);
            }
            return this.isHardwareSupportedInCurrentSdkVp9(mediaCodecInfo);
        }
        return this.isHardwareSupportedInCurrentSdkVp8(mediaCodecInfo);
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo object) {
        boolean bl;
        block5: {
            block4: {
                bl = H264_HW_EXCEPTION_MODELS.contains(Build.MODEL);
                boolean bl2 = false;
                if (bl) {
                    return false;
                }
                if (((String)(object = object.getName())).startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19) break block4;
                bl = bl2;
                if (!((String)object).startsWith("OMX.Exynos.")) break block5;
                bl = bl2;
                if (Build.VERSION.SDK_INT < 21) break block5;
            }
            bl = true;
        }
        return bl;
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo object) {
        boolean bl = ((String)(object = object.getName())).startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || ((String)object).startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || ((String)object).startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
        return bl;
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo object) {
        boolean bl = (((String)(object = object.getName())).startsWith("OMX.qcom.") || ((String)object).startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
        return bl;
    }

    private boolean isMediaCodecAllowed(MediaCodecInfo mediaCodecInfo) {
        Predicate<MediaCodecInfo> predicate = this.codecAllowedPredicate;
        if (predicate == null) {
            return true;
        }
        return predicate.test(mediaCodecInfo);
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        boolean bl = MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecType);
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType())) == null) {
            return false;
        }
        bl = bl2;
        if (this.isHardwareSupportedInCurrentSdk(mediaCodecInfo, videoCodecType)) {
            bl = bl2;
            if (this.isMediaCodecAllowed(mediaCodecInfo)) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        VideoCodecType videoCodecType = VideoCodecType.valueOf(videoCodecInfo.name);
        MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
        if (mediaCodecInfo == null) {
            return null;
        }
        String string2 = mediaCodecInfo.getName();
        Object object = videoCodecType.mimeType();
        Integer n2 = MediaCodecUtils.selectColorFormat(MediaCodecUtils.TEXTURE_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType((String)object));
        object = MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType((String)object));
        if (videoCodecType == VideoCodecType.H264) {
            boolean bl = H264Utils.isSameH264Profile(videoCodecInfo.params, MediaCodecUtils.getCodecProperties(videoCodecType, true));
            boolean bl2 = H264Utils.isSameH264Profile(videoCodecInfo.params, MediaCodecUtils.getCodecProperties(videoCodecType, false));
            if (!bl && !bl2) {
                return null;
            }
            if (bl && !this.isH264HighProfileSupported(mediaCodecInfo)) {
                return null;
            }
        }
        return new HardwareVideoEncoder(new MediaCodecWrapperFactoryImpl(), string2, videoCodecType, n2, (Integer)object, videoCodecInfo.params, this.getKeyFrameIntervalSec(videoCodecType), this.getForcedKeyFrameIntervalMs(videoCodecType, string2), this.createBitrateAdjuster(videoCodecType, string2), this.sharedContext);
    }

    @Override
    @CalledByNative
    public /* synthetic */ VideoCodecInfo[] getImplementations() {
        return VideoEncoderFactory$_CC.$default$getImplementations(this);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        if (Build.VERSION.SDK_INT < 19) {
            return new VideoCodecInfo[0];
        }
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        VideoCodecType videoCodecType = VideoCodecType.VP8;
        VideoCodecType videoCodecType2 = VideoCodecType.VP9;
        VideoCodecType videoCodecType3 = VideoCodecType.H264;
        for (int i3 = 0; i3 < 3; ++i3) {
            VideoCodecType videoCodecType4 = (new VideoCodecType[]{videoCodecType, videoCodecType2, videoCodecType3})[i3];
            MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType4);
            if (mediaCodecInfo == null) continue;
            String string2 = videoCodecType4.name();
            if (videoCodecType4 == VideoCodecType.H264 && this.isH264HighProfileSupported(mediaCodecInfo)) {
                arrayList.add(new VideoCodecInfo(string2, MediaCodecUtils.getCodecProperties(videoCodecType4, true)));
            }
            arrayList.add(new VideoCodecInfo(string2, MediaCodecUtils.getCodecProperties(videoCodecType4, false)));
        }
        return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
    }
}

