/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Bundle;
import android.view.Surface;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.webrtc.BitrateAdjuster;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;
import org.webrtc.EglBase$_CC;
import org.webrtc.EglBase14;
import org.webrtc.EncodedImage;
import org.webrtc.GlRectDrawer;
import org.webrtc.Logging;
import org.webrtc.MediaCodecWrapper;
import org.webrtc.MediaCodecWrapperFactory;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoder$_CC;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc.YuvHelper;
import org.webrtc._$;

@TargetApi(value=19)
class HardwareVideoEncoder
implements VideoEncoder {
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final String KEY_BITRATE_MODE = "bitrate-mode";
    private static final int MAX_ENCODER_Q_SIZE = 2;
    private static final int MAX_VIDEO_FRAMERATE = 30;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final String TAG = "HardwareVideoEncoder";
    private static final int VIDEO_AVC_LEVEL_3 = 256;
    private static final int VIDEO_AVC_PROFILE_HIGH = 8;
    private static final int VIDEO_ControlRateConstant = 2;
    private int adjustedBitrate;
    private boolean automaticResizeOn;
    private final BitrateAdjuster bitrateAdjuster;
    private VideoEncoder.Callback callback;
    private MediaCodecWrapper codec;
    private final String codecName;
    private final VideoCodecType codecType;
    private ByteBuffer configBuffer;
    private final ThreadUtils.ThreadChecker encodeThreadChecker;
    private final long forcedKeyFrameNs;
    private int height;
    private final int keyFrameIntervalSec;
    private long lastKeyFrameNs;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private ByteBuffer[] outputBuffers;
    private final BusyCount outputBuffersBusyCount;
    private final BlockingDeque<EncodedImage.Builder> outputBuilders;
    private Thread outputThread;
    private final ThreadUtils.ThreadChecker outputThreadChecker;
    private final Map<String, String> params;
    private volatile boolean running;
    private final EglBase14.Context sharedContext;
    private volatile Exception shutdownException;
    private final Integer surfaceColorFormat;
    private final GlRectDrawer textureDrawer = new GlRectDrawer();
    private EglBase14 textureEglBase;
    private Surface textureInputSurface;
    private boolean useSurfaceMode;
    private final VideoFrameDrawer videoFrameDrawer = new VideoFrameDrawer();
    private int width;
    private final Integer yuvColorFormat;
    private final YuvFormat yuvFormat;

    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String string2, VideoCodecType videoCodecType, Integer n2, Integer n3, Map<String, String> map, int n4, int n5, BitrateAdjuster bitrateAdjuster, EglBase14.Context context) {
        this.outputBuilders = new LinkedBlockingDeque<EncodedImage.Builder>();
        this.encodeThreadChecker = new ThreadUtils.ThreadChecker();
        this.outputThreadChecker = new ThreadUtils.ThreadChecker();
        this.outputBuffersBusyCount = new BusyCount();
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = string2;
        this.codecType = videoCodecType;
        this.surfaceColorFormat = n2;
        this.yuvColorFormat = n3;
        this.yuvFormat = YuvFormat.valueOf(n3);
        this.params = map;
        this.keyFrameIntervalSec = n4;
        this.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(n5);
        this.bitrateAdjuster = bitrateAdjuster;
        this.sharedContext = context;
        this.encodeThreadChecker.detachThread();
    }

    private boolean canUseSurface() {
        boolean bl = this.sharedContext != null && this.surfaceColorFormat != null;
        return bl;
    }

    private Thread createOutputThread() {
        return new Thread(){

            @Override
            public void run() {
                while (HardwareVideoEncoder.this.running) {
                    HardwareVideoEncoder.this.deliverEncodedImage();
                }
                HardwareVideoEncoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    private VideoCodecStatus encodeByteBuffer(VideoFrame object, VideoFrame.Buffer buffer, int n2) {
        int n3;
        long l3;
        block6: {
            this.encodeThreadChecker.checkIsOnValidThread();
            l3 = (((VideoFrame)object).getTimestampNs() + 500L) / 1000L;
            try {
                n3 = this.codec.dequeueInputBuffer(0L);
                if (n3 != -1) break block6;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
                return VideoCodecStatus.ERROR;
            }
            Logging.d(TAG, "Dropped frame, no input buffers available");
            return VideoCodecStatus.NO_OUTPUT;
        }
        try {
            object = this.codec.getInputBuffers()[n3];
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "getInputBuffers failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        this.fillInputBuffer((ByteBuffer)object, buffer);
        try {
            this.codec.queueInputBuffer(n3, 0, n2, l3, 0);
            return VideoCodecStatus.OK;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
    }

    private VideoCodecStatus encodeTextureBuffer(VideoFrame videoFrame) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            GLES20.glClear((int)16384);
            VideoFrame videoFrame2 = new VideoFrame(videoFrame.getBuffer(), 0, videoFrame.getTimestampNs());
            this.videoFrameDrawer.drawFrame(videoFrame2, this.textureDrawer, null);
            this.textureEglBase.swapBuffers(videoFrame.getTimestampNs());
            return VideoCodecStatus.OK;
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeTexture failed", runtimeException);
            return VideoCodecStatus.ERROR;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VideoCodecStatus initEncodeInternal() {
        Object object;
        this.encodeThreadChecker.checkIsOnValidThread();
        this.lastKeyFrameNs = -1L;
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
            object = this.useSurfaceMode ? this.surfaceColorFormat : this.yuvColorFormat;
        }
        catch (IOException | IllegalArgumentException exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot create media encoder ");
            stringBuilder.append(this.codecName);
            Logging.e(TAG, stringBuilder.toString());
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        int n2 = (Integer)object;
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)this.width, (int)this.height);
            mediaFormat.setInteger("bitrate", this.adjustedBitrate);
            mediaFormat.setInteger(KEY_BITRATE_MODE, 2);
            mediaFormat.setInteger("color-format", n2);
            mediaFormat.setInteger("frame-rate", this.bitrateAdjuster.getCodecConfigFramerate());
            mediaFormat.setInteger("i-frame-interval", this.keyFrameIntervalSec);
            if (this.codecType == VideoCodecType.H264) {
                CharSequence charSequence = this.params.get("profile-level-id");
                object = charSequence;
                if (charSequence == null) {
                    object = "42e01f";
                }
                n2 = -1;
                int n3 = ((String)object).hashCode();
                if (n3 != 1537948542) {
                    if (n3 == 1595523974 && ((String)object).equals("640c1f")) {
                        n2 = 0;
                    }
                } else if (((String)object).equals("42e01f")) {
                    n2 = 1;
                }
                if (n2 != 0) {
                    if (n2 != 1) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("Unknown profile level id: ");
                        ((StringBuilder)charSequence).append((String)object);
                        Logging.w(TAG, ((StringBuilder)charSequence).toString());
                    }
                } else {
                    mediaFormat.setInteger("profile", 8);
                    mediaFormat.setInteger("level", 256);
                }
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Format: ");
            ((StringBuilder)object).append(mediaFormat);
            Logging.d(TAG, ((StringBuilder)object).toString());
            this.codec.configure(mediaFormat, null, null, 1);
            if (this.useSurfaceMode) {
                this.textureEglBase = EglBase$_CC.createEgl14(this.sharedContext, EglBase.CONFIG_RECORDABLE);
                object = this.codec.createInputSurface();
                this.textureInputSurface = object;
                this.textureEglBase.createSurface((Surface)object);
                this.textureEglBase.makeCurrent();
            }
            this.codec.start();
            this.outputBuffers = this.codec.getOutputBuffers();
            this.running = true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initEncodeInternal failed", illegalStateException);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.outputThreadChecker.detachThread();
        this.outputThread = object = this.createOutputThread();
        ((Thread)object).start();
        return VideoCodecStatus.OK;
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        this.outputBuffersBusyCount.waitForZero();
        try {
            this.codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder stop failed", exception);
        }
        try {
            this.codec.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder release failed", exception);
            this.shutdownException = exception;
        }
        this.configBuffer = null;
        Logging.d(TAG, "Release on output thread done");
    }

    private void requestKeyFrame(long l3) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("request-sync", 0);
            this.codec.setParameters(bundle);
            this.lastKeyFrameNs = l3;
            return;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "requestKeyFrame failed", illegalStateException);
            return;
        }
    }

    private VideoCodecStatus resetCodec(int n2, int n3, boolean bl) {
        this.encodeThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = this.release();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        this.width = n2;
        this.height = n3;
        this.useSurfaceMode = bl;
        return this.initEncodeInternal();
    }

    private boolean shouldForceKeyFrame(long l3) {
        this.encodeThreadChecker.checkIsOnValidThread();
        long l4 = this.forcedKeyFrameNs;
        boolean bl = l4 > 0L && l3 > this.lastKeyFrameNs + l4;
        return bl;
    }

    private VideoCodecStatus updateBitrate() {
        this.outputThreadChecker.checkIsOnValidThread();
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        try {
            Object object = new Bundle();
            object.putInt("video-bitrate", this.adjustedBitrate);
            this.codec.setParameters((Bundle)object);
            object = VideoCodecStatus.OK;
            return object;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "updateBitrate failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
    }

    @Override
    @CalledByNative
    public /* synthetic */ long createNativeVideoEncoder() {
        return VideoEncoder$_CC.$default$createNativeVideoEncoder(this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deliverEncodedImage() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            void var3_7;
            Object object;
            Object object2 = new MediaCodec.BufferInfo();
            int n2 = this.codec.dequeueOutputBuffer((MediaCodec.BufferInfo)object2, 100000L);
            if (n2 < 0) {
                if (n2 != -3) return;
                this.outputBuffersBusyCount.waitForZero();
                this.outputBuffers = this.codec.getOutputBuffers();
                return;
            }
            ByteBuffer byteBuffer = this.outputBuffers[n2];
            byteBuffer.position(((MediaCodec.BufferInfo)object2).offset);
            byteBuffer.limit(((MediaCodec.BufferInfo)object2).offset + ((MediaCodec.BufferInfo)object2).size);
            if ((((MediaCodec.BufferInfo)object2).flags & 2) != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Config frame generated. Offset: ");
                stringBuilder.append(((MediaCodec.BufferInfo)object2).offset);
                stringBuilder.append(". Size: ");
                stringBuilder.append(((MediaCodec.BufferInfo)object2).size);
                Logging.d(TAG, stringBuilder.toString());
                object2 = ByteBuffer.allocateDirect(((MediaCodec.BufferInfo)object2).size);
                this.configBuffer = object2;
                ((ByteBuffer)object2).put(byteBuffer);
                return;
            }
            this.bitrateAdjuster.reportEncodedFrame(((MediaCodec.BufferInfo)object2).size);
            if (this.adjustedBitrate != this.bitrateAdjuster.getAdjustedBitrateBps()) {
                this.updateBitrate();
            }
            int n3 = ((MediaCodec.BufferInfo)object2).flags;
            boolean bl = true;
            if ((n3 & 1) == 0) {
                bl = false;
            }
            if (bl) {
                Logging.d(TAG, "Sync frame generated");
            }
            if (bl && this.codecType == VideoCodecType.H264) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Prepending config frame of size ");
                ((StringBuilder)object).append(this.configBuffer.capacity());
                ((StringBuilder)object).append(" to output buffer with offset ");
                ((StringBuilder)object).append(((MediaCodec.BufferInfo)object2).offset);
                ((StringBuilder)object).append(", size ");
                ((StringBuilder)object).append(((MediaCodec.BufferInfo)object2).size);
                Logging.d(TAG, ((StringBuilder)object).toString());
                object2 = ByteBuffer.allocateDirect(((MediaCodec.BufferInfo)object2).size + this.configBuffer.capacity());
                this.configBuffer.rewind();
                ((ByteBuffer)object2).put(this.configBuffer);
                ((ByteBuffer)object2).put(byteBuffer);
                ((ByteBuffer)object2).rewind();
            } else {
                object2 = byteBuffer.slice();
            }
            if (bl) {
                EncodedImage.FrameType frameType = EncodedImage.FrameType.VideoFrameKey;
            } else {
                EncodedImage.FrameType frameType = EncodedImage.FrameType.VideoFrameDelta;
            }
            this.outputBuffersBusyCount.increment();
            EncodedImage.Builder builder = this.outputBuilders.poll();
            object = new _$.Lambda.HardwareVideoEncoder.F5M8yR9Mkg8WzwHcYIIOdTEImls(this, n2);
            object2 = builder.setBuffer((ByteBuffer)object2, (Runnable)object).setFrameType((EncodedImage.FrameType)var3_7).createEncodedImage();
            object = this.callback;
            VideoEncoder.CodecSpecificInfo codecSpecificInfo = new VideoEncoder.CodecSpecificInfo();
            object.onEncodedFrame((EncodedImage)object2, codecSpecificInfo);
            ((EncodedImage)object2).release();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "deliverOutput failed", illegalStateException);
        }
    }

    @Override
    public VideoCodecStatus encode(VideoFrame object, VideoEncoder.EncodeInfo object2) {
        int n2;
        VideoCodecStatus videoCodecStatus;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.codec == null) {
            return VideoCodecStatus.UNINITIALIZED;
        }
        VideoFrame.Buffer buffer = object.getBuffer();
        boolean bl = buffer instanceof VideoFrame.TextureBuffer;
        int n3 = object.getBuffer().getWidth();
        int n4 = object.getBuffer().getHeight();
        boolean bl2 = this.canUseSurface();
        bl2 = bl2 && bl;
        if ((n3 != this.width || n4 != this.height || bl2 != this.useSurfaceMode) && (videoCodecStatus = this.resetCodec(n3, n4, bl2)) != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        if (this.outputBuilders.size() > 2) {
            Logging.e(TAG, "Dropped frame, encoder queue full");
            return VideoCodecStatus.NO_OUTPUT;
        }
        object2 = object2.frameTypes;
        n3 = ((EncodedImage.FrameType[])object2).length;
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (object2[n2] != EncodedImage.FrameType.VideoFrameKey) continue;
            n4 = 1;
        }
        if (n4 != 0 || this.shouldForceKeyFrame(object.getTimestampNs())) {
            this.requestKeyFrame(object.getTimestampNs());
        }
        n2 = buffer.getHeight() * buffer.getWidth() * 3 / 2;
        object2 = EncodedImage.builder().setCaptureTimeNs(object.getTimestampNs()).setCompleteFrame(true).setEncodedWidth(object.getBuffer().getWidth()).setEncodedHeight(object.getBuffer().getHeight()).setRotation(object.getRotation());
        this.outputBuilders.offer((EncodedImage.Builder)object2);
        object = this.useSurfaceMode ? this.encodeTextureBuffer((VideoFrame)object) : this.encodeByteBuffer((VideoFrame)object, buffer, n2);
        if (object != VideoCodecStatus.OK) {
            this.outputBuilders.pollLast();
        }
        return object;
    }

    protected void fillInputBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
        this.yuvFormat.fillBuffer(byteBuffer, buffer);
    }

    @Override
    public String getImplementationName() {
        return "HWEncoder";
    }

    @Override
    @CalledByNative
    public /* synthetic */ VideoEncoder.ResolutionBitrateLimits[] getResolutionBitrateLimits() {
        return VideoEncoder$_CC.$default$getResolutionBitrateLimits(this);
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.automaticResizeOn) {
            VideoCodecType videoCodecType = this.codecType;
            if (videoCodecType == VideoCodecType.VP8) {
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (videoCodecType == VideoCodecType.H264) {
                return new VideoEncoder.ScalingSettings(24, 37);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback object) {
        int n2;
        this.encodeThreadChecker.checkIsOnValidThread();
        this.callback = object;
        this.automaticResizeOn = settings.automaticResizeOn;
        this.width = settings.width;
        this.height = settings.height;
        this.useSurfaceMode = this.canUseSurface();
        int n3 = settings.startBitrate;
        if (n3 != 0 && (n2 = settings.maxFramerate) != 0) {
            this.bitrateAdjuster.setTargets(n3 * 1000, n2);
        }
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        object = new StringBuilder();
        ((StringBuilder)object).append("initEncode: ");
        ((StringBuilder)object).append(this.width);
        ((StringBuilder)object).append(" x ");
        ((StringBuilder)object).append(this.height);
        ((StringBuilder)object).append(". @ ");
        ((StringBuilder)object).append(settings.startBitrate);
        ((StringBuilder)object).append("kbps. Fps: ");
        ((StringBuilder)object).append(settings.maxFramerate);
        ((StringBuilder)object).append(" Use surface mode: ");
        ((StringBuilder)object).append(this.useSurfaceMode);
        Logging.d(TAG, ((StringBuilder)object).toString());
        return this.initEncodeInternal();
    }

    @Override
    @CalledByNative
    public /* synthetic */ boolean isHardwareEncoder() {
        return VideoEncoder$_CC.$default$isHardwareEncoder(this);
    }

    public /* synthetic */ void lambda$deliverEncodedImage$0$HardwareVideoEncoder(int n2) {
        try {
            this.codec.releaseOutputBuffer(n2, false);
        }
        catch (Exception exception) {
            Logging.e(TAG, "releaseOutputBuffer failed", exception);
        }
        this.outputBuffersBusyCount.decrement();
    }

    @Override
    public VideoCodecStatus release() {
        VideoCodecStatus videoCodecStatus;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.outputThread == null) {
            videoCodecStatus = VideoCodecStatus.OK;
        } else {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                videoCodecStatus = VideoCodecStatus.TIMEOUT;
            } else if (this.shutdownException != null) {
                Logging.e(TAG, "Media encoder release exception", this.shutdownException);
                videoCodecStatus = VideoCodecStatus.ERROR;
            } else {
                videoCodecStatus = VideoCodecStatus.OK;
            }
        }
        this.textureDrawer.release();
        this.videoFrameDrawer.release();
        EglBase14 eglBase14 = this.textureEglBase;
        if (eglBase14 != null) {
            eglBase14.release();
            this.textureEglBase = null;
        }
        if ((eglBase14 = this.textureInputSurface) != null) {
            eglBase14.release();
            this.textureInputSurface = null;
        }
        this.outputBuilders.clear();
        this.codec = null;
        this.outputBuffers = null;
        this.outputThread = null;
        this.encodeThreadChecker.detachThread();
        return videoCodecStatus;
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int n2) {
        this.encodeThreadChecker.checkIsOnValidThread();
        int n3 = n2;
        if (n2 > 30) {
            n3 = 30;
        }
        this.bitrateAdjuster.setTargets(bitrateAllocation.getSum(), n3);
        return VideoCodecStatus.OK;
    }

    private static class BusyCount {
        private int count;
        private final Object countLock = new Object();

        private BusyCount() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void decrement() {
            Object object = this.countLock;
            synchronized (object) {
                int n2;
                this.count = n2 = this.count - 1;
                if (n2 == 0) {
                    this.countLock.notifyAll();
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void increment() {
            Object object = this.countLock;
            synchronized (object) {
                ++this.count;
                return;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void waitForZero() {
            Object object = this.countLock;
            synchronized (object) {
                boolean bl = false;
                while (true) {
                    int n2;
                    if ((n2 = this.count) <= 0) {
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 6, 7] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                        if (!bl) return;
                        Thread.currentThread().interrupt();
                        return;
                    }
                    try {
                        this.countLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Logging.e(HardwareVideoEncoder.TAG, "Interrupted while waiting on busy count", interruptedException);
                        bl = true;
                    }
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
    }

    private static abstract class YuvFormat
    extends Enum<YuvFormat> {
        private static final /* synthetic */ YuvFormat[] $VALUES;
        public static final /* enum */ YuvFormat I420;
        public static final /* enum */ YuvFormat NV12;

        static {
            YuvFormat yuvFormat;
            I420 = new YuvFormat(){

                @Override
                void fillBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
                    buffer = buffer.toI420();
                    YuvHelper.I420Copy(buffer.getDataY(), buffer.getStrideY(), buffer.getDataU(), buffer.getStrideU(), buffer.getDataV(), buffer.getStrideV(), byteBuffer, buffer.getWidth(), buffer.getHeight());
                    buffer.release();
                }
            };
            NV12 = yuvFormat = new YuvFormat(){

                @Override
                void fillBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
                    buffer = buffer.toI420();
                    YuvHelper.I420ToNV12(buffer.getDataY(), buffer.getStrideY(), buffer.getDataU(), buffer.getStrideU(), buffer.getDataV(), buffer.getStrideV(), byteBuffer, buffer.getWidth(), buffer.getHeight());
                    buffer.release();
                }
            };
            $VALUES = new YuvFormat[]{I420, yuvFormat};
        }

        static YuvFormat valueOf(int n2) {
            if (n2 != 19) {
                if (n2 != 21 && n2 != 2141391872 && n2 != 2141391876) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unsupported colorFormat: ");
                    stringBuilder.append(n2);
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
                return NV12;
            }
            return I420;
        }

        public static YuvFormat valueOf(String string2) {
            return Enum.valueOf(YuvFormat.class, string2);
        }

        public static YuvFormat[] values() {
            return (YuvFormat[])$VALUES.clone();
        }

        abstract void fillBuffer(ByteBuffer var1, VideoFrame.Buffer var2);
    }
}

