/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GlUtil {
    private GlUtil() {
    }

    public static void checkNoGLES2Error(String object) {
        int n2 = GLES20.glGetError();
        if (n2 != 0) {
            if (n2 == 1285) {
                object = new GlOutOfMemoryException((String)object);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)object);
                stringBuilder.append(": GLES20 error: ");
                stringBuilder.append(n2);
                object = new RuntimeException(stringBuilder.toString());
            }
            throw object;
        }
    }

    public static FloatBuffer createFloatBuffer(float[] fArray) {
        Buffer buffer = ByteBuffer.allocateDirect(fArray.length * 4);
        ((ByteBuffer)buffer).order(ByteOrder.nativeOrder());
        buffer = ((ByteBuffer)buffer).asFloatBuffer();
        ((FloatBuffer)buffer).put(fArray);
        ((FloatBuffer)buffer).position(0);
        return buffer;
    }

    public static int generateTexture(int n2) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        int n3 = nArray[0];
        GLES20.glBindTexture((int)n2, (int)n3);
        GLES20.glTexParameterf((int)n2, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)n2, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)n2, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)n2, (int)10243, (float)33071.0f);
        GlUtil.checkNoGLES2Error("generateTexture");
        return n3;
    }

    public static class GlOutOfMemoryException
    extends RuntimeException {
        public GlOutOfMemoryException(String string2) {
            super(string2);
        }
    }
}

