/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import org.webrtc.GlUtil;

public class GlTextureFrameBuffer {
    private int frameBufferId;
    private int height;
    private final int pixelFormat;
    private int textureId;
    private int width;

    public GlTextureFrameBuffer(int n2) {
        switch (n2) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Invalid pixel format: ");
                stringBuilder.append(n2);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            case 6407: 
            case 6408: 
            case 6409: 
        }
        this.pixelFormat = n2;
        this.width = 0;
        this.height = 0;
    }

    public int getFrameBufferId() {
        return this.frameBufferId;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public int getWidth() {
        return this.width;
    }

    public void release() {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.textureId}, (int)0);
        this.textureId = 0;
        GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.frameBufferId}, (int)0);
        this.frameBufferId = 0;
        this.width = 0;
        this.height = 0;
    }

    public void setSize(int n2, int n3) {
        if (n2 > 0 && n3 > 0) {
            Object object;
            if (n2 == this.width && n3 == this.height) {
                return;
            }
            this.width = n2;
            this.height = n3;
            if (this.textureId == 0) {
                this.textureId = GlUtil.generateTexture(3553);
            }
            if (this.frameBufferId == 0) {
                object = new int[1];
                GLES20.glGenFramebuffers((int)1, (int[])object, (int)0);
                this.frameBufferId = object[0];
            }
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.textureId);
            int n4 = this.pixelFormat;
            GLES20.glTexImage2D((int)3553, (int)0, (int)n4, (int)n2, (int)n3, (int)0, (int)n4, (int)5121, null);
            GLES20.glBindTexture((int)3553, (int)0);
            GlUtil.checkNoGLES2Error("GlTextureFrameBuffer setSize");
            GLES20.glBindFramebuffer((int)36160, (int)this.frameBufferId);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.textureId, (int)0);
            n2 = GLES20.glCheckFramebufferStatus((int)36160);
            if (n2 == 36053) {
                GLES20.glBindFramebuffer((int)36160, (int)0);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Framebuffer not complete, status: ");
            ((StringBuilder)object).append(n2);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid size: ");
        stringBuilder.append(n2);
        stringBuilder.append("x");
        stringBuilder.append(n3);
        throw new IllegalArgumentException(stringBuilder.toString());
    }
}

