/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.webrtc.GlUtil;
import org.webrtc.Logging;

public class GlShader {
    private static final String TAG = "GlShader";
    private int program;

    public GlShader(String object, String string2) {
        int n2;
        int n3 = GlShader.compileShader(35633, (String)object);
        int n4 = GlShader.compileShader(35632, string2);
        this.program = n2 = GLES20.glCreateProgram();
        if (n2 != 0) {
            GLES20.glAttachShader((int)n2, (int)n3);
            GLES20.glAttachShader((int)this.program, (int)n4);
            GLES20.glLinkProgram((int)this.program);
            object = new int[1];
            object[0] = false;
            GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])object, (int)0);
            if (object[0] == true) {
                GLES20.glDeleteShader((int)n3);
                GLES20.glDeleteShader((int)n4);
                GlUtil.checkNoGLES2Error("Creating GlShader");
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Could not link program: ");
            ((StringBuilder)object).append(GLES20.glGetProgramInfoLog((int)this.program));
            Logging.e(TAG, ((StringBuilder)object).toString());
            throw new RuntimeException(GLES20.glGetProgramInfoLog((int)this.program));
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("glCreateProgram() failed. GLES20 error: ");
        ((StringBuilder)object).append(GLES20.glGetError());
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    private static int compileShader(int n2, String charSequence) {
        if ((n2 = GLES20.glCreateShader((int)n2)) != 0) {
            GLES20.glShaderSource((int)n2, (String)charSequence);
            GLES20.glCompileShader((int)n2);
            Object object = new int[]{0};
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])object, (int)0);
            if (object[0] == 1) {
                GlUtil.checkNoGLES2Error("compileShader");
                return n2;
            }
            object = new StringBuilder();
            object.append("Compile error ");
            object.append(GLES20.glGetShaderInfoLog((int)n2));
            object.append(" in shader:\n");
            object.append((String)charSequence);
            Logging.e(TAG, object.toString());
            throw new RuntimeException(GLES20.glGetShaderInfoLog((int)n2));
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("glCreateShader() failed. GLES20 error: ");
        ((StringBuilder)charSequence).append(GLES20.glGetError());
        throw new RuntimeException(((StringBuilder)charSequence).toString());
    }

    public int getAttribLocation(String string2) {
        int n2 = this.program;
        if (n2 != -1) {
            if ((n2 = GLES20.glGetAttribLocation((int)n2, (String)string2)) >= 0) {
                return n2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not locate '");
            stringBuilder.append(string2);
            stringBuilder.append("' in program");
            throw new RuntimeException(stringBuilder.toString());
        }
        throw new RuntimeException("The program has been released");
    }

    public int getUniformLocation(String string2) {
        int n2 = this.program;
        if (n2 != -1) {
            if ((n2 = GLES20.glGetUniformLocation((int)n2, (String)string2)) >= 0) {
                return n2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not locate uniform '");
            stringBuilder.append(string2);
            stringBuilder.append("' in program");
            throw new RuntimeException(stringBuilder.toString());
        }
        throw new RuntimeException("The program has been released");
    }

    public void release() {
        Logging.d(TAG, "Deleting shader.");
        int n2 = this.program;
        if (n2 != -1) {
            GLES20.glDeleteProgram((int)n2);
            this.program = -1;
        }
    }

    public void setVertexAttribArray(String string2, int n2, int n3, FloatBuffer floatBuffer) {
        if (this.program != -1) {
            int n4 = this.getAttribLocation(string2);
            GLES20.glEnableVertexAttribArray((int)n4);
            GLES20.glVertexAttribPointer((int)n4, (int)n2, (int)5126, (boolean)false, (int)n3, (Buffer)floatBuffer);
            GlUtil.checkNoGLES2Error("setVertexAttribArray");
            return;
        }
        throw new RuntimeException("The program has been released");
    }

    public void setVertexAttribArray(String string2, int n2, FloatBuffer floatBuffer) {
        this.setVertexAttribArray(string2, n2, 0, floatBuffer);
    }

    public void useProgram() {
        int n2 = this.program;
        if (n2 != -1) {
            GLES20.glUseProgram((int)n2);
            GlUtil.checkNoGLES2Error("glUseProgram");
            return;
        }
        throw new RuntimeException("The program has been released");
    }
}

