/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.webrtc.GlShader;
import org.webrtc.GlUtil;
import org.webrtc.RendererCommon;

class GlGenericDrawer
implements RendererCommon.GlDrawer {
    private static final String DEFAULT_VERTEX_SHADER_STRING = "varying vec2 tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\nuniform mat4 tex_mat;\nvoid main() {\n  gl_Position = in_pos;\n  tc = (tex_mat * in_tc).xy;\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUFFER = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEXTURE_BUFFER = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private static final String INPUT_TEXTURE_COORDINATE_NAME = "in_tc";
    private static final String INPUT_VERTEX_COORDINATE_NAME = "in_pos";
    private static final String TEXTURE_MATRIX_NAME = "tex_mat";
    private GlShader currentShader;
    private ShaderType currentShaderType;
    private final String genericFragmentSource;
    private int inPosLocation;
    private int inTcLocation;
    private final ShaderCallbacks shaderCallbacks;
    private int texMatrixLocation;
    private final String vertexShader;

    public GlGenericDrawer(String string2, String string3, ShaderCallbacks shaderCallbacks) {
        this.vertexShader = string2;
        this.genericFragmentSource = string3;
        this.shaderCallbacks = shaderCallbacks;
    }

    public GlGenericDrawer(String string2, ShaderCallbacks shaderCallbacks) {
        this(DEFAULT_VERTEX_SHADER_STRING, string2, shaderCallbacks);
    }

    static String createFragmentShaderString(String string2, ShaderType object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object == ShaderType.OES) {
            stringBuilder.append("#extension GL_OES_EGL_image_external : require\n");
        }
        stringBuilder.append("precision mediump float;\n");
        stringBuilder.append("varying vec2 tc;\n");
        if (object == ShaderType.YUV) {
            stringBuilder.append("uniform sampler2D y_tex;\n");
            stringBuilder.append("uniform sampler2D u_tex;\n");
            stringBuilder.append("uniform sampler2D v_tex;\n");
            stringBuilder.append("vec4 sample(vec2 p) {\n");
            stringBuilder.append("  float y = texture2D(y_tex, p).r * 1.16438;\n");
            stringBuilder.append("  float u = texture2D(u_tex, p).r;\n");
            stringBuilder.append("  float v = texture2D(v_tex, p).r;\n");
            stringBuilder.append("  return vec4(y + 1.59603 * v - 0.874202,\n");
            stringBuilder.append("    y - 0.391762 * u - 0.812968 * v + 0.531668,\n");
            stringBuilder.append("    y + 2.01723 * u - 1.08563, 1);\n");
            stringBuilder.append("}\n");
            stringBuilder.append(string2);
        } else {
            object = object == ShaderType.OES ? "samplerExternalOES" : "sampler2D";
            stringBuilder.append("uniform ");
            stringBuilder.append((String)object);
            stringBuilder.append(" tex;\n");
            stringBuilder.append(string2.replace("sample(", "texture2D(tex, "));
        }
        return stringBuilder.toString();
    }

    private void prepareShader(ShaderType object, float[] fArray, int n2, int n3, int n4, int n5) {
        if (((Enum)object).equals((Object)this.currentShaderType)) {
            object = this.currentShader;
        } else {
            this.currentShaderType = object;
            GlShader glShader = this.currentShader;
            if (glShader != null) {
                glShader.release();
            }
            this.currentShader = glShader = this.createShader((ShaderType)((Object)object));
            glShader.useProgram();
            if (object == ShaderType.YUV) {
                GLES20.glUniform1i((int)glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)glShader.getUniformLocation("v_tex"), (int)2);
            } else {
                GLES20.glUniform1i((int)glShader.getUniformLocation("tex"), (int)0);
            }
            GlUtil.checkNoGLES2Error("Create shader");
            this.shaderCallbacks.onNewShader(glShader);
            this.texMatrixLocation = glShader.getUniformLocation(TEXTURE_MATRIX_NAME);
            this.inPosLocation = glShader.getAttribLocation(INPUT_VERTEX_COORDINATE_NAME);
            this.inTcLocation = glShader.getAttribLocation(INPUT_TEXTURE_COORDINATE_NAME);
            object = glShader;
        }
        ((GlShader)object).useProgram();
        GLES20.glEnableVertexAttribArray((int)this.inPosLocation);
        GLES20.glVertexAttribPointer((int)this.inPosLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_BUFFER);
        GLES20.glEnableVertexAttribArray((int)this.inTcLocation);
        GLES20.glVertexAttribPointer((int)this.inTcLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_TEXTURE_BUFFER);
        GLES20.glUniformMatrix4fv((int)this.texMatrixLocation, (int)1, (boolean)false, (float[])fArray, (int)0);
        this.shaderCallbacks.onPrepareShader((GlShader)object, fArray, n2, n3, n4, n5);
        GlUtil.checkNoGLES2Error("Prepare shader");
    }

    GlShader createShader(ShaderType shaderType) {
        return new GlShader(this.vertexShader, GlGenericDrawer.createFragmentShaderString(this.genericFragmentSource, shaderType));
    }

    @Override
    public void drawOes(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.prepareShader(ShaderType.OES, fArray, n3, n4, n7, n8);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n2);
        GLES20.glViewport((int)n5, (int)n6, (int)n7, (int)n8);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    @Override
    public void drawRgb(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.prepareShader(ShaderType.RGB, fArray, n3, n4, n7, n8);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        GLES20.glViewport((int)n5, (int)n6, (int)n7, (int)n8);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] nArray, float[] fArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.prepareShader(ShaderType.YUV, fArray, n2, n3, n6, n7);
        for (n2 = 0; n2 < 3; ++n2) {
            GLES20.glActiveTexture((int)(33984 + n2));
            GLES20.glBindTexture((int)3553, (int)nArray[n2]);
        }
        GLES20.glViewport((int)n4, (int)n5, (int)n6, (int)n7);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        for (n2 = 0; n2 < 3; ++n2) {
            GLES20.glActiveTexture((int)(n2 + 33984));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void release() {
        GlShader glShader = this.currentShader;
        if (glShader != null) {
            glShader.release();
            this.currentShader = null;
            this.currentShaderType = null;
        }
    }

    public static interface ShaderCallbacks {
        public void onNewShader(GlShader var1);

        public void onPrepareShader(GlShader var1, float[] var2, int var3, int var4, int var5, int var6);
    }

    public static final class ShaderType
    extends Enum<ShaderType> {
        private static final /* synthetic */ ShaderType[] $VALUES;
        public static final /* enum */ ShaderType OES;
        public static final /* enum */ ShaderType RGB;
        public static final /* enum */ ShaderType YUV;

        static {
            ShaderType shaderType;
            OES = new ShaderType();
            RGB = new ShaderType();
            YUV = shaderType = new ShaderType();
            $VALUES = new ShaderType[]{OES, RGB, shaderType};
        }

        public static ShaderType valueOf(String string2) {
            return Enum.valueOf(ShaderType.class, string2);
        }

        public static ShaderType[] values() {
            return (ShaderType[])$VALUES.clone();
        }
    }
}

