/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.SystemClock;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.webrtc.CapturerObserver;
import org.webrtc.JavaI420Buffer;
import org.webrtc.Logging;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;

public class FileVideoCapturer
implements VideoCapturer {
    private static final String TAG = "FileVideoCapturer";
    private CapturerObserver capturerObserver;
    private final TimerTask tickTask;
    private final Timer timer = new Timer();
    private final VideoReader videoReader;

    public FileVideoCapturer(String string2) throws IOException {
        this.tickTask = new TimerTask(){

            @Override
            public void run() {
                FileVideoCapturer.this.tick();
            }
        };
        try {
            VideoReaderY4M videoReaderY4M = new VideoReaderY4M(string2);
            this.videoReader = videoReaderY4M;
            return;
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not open video file: ");
            stringBuilder.append(string2);
            Logging.d(TAG, stringBuilder.toString());
            throw iOException;
        }
    }

    @Override
    public void changeCaptureFormat(int n2, int n3, int n4) {
    }

    @Override
    public void dispose() {
        this.videoReader.close();
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    @Override
    public void startCapture(int n2, int n3, int n4) {
        this.timer.schedule(this.tickTask, 0L, (long)(1000 / n4));
    }

    @Override
    public void stopCapture() throws InterruptedException {
        this.timer.cancel();
    }

    public void tick() {
        VideoFrame videoFrame = this.videoReader.getNextFrame();
        this.capturerObserver.onFrameCaptured(videoFrame);
        videoFrame.release();
    }

    private static interface VideoReader {
        public void close();

        public VideoFrame getNextFrame();
    }

    private static class VideoReaderY4M
    implements VideoReader {
        private static final int FRAME_DELIMETER_LENGTH = 6;
        private static final String TAG = "VideoReaderY4M";
        private static final String Y4M_FRAME_DELIMETER = "FRAME";
        private final int frameHeight;
        private final int frameWidth;
        private final RandomAccessFile mediaFile;
        private final FileChannel mediaFileChannel;
        private final long videoStart;

        public VideoReaderY4M(String object) throws IOException {
            int n2;
            Object object2 = new RandomAccessFile((String)object, "r");
            this.mediaFile = object2;
            this.mediaFileChannel = ((RandomAccessFile)object2).getChannel();
            object2 = new StringBuilder();
            while ((n2 = this.mediaFile.read()) != -1) {
                if (n2 == 10) {
                    this.videoStart = this.mediaFileChannel.position();
                    object2 = ((StringBuilder)object2).toString().split("[ ]");
                    int n3 = ((String[])object2).length;
                    object = "";
                    int n4 = 0;
                    n2 = 0;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        String string2 = object2[i3];
                        char c3 = string2.charAt(0);
                        if (c3 != 'C') {
                            if (c3 != 'H') {
                                if (c3 != 'W') continue;
                                n4 = Integer.parseInt(string2.substring(1));
                                continue;
                            }
                            n2 = Integer.parseInt(string2.substring(1));
                            continue;
                        }
                        object = string2.substring(1);
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Color space: ");
                    ((StringBuilder)object2).append((String)object);
                    Logging.d(TAG, ((StringBuilder)object2).toString());
                    if (!((String)object).equals("420") && !((String)object).equals("420mpeg2")) {
                        throw new IllegalArgumentException("Does not support any other color space than I420 or I420mpeg2");
                    }
                    if (n4 % 2 != 1 && n2 % 2 != 1) {
                        this.frameWidth = n4;
                        this.frameHeight = n2;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("frame dim: (");
                        ((StringBuilder)object).append(n4);
                        ((StringBuilder)object).append(", ");
                        ((StringBuilder)object).append(n2);
                        ((StringBuilder)object).append(")");
                        Logging.d(TAG, ((StringBuilder)object).toString());
                        return;
                    }
                    throw new IllegalArgumentException("Does not support odd width or height");
                }
                ((StringBuilder)object2).append((char)n2);
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Found end of file before end of header for file: ");
            ((StringBuilder)object2).append((String)object);
            object = new RuntimeException(((StringBuilder)object2).toString());
            throw object;
        }

        @Override
        public void close() {
            try {
                this.mediaFile.close();
            }
            catch (IOException iOException) {
                Logging.e(TAG, "Problem closing file", iOException);
            }
        }

        @Override
        public VideoFrame getNextFrame() {
            String string2;
            Comparable<ByteBuffer> comparable;
            Object object;
            block5: {
                long l3 = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                object = JavaI420Buffer.allocate(this.frameWidth, this.frameHeight);
                comparable = ((JavaI420Buffer)object).getDataY();
                ByteBuffer byteBuffer = ((JavaI420Buffer)object).getDataU();
                ByteBuffer byteBuffer2 = ((JavaI420Buffer)object).getDataV();
                int n2 = (this.frameHeight + 1) / 2;
                ((JavaI420Buffer)object).getStrideY();
                ((JavaI420Buffer)object).getStrideU();
                ((JavaI420Buffer)object).getStrideV();
                try {
                    ByteBuffer byteBuffer3 = ByteBuffer.allocate(FRAME_DELIMETER_LENGTH);
                    if (this.mediaFileChannel.read(byteBuffer3) < FRAME_DELIMETER_LENGTH) {
                        this.mediaFileChannel.position(this.videoStart);
                        if (this.mediaFileChannel.read(byteBuffer3) < FRAME_DELIMETER_LENGTH) {
                            RuntimeException runtimeException = new RuntimeException("Error looping video");
                            throw runtimeException;
                        }
                    }
                    if (!(string2 = new String(byteBuffer3.array(), Charset.forName("US-ASCII"))).equals("FRAME\n")) break block5;
                    this.mediaFileChannel.read((ByteBuffer)comparable);
                    this.mediaFileChannel.read(byteBuffer);
                    this.mediaFileChannel.read(byteBuffer2);
                    return new VideoFrame((VideoFrame.Buffer)object, 0, l3);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            comparable = new Comparable<ByteBuffer>();
            ((StringBuilder)comparable).append("Frames should be delimited by FRAME plus newline, found delimter was: '");
            ((StringBuilder)comparable).append(string2);
            ((StringBuilder)comparable).append("'");
            object = new RuntimeException(((StringBuilder)comparable).toString());
            throw object;
        }
    }
}

