/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.webrtc.CalledByNative;
import org.webrtc.RefCountDelegate;
import org.webrtc.RefCounted;

public class EncodedImage
implements RefCounted {
    public final ByteBuffer buffer;
    public final long captureTimeMs;
    public final long captureTimeNs;
    public final boolean completeFrame;
    public final int encodedHeight;
    public final int encodedWidth;
    public final FrameType frameType;
    public final Integer qp;
    private final RefCountDelegate refCountDelegate;
    public final int rotation;

    @CalledByNative
    private EncodedImage(ByteBuffer byteBuffer, Runnable runnable, int n2, int n3, long l3, FrameType frameType, int n4, boolean bl, Integer n5) {
        this.buffer = byteBuffer;
        this.encodedWidth = n2;
        this.encodedHeight = n3;
        this.captureTimeMs = TimeUnit.NANOSECONDS.toMillis(l3);
        this.captureTimeNs = l3;
        this.frameType = frameType;
        this.rotation = n4;
        this.completeFrame = bl;
        this.qp = n5;
        this.refCountDelegate = new RefCountDelegate(runnable);
    }

    public static Builder builder() {
        return new Builder();
    }

    @CalledByNative
    private ByteBuffer getBuffer() {
        return this.buffer;
    }

    @CalledByNative
    private long getCaptureTimeNs() {
        return this.captureTimeNs;
    }

    @CalledByNative
    private boolean getCompleteFrame() {
        return this.completeFrame;
    }

    @CalledByNative
    private int getEncodedHeight() {
        return this.encodedHeight;
    }

    @CalledByNative
    private int getEncodedWidth() {
        return this.encodedWidth;
    }

    @CalledByNative
    private int getFrameType() {
        return this.frameType.getNative();
    }

    @CalledByNative
    private Integer getQp() {
        return this.qp;
    }

    @CalledByNative
    private int getRotation() {
        return this.rotation;
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    public static class Builder {
        private ByteBuffer buffer;
        private long captureTimeNs;
        private boolean completeFrame;
        private int encodedHeight;
        private int encodedWidth;
        private FrameType frameType;
        private Integer qp;
        private Runnable releaseCallback;
        private int rotation;

        private Builder() {
        }

        public EncodedImage createEncodedImage() {
            return new EncodedImage(this.buffer, this.releaseCallback, this.encodedWidth, this.encodedHeight, this.captureTimeNs, this.frameType, this.rotation, this.completeFrame, this.qp);
        }

        public Builder setBuffer(ByteBuffer byteBuffer, Runnable runnable) {
            this.buffer = byteBuffer;
            this.releaseCallback = runnable;
            return this;
        }

        @Deprecated
        public Builder setCaptureTimeMs(long l3) {
            this.captureTimeNs = TimeUnit.MILLISECONDS.toNanos(l3);
            return this;
        }

        public Builder setCaptureTimeNs(long l3) {
            this.captureTimeNs = l3;
            return this;
        }

        public Builder setCompleteFrame(boolean bl) {
            this.completeFrame = bl;
            return this;
        }

        public Builder setEncodedHeight(int n2) {
            this.encodedHeight = n2;
            return this;
        }

        public Builder setEncodedWidth(int n2) {
            this.encodedWidth = n2;
            return this;
        }

        public Builder setFrameType(FrameType frameType) {
            this.frameType = frameType;
            return this;
        }

        public Builder setQp(Integer n2) {
            this.qp = n2;
            return this;
        }

        public Builder setRotation(int n2) {
            this.rotation = n2;
            return this;
        }
    }

    public static final class FrameType
    extends Enum<FrameType> {
        private static final /* synthetic */ FrameType[] $VALUES;
        public static final /* enum */ FrameType EmptyFrame;
        public static final /* enum */ FrameType VideoFrameDelta;
        public static final /* enum */ FrameType VideoFrameKey;
        private final int nativeIndex;

        static {
            FrameType frameType;
            EmptyFrame = new FrameType(0);
            VideoFrameKey = new FrameType(3);
            VideoFrameDelta = frameType = new FrameType(4);
            $VALUES = new FrameType[]{EmptyFrame, VideoFrameKey, frameType};
        }

        private FrameType(int n3) {
            this.nativeIndex = n3;
        }

        @CalledByNative(value="FrameType")
        static FrameType fromNativeIndex(int n2) {
            for (FrameType frameType : FrameType.values()) {
                if (frameType.getNative() != n2) continue;
                return frameType;
            }
            Object object = new StringBuilder();
            ((StringBuilder)object).append("Unknown native frame type: ");
            ((StringBuilder)object).append(n2);
            object = new IllegalArgumentException(((StringBuilder)object).toString());
            throw object;
        }

        public static FrameType valueOf(String string2) {
            return Enum.valueOf(FrameType.class, string2);
        }

        public static FrameType[] values() {
            return (FrameType[])$VALUES.clone();
        }

        public int getNative() {
            return this.nativeIndex;
        }
    }
}

