/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.webrtc.EglBase;
import org.webrtc.EglBase$_CC;
import org.webrtc.GlTextureFrameBuffer;
import org.webrtc.GlUtil;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc.VideoSink;
import org.webrtc._$;

public class EglRenderer
implements VideoSink {
    private static final long LOG_INTERVAL_SEC = 4L;
    private static final String TAG = "EglRenderer";
    private final GlTextureFrameBuffer bitmapTextureFramebuffer;
    private final Matrix drawMatrix;
    private RendererCommon.GlDrawer drawer;
    private EglBase eglBase;
    private final EglSurfaceCreation eglSurfaceCreationRunnable;
    private volatile ErrorCallback errorCallback;
    private final Object fpsReductionLock;
    private final VideoFrameDrawer frameDrawer;
    private final ArrayList<FrameListenerAndParams> frameListeners;
    private final Object frameLock;
    private int framesDropped;
    private int framesReceived;
    private int framesRendered;
    private final Object handlerLock = new Object();
    private float layoutAspectRatio;
    private final Object layoutLock;
    private final Runnable logStatisticsRunnable;
    private long minRenderPeriodNs;
    private boolean mirrorHorizontally;
    private boolean mirrorVertically;
    protected final String name;
    private long nextFrameTimeNs;
    private VideoFrame pendingFrame;
    private long renderSwapBufferTimeNs;
    private Handler renderThreadHandler;
    private long renderTimeNs;
    private final Object statisticsLock;
    private long statisticsStartTimeNs;
    private boolean usePresentationTimeStamp;

    public EglRenderer(String string2) {
        this(string2, new VideoFrameDrawer());
    }

    public EglRenderer(String string2, VideoFrameDrawer videoFrameDrawer) {
        this.frameListeners = new ArrayList();
        this.fpsReductionLock = new Object();
        this.drawMatrix = new Matrix();
        this.frameLock = new Object();
        this.layoutLock = new Object();
        this.statisticsLock = new Object();
        this.bitmapTextureFramebuffer = new GlTextureFrameBuffer(6408);
        this.logStatisticsRunnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                EglRenderer.this.logStatistics();
                Object object = EglRenderer.this.handlerLock;
                synchronized (object) {
                    if (EglRenderer.this.renderThreadHandler != null) {
                        EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                        EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                    }
                    return;
                }
            }
        };
        this.eglSurfaceCreationRunnable = new EglSurfaceCreation();
        this.name = string2;
        this.frameDrawer = videoFrameDrawer;
    }

    static /* synthetic */ Handler access$302(EglRenderer eglRenderer, Handler handler) {
        eglRenderer.renderThreadHandler = handler;
        return handler;
    }

    private String averageTimeAsString(long l3, int n2) {
        CharSequence charSequence;
        if (n2 <= 0) {
            charSequence = "NA";
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(TimeUnit.NANOSECONDS.toMicros(l3 / (long)n2));
            ((StringBuilder)charSequence).append(" us");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    private void clearSurfaceOnRenderThread(float f3, float f4, float f5, float f6) {
        EglBase eglBase = this.eglBase;
        if (eglBase != null && eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)f3, (float)f4, (float)f5, (float)f6);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    private void createEglSurfaceInternal(Object object) {
        this.eglSurfaceCreationRunnable.setSurface(object);
        this.postToRenderThread(this.eglSurfaceCreationRunnable);
    }

    public static /* synthetic */ void lambda$vWDJEj1GWjHSjwoQQjEEK_IVOJE(EglRenderer eglRenderer) {
        eglRenderer.renderFrameOnRenderThread();
    }

    private void logD(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(string2);
        Logging.d(TAG, stringBuilder.toString());
    }

    private void logE(String string2, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(string2);
        Logging.e(TAG, stringBuilder.toString(), throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logStatistics() {
        DecimalFormat decimalFormat = new DecimalFormat("#.0");
        long l3 = System.nanoTime();
        Object object = this.statisticsLock;
        synchronized (object) {
            long l4 = l3 - this.statisticsStartTimeNs;
            if (l4 > 0L && (this.minRenderPeriodNs != Long.MAX_VALUE || this.framesReceived != 0)) {
                float f3 = (float)((long)this.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)l4;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Duration: ");
                stringBuilder.append(TimeUnit.NANOSECONDS.toMillis(l4));
                stringBuilder.append(" ms. Frames received: ");
                stringBuilder.append(this.framesReceived);
                stringBuilder.append(". Dropped: ");
                stringBuilder.append(this.framesDropped);
                stringBuilder.append(". Rendered: ");
                stringBuilder.append(this.framesRendered);
                stringBuilder.append(". Render fps: ");
                stringBuilder.append(decimalFormat.format(f3));
                stringBuilder.append(". Average render time: ");
                stringBuilder.append(this.averageTimeAsString(this.renderTimeNs, this.framesRendered));
                stringBuilder.append(". Average swapBuffer time: ");
                stringBuilder.append(this.averageTimeAsString(this.renderSwapBufferTimeNs, this.framesRendered));
                stringBuilder.append(".");
                this.logD(stringBuilder.toString());
                this.resetStatistics(l3);
                return;
            }
            return;
        }
    }

    private void logW(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(string2);
        Logging.w(TAG, stringBuilder.toString());
    }

    private void notifyCallbacks(VideoFrame videoFrame, boolean bl) {
        if (this.frameListeners.isEmpty()) {
            return;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        Object object = this.drawMatrix;
        float f3 = this.mirrorHorizontally ? -1.0f : 1.0f;
        float f4 = this.mirrorVertically ? -1.0f : 1.0f;
        object.preScale(f3, f4);
        this.drawMatrix.preScale(1.0f, -1.0f);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        Iterator<FrameListenerAndParams> iterator = this.frameListeners.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!bl && object.applyFpsReduction) continue;
            iterator.remove();
            int n2 = (int)(object.scale * (float)videoFrame.getRotatedWidth());
            int n3 = (int)(object.scale * (float)videoFrame.getRotatedHeight());
            if (n2 != 0 && n3 != 0) {
                this.bitmapTextureFramebuffer.setSize(n2, n3);
                GLES20.glBindFramebuffer((int)36160, (int)this.bitmapTextureFramebuffer.getFrameBufferId());
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.bitmapTextureFramebuffer.getTextureId(), (int)0);
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GLES20.glClear((int)16384);
                this.frameDrawer.drawFrame(videoFrame, object.drawer, this.drawMatrix, 0, 0, n2, n3);
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 * n3 * 4);
                GLES20.glViewport((int)0, (int)0, (int)n2, (int)n3);
                GLES20.glReadPixels((int)0, (int)0, (int)n2, (int)n3, (int)6408, (int)5121, (Buffer)byteBuffer);
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
                Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap2.copyPixelsFromBuffer((Buffer)byteBuffer);
                object.listener.onFrame(bitmap2);
                continue;
            }
            object.listener.onFrame(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postToRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderFrameOnRenderThread() {
        block32: {
            block33: {
                block34: {
                    var1_1 = this.frameLock;
                    synchronized (var1_1) {
                        if (this.pendingFrame == null) {
                            return;
                        }
                        var2_5 = this.pendingFrame;
                        this.pendingFrame = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 10] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                        var1_1 = this.eglBase;
                        if (var1_1 == null || !var1_1.hasSurface()) break block32;
                        var1_1 = this.fpsReductionLock;
                        {
                            catch (Throwable var2_6) {}
                            {
                                throw var2_6;
                            }
                        }
                    }
                    synchronized (var1_1) {
                        if (this.minRenderPeriodNs == 0x7FFFFFFFFFFFFFFFL) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                var3_8 = false;
                                break;
                            }
                        } else if (this.minRenderPeriodNs <= 0L) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                var3_8 = true;
                                break;
                            }
                        } else {
                            var4_7 = System.nanoTime();
                            if (var4_7 < this.nextFrameTimeNs) {
                                this.logD("Skipping frame rendering - fps reduction is active.");
                                ** continue;
                            }
                            this.nextFrameTimeNs = var6_9 = this.nextFrameTimeNs + this.minRenderPeriodNs;
                            this.nextFrameTimeNs = Math.max(var6_9, var4_7);
                            ** continue;
                        }
                    }
                    var8_10 = System.nanoTime();
                    var10_11 = (float)var2_5.getRotatedWidth() / (float)var2_5.getRotatedHeight();
                    var1_1 = this.layoutLock;
                    synchronized (var1_1) {
                        var11_12 = this.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : var10_11;
                    }
                    var12_13 = 1.0f;
                    if (var10_11 > var11_12) {
                        var10_11 = var11_12 / var10_11;
                        var11_12 = 1.0f;
                    } else {
                        var11_12 = var10_11 / var11_12;
                        var10_11 = 1.0f;
                    }
                    this.drawMatrix.reset();
                    this.drawMatrix.preTranslate(0.5f, 0.5f);
                    var1_1 = this.drawMatrix;
                    var13_14 = this.mirrorHorizontally != false ? -1.0f : 1.0f;
                    if (this.mirrorVertically) {
                        var12_13 = -1.0f;
                    }
                    var1_1.preScale(var13_14, var12_13);
                    this.drawMatrix.preScale(var10_11, var11_12);
                    this.drawMatrix.preTranslate(-0.5f, -0.5f);
                    if (var3_8) {
                        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                        GLES20.glClear((int)16384);
                        this.frameDrawer.drawFrame(var2_5, this.drawer, this.drawMatrix, 0, 0, this.eglBase.surfaceWidth(), this.eglBase.surfaceHeight());
                        var4_7 = System.nanoTime();
                        if (this.usePresentationTimeStamp) {
                            this.eglBase.swapBuffers(var2_5.getTimestampNs());
                        } else {
                            this.eglBase.swapBuffers();
                        }
                        var6_9 = System.nanoTime();
                        var1_1 = this.statisticsLock;
                        synchronized (var1_1) {
                            ++this.framesRendered;
                            this.renderTimeNs += var6_9 - var8_10;
                            this.renderSwapBufferTimeNs += var6_9 - var4_7;
                        }
                        {
                            catch (Throwable var1_2) {
                                break block33;
                            }
                            catch (GlUtil.GlOutOfMemoryException var1_3) {}
                            {
                                this.logE("Error while drawing frame", var1_3);
                                var1_4 = this.errorCallback;
                                if (var1_4 != null) {
                                    var1_4.onGlOutOfMemory();
                                }
                                this.drawer.release();
                                this.frameDrawer.release();
                                this.bitmapTextureFramebuffer.release();
                                break block34;
                            }
                        }
                    }
                    this.notifyCallbacks(var2_5, var3_8);
                }
                var2_5.release();
                return;
            }
            var2_5.release();
            throw var1_2;
        }
        this.logD("Dropping frame - No surface");
        var2_5.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetStatistics(long l3) {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.statisticsStartTimeNs = l3;
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.renderTimeNs = 0L;
            this.renderSwapBufferTimeNs = 0L;
            return;
        }
    }

    public void addFrameListener(FrameListener frameListener, float f3) {
        this.addFrameListener(frameListener, f3, null, false);
    }

    public void addFrameListener(FrameListener frameListener, float f3, RendererCommon.GlDrawer glDrawer) {
        this.addFrameListener(frameListener, f3, glDrawer, false);
    }

    public void addFrameListener(FrameListener frameListener, float f3, RendererCommon.GlDrawer glDrawer, boolean bl) {
        this.postToRenderThread((Runnable)new _$.Lambda.EglRenderer.RQnwmlnL5c18V7FwaqbMl6FsQRo(this, glDrawer, frameListener, f3, bl));
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearImage(float f3, float f4, float f5, float f6) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            Handler handler = this.renderThreadHandler;
            _$.Lambda.EglRenderer.rAPTAEHKQxRxBFU3vvHmF68TV5E rAPTAEHKQxRxBFU3vvHmF68TV5E2 = new _$.Lambda.EglRenderer.rAPTAEHKQxRxBFU3vvHmF68TV5E(this, f3, f4, f5, f6);
            handler.postAtFrontOfQueue((Runnable)rAPTAEHKQxRxBFU3vvHmF68TV5E2);
            return;
        }
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.init(context, nArray, glDrawer, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(EglBase.Context object, int[] object2, RendererCommon.GlDrawer object3, boolean bl) {
        Object object4 = this.handlerLock;
        synchronized (object4) {
            if (this.renderThreadHandler == null) {
                this.logD("Initializing EglRenderer");
                this.drawer = object3;
                this.usePresentationTimeStamp = bl;
                object3 = new StringBuilder();
                ((StringBuilder)object3).append(this.name);
                ((StringBuilder)object3).append(TAG);
                HandlerThread handlerThread = new HandlerThread(((StringBuilder)object3).toString());
                handlerThread.start();
                handlerThread = handlerThread.getLooper();
                Runnable runnable = new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        Object object = EglRenderer.this.handlerLock;
                        synchronized (object) {
                            EglRenderer.access$302(EglRenderer.this, null);
                            return;
                        }
                    }
                };
                object3 = new HandlerWithExceptionCallback((Looper)handlerThread, runnable);
                this.renderThreadHandler = object3;
                handlerThread = new _$.Lambda.EglRenderer.A5MPsBufyTiKpmjvPS46Dr9iaHs(this, (EglBase.Context)object, (int[])object2);
                ThreadUtils.invokeAtFrontUninterruptibly((Handler)object3, (Runnable)handlerThread);
                this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
                this.resetStatistics(System.nanoTime());
                this.renderThreadHandler.postDelayed(this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                return;
            }
            object2 = new StringBuilder;
            ((StringBuilder)object2)();
            ((StringBuilder)object2).append(this.name);
            ((StringBuilder)object2).append("Already initialized");
            object = new IllegalStateException(((StringBuilder)object2).toString());
            throw object;
        }
    }

    public /* synthetic */ void lambda$addFrameListener$3$EglRenderer(RendererCommon.GlDrawer glDrawer, FrameListener frameListener, float f3, boolean bl) {
        RendererCommon.GlDrawer glDrawer2 = glDrawer;
        if (glDrawer == null) {
            glDrawer2 = this.drawer;
        }
        this.frameListeners.add(new FrameListenerAndParams(frameListener, f3, glDrawer2, bl));
    }

    public /* synthetic */ void lambda$clearImage$6$EglRenderer(float f3, float f4, float f5, float f6) {
        this.clearSurfaceOnRenderThread(f3, f4, f5, f6);
    }

    public /* synthetic */ void lambda$init$0$EglRenderer(EglBase.Context context, int[] nArray) {
        if (context == null) {
            this.logD("EglBase10.create context");
            this.eglBase = EglBase$_CC.createEgl10(nArray);
        } else {
            this.logD("EglBase.create shared context");
            this.eglBase = EglBase$_CC.create(context, nArray);
        }
    }

    public /* synthetic */ void lambda$release$1$EglRenderer(CountDownLatch countDownLatch) {
        GLES20.glUseProgram((int)0);
        RendererCommon.GlDrawer glDrawer = this.drawer;
        if (glDrawer != null) {
            glDrawer.release();
            this.drawer = null;
        }
        this.frameDrawer.release();
        this.bitmapTextureFramebuffer.release();
        if (this.eglBase != null) {
            this.logD("eglBase detach and release.");
            this.eglBase.detachCurrent();
            this.eglBase.release();
            this.eglBase = null;
        }
        this.frameListeners.clear();
        countDownLatch.countDown();
    }

    public /* synthetic */ void lambda$release$2$EglRenderer(Looper looper) {
        this.logD("Quitting render thread.");
        looper.quit();
    }

    public /* synthetic */ void lambda$releaseEglSurface$5$EglRenderer(Runnable runnable) {
        EglBase eglBase = this.eglBase;
        if (eglBase != null) {
            eglBase.detachCurrent();
            this.eglBase.releaseSurface();
        }
        runnable.run();
    }

    public /* synthetic */ void lambda$removeFrameListener$4$EglRenderer(CountDownLatch object, FrameListener frameListener) {
        ((CountDownLatch)object).countDown();
        object = this.frameListeners.iterator();
        while (object.hasNext()) {
            if (((FrameListenerAndParams)object.next()).listener != frameListener) continue;
            object.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onFrame(VideoFrame object) {
        boolean bl;
        Object object2 = this.statisticsLock;
        synchronized (object2) {
            ++this.framesReceived;
        }
        object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            Object object3 = this.frameLock;
            synchronized (object3) {
                bl = this.pendingFrame != null;
                if (bl) {
                    this.pendingFrame.release();
                }
                this.pendingFrame = object;
                ((VideoFrame)object).retain();
                object = this.renderThreadHandler;
                _$.Lambda.EglRenderer.vWDJEj1GWjHSjwoQQjEEK_IVOJE vWDJEj1GWjHSjwoQQjEEK_IVOJE2 = new _$.Lambda.EglRenderer.vWDJEj1GWjHSjwoQQjEEK_IVOJE(this);
                object.post((Runnable)vWDJEj1GWjHSjwoQQjEEK_IVOJE2);
            }
        }
        if (!bl) return;
        object = this.statisticsLock;
        synchronized (object) {
            ++this.framesDropped;
            return;
        }
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void printStackTrace() {
        Object object = this.handlerLock;
        synchronized (object) {
            StackTraceElement[] stackTraceElementArray = this.renderThreadHandler == null ? null : this.renderThreadHandler.getLooper().getThread();
            if (stackTraceElementArray == null || (stackTraceElementArray = stackTraceElementArray.getStackTrace()).length <= 0) return;
            this.logW("EglRenderer stack trace:");
            int n2 = stackTraceElementArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                this.logW(stackTraceElementArray[i3].toString());
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        this.logD("Releasing.");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            Handler handler = this.renderThreadHandler;
            _$.Lambda.EglRenderer.MFF8Cl7oJsgEmXm7UI2GkKtNTYY mFF8Cl7oJsgEmXm7UI2GkKtNTYY = new _$.Lambda.EglRenderer.MFF8Cl7oJsgEmXm7UI2GkKtNTYY(this, countDownLatch);
            handler.postAtFrontOfQueue((Runnable)mFF8Cl7oJsgEmXm7UI2GkKtNTYY);
            handler = this.renderThreadHandler.getLooper();
            Handler handler2 = this.renderThreadHandler;
            mFF8Cl7oJsgEmXm7UI2GkKtNTYY = new _$.Lambda.EglRenderer.0TOf6TQvvPy5g4d42QjmzelnDZI(this, (Looper)handler);
            handler2.post((Runnable)mFF8Cl7oJsgEmXm7UI2GkKtNTYY);
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                this.pendingFrame.release();
                this.pendingFrame = null;
            }
        }
        this.logD("Releasing done.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseEglSurface(Runnable runnable) {
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                Handler handler = this.renderThreadHandler;
                _$.Lambda.EglRenderer.ZLNzG80KHUk0Ad58984FOsNt9s8 zLNzG80KHUk0Ad58984FOsNt9s8 = new _$.Lambda.EglRenderer.ZLNzG80KHUk0Ad58984FOsNt9s8(this, runnable);
                handler.postAtFrontOfQueue((Runnable)zLNzG80KHUk0Ad58984FOsNt9s8);
                return;
            }
        }
        runnable.run();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFrameListener(FrameListener object) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() != this.renderThreadHandler.getLooper().getThread()) {
                _$.Lambda.EglRenderer.6uTxCXz4FQA7p26IUV3iP2Ty5gk uTxCXz4FQA7p26IUV3iP2Ty5gk = new _$.Lambda.EglRenderer.6uTxCXz4FQA7p26IUV3iP2Ty5gk(this, countDownLatch, (FrameListener)object);
                this.postToRenderThread((Runnable)uTxCXz4FQA7p26IUV3iP2Ty5gk);
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                ThreadUtils.awaitUninterruptibly(countDownLatch);
                return;
            }
            object = new RuntimeException("removeFrameListener must not be called on the render thread.");
            throw object;
        }
    }

    public void setErrorCallback(ErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFpsReduction(float f3) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("setFpsReduction: ");
        ((StringBuilder)object).append(f3);
        this.logD(((StringBuilder)object).toString());
        object = this.fpsReductionLock;
        synchronized (object) {
            long l3 = this.minRenderPeriodNs;
            this.minRenderPeriodNs = f3 <= 0.0f ? Long.MAX_VALUE : (long)((float)TimeUnit.SECONDS.toNanos(1L) / f3);
            if (this.minRenderPeriodNs != l3) {
                this.nextFrameTimeNs = System.nanoTime();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLayoutAspectRatio(float f3) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("setLayoutAspectRatio: ");
        ((StringBuilder)object).append(f3);
        this.logD(((StringBuilder)object).toString());
        object = this.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = f3;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMirror(boolean bl) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("setMirrorHorizontally: ");
        ((StringBuilder)object).append(bl);
        this.logD(((StringBuilder)object).toString());
        object = this.layoutLock;
        synchronized (object) {
            this.mirrorHorizontally = bl;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMirrorVertically(boolean bl) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("setMirrorVertically: ");
        ((StringBuilder)object).append(bl);
        this.logD(((StringBuilder)object).toString());
        object = this.layoutLock;
        synchronized (object) {
            this.mirrorVertically = bl;
            return;
        }
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        @Override
        public void run() {
            synchronized (this) {
                if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                    if (this.surface instanceof Surface) {
                        EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                    } else {
                        if (!(this.surface instanceof SurfaceTexture)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Invalid surface: ");
                            stringBuilder.append(this.surface);
                            IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
                            throw illegalStateException;
                        }
                        EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                    }
                    EglRenderer.this.eglBase.makeCurrent();
                    GLES20.glPixelStorei((int)3317, (int)1);
                }
                return;
            }
        }

        public void setSurface(Object object) {
            synchronized (this) {
                this.surface = object;
                return;
            }
        }
    }

    public static interface ErrorCallback {
        public void onGlOutOfMemory();
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }

    private static class FrameListenerAndParams {
        public final boolean applyFpsReduction;
        public final RendererCommon.GlDrawer drawer;
        public final FrameListener listener;
        public final float scale;

        public FrameListenerAndParams(FrameListener frameListener, float f3, RendererCommon.GlDrawer glDrawer, boolean bl) {
            this.listener = frameListener;
            this.scale = f3;
            this.drawer = glDrawer;
            this.applyFpsReduction = bl;
        }
    }

    private static class HandlerWithExceptionCallback
    extends Handler {
        private final Runnable exceptionCallback;

        public HandlerWithExceptionCallback(Looper looper, Runnable runnable) {
            super(looper);
            this.exceptionCallback = runnable;
        }

        public void dispatchMessage(Message message) {
            try {
                super.dispatchMessage(message);
                return;
            }
            catch (Exception exception) {
                Logging.e(EglRenderer.TAG, "Exception on EglRenderer thread", exception);
                this.exceptionCallback.run();
                throw exception;
            }
        }
    }
}

