/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.view.Surface;
import org.webrtc.EglBase;
import org.webrtc.EglBase$_CC;
import org.webrtc.EglBase14;
import org.webrtc.Logging;

@TargetApi(value=18)
class EglBase14Impl
implements EglBase14 {
    private static final int CURRENT_SDK_VERSION = Build.VERSION.SDK_INT;
    private static final int EGLExt_SDK_VERSION = 18;
    private static final String TAG = "EglBase14Impl";
    private EGLConfig eglConfig;
    private EGLContext eglContext;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface = EGL14.EGL_NO_SURFACE;

    public EglBase14Impl(EGLContext eGLContext, int[] object) {
        EGLDisplay eGLDisplay;
        this.eglDisplay = eGLDisplay = EglBase14Impl.getEglDisplay();
        this.eglConfig = EglBase14Impl.getEglConfig(eGLDisplay, (int[])object);
        int n2 = EglBase$_CC.getOpenGlesVersionFromConfig((int[])object);
        object = new StringBuilder();
        ((StringBuilder)object).append("Using OpenGL ES version ");
        ((StringBuilder)object).append(n2);
        Logging.d(TAG, ((StringBuilder)object).toString());
        this.eglContext = EglBase14Impl.createEglContext(eGLContext, this.eglDisplay, this.eglConfig, n2);
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay != EGL14.EGL_NO_DISPLAY && this.eglContext != EGL14.EGL_NO_CONTEXT && this.eglConfig != null) {
            return;
        }
        throw new RuntimeException("This object has been released");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static EGLContext createEglContext(EGLContext object, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2) {
        if (object != null) {
            if (object == EGL14.EGL_NO_CONTEXT) throw new RuntimeException("Invalid sharedContext");
        }
        Object object2 = object;
        if (object == null) {
            object2 = EGL14.EGL_NO_CONTEXT;
        }
        object = EglBase.lock;
        // MONITORENTER : object
        eGLDisplay = EGL14.eglCreateContext((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (EGLContext)object2, (int[])new int[]{12440, n2, 12344}, (int)0);
        // MONITOREXIT : object
        if (eGLDisplay != EGL14.EGL_NO_CONTEXT) {
            return eGLDisplay;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Failed to create EGL context: 0x");
        ((StringBuilder)object).append(Integer.toHexString(EGL14.eglGetError()));
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof Surface) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a Surface or SurfaceTexture");
        }
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            object = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (Object)object, (int[])new int[]{12344}, (int)0);
            this.eglSurface = object;
            if (object != EGL14.EGL_NO_SURFACE) {
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Failed to create window surface: 0x");
            ((StringBuilder)object).append(Integer.toHexString(EGL14.eglGetError()));
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    private static EGLConfig getEglConfig(EGLDisplay object, int[] nArray) {
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[1];
        if (EGL14.eglChooseConfig((EGLDisplay)object, (int[])nArray, (int)0, (EGLConfig[])eGLConfigArray, (int)0, (int)1, (int[])nArray2, (int)0)) {
            if (nArray2[0] > 0) {
                object = eGLConfigArray[0];
                if (object != null) {
                    return object;
                }
                throw new RuntimeException("eglChooseConfig returned null");
            }
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("eglChooseConfig failed: 0x");
        ((StringBuilder)object).append(Integer.toHexString(EGL14.eglGetError()));
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    private static EGLDisplay getEglDisplay() {
        Object object = EGL14.eglGetDisplay((int)0);
        if (object != EGL14.EGL_NO_DISPLAY) {
            int[] nArray = new int[2];
            if (EGL14.eglInitialize((EGLDisplay)object, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
                return object;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unable to initialize EGL14: 0x");
            ((StringBuilder)object).append(Integer.toHexString(EGL14.eglGetError()));
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unable to get EGL14 display: 0x");
        ((StringBuilder)object).append(Integer.toHexString(EGL14.eglGetError()));
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    public static boolean isEGL14Supported() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SDK version: ");
        stringBuilder.append(CURRENT_SDK_VERSION);
        stringBuilder.append(". isEGL14Supported: ");
        int n2 = CURRENT_SDK_VERSION;
        boolean bl = true;
        boolean bl2 = n2 >= 18;
        stringBuilder.append(bl2);
        Logging.d(TAG, stringBuilder.toString());
        bl2 = CURRENT_SDK_VERSION >= 18 ? bl : false;
        return bl2;
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n2, int n3) {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            Object object = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (int[])new int[]{12375, n2, 12374, n3, 12344}, (int)0);
            this.eglSurface = object;
            if (object != EGL14.EGL_NO_SURFACE) {
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Failed to create pixel buffer surface with size ");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append("x");
            ((StringBuilder)object).append(n3);
            ((StringBuilder)object).append(": 0x");
            ((StringBuilder)object).append(Integer.toHexString(EGL14.eglGetError()));
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    @Override
    public void createSurface(Surface surface) {
        this.createSurfaceInternal(surface);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void detachCurrent() {
        Object object = EglBase.lock;
        synchronized (object) {
            if (EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("eglDetachCurrent failed: 0x");
            stringBuilder.append(Integer.toHexString(EGL14.eglGetError()));
            RuntimeException runtimeException = new RuntimeException(stringBuilder.toString());
            throw runtimeException;
        }
    }

    @Override
    public Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        boolean bl = this.eglSurface != EGL14.EGL_NO_SURFACE;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void makeCurrent() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't make current");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            if (EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("eglMakeCurrent failed: 0x");
            stringBuilder.append(Integer.toHexString(EGL14.eglGetError()));
            RuntimeException runtimeException = new RuntimeException(stringBuilder.toString());
            throw runtimeException;
        }
    }

    @Override
    public void release() {
        this.checkIsNotReleased();
        this.releaseSurface();
        this.detachCurrent();
        EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
        EGL14.eglReleaseThread();
        EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
        this.eglContext = EGL14.EGL_NO_CONTEXT;
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        this.eglConfig = null;
    }

    @Override
    public void releaseSurface() {
        EGLSurface eGLSurface = this.eglSurface;
        if (eGLSurface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)eGLSurface);
            this.eglSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12374, (int[])nArray, (int)0);
        return nArray[0];
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12375, (int[])nArray, (int)0);
        return nArray[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void swapBuffers() {
        this.checkIsNotReleased();
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            Object object = EglBase.lock;
            synchronized (object) {
                EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void swapBuffers(long l3) {
        this.checkIsNotReleased();
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            Object object = EglBase.lock;
            synchronized (object) {
                EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (long)l3);
                EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    public static class Context
    implements EglBase14.Context {
        private final EGLContext egl14Context;

        public Context(EGLContext eGLContext) {
            this.egl14Context = eGLContext;
        }

        @Override
        @TargetApi(value=21)
        public long getNativeEglContext() {
            long l3 = CURRENT_SDK_VERSION >= 21 ? this.egl14Context.getNativeHandle() : (long)this.egl14Context.getHandle();
            return l3;
        }

        @Override
        public EGLContext getRawContext() {
            return this.egl14Context;
        }
    }
}

