/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import org.webrtc.EglBase;
import org.webrtc.EglBase$_CC;
import org.webrtc.EglBase10;
import org.webrtc.Logging;

class EglBase10Impl
implements EglBase10 {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final String TAG = "EglBase10Impl";
    private final EGL10 egl;
    private EGLConfig eglConfig;
    private EGLContext eglContext;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface = EGL10.EGL_NO_SURFACE;

    public EglBase10Impl(EGLContext eGLContext, int[] object) {
        EGLDisplay eGLDisplay;
        this.egl = (EGL10)EGLContext.getEGL();
        this.eglDisplay = eGLDisplay = this.getEglDisplay();
        this.eglConfig = this.getEglConfig(eGLDisplay, (int[])object);
        int n2 = EglBase$_CC.getOpenGlesVersionFromConfig((int[])object);
        object = new StringBuilder();
        ((StringBuilder)object).append("Using OpenGL ES version ");
        ((StringBuilder)object).append(n2);
        Logging.d(TAG, ((StringBuilder)object).toString());
        this.eglContext = this.createEglContext(eGLContext, this.eglDisplay, this.eglConfig, n2);
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay != EGL10.EGL_NO_DISPLAY && this.eglContext != EGL10.EGL_NO_CONTEXT && this.eglConfig != null) {
            return;
        }
        throw new RuntimeException("This object has been released");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private EGLContext createEglContext(EGLContext object, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2) {
        if (object != null) {
            if (object == EGL10.EGL_NO_CONTEXT) throw new RuntimeException("Invalid sharedContext");
        }
        Object object2 = object;
        if (object == null) {
            object2 = EGL10.EGL_NO_CONTEXT;
        }
        object = EglBase.lock;
        // MONITORENTER : object
        eGLDisplay = this.egl.eglCreateContext(eGLDisplay, eGLConfig, (EGLContext)object2, new int[]{12440, n2, 12344});
        // MONITOREXIT : object
        if (eGLDisplay != EGL10.EGL_NO_CONTEXT) {
            return eGLDisplay;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Failed to create EGL context: 0x");
        ((StringBuilder)object).append(Integer.toHexString(this.egl.eglGetError()));
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof SurfaceHolder) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a SurfaceHolder or SurfaceTexture");
        }
        this.checkIsNotReleased();
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            object = this.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, object, new int[]{12344});
            this.eglSurface = object;
            if (object != EGL10.EGL_NO_SURFACE) {
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Failed to create window surface: 0x");
            ((StringBuilder)object).append(Integer.toHexString(this.egl.eglGetError()));
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    private EGLConfig getEglConfig(EGLDisplay object, int[] nArray) {
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[1];
        if (this.egl.eglChooseConfig((EGLDisplay)object, nArray, eGLConfigArray, 1, nArray2)) {
            if (nArray2[0] > 0) {
                object = eGLConfigArray[0];
                if (object != null) {
                    return object;
                }
                throw new RuntimeException("eglChooseConfig returned null");
            }
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("eglChooseConfig failed: 0x");
        ((StringBuilder)object).append(Integer.toHexString(this.egl.eglGetError()));
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    private EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (eGLDisplay != EGL10.EGL_NO_DISPLAY) {
            Object object = new int[2];
            if (this.egl.eglInitialize(eGLDisplay, object)) {
                return eGLDisplay;
            }
            object = new StringBuilder();
            object.append("Unable to initialize EGL10: 0x");
            object.append(Integer.toHexString(this.egl.eglGetError()));
            throw new RuntimeException(object.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to get EGL10 display: 0x");
        stringBuilder.append(Integer.toHexString(this.egl.eglGetError()));
        throw new RuntimeException(stringBuilder.toString());
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n2, int n3) {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            Object object = this.egl.eglCreatePbufferSurface(this.eglDisplay, this.eglConfig, new int[]{12375, n2, 12374, n3, 12344});
            this.eglSurface = object;
            if (object != EGL10.EGL_NO_SURFACE) {
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Failed to create pixel buffer surface with size ");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append("x");
            ((StringBuilder)object).append(n3);
            ((StringBuilder)object).append(": 0x");
            ((StringBuilder)object).append(Integer.toHexString(this.egl.eglGetError()));
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    @Override
    public void createSurface(Surface surface) {
        this.createSurfaceInternal(new SurfaceHolder(surface){
            private final Surface surface;
            {
                this.surface = surface;
            }

            public void addCallback(SurfaceHolder.Callback callback) {
            }

            public Surface getSurface() {
                return this.surface;
            }

            public Rect getSurfaceFrame() {
                return null;
            }

            public boolean isCreating() {
                return false;
            }

            public Canvas lockCanvas() {
                return null;
            }

            public Canvas lockCanvas(Rect rect) {
                return null;
            }

            public void removeCallback(SurfaceHolder.Callback callback) {
            }

            public void setFixedSize(int n2, int n3) {
            }

            public void setFormat(int n2) {
            }

            public void setKeepScreenOn(boolean bl) {
            }

            public void setSizeFromLayout() {
            }

            @Deprecated
            public void setType(int n2) {
            }

            public void unlockCanvasAndPost(Canvas canvas) {
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void detachCurrent() {
        Object object = EglBase.lock;
        synchronized (object) {
            if (this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("eglDetachCurrent failed: 0x");
            stringBuilder.append(Integer.toHexString(this.egl.eglGetError()));
            RuntimeException runtimeException = new RuntimeException(stringBuilder.toString());
            throw runtimeException;
        }
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        boolean bl = this.eglSurface != EGL10.EGL_NO_SURFACE;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void makeCurrent() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't make current");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            if (this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("eglMakeCurrent failed: 0x");
            stringBuilder.append(Integer.toHexString(this.egl.eglGetError()));
            RuntimeException runtimeException = new RuntimeException(stringBuilder.toString());
            throw runtimeException;
        }
    }

    @Override
    public void release() {
        this.checkIsNotReleased();
        this.releaseSurface();
        this.detachCurrent();
        this.egl.eglDestroyContext(this.eglDisplay, this.eglContext);
        this.egl.eglTerminate(this.eglDisplay);
        this.eglContext = EGL10.EGL_NO_CONTEXT;
        this.eglDisplay = EGL10.EGL_NO_DISPLAY;
        this.eglConfig = null;
    }

    @Override
    public void releaseSurface() {
        EGLSurface eGLSurface = this.eglSurface;
        if (eGLSurface != EGL10.EGL_NO_SURFACE) {
            this.egl.eglDestroySurface(this.eglDisplay, eGLSurface);
            this.eglSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12374, nArray);
        return nArray[0];
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12375, nArray);
        return nArray[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void swapBuffers() {
        this.checkIsNotReleased();
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            Object object = EglBase.lock;
            synchronized (object) {
                this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    @Override
    public void swapBuffers(long l3) {
        this.swapBuffers();
    }

    private static class Context
    implements EglBase10.Context {
        private final EGLContext eglContext;

        public Context(EGLContext eGLContext) {
            this.eglContext = eGLContext;
        }

        @Override
        public long getNativeEglContext() {
            return 0L;
        }

        @Override
        public EGLContext getRawContext() {
            return this.eglContext;
        }
    }
}

