/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import java.util.ArrayList;
import org.webrtc.EglBase$_CC;

public interface EglBase {
    public static final int[] CONFIG_PIXEL_BUFFER;
    public static final int[] CONFIG_PIXEL_RGBA_BUFFER;
    public static final int[] CONFIG_PLAIN;
    public static final int[] CONFIG_RECORDABLE;
    public static final int[] CONFIG_RGBA;
    public static final int EGL_OPENGL_ES2_BIT = 4;
    public static final int EGL_OPENGL_ES3_BIT = 64;
    public static final int EGL_RECORDABLE_ANDROID = 12610;
    public static final Object lock;

    static {
        lock = new Object();
        CONFIG_PLAIN = EglBase$_CC.configBuilder().createConfigAttributes();
        CONFIG_RGBA = EglBase$_CC.configBuilder().setHasAlphaChannel(true).createConfigAttributes();
        CONFIG_PIXEL_BUFFER = EglBase$_CC.configBuilder().setSupportsPixelBuffer(true).createConfigAttributes();
        CONFIG_PIXEL_RGBA_BUFFER = EglBase$_CC.configBuilder().setHasAlphaChannel(true).setSupportsPixelBuffer(true).createConfigAttributes();
        CONFIG_RECORDABLE = EglBase$_CC.configBuilder().setIsRecordable(true).createConfigAttributes();
    }

    public void createDummyPbufferSurface();

    public void createPbufferSurface(int var1, int var2);

    public void createSurface(SurfaceTexture var1);

    public void createSurface(Surface var1);

    public void detachCurrent();

    public Context getEglBaseContext();

    public boolean hasSurface();

    public void makeCurrent();

    public void release();

    public void releaseSurface();

    public int surfaceHeight();

    public int surfaceWidth();

    public void swapBuffers();

    public void swapBuffers(long var1);

    public static class ConfigBuilder {
        private boolean hasAlphaChannel;
        private boolean isRecordable;
        private int openGlesVersion = 2;
        private boolean supportsPixelBuffer;

        public int[] createConfigAttributes() {
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(12324);
            Object object = 8;
            arrayList.add((Integer)object);
            arrayList.add(12323);
            arrayList.add((Integer)object);
            arrayList.add(12322);
            arrayList.add((Integer)object);
            if (this.hasAlphaChannel) {
                arrayList.add(12321);
                arrayList.add((Integer)object);
            }
            if ((n2 = this.openGlesVersion) == 2 || n2 == 3) {
                arrayList.add(12352);
                n2 = this.openGlesVersion == 3 ? 64 : 4;
                arrayList.add(n2);
            }
            if (this.supportsPixelBuffer) {
                arrayList.add(12339);
                arrayList.add(1);
            }
            if (this.isRecordable) {
                arrayList.add(12610);
                arrayList.add(1);
            }
            arrayList.add(12344);
            object = new int[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object[n2] = (Integer)arrayList.get(n2);
            }
            return object;
        }

        public ConfigBuilder setHasAlphaChannel(boolean bl) {
            this.hasAlphaChannel = bl;
            return this;
        }

        public ConfigBuilder setIsRecordable(boolean bl) {
            this.isRecordable = bl;
            return this;
        }

        public ConfigBuilder setOpenGlesVersion(int n2) {
            if (n2 >= 1 && n2 <= 3) {
                this.openGlesVersion = n2;
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("OpenGL ES version ");
            stringBuilder.append(n2);
            stringBuilder.append(" not supported");
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public ConfigBuilder setSupportsPixelBuffer(boolean bl) {
            this.supportsPixelBuffer = bl;
            return this;
        }
    }

    public static interface Context {
        public static final long NO_CONTEXT = 0L;

        public long getNativeEglContext();
    }
}

