/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.BaseBitrateAdjuster;

class DynamicBitrateAdjuster
extends BaseBitrateAdjuster {
    private static final double BITRATE_ADJUSTMENT_MAX_SCALE = 4.0;
    private static final double BITRATE_ADJUSTMENT_SEC = 3.0;
    private static final int BITRATE_ADJUSTMENT_STEPS = 20;
    private static final double BITS_PER_BYTE = 8.0;
    private int bitrateAdjustmentScaleExp;
    private double deviationBytes;
    private double timeSinceLastAdjustmentMs;

    DynamicBitrateAdjuster() {
    }

    private double getBitrateAdjustmentScale() {
        double d3 = this.bitrateAdjustmentScaleExp;
        Double.isNaN(d3);
        return Math.pow(4.0, d3 / 20.0);
    }

    public int getAdjustedBitrateBps() {
        double d3 = this.targetBitrateBps;
        double d4 = this.getBitrateAdjustmentScale();
        Double.isNaN(d3);
        return (int)(d3 * d4);
    }

    public void reportEncodedFrame(int n2) {
        int n3 = this.targetFps;
        if (n3 == 0) {
            return;
        }
        int n4 = this.targetBitrateBps;
        double d3 = n4;
        Double.isNaN(d3);
        double d4 = n3;
        Double.isNaN(d4);
        double d5 = (d3 /= 8.0) / d4;
        d3 = this.deviationBytes;
        d4 = n2;
        Double.isNaN(d4);
        this.deviationBytes = d4 = d3 + (d4 - d5);
        d3 = this.timeSinceLastAdjustmentMs;
        d5 = n3;
        Double.isNaN(d5);
        this.timeSinceLastAdjustmentMs = d3 + 1000.0 / d5;
        d3 = n4;
        Double.isNaN(d3);
        d5 = 3.0 * (d3 /= 8.0);
        this.deviationBytes = d4 = Math.min(d4, d5);
        this.deviationBytes = d4 = Math.max(d4, -d5);
        if (this.timeSinceLastAdjustmentMs <= 3000.0) {
            return;
        }
        if (d4 > d3) {
            n2 = (int)(d4 / d3 + 0.5);
            this.bitrateAdjustmentScaleExp = n2 = this.bitrateAdjustmentScaleExp - n2;
            this.bitrateAdjustmentScaleExp = Math.max(n2, -20);
            this.deviationBytes = d3;
        } else {
            d5 = -d3;
            if (d4 < d5) {
                n2 = (int)(-d4 / d3 + 0.5);
                this.bitrateAdjustmentScaleExp = n2 = this.bitrateAdjustmentScaleExp + n2;
                this.bitrateAdjustmentScaleExp = Math.min(n2, 20);
                this.deviationBytes = d5;
            }
        }
        this.timeSinceLastAdjustmentMs = 0.0;
    }

    public void setTargets(int n2, int n3) {
        int n4 = this.targetBitrateBps;
        if (n4 > 0 && n2 < n4) {
            double d3 = this.deviationBytes;
            double d4 = n2;
            Double.isNaN(d4);
            double d5 = n4;
            Double.isNaN(d5);
            this.deviationBytes = d3 * d4 / d5;
        }
        super.setTargets(n2, n3);
    }
}

