/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoEncoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoEncoderFactory$_CC;
import org.webrtc.VideoEncoderFallback;

public class DefaultVideoEncoderFactory
implements VideoEncoderFactory {
    private final VideoEncoderFactory hardwareVideoEncoderFactory;
    private final VideoEncoderFactory softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();

    public DefaultVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2) {
        this.hardwareVideoEncoderFactory = new HardwareVideoEncoderFactory(context, bl, bl2);
    }

    DefaultVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
        this.hardwareVideoEncoderFactory = videoEncoderFactory;
    }

    @Override
    public VideoEncoder createEncoder(VideoCodecInfo object) {
        VideoEncoder videoEncoder = this.softwareVideoEncoderFactory.createEncoder((VideoCodecInfo)object);
        VideoEncoder videoEncoder2 = this.hardwareVideoEncoderFactory.createEncoder((VideoCodecInfo)object);
        if (videoEncoder2 != null && videoEncoder != null) {
            return new VideoEncoderFallback(videoEncoder, videoEncoder2);
        }
        object = videoEncoder;
        if (videoEncoder2 != null) {
            object = videoEncoder2;
        }
        return object;
    }

    @Override
    @CalledByNative
    public /* synthetic */ VideoCodecInfo[] getImplementations() {
        return VideoEncoderFactory$_CC.$default$getImplementations(this);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet = new LinkedHashSet<VideoCodecInfo>();
        linkedHashSet.addAll(Arrays.asList(this.softwareVideoEncoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(this.hardwareVideoEncoderFactory.getSupportedCodecs()));
        return linkedHashSet.toArray(new VideoCodecInfo[linkedHashSet.size()]);
    }
}

