/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoDecoderFactory;
import org.webrtc.PlatformSoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoDecoderFactory$_CC;
import org.webrtc.VideoDecoderFallback;

public class DefaultVideoDecoderFactory
implements VideoDecoderFactory {
    private final VideoDecoderFactory hardwareVideoDecoderFactory;
    private final VideoDecoderFactory platformSoftwareVideoDecoderFactory;
    private final VideoDecoderFactory softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();

    public DefaultVideoDecoderFactory(EglBase.Context context) {
        this.hardwareVideoDecoderFactory = new HardwareVideoDecoderFactory(context);
        this.platformSoftwareVideoDecoderFactory = new PlatformSoftwareVideoDecoderFactory(context);
    }

    DefaultVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
        this.hardwareVideoDecoderFactory = videoDecoderFactory;
        this.platformSoftwareVideoDecoderFactory = null;
    }

    @Override
    @Deprecated
    public /* synthetic */ VideoDecoder createDecoder(String string2) {
        return VideoDecoderFactory$_CC.$default$createDecoder((VideoDecoderFactory)this, string2);
    }

    @Override
    public VideoDecoder createDecoder(VideoCodecInfo object) {
        VideoDecoder videoDecoder = this.softwareVideoDecoderFactory.createDecoder((VideoCodecInfo)object);
        VideoDecoder videoDecoder2 = this.hardwareVideoDecoderFactory.createDecoder((VideoCodecInfo)object);
        VideoDecoder videoDecoder3 = videoDecoder;
        if (videoDecoder == null) {
            VideoDecoderFactory videoDecoderFactory = this.platformSoftwareVideoDecoderFactory;
            videoDecoder3 = videoDecoder;
            if (videoDecoderFactory != null) {
                videoDecoder3 = videoDecoderFactory.createDecoder((VideoCodecInfo)object);
            }
        }
        if (videoDecoder2 != null && videoDecoder3 != null) {
            return new VideoDecoderFallback(videoDecoder3, videoDecoder2);
        }
        object = videoDecoder2 != null ? videoDecoder2 : videoDecoder3;
        return object;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet = new LinkedHashSet<VideoCodecInfo>();
        linkedHashSet.addAll(Arrays.asList(this.softwareVideoDecoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(this.hardwareVideoDecoderFactory.getSupportedCodecs()));
        VideoDecoderFactory videoDecoderFactory = this.platformSoftwareVideoDecoderFactory;
        if (videoDecoderFactory != null) {
            linkedHashSet.addAll(Arrays.asList(videoDecoderFactory.getSupportedCodecs()));
        }
        return linkedHashSet.toArray(new VideoCodecInfo[linkedHashSet.size()]);
    }
}

