/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;

public class DataChannel {
    private long nativeDataChannel;
    private long nativeObserver;

    @CalledByNative
    public DataChannel(long l3) {
        this.nativeDataChannel = l3;
    }

    private void checkDataChannelExists() {
        if (this.nativeDataChannel != 0L) {
            return;
        }
        throw new IllegalStateException("DataChannel has been disposed.");
    }

    private native long nativeBufferedAmount();

    private native void nativeClose();

    private native int nativeId();

    private native String nativeLabel();

    private native long nativeRegisterObserver(Observer var1);

    private native boolean nativeSend(byte[] var1, boolean var2);

    private native State nativeState();

    private native void nativeUnregisterObserver(long var1);

    public long bufferedAmount() {
        this.checkDataChannelExists();
        return this.nativeBufferedAmount();
    }

    public void close() {
        this.checkDataChannelExists();
        this.nativeClose();
    }

    public void dispose() {
        this.checkDataChannelExists();
        JniCommon.nativeReleaseRef(this.nativeDataChannel);
        this.nativeDataChannel = 0L;
    }

    @CalledByNative
    long getNativeDataChannel() {
        return this.nativeDataChannel;
    }

    public int id() {
        this.checkDataChannelExists();
        return this.nativeId();
    }

    public String label() {
        this.checkDataChannelExists();
        return this.nativeLabel();
    }

    public void registerObserver(Observer observer) {
        this.checkDataChannelExists();
        long l3 = this.nativeObserver;
        if (l3 != 0L) {
            this.nativeUnregisterObserver(l3);
        }
        this.nativeObserver = this.nativeRegisterObserver(observer);
    }

    public boolean send(Buffer buffer) {
        this.checkDataChannelExists();
        byte[] byArray = new byte[buffer.data.remaining()];
        buffer.data.get(byArray);
        return this.nativeSend(byArray, buffer.binary);
    }

    public State state() {
        this.checkDataChannelExists();
        return this.nativeState();
    }

    public void unregisterObserver() {
        this.checkDataChannelExists();
        this.nativeUnregisterObserver(this.nativeObserver);
    }

    public static class Buffer {
        public final boolean binary;
        public final ByteBuffer data;

        @CalledByNative(value="Buffer")
        public Buffer(ByteBuffer byteBuffer, boolean bl) {
            this.data = byteBuffer;
            this.binary = bl;
        }
    }

    public static class Init {
        public int id = -1;
        public int maxRetransmitTimeMs = -1;
        public int maxRetransmits = -1;
        public boolean negotiated;
        public boolean ordered = true;
        public String protocol = "";

        @CalledByNative(value="Init")
        int getId() {
            return this.id;
        }

        @CalledByNative(value="Init")
        int getMaxRetransmitTimeMs() {
            return this.maxRetransmitTimeMs;
        }

        @CalledByNative(value="Init")
        int getMaxRetransmits() {
            return this.maxRetransmits;
        }

        @CalledByNative(value="Init")
        boolean getNegotiated() {
            return this.negotiated;
        }

        @CalledByNative(value="Init")
        boolean getOrdered() {
            return this.ordered;
        }

        @CalledByNative(value="Init")
        String getProtocol() {
            return this.protocol;
        }
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onBufferedAmountChange(long var1);

        @CalledByNative(value="Observer")
        public void onMessage(Buffer var1);

        @CalledByNative(value="Observer")
        public void onStateChange();
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State CLOSED;
        public static final /* enum */ State CLOSING;
        public static final /* enum */ State CONNECTING;
        public static final /* enum */ State OPEN;

        static {
            State state;
            CONNECTING = new State();
            OPEN = new State();
            CLOSING = new State();
            CLOSED = state = new State();
            $VALUES = new State[]{CONNECTING, OPEN, CLOSING, state};
        }

        @CalledByNative(value="State")
        static State fromNativeIndex(int n2) {
            return State.values()[n2];
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

