/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.zone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.Month;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.chrono.IsoChronology;
import org.threeten.bp.temporal.c;
import org.threeten.bp.temporal.d;
import org.threeten.bp.zone.Ser;
import org.threeten.bp.zone.ZoneOffsetTransition;

public final class ZoneOffsetTransitionRule
implements Serializable {
    private static final long serialVersionUID = 6889046316657758795L;
    private final byte dom;
    private final DayOfWeek dow;
    private final Month month;
    private final ZoneOffset offsetAfter;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset standardOffset;
    private final LocalTime time;
    private final TimeDefinition timeDefinition;
    private final boolean timeEndOfDay;

    ZoneOffsetTransitionRule(Month month, int n2, DayOfWeek dayOfWeek, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        this.month = month;
        this.dom = (byte)n2;
        this.dow = dayOfWeek;
        this.time = localTime;
        this.timeEndOfDay = bl;
        this.timeDefinition = timeDefinition;
        this.standardOffset = zoneOffset;
        this.offsetBefore = zoneOffset2;
        this.offsetAfter = zoneOffset3;
    }

    static ZoneOffsetTransitionRule b(DataInput object) {
        int n2 = object.readInt();
        Month month = Month.v(n2 >>> 28);
        int n3 = ((0xFC00000 & n2) >>> 22) - 32;
        int n4 = (0x380000 & n2) >>> 19;
        DayOfWeek dayOfWeek = n4 == 0 ? null : DayOfWeek.j(n4);
        int n5 = (0x7C000 & n2) >>> 14;
        TimeDefinition timeDefinition = TimeDefinition.values()[(n2 & 0x3000) >>> 12];
        n4 = (n2 & 0xFF0) >>> 4;
        int n6 = (n2 & 0xC) >>> 2;
        LocalTime localTime = n5 == 31 ? LocalTime.H(object.readInt()) : LocalTime.D(n5 % 24, 0);
        n4 = n4 == 255 ? object.readInt() : (n4 - 128) * 900;
        ZoneOffset zoneOffset = ZoneOffset.E(n4);
        ZoneOffset zoneOffset2 = n6 == 3 ? ZoneOffset.E(object.readInt()) : ZoneOffset.E(n6 * 1800 + zoneOffset.B());
        object = n2 == 3 ? ZoneOffset.E(object.readInt()) : ZoneOffset.E((n2 &= 3) * 1800 + zoneOffset.B());
        boolean bl = n5 == 24;
        yig.M((Object)month, (String)"month");
        yig.M((Object)localTime, (String)"time");
        yig.M((Object)((Object)timeDefinition), (String)"timeDefnition");
        yig.M((Object)zoneOffset, (String)"standardOffset");
        yig.M((Object)zoneOffset2, (String)"offsetBefore");
        yig.M((Object)object, (String)"offsetAfter");
        if (n3 >= -28 && n3 <= 31 && n3 != 0) {
            if (bl && !localTime.equals(LocalTime.c)) {
                throw new IllegalArgumentException("Time must be midnight when end of day flag is true");
            }
            return new ZoneOffsetTransitionRule(month, n3, dayOfWeek, localTime, bl, timeDefinition, zoneOffset, zoneOffset2, (ZoneOffset)object);
        }
        throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
    }

    private Object writeReplace() {
        return new Ser(3, this);
    }

    public ZoneOffsetTransition a(int n2) {
        c c3;
        Object object;
        c c4;
        byte by = this.dom;
        if (by < 0) {
            c4 = this.month;
            object = LocalDate.Z(n2, (Month)c4, ((Month)c4).l(IsoChronology.c.w(n2)) + 1 + this.dom);
            c3 = this.dow;
            c4 = object;
            if (c3 != null) {
                c4 = ((LocalDate)object).i0(d.b((DayOfWeek)c3));
            }
        } else {
            object = LocalDate.Z(n2, this.month, by);
            c3 = this.dow;
            c4 = object;
            if (c3 != null) {
                c4 = ((LocalDate)object).i0(d.a((DayOfWeek)c3));
            }
        }
        object = c4;
        if (this.timeEndOfDay) {
            object = ((LocalDate)c4).d0(1L);
        }
        c4 = LocalDateTime.T((LocalDate)object, this.time);
        object = this.timeDefinition;
        c3 = this.standardOffset;
        ZoneOffset zoneOffset = this.offsetBefore;
        n2 = ((Enum)object).ordinal();
        if (n2 != 0) {
            if (n2 == 2) {
                c4 = ((LocalDateTime)c4).Z(zoneOffset.B() - ((ZoneOffset)c3).B());
            }
        } else {
            c4 = ((LocalDateTime)c4).Z(zoneOffset.B() - ZoneOffset.p.B());
        }
        return new ZoneOffsetTransition((LocalDateTime)c4, this.offsetBefore, this.offsetAfter);
    }

    void c(DataOutput dataOutput) {
        int n2 = this.timeEndOfDay ? 86400 : this.time.R();
        int n3 = this.standardOffset.B();
        int n4 = this.offsetBefore.B() - n3;
        int n5 = this.offsetAfter.B() - n3;
        int n6 = n2 % 3600 == 0 ? (this.timeEndOfDay ? 24 : this.time.y()) : 31;
        int n7 = n3 % 900 == 0 ? n3 / 900 + 128 : 255;
        n4 = n4 != 0 && n4 != 1800 && n4 != 3600 ? 3 : (n4 /= 1800);
        n5 = n5 != 0 && n5 != 1800 && n5 != 3600 ? 3 : (n5 /= 1800);
        DayOfWeek dayOfWeek = this.dow;
        int n8 = dayOfWeek == null ? 0 : dayOfWeek.c();
        dataOutput.writeInt((this.month.j() << 28) + (this.dom + 32 << 22) + (n8 << 19) + (n6 << 14) + (this.timeDefinition.ordinal() << 12) + (n7 << 4) + (n4 << 2) + n5);
        if (n6 == 31) {
            dataOutput.writeInt(n2);
        }
        if (n7 == 255) {
            dataOutput.writeInt(n3);
        }
        if (n4 == 3) {
            dataOutput.writeInt(this.offsetBefore.B());
        }
        if (n5 == 3) {
            dataOutput.writeInt(this.offsetAfter.B());
        }
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof ZoneOffsetTransitionRule) {
            object = (ZoneOffsetTransitionRule)object;
            if (!(this.month == ((ZoneOffsetTransitionRule)object).month && this.dom == ((ZoneOffsetTransitionRule)object).dom && this.dow == ((ZoneOffsetTransitionRule)object).dow && this.timeDefinition == ((ZoneOffsetTransitionRule)object).timeDefinition && this.time.equals(((ZoneOffsetTransitionRule)object).time) && this.timeEndOfDay == ((ZoneOffsetTransitionRule)object).timeEndOfDay && this.standardOffset.equals(((ZoneOffsetTransitionRule)object).standardOffset) && this.offsetBefore.equals(((ZoneOffsetTransitionRule)object).offsetBefore) && this.offsetAfter.equals(((ZoneOffsetTransitionRule)object).offsetAfter))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.time.R();
        int n3 = this.timeEndOfDay;
        int n4 = this.month.ordinal();
        byte by = this.dom;
        DayOfWeek dayOfWeek = this.dow;
        int n5 = dayOfWeek == null ? 7 : dayOfWeek.ordinal();
        int n6 = this.timeDefinition.ordinal();
        return this.standardOffset.hashCode() ^ n6 + ((n2 + n3 << 15) + (n4 << 11) + (by + 32 << 5) + (n5 << 2)) ^ this.offsetBefore.hashCode() ^ this.offsetAfter.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = qe.v1((String)"TransitionRule[");
        Object object = this.offsetBefore.y(this.offsetAfter) > 0 ? "Gap " : "Overlap ";
        stringBuilder.append((String)object);
        stringBuilder.append(this.offsetBefore);
        stringBuilder.append(" to ");
        stringBuilder.append(this.offsetAfter);
        stringBuilder.append(", ");
        object = this.dow;
        if (object != null) {
            byte by = this.dom;
            if (by == -1) {
                stringBuilder.append(((Enum)object).name());
                stringBuilder.append(" on or before last day of ");
                stringBuilder.append(this.month.name());
            } else if (by < 0) {
                stringBuilder.append(((Enum)object).name());
                stringBuilder.append(" on or before last day minus ");
                stringBuilder.append(-this.dom - 1);
                stringBuilder.append(" of ");
                stringBuilder.append(this.month.name());
            } else {
                stringBuilder.append(((Enum)object).name());
                stringBuilder.append(" on or after ");
                stringBuilder.append(this.month.name());
                stringBuilder.append(' ');
                stringBuilder.append(this.dom);
            }
        } else {
            stringBuilder.append(this.month.name());
            stringBuilder.append(' ');
            stringBuilder.append(this.dom);
        }
        stringBuilder.append(" at ");
        object = this.timeEndOfDay ? "24:00" : this.time.toString();
        stringBuilder.append((String)object);
        stringBuilder.append(" ");
        stringBuilder.append((Object)this.timeDefinition);
        stringBuilder.append(", standard offset ");
        stringBuilder.append(this.standardOffset);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static final class TimeDefinition
    extends Enum<TimeDefinition> {
        public static final /* enum */ TimeDefinition a;
        public static final /* enum */ TimeDefinition b;
        public static final /* enum */ TimeDefinition c;
        private static final /* synthetic */ TimeDefinition[] f;

        static {
            TimeDefinition timeDefinition;
            TimeDefinition timeDefinition2;
            TimeDefinition timeDefinition3;
            a = timeDefinition3 = new TimeDefinition();
            b = timeDefinition2 = new TimeDefinition();
            c = timeDefinition = new TimeDefinition();
            f = new TimeDefinition[]{timeDefinition3, timeDefinition2, timeDefinition};
        }

        public static TimeDefinition valueOf(String string2) {
            return Enum.valueOf(TimeDefinition.class, string2);
        }

        public static TimeDefinition[] values() {
            return (TimeDefinition[])f.clone();
        }
    }
}

