/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.Year;
import org.threeten.bp.chrono.e;
import org.threeten.bp.format.ResolverStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.IsoFields;
import org.threeten.bp.temporal.ValueRange;
import org.threeten.bp.temporal.b;
import org.threeten.bp.temporal.f;
import org.threeten.bp.temporal.i;

public final class WeekFields
implements Serializable {
    private static final ConcurrentMap<String, WeekFields> p = new ConcurrentHashMap<String, WeekFields>(4, 0.75f, 2);
    private static final long serialVersionUID = -1177360819670808121L;
    private final transient f a = org.threeten.bp.temporal.WeekFields$a.e(this);
    private final transient f b = org.threeten.bp.temporal.WeekFields$a.n(this);
    private final transient f c;
    private final transient f f;
    private final DayOfWeek firstDayOfWeek;
    private final int minimalDays;

    static {
        new WeekFields(DayOfWeek.a, 4);
        WeekFields.f(DayOfWeek.s, 1);
    }

    private WeekFields(DayOfWeek dayOfWeek, int n2) {
        org.threeten.bp.temporal.WeekFields$a.p(this);
        this.c = org.threeten.bp.temporal.WeekFields$a.o(this);
        this.f = org.threeten.bp.temporal.WeekFields$a.m(this);
        yig.M((Object)dayOfWeek, (String)"firstDayOfWeek");
        if (n2 >= 1 && n2 <= 7) {
            this.firstDayOfWeek = dayOfWeek;
            this.minimalDays = n2;
            return;
        }
        throw new IllegalArgumentException("Minimal number of days is invalid");
    }

    public static WeekFields e(Locale cloneable) {
        yig.M((Object)cloneable, (String)"locale");
        cloneable = new GregorianCalendar(new Locale(((Locale)cloneable).getLanguage(), ((Locale)cloneable).getCountry()));
        int n2 = ((Calendar)cloneable).getFirstDayOfWeek();
        return WeekFields.f(DayOfWeek.s.l(n2 - 1), ((Calendar)cloneable).getMinimalDaysInFirstWeek());
    }

    public static WeekFields f(DayOfWeek dayOfWeek, int n2) {
        Serializable serializable = new StringBuilder();
        serializable.append(dayOfWeek.toString());
        serializable.append(n2);
        String string2 = serializable.toString();
        ConcurrentMap<String, WeekFields> concurrentMap = p;
        WeekFields weekFields = (WeekFields)concurrentMap.get(string2);
        serializable = weekFields;
        if (weekFields == null) {
            concurrentMap.putIfAbsent(string2, new WeekFields(dayOfWeek, n2));
            serializable = (WeekFields)concurrentMap.get(string2);
        }
        return serializable;
    }

    private Object readResolve() {
        try {
            WeekFields weekFields = WeekFields.f(this.firstDayOfWeek, this.minimalDays);
            return weekFields;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuilder stringBuilder = qe.v1((String)"Invalid WeekFields");
            stringBuilder.append(illegalArgumentException.getMessage());
            throw new InvalidObjectException(stringBuilder.toString());
        }
    }

    public f b() {
        return this.a;
    }

    public DayOfWeek c() {
        return this.firstDayOfWeek;
    }

    public int d() {
        return this.minimalDays;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object instanceof WeekFields) {
            if (this.hashCode() != object.hashCode()) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public f g() {
        return this.f;
    }

    public f h() {
        return this.b;
    }

    public int hashCode() {
        return this.firstDayOfWeek.ordinal() * 7 + this.minimalDays;
    }

    public f i() {
        return this.c;
    }

    public String toString() {
        StringBuilder stringBuilder = qe.v1((String)"WeekFields[");
        stringBuilder.append(this.firstDayOfWeek);
        stringBuilder.append(',');
        return qe.a1((StringBuilder)stringBuilder, (int)this.minimalDays, (char)']');
    }

    static class a
    implements f {
        private static final ValueRange r = ValueRange.g(1L, 7L);
        private static final ValueRange s = ValueRange.i(0L, 1L, 4L, 6L);
        private static final ValueRange t = ValueRange.i(0L, 1L, 52L, 54L);
        private static final ValueRange u = ValueRange.h(1L, 52L, 53L);
        private static final ValueRange v = ChronoField.M.i();
        private final String a;
        private final WeekFields b;
        private final i c;
        private final i f;
        private final ValueRange p;

        private a(String string2, WeekFields weekFields, i i3, i i4, ValueRange valueRange) {
            this.a = string2;
            this.b = weekFields;
            this.c = i3;
            this.f = i4;
            this.p = valueRange;
        }

        private int a(int n2, int n3) {
            return (n3 - 1 + (n2 + 7)) / 7;
        }

        private int b(b b3, int n2) {
            return yig.t((int)(b3.p((f)ChronoField.B) - n2), (int)7) + 1;
        }

        private long d(b b3, int n2) {
            int n3 = b3.p((f)ChronoField.F);
            return this.a(this.r(n3, n2), n3);
        }

        static a e(WeekFields weekFields) {
            return new a("DayOfWeek", weekFields, ChronoUnit.t, ChronoUnit.u, r);
        }

        static a m(WeekFields weekFields) {
            return new a("WeekBasedYear", weekFields, IsoFields.d, ChronoUnit.B, v);
        }

        static a n(WeekFields weekFields) {
            return new a("WeekOfMonth", weekFields, ChronoUnit.u, ChronoUnit.v, s);
        }

        static a o(WeekFields weekFields) {
            return new a("WeekOfWeekBasedYear", weekFields, ChronoUnit.u, IsoFields.d, u);
        }

        static a p(WeekFields weekFields) {
            return new a("WeekOfYear", weekFields, ChronoUnit.u, ChronoUnit.w, t);
        }

        private ValueRange q(b b3) {
            int n2 = this.b.c().c();
            n2 = yig.t((int)(b3.p((f)ChronoField.B) - n2), (int)7) + 1;
            long l3 = this.d(b3, n2);
            if (l3 == 0L) {
                return this.q(e.l(b3).g(b3).y(2L, ChronoUnit.u));
            }
            int n3 = this.r(b3.p((f)ChronoField.F), n2);
            n2 = Year.v(b3.p((f)ChronoField.M)) ? 366 : 365;
            n2 = this.a(n3, this.b.d() + n2);
            if (l3 >= (long)n2) {
                return this.q(e.l(b3).g(b3).A(2L, ChronoUnit.u));
            }
            return ValueRange.g(1L, n2 - 1);
        }

        private int r(int n2, int n3) {
            n3 = yig.t((int)(n2 - n3), (int)7);
            n2 = -n3;
            if (n3 + 1 > this.b.d()) {
                n2 = 7 - n3;
            }
            return n2;
        }

        public boolean c() {
            return true;
        }

        public <R extends org.threeten.bp.temporal.a> R f(R object, long l3) {
            int n2;
            int n3 = this.p.a(l3, this);
            if (n3 == (n2 = object.p(this))) {
                return object;
            }
            if (this.f == ChronoUnit.B) {
                int n4 = object.p(this.b.c);
                double d3 = l3 - (long)n2;
                Double.isNaN(d3);
                Double.isNaN(d3);
                l3 = (long)(d3 * 52.1775);
                ChronoUnit chronoUnit = ChronoUnit.u;
                org.threeten.bp.temporal.a a3 = object.s(l3, chronoUnit);
                if (a3.p(this) > n3) {
                    object = a3.m(a3.p(this.b.c), chronoUnit);
                } else {
                    object = a3;
                    if (a3.p(this) < n3) {
                        object = a3.s(2L, chronoUnit);
                    }
                    a3 = object.s(n4 - object.p(this.b.c), chronoUnit);
                    object = a3;
                    if (a3.p(this) > n3) {
                        object = a3.m(1L, chronoUnit);
                    }
                }
                return object;
            }
            return (R)object.s(n3 - n2, this.c);
        }

        public boolean g(b b3) {
            if (b3.k((f)ChronoField.B)) {
                i i3 = this.f;
                if (i3 == ChronoUnit.u) {
                    return true;
                }
                if (i3 == ChronoUnit.v) {
                    return b3.k((f)ChronoField.E);
                }
                if (i3 == ChronoUnit.w) {
                    return b3.k((f)ChronoField.F);
                }
                if (i3 == IsoFields.d) {
                    return b3.k((f)ChronoField.G);
                }
                if (i3 == ChronoUnit.B) {
                    return b3.k((f)ChronoField.G);
                }
            }
            return false;
        }

        public ValueRange h(b object) {
            Object object2;
            block8: {
                block7: {
                    block6: {
                        object2 = this.f;
                        if (object2 == ChronoUnit.u) {
                            return this.p;
                        }
                        if (object2 != ChronoUnit.v) break block6;
                        object2 = ChronoField.E;
                        break block7;
                    }
                    if (object2 != ChronoUnit.w) break block8;
                    object2 = ChronoField.F;
                }
                int n2 = this.b.c().c();
                n2 = yig.t((int)(object.p((f)ChronoField.B) - n2), (int)7);
                n2 = this.r(object.p((f)object2), n2 + 1);
                object = object.h((f)object2);
                return ValueRange.g(this.a(n2, (int)((ValueRange)object).d()), this.a(n2, (int)((ValueRange)object).c()));
            }
            if (object2 == IsoFields.d) {
                return this.q((b)object);
            }
            if (object2 == ChronoUnit.B) {
                return object.h((f)ChronoField.M);
            }
            throw new IllegalStateException("unreachable");
        }

        public ValueRange i() {
            return this.p;
        }

        public long j(b b3) {
            ChronoUnit chronoUnit;
            i i3;
            ChronoField chronoField;
            int n2;
            block18: {
                block17: {
                    block16: {
                        n2 = this.b.c().c();
                        chronoField = ChronoField.B;
                        n2 = yig.t((int)(b3.p((f)chronoField) - n2), (int)7) + 1;
                        i3 = this.f;
                        chronoUnit = ChronoUnit.u;
                        if (i3 == chronoUnit) {
                            return n2;
                        }
                        if (i3 != ChronoUnit.v) break block16;
                        int n3 = b3.p((f)ChronoField.E);
                        n2 = this.a(this.r(n3, n2), n3);
                        break block17;
                    }
                    if (i3 != ChronoUnit.w) break block18;
                    int n4 = b3.p((f)ChronoField.F);
                    n2 = this.a(this.r(n4, n2), n4);
                }
                return n2;
            }
            i i4 = IsoFields.d;
            n2 = 366;
            if (i3 == i4) {
                int n5 = this.b.c().c();
                n5 = yig.t((int)(b3.p((f)chronoField) - n5), (int)7) + 1;
                long l3 = this.d(b3, n5);
                if (l3 == 0L) {
                    n2 = (int)this.d(e.l(b3).g(b3).y(1L, chronoUnit), n5) + 1;
                } else {
                    long l4 = l3;
                    if (l3 >= 53L) {
                        n5 = this.r(b3.p((f)ChronoField.F), n5);
                        if (!Year.v(b3.p((f)ChronoField.M))) {
                            n2 = 365;
                        }
                        n2 = this.a(n5, this.b.d() + n2);
                        l4 = l3;
                        if (l3 >= (long)n2) {
                            l4 = l3 - (long)(n2 - 1);
                        }
                    }
                    n2 = (int)l4;
                }
                return n2;
            }
            if (i3 == ChronoUnit.B) {
                int n6 = this.b.c().c();
                n6 = yig.t((int)(b3.p((f)chronoField) - n6), (int)7) + 1;
                int n7 = b3.p((f)ChronoField.M);
                long l5 = this.d(b3, n6);
                if (l5 == 0L) {
                    n2 = n7 - 1;
                } else if (l5 < 53L) {
                    n2 = n7;
                } else {
                    int n8 = this.r(b3.p((f)ChronoField.F), n6);
                    n6 = Year.v(n7) ? n2 : 365;
                    n2 = n7;
                    if (l5 >= (long)this.a(n8, this.b.d() + n6)) {
                        n2 = n7 + 1;
                    }
                }
                return n2;
            }
            throw new IllegalStateException("unreachable");
        }

        public boolean k() {
            return false;
        }

        public b l(Map<f, Long> map, b object, ResolverStyle resolverStyle) {
            ResolverStyle resolverStyle2 = ResolverStyle.a;
            ResolverStyle resolverStyle3 = ResolverStyle.c;
            int n2 = this.b.c().c();
            if (this.f == ChronoUnit.u) {
                long l3 = map.remove(this);
                n2 = yig.t((int)(this.p.a(l3, this) - 1 + (n2 - 1)), (int)7);
                map.put(ChronoField.B, Long.valueOf(n2 + 1));
                return null;
            }
            ChronoField chronoField = ChronoField.B;
            if (!map.containsKey((Object)chronoField)) {
                return null;
            }
            if (this.f == ChronoUnit.B) {
                long l4;
                long l5;
                if (!map.containsKey(this.b.c)) {
                    return null;
                }
                object = e.l((b)object);
                int n3 = yig.t((int)(chronoField.m(map.get((Object)chronoField)) - n2), (int)7);
                int n4 = this.p.a(map.get(this), this);
                if (resolverStyle == resolverStyle3) {
                    object = ((e)object).f(n4, 1, this.b.d());
                    l5 = map.get(this.b.c);
                    n2 = this.b((b)object, n2);
                    l4 = this.d((b)object, n2);
                } else {
                    object = ((e)object).f(n4, 1, this.b.d());
                    l5 = this.b.c.i().a(map.get(this.b.c), this.b.c);
                    n2 = this.b((b)object, n2);
                    l4 = this.d((b)object, n2);
                }
                object = ((org.threeten.bp.chrono.a)object).A((l5 - l4) * 7L + (long)(n3 + 1 - n2), ChronoUnit.t);
                if (resolverStyle == resolverStyle2 && object.r((f)this) != map.get(this).longValue()) {
                    throw new DateTimeException("Strict mode rejected date parsed to a different year");
                }
                map.remove(this);
                map.remove(this.b.c);
                map.remove((Object)chronoField);
                return object;
            }
            ChronoField chronoField2 = ChronoField.M;
            if (!map.containsKey((Object)chronoField2)) {
                return null;
            }
            int n5 = yig.t((int)(chronoField.m(map.get((Object)chronoField)) - n2), (int)7) + 1;
            int n6 = chronoField2.m(map.get((Object)chronoField2));
            object = e.l((b)object);
            Object object2 = this.f;
            ChronoUnit chronoUnit = ChronoUnit.v;
            if (object2 == chronoUnit) {
                object2 = ChronoField.J;
                if (!map.containsKey(object2)) {
                    return null;
                }
                long l6 = map.remove(this);
                if (resolverStyle == resolverStyle3) {
                    long l7 = map.get(object2);
                    object = ((e)object).f(n6, 1, 1).A(l7 - 1L, chronoUnit);
                    n6 = this.b((b)object, n2);
                    n2 = object.p((f)ChronoField.E);
                    n2 = this.a(this.r(n2, n6), n2);
                } else {
                    object = ((e)object).f(n6, ((ChronoField)((Object)object2)).m(map.get(object2)), 8);
                    n6 = this.b((b)object, n2);
                    l6 = this.p.a(l6, this);
                    n2 = object.p((f)ChronoField.E);
                    n2 = this.a(this.r(n2, n6), n2);
                }
                object = ((org.threeten.bp.chrono.a)object).A((l6 - (long)n2) * 7L + (long)(n5 - n6), ChronoUnit.t);
                if (resolverStyle == resolverStyle2 && object.r((f)object2) != map.get(object2).longValue()) {
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
                map.remove(this);
                map.remove((Object)chronoField2);
                map.remove(object2);
                map.remove((Object)chronoField);
                return object;
            }
            if (object2 == ChronoUnit.w) {
                long l8;
                long l9 = map.remove(this);
                object = ((e)object).f(n6, 1, 1);
                if (resolverStyle == resolverStyle3) {
                    n2 = this.b((b)object, n2);
                    l8 = this.d((b)object, n2);
                } else {
                    n2 = this.b((b)object, n2);
                    l9 = this.p.a(l9, this);
                    l8 = this.d((b)object, n2);
                }
                object = ((org.threeten.bp.chrono.a)object).A((l9 - l8) * 7L + (long)(n5 - n2), ChronoUnit.t);
                if (resolverStyle == resolverStyle2 && object.r((f)chronoField2) != map.get((Object)chronoField2).longValue()) {
                    throw new DateTimeException("Strict mode rejected date parsed to a different year");
                }
                map.remove(this);
                map.remove((Object)chronoField2);
                map.remove((Object)chronoField);
                return object;
            }
            throw new IllegalStateException("unreachable");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.a);
            stringBuilder.append("[");
            stringBuilder.append(this.b.toString());
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

