/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.List;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.Ser;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.chrono.b;
import org.threeten.bp.chrono.d;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.ValueRange;
import org.threeten.bp.temporal.a;
import org.threeten.bp.temporal.c;
import org.threeten.bp.temporal.f;
import org.threeten.bp.temporal.g;
import org.threeten.bp.temporal.h;
import org.threeten.bp.temporal.i;
import org.threeten.bp.zone.ZoneOffsetTransition;
import org.threeten.bp.zone.ZoneRules;

public final class ZonedDateTime
extends d<LocalDate>
implements a,
Serializable {
    private static final long serialVersionUID = -6260982410461394882L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    private ZonedDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        this.dateTime = localDateTime;
        this.offset = zoneOffset;
        this.zone = zoneId;
    }

    private static ZonedDateTime J(long l3, int n2, ZoneId zoneId) {
        ZoneOffset zoneOffset = zoneId.t().a(Instant.E(l3, n2));
        return new ZonedDateTime(LocalDateTime.U(l3, n2, zoneOffset), zoneOffset, zoneId);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ZonedDateTime K(org.threeten.bp.temporal.b b3) {
        ChronoField chronoField;
        ZoneId zoneId;
        if (b3 instanceof ZonedDateTime) {
            return (ZonedDateTime)b3;
        }
        try {
            zoneId = ZoneId.c(b3);
            chronoField = ChronoField.O;
            boolean bl = b3.k((f)chronoField);
            if (!bl) return ZonedDateTime.O(LocalDateTime.I(b3), zoneId, null);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException(qe.p1((org.threeten.bp.temporal.b)b3, (StringBuilder)qe.A1((String)"Unable to obtain ZonedDateTime from TemporalAccessor: ", (org.threeten.bp.temporal.b)b3, (String)", type ")));
        }
        try {
            return ZonedDateTime.J(b3.r((f)chronoField), b3.p((f)ChronoField.a), zoneId);
        }
        catch (DateTimeException dateTimeException) {
            return ZonedDateTime.O(LocalDateTime.I(b3), zoneId, null);
        }
    }

    public static ZonedDateTime N(Instant instant, ZoneId zoneId) {
        yig.M((Object)instant, (String)"instant");
        yig.M((Object)zoneId, (String)"zone");
        return ZonedDateTime.J(instant.x(), instant.y(), zoneId);
    }

    public static ZonedDateTime O(LocalDateTime localDateTime, ZoneId zoneId, ZoneOffset comparable) {
        yig.M((Object)localDateTime, (String)"localDateTime");
        yig.M((Object)zoneId, (String)"zone");
        if (zoneId instanceof ZoneOffset) {
            return new ZonedDateTime(localDateTime, (ZoneOffset)zoneId, zoneId);
        }
        ZoneRules zoneRules = zoneId.t();
        List<ZoneOffset> list = zoneRules.c(localDateTime);
        if (list.size() == 1) {
            comparable = list.get(0);
        } else if (list.size() == 0) {
            comparable = zoneRules.b(localDateTime);
            localDateTime = localDateTime.Z(((ZoneOffsetTransition)comparable).g().f());
            comparable = ((ZoneOffsetTransition)comparable).h();
        } else if (comparable == null || !list.contains(comparable)) {
            comparable = list.get(0);
            yig.M(comparable, (String)"offset");
            comparable = (ZoneOffset)comparable;
        }
        return new ZonedDateTime(localDateTime, (ZoneOffset)comparable, zoneId);
    }

    static ZonedDateTime Q(DataInput object) {
        LocalDateTime localDateTime = LocalDateTime.b0((DataInput)object);
        ZoneOffset zoneOffset = ZoneOffset.G((DataInput)object);
        object = (ZoneId)Ser.a((DataInput)object);
        yig.M((Object)localDateTime, (String)"localDateTime");
        yig.M((Object)zoneOffset, (String)"offset");
        yig.M((Object)object, (String)"zone");
        if (object instanceof ZoneOffset && !zoneOffset.equals(object)) {
            throw new IllegalArgumentException("ZoneId must match ZoneOffset");
        }
        return new ZonedDateTime(localDateTime, zoneOffset, (ZoneId)object);
    }

    private ZonedDateTime R(LocalDateTime localDateTime) {
        return ZonedDateTime.O(localDateTime, this.zone, this.offset);
    }

    private ZonedDateTime S(ZoneOffset zoneOffset) {
        if (!zoneOffset.equals(this.offset) && this.zone.t().f(this.dateTime, zoneOffset)) {
            return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(6, this);
    }

    @Override
    public b D() {
        return this.dateTime;
    }

    @Override
    public LocalTime E() {
        return this.dateTime.E();
    }

    @Override
    public d I(ZoneId serializable) {
        yig.M((Object)serializable, (String)"zone");
        serializable = this.zone.equals(serializable) ? this : ZonedDateTime.O(this.dateTime, serializable, this.offset);
        return serializable;
    }

    public ZonedDateTime L(long l3, i object) {
        object = l3 == Long.MIN_VALUE ? this.P(Long.MAX_VALUE, (i)object).P(1L, (i)object) : this.P(-l3, (i)object);
        return object;
    }

    public ZonedDateTime P(long l3, i object) {
        if (object instanceof ChronoUnit) {
            if (object.c()) {
                return this.R(this.dateTime.V(l3, (i)object));
            }
            LocalDateTime localDateTime = this.dateTime.V(l3, (i)object);
            object = this.offset;
            ZoneId zoneId = this.zone;
            yig.M((Object)localDateTime, (String)"localDateTime");
            yig.M((Object)object, (String)"offset");
            yig.M((Object)zoneId, (String)"zone");
            return ZonedDateTime.J(localDateTime.A((ZoneOffset)object), localDateTime.J(), zoneId);
        }
        return object.g(this, l3);
    }

    public LocalDate T() {
        return this.dateTime.c0();
    }

    public LocalDateTime U() {
        return this.dateTime;
    }

    public ZonedDateTime V(c c3) {
        if (c3 instanceof LocalDate) {
            return ZonedDateTime.O(LocalDateTime.T((LocalDate)c3, this.dateTime.E()), this.zone, this.offset);
        }
        if (c3 instanceof LocalTime) {
            return ZonedDateTime.O(LocalDateTime.T(this.dateTime.c0(), (LocalTime)c3), this.zone, this.offset);
        }
        if (c3 instanceof LocalDateTime) {
            return this.R((LocalDateTime)c3);
        }
        if (c3 instanceof Instant) {
            c3 = (Instant)c3;
            return ZonedDateTime.J(((Instant)c3).x(), ((Instant)c3).y(), this.zone);
        }
        if (c3 instanceof ZoneOffset) {
            return this.S((ZoneOffset)c3);
        }
        return (ZonedDateTime)c3.g(this);
    }

    public ZonedDateTime X(f f3, long l3) {
        if (f3 instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)f3;
            int n2 = chronoField.ordinal();
            if (n2 != 28) {
                if (n2 != 29) {
                    return this.R(this.dateTime.f0(f3, l3));
                }
                return this.S(ZoneOffset.E(chronoField.m(l3)));
            }
            return ZonedDateTime.J(l3, this.dateTime.J(), this.zone);
        }
        return (ZonedDateTime)f3.f((a)this, l3);
    }

    public ZonedDateTime Y(ZoneId serializable) {
        yig.M((Object)serializable, (String)"zone");
        serializable = this.zone.equals(serializable) ? this : ZonedDateTime.J(this.dateTime.A(this.offset), this.dateTime.J(), serializable);
        return serializable;
    }

    void Z(DataOutput dataOutput) {
        this.dateTime.g0(dataOutput);
        this.offset.H(dataOutput);
        this.zone.x(dataOutput);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object instanceof ZonedDateTime) {
            object = (ZonedDateTime)object;
            if (!(this.dateTime.equals(((ZonedDateTime)object).dateTime) && this.offset.equals(((ZonedDateTime)object).offset) && this.zone.equals(((ZonedDateTime)object).zone))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    @Override
    public ValueRange h(f f3) {
        if (f3 instanceof ChronoField) {
            if (f3 != ChronoField.O && f3 != ChronoField.P) {
                return this.dateTime.h(f3);
            }
            return f3.i();
        }
        return f3.h((org.threeten.bp.temporal.b)this);
    }

    @Override
    public int hashCode() {
        return this.dateTime.hashCode() ^ this.offset.hashCode() ^ Integer.rotateLeft(this.zone.hashCode(), 3);
    }

    @Override
    public <R> R i(h<R> h3) {
        if (h3 == g.b()) {
            return (R)this.T();
        }
        return super.i(h3);
    }

    public boolean k(f f3) {
        boolean bl = f3 instanceof ChronoField || f3 != null && f3.g((org.threeten.bp.temporal.b)this);
        return bl;
    }

    @Override
    public long o(a a3, i i3) {
        a3 = ZonedDateTime.K(a3);
        if (i3 instanceof ChronoUnit) {
            a3 = ((ZonedDateTime)a3).Y(this.zone);
            if (i3.c()) {
                return this.dateTime.o(((ZonedDateTime)a3).dateTime, i3);
            }
            return OffsetDateTime.w(this.dateTime, this.offset).o(OffsetDateTime.w(((ZonedDateTime)a3).dateTime, ((ZonedDateTime)a3).offset), i3);
        }
        return i3.f(this, a3);
    }

    @Override
    public int p(f f3) {
        if (f3 instanceof ChronoField) {
            int n2 = ((ChronoField)f3).ordinal();
            if (n2 != 28) {
                if (n2 != 29) {
                    return this.dateTime.p(f3);
                }
                return this.offset.B();
            }
            throw new DateTimeException(qe.Z0((String)"Field too large for an int: ", (f)f3));
        }
        return super.p(f3);
    }

    @Override
    public long r(f f3) {
        if (f3 instanceof ChronoField) {
            int n2 = ((ChronoField)f3).ordinal();
            if (n2 != 28) {
                if (n2 != 29) {
                    return this.dateTime.r(f3);
                }
                return this.offset.B();
            }
            return this.A();
        }
        return f3.j((org.threeten.bp.temporal.b)this);
    }

    @Override
    public String toString() {
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(this.dateTime.toString());
        ((StringBuilder)charSequence).append(this.offset.toString());
        String string2 = ((StringBuilder)charSequence).toString();
        charSequence = string2;
        if (this.offset != this.zone) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append('[');
            ((StringBuilder)charSequence).append(this.zone.toString());
            ((StringBuilder)charSequence).append(']');
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    @Override
    public ZoneOffset v() {
        return this.offset;
    }

    @Override
    public ZoneId w() {
        return this.zone;
    }
}

