/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Ser;
import org.threeten.bp.ZoneId;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.UnsupportedTemporalTypeException;
import org.threeten.bp.temporal.ValueRange;
import org.threeten.bp.temporal.a;
import org.threeten.bp.temporal.b;
import org.threeten.bp.temporal.c;
import org.threeten.bp.temporal.f;
import org.threeten.bp.temporal.g;
import org.threeten.bp.temporal.h;
import org.threeten.bp.zone.ZoneRules;

public final class ZoneOffset
extends ZoneId
implements b,
c,
Comparable<ZoneOffset>,
Serializable {
    private static final ConcurrentMap<Integer, ZoneOffset> c = new ConcurrentHashMap<Integer, ZoneOffset>(16, 0.75f, 4);
    private static final ConcurrentMap<String, ZoneOffset> f = new ConcurrentHashMap<String, ZoneOffset>(16, 0.75f, 4);
    public static final ZoneOffset p = ZoneOffset.E(0);
    public static final ZoneOffset r = ZoneOffset.E(-64800);
    public static final ZoneOffset s = ZoneOffset.E(64800);
    private static final long serialVersionUID = 2357656521762053153L;
    private final transient String b;
    private final int totalSeconds;

    private ZoneOffset(int n2) {
        String string2;
        this.totalSeconds = n2;
        if (n2 == 0) {
            string2 = "Z";
        } else {
            int n3 = Math.abs(n2);
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = n3 / 3600;
            int n5 = n3 / 60 % 60;
            string2 = n2 < 0 ? "-" : "+";
            stringBuilder.append(string2);
            string2 = n4 < 10 ? "0" : "";
            stringBuilder.append(string2);
            stringBuilder.append(n4);
            String string3 = ":0";
            string2 = n5 < 10 ? ":0" : ":";
            stringBuilder.append(string2);
            stringBuilder.append(n5);
            n2 = n3 % 60;
            if (n2 != 0) {
                string2 = n2 < 10 ? string3 : ":";
                stringBuilder.append(string2);
                stringBuilder.append(n2);
            }
            string2 = stringBuilder.toString();
        }
        this.b = string2;
    }

    public static ZoneOffset A(b b3) {
        ZoneOffset zoneOffset = (ZoneOffset)b3.i(g.d());
        if (zoneOffset != null) {
            return zoneOffset;
        }
        throw new DateTimeException(qe.p1((b)b3, (StringBuilder)qe.A1((String)"Unable to obtain ZoneOffset from TemporalAccessor: ", (b)b3, (String)", type ")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZoneOffset C(String object) {
        int n2;
        int n3;
        int n4;
        block8: {
            block9: {
                Object object2;
                block5: {
                    block4: {
                        block6: {
                            block7: {
                                yig.M((Object)object, (String)"offsetId");
                                object2 = (ZoneOffset)f.get(object);
                                if (object2 != null) {
                                    return object2;
                                }
                                n4 = ((String)object).length();
                                if (n4 == 2) break block4;
                                object2 = object;
                                if (n4 == 3) break block5;
                                if (n4 == 5) break block6;
                                if (n4 == 6) break block7;
                                if (n4 != 7) {
                                    if (n4 != 9) throw new DateTimeException(qe.U0((String)"Invalid ID for ZoneOffset, invalid format: ", (String)object));
                                    n4 = ZoneOffset.F((CharSequence)object, 1, false);
                                    n3 = ZoneOffset.F((CharSequence)object, 4, true);
                                    n2 = ZoneOffset.F((CharSequence)object, 7, true);
                                } else {
                                    n4 = ZoneOffset.F((CharSequence)object, 1, false);
                                    n3 = ZoneOffset.F((CharSequence)object, 3, false);
                                    n2 = ZoneOffset.F((CharSequence)object, 5, false);
                                }
                                break block8;
                            }
                            n4 = ZoneOffset.F((CharSequence)object, 1, false);
                            n3 = ZoneOffset.F((CharSequence)object, 4, true);
                            break block9;
                        }
                        n4 = ZoneOffset.F((CharSequence)object, 1, false);
                        n3 = ZoneOffset.F((CharSequence)object, 3, false);
                        break block9;
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(((String)object).charAt(0));
                    ((StringBuilder)object2).append("0");
                    ((StringBuilder)object2).append(((String)object).charAt(1));
                    object2 = ((StringBuilder)object2).toString();
                }
                n4 = ZoneOffset.F((CharSequence)object2, 1, false);
                n3 = 0;
                object = object2;
            }
            n2 = 0;
        }
        char c3 = ((String)object).charAt(0);
        if (c3 != '+' && c3 != '-') {
            throw new DateTimeException(qe.U0((String)"Invalid ID for ZoneOffset, plus/minus not found when expected: ", (String)object));
        }
        if (c3 != '-') return ZoneOffset.D(n4, n3, n2);
        return ZoneOffset.D(-n4, -n3, -n2);
    }

    public static ZoneOffset D(int n2, int n3, int n4) {
        if (n2 >= -18 && n2 <= 18) {
            if (n2 > 0) {
                if (n3 < 0 || n4 < 0) {
                    throw new DateTimeException("Zone offset minutes and seconds must be positive because hours is positive");
                }
            } else if (n2 < 0) {
                if (n3 > 0 || n4 > 0) {
                    throw new DateTimeException("Zone offset minutes and seconds must be negative because hours is negative");
                }
            } else if (n3 > 0 && n4 < 0 || n3 < 0 && n4 > 0) {
                throw new DateTimeException("Zone offset minutes and seconds must have the same sign");
            }
            if (Math.abs(n3) <= 59) {
                if (Math.abs(n4) <= 59) {
                    if (Math.abs(n2) == 18 && (Math.abs(n3) > 0 || Math.abs(n4) > 0)) {
                        throw new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
                    }
                    return ZoneOffset.E(n3 * 60 + n2 * 3600 + n4);
                }
                StringBuilder stringBuilder = qe.v1((String)"Zone offset seconds not in valid range: abs(value) ");
                stringBuilder.append(Math.abs(n4));
                stringBuilder.append(" is not in the range 0 to 59");
                throw new DateTimeException(stringBuilder.toString());
            }
            StringBuilder stringBuilder = qe.v1((String)"Zone offset minutes not in valid range: abs(value) ");
            stringBuilder.append(Math.abs(n3));
            stringBuilder.append(" is not in the range 0 to 59");
            throw new DateTimeException(stringBuilder.toString());
        }
        throw new DateTimeException(qe.P0((String)"Zone offset hours not in valid range: value ", (int)n2, (String)" is not in the range -18 to 18"));
    }

    public static ZoneOffset E(int n2) {
        if (Math.abs(n2) <= 64800) {
            if (n2 % 900 == 0) {
                ZoneOffset zoneOffset;
                Integer n3 = n2;
                ConcurrentMap<Integer, ZoneOffset> concurrentMap = c;
                ZoneOffset zoneOffset2 = zoneOffset = (ZoneOffset)concurrentMap.get(n3);
                if (zoneOffset == null) {
                    concurrentMap.putIfAbsent(n3, new ZoneOffset(n2));
                    zoneOffset2 = (ZoneOffset)concurrentMap.get(n3);
                    f.putIfAbsent(zoneOffset2.b, zoneOffset2);
                }
                return zoneOffset2;
            }
            return new ZoneOffset(n2);
        }
        throw new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
    }

    private static int F(CharSequence charSequence, int n2, boolean bl) {
        if (bl && charSequence.charAt(n2 - 1) != ':') {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid ID for ZoneOffset, colon not found when expected: ");
            stringBuilder.append((Object)charSequence);
            throw new DateTimeException(stringBuilder.toString());
        }
        char c3 = charSequence.charAt(n2);
        n2 = charSequence.charAt(n2 + 1);
        if (c3 >= '0' && c3 <= '9' && n2 >= 48 && n2 <= 57) {
            return n2 - 48 + (c3 - 48) * 10;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid ID for ZoneOffset, non numeric characters found: ");
        stringBuilder.append((Object)charSequence);
        throw new DateTimeException(stringBuilder.toString());
    }

    static ZoneOffset G(DataInput object) {
        byte by = object.readByte();
        object = by == 127 ? ZoneOffset.E(object.readInt()) : ZoneOffset.E(by * 900);
        return object;
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(8, this);
    }

    public int B() {
        return this.totalSeconds;
    }

    void H(DataOutput dataOutput) {
        int n2 = this.totalSeconds;
        int n3 = n2 % 900 == 0 ? n2 / 900 : 127;
        dataOutput.writeByte(n3);
        if (n3 == 127) {
            dataOutput.writeInt(n2);
        }
    }

    @Override
    public int compareTo(Object object) {
        return ((ZoneOffset)object).totalSeconds - this.totalSeconds;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object instanceof ZoneOffset) {
            if (this.totalSeconds != ((ZoneOffset)object).totalSeconds) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    @Override
    public a g(a a3) {
        return a3.f(ChronoField.P, this.totalSeconds);
    }

    public ValueRange h(f f3) {
        if (f3 == ChronoField.P) {
            return f3.i();
        }
        if (!(f3 instanceof ChronoField)) {
            return f3.h((b)this);
        }
        throw new UnsupportedTemporalTypeException(qe.Z0((String)"Unsupported field: ", (f)f3));
    }

    @Override
    public int hashCode() {
        return this.totalSeconds;
    }

    public <R> R i(h<R> h3) {
        if (h3 != g.d() && h3 != g.f()) {
            if (h3 != g.b() && h3 != g.c() && h3 != g.e() && h3 != g.a() && h3 != g.g()) {
                return h3.a(this);
            }
            return null;
        }
        return (R)this;
    }

    public boolean k(f f3) {
        boolean bl = f3 instanceof ChronoField;
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            if (f3 != ChronoField.P) {
                bl3 = false;
            }
            return bl3;
        }
        bl3 = f3 != null && f3.g((b)this) ? bl2 : false;
        return bl3;
    }

    @Override
    public String l() {
        return this.b;
    }

    public int p(f f3) {
        if (f3 == ChronoField.P) {
            return this.totalSeconds;
        }
        if (!(f3 instanceof ChronoField)) {
            return this.h(f3).a(this.r(f3), f3);
        }
        throw new UnsupportedTemporalTypeException(qe.Z0((String)"Unsupported field: ", (f)f3));
    }

    public long r(f f3) {
        if (f3 == ChronoField.P) {
            return this.totalSeconds;
        }
        if (!(f3 instanceof ChronoField)) {
            return f3.j((b)this);
        }
        throw new DateTimeException(qe.Z0((String)"Unsupported field: ", (f)f3));
    }

    @Override
    public ZoneRules t() {
        return ZoneRules.g(this);
    }

    @Override
    public String toString() {
        return this.b;
    }

    @Override
    void x(DataOutput dataOutput) {
        dataOutput.writeByte(8);
        this.H(dataOutput);
    }

    public int y(ZoneOffset zoneOffset) {
        return zoneOffset.totalSeconds - this.totalSeconds;
    }
}

