/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.Month;
import org.threeten.bp.Period;
import org.threeten.bp.Ser;
import org.threeten.bp.chrono.IsoChronology;
import org.threeten.bp.chrono.a;
import org.threeten.bp.chrono.b;
import org.threeten.bp.chrono.e;
import org.threeten.bp.chrono.f;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.UnsupportedTemporalTypeException;
import org.threeten.bp.temporal.ValueRange;
import org.threeten.bp.temporal.c;
import org.threeten.bp.temporal.g;
import org.threeten.bp.temporal.h;
import org.threeten.bp.temporal.i;

public final class LocalDate
extends a
implements org.threeten.bp.temporal.a,
c,
Serializable {
    public static final LocalDate a = LocalDate.Y(-999999999, 1, 1);
    public static final LocalDate b = LocalDate.Y(999999999, 12, 31);
    private static final long serialVersionUID = 2942565459149668126L;
    private final short day;
    private final short month;
    private final int year;

    private LocalDate(int n2, int n3, int n4) {
        this.year = n2;
        this.month = (short)n3;
        this.day = (short)n4;
    }

    private static LocalDate H(int n2, Month month, int n3) {
        if (n3 > 28 && n3 > month.l(IsoChronology.c.w(n2))) {
            if (n3 == 29) {
                throw new DateTimeException(qe.P0((String)"Invalid date 'February 29' as '", (int)n2, (String)"' is not a leap year"));
            }
            StringBuilder stringBuilder = qe.v1((String)"Invalid date '");
            stringBuilder.append(month.name());
            stringBuilder.append(" ");
            stringBuilder.append(n3);
            stringBuilder.append("'");
            throw new DateTimeException(stringBuilder.toString());
        }
        return new LocalDate(n2, month.j(), n3);
    }

    public static LocalDate J(org.threeten.bp.temporal.b b3) {
        LocalDate localDate = (LocalDate)b3.i(g.b());
        if (localDate != null) {
            return localDate;
        }
        throw new DateTimeException(qe.p1((org.threeten.bp.temporal.b)b3, (StringBuilder)qe.A1((String)"Unable to obtain LocalDate from TemporalAccessor: ", (org.threeten.bp.temporal.b)b3, (String)", type ")));
    }

    private int K(org.threeten.bp.temporal.f f3) {
        int n2 = ((ChronoField)f3).ordinal();
        int n3 = 1;
        switch (n2) {
            default: {
                throw new UnsupportedTemporalTypeException(qe.Z0((String)"Unsupported field: ", (org.threeten.bp.temporal.f)f3));
            }
            case 27: {
                if (this.year < 1) {
                    n3 = 0;
                }
                return n3;
            }
            case 26: {
                return this.year;
            }
            case 25: {
                n3 = this.year;
                if (n3 < 1) {
                    n3 = 1 - n3;
                }
                return n3;
            }
            case 24: {
                throw new DateTimeException(qe.Z0((String)"Field too large for an int: ", (org.threeten.bp.temporal.f)f3));
            }
            case 23: {
                return this.month;
            }
            case 22: {
                return (this.O() - 1) / 7 + 1;
            }
            case 21: {
                return (this.day - 1) / 7 + 1;
            }
            case 20: {
                throw new DateTimeException(qe.Z0((String)"Field too large for an int: ", (org.threeten.bp.temporal.f)f3));
            }
            case 19: {
                return this.O();
            }
            case 18: {
                return this.day;
            }
            case 17: {
                return (this.O() - 1) % 7 + 1;
            }
            case 16: {
                return (this.day - 1) % 7 + 1;
            }
            case 15: 
        }
        return this.N().c();
    }

    private long Q() {
        return (long)this.year * 12L + (long)(this.month - 1);
    }

    private long X(LocalDate localDate) {
        long l3 = this.Q();
        long l4 = this.day;
        return (localDate.Q() * 32L + (long)localDate.day - (l3 * 32L + l4)) / 32L;
    }

    public static LocalDate Y(int n2, int n3, int n4) {
        ChronoField.M.o(n2);
        ChronoField.J.o(n3);
        ChronoField.E.o(n4);
        return LocalDate.H(n2, Month.v(n3), n4);
    }

    public static LocalDate Z(int n2, Month month, int n3) {
        ChronoField.M.o(n2);
        yig.M((Object)month, (String)"month");
        ChronoField.E.o(n3);
        return LocalDate.H(n2, month, n3);
    }

    public static LocalDate a0(long l3) {
        long l4;
        ChronoField.G.o(l3);
        long l5 = l3 + 719528L - 60L;
        if (l5 < 0L) {
            l4 = (l5 + 1L) / 146097L - 1L;
            l3 = l4 * 400L;
            l5 += -l4 * 146097L;
        } else {
            l3 = 0L;
        }
        long l6 = (l5 * 400L + 591L) / 146097L;
        l4 = l6 / 4L;
        long l7 = l6 / 100L;
        long l8 = l5 - (l6 / 400L + (l4 + l6 * 365L - l7));
        l4 = l6;
        l7 = l8;
        if (l8 < 0L) {
            l4 = l6 - 1L;
            l7 = l4 / 4L;
            l6 = l4 / 100L;
            l7 = l5 - (l4 / 400L + (l7 + 365L * l4 - l6));
        }
        int n2 = (int)l7;
        int n3 = (n2 * 5 + 2) / 153;
        int n4 = (n3 * 306 + 5) / 10;
        l5 = n3 / 10;
        return new LocalDate(ChronoField.M.m(l4 + l3 + l5), (n3 + 2) % 12 + 1, n2 - n4 + 1);
    }

    public static LocalDate b0(int n2, int n3) {
        Enum enum_ = ChronoField.M;
        long l3 = n2;
        ((ChronoField)enum_).o(l3);
        ChronoField.F.o(n3);
        boolean bl = IsoChronology.c.w(l3);
        if (n3 == 366 && !bl) {
            throw new DateTimeException(qe.P0((String)"Invalid date 'DayOfYear 366' as '", (int)n2, (String)"' is not a leap year"));
        }
        Month month = Month.v((n3 - 1) / 31 + 1);
        int n4 = month.c(bl);
        enum_ = month;
        if (n3 > month.l(bl) + n4 - 1) {
            enum_ = month.w(1L);
        }
        return LocalDate.H(n2, (Month)enum_, n3 - ((Month)enum_).c(bl) + 1);
    }

    private static LocalDate h0(int n2, int n3, int n4) {
        if (n3 != 2) {
            if (n3 == 4 || n3 == 6 || n3 == 9 || n3 == 11) {
                n4 = Math.min(n4, 30);
            }
        } else {
            int n5 = IsoChronology.c.w(n2) ? 29 : 28;
            n4 = Math.min(n4, n5);
        }
        return LocalDate.Y(n2, n3, n4);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(3, this);
    }

    @Override
    public a C(org.threeten.bp.temporal.e e3) {
        return (LocalDate)((Period)e3).a(this);
    }

    @Override
    public long D() {
        long l3 = this.year;
        long l4 = this.month;
        long l5 = 365L * l3 + 0L;
        if (l3 >= 0L) {
            long l6 = (3L + l3) / 4L;
            long l7 = (99L + l3) / 100L;
            l3 = (l3 + 399L) / 400L + (l6 - l7) + l5;
        } else {
            long l8 = l3 / -4L;
            long l9 = l3 / -100L;
            l3 = l5 - (l3 / -400L + (l8 - l9));
        }
        l5 = (367L * l4 - 362L) / 12L + l3 + (long)(this.day - 1);
        l3 = l5--;
        if (l4 > 2L) {
            l3 = l5;
            if (!this.T()) {
                l3 = l5 - 1L;
            }
        }
        return l3 - 719528L;
    }

    int G(LocalDate localDate) {
        int n2;
        int n3 = n2 = this.year - localDate.year;
        if (n2 == 0) {
            n3 = n2 = this.month - localDate.month;
            if (n2 == 0) {
                n3 = this.day - localDate.day;
            }
        }
        return n3;
    }

    long I(LocalDate localDate) {
        return localDate.D() - this.D();
    }

    public int L() {
        return this.day;
    }

    public DayOfWeek N() {
        return DayOfWeek.j(yig.u((long)(this.D() + 3L), (int)7) + 1);
    }

    public int O() {
        return Month.v(this.month).c(this.T()) + this.day - 1;
    }

    public int P() {
        return this.month;
    }

    public int R() {
        return this.year;
    }

    public boolean S(a a3) {
        boolean bl = a3 instanceof LocalDate;
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            if (this.G((LocalDate)a3) >= 0) {
                bl3 = false;
            }
            return bl3;
        }
        bl3 = this.D() < a3.D() ? bl2 : false;
        return bl3;
    }

    public boolean T() {
        return IsoChronology.c.w(this.year);
    }

    public LocalDate U(long l3, i object) {
        object = l3 == Long.MIN_VALUE ? this.c0(Long.MAX_VALUE, (i)object).c0(1L, (i)object) : this.c0(-l3, (i)object);
        return object;
    }

    public LocalDate V(long l3) {
        LocalDate localDate = l3 == Long.MIN_VALUE ? this.d0(Long.MAX_VALUE).d0(1L) : this.d0(-l3);
        return localDate;
    }

    public LocalDate c0(long l3, i object) {
        if (object instanceof ChronoUnit) {
            switch (((ChronoUnit)object).ordinal()) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unsupported unit: ");
                    stringBuilder.append(object);
                    throw new UnsupportedTemporalTypeException(stringBuilder.toString());
                }
                case 14: {
                    object = ChronoField.N;
                    return this.j0((org.threeten.bp.temporal.f)object, yig.R((long)this.r((org.threeten.bp.temporal.f)object), (long)l3));
                }
                case 13: {
                    return this.g0(yig.S((long)l3, (int)1000));
                }
                case 12: {
                    return this.g0(yig.S((long)l3, (int)100));
                }
                case 11: {
                    return this.g0(yig.S((long)l3, (int)10));
                }
                case 10: {
                    return this.g0(l3);
                }
                case 9: {
                    return this.e0(l3);
                }
                case 8: {
                    return this.f0(l3);
                }
                case 7: 
            }
            return this.d0(l3);
        }
        return object.g(this, l3);
    }

    public LocalDate d0(long l3) {
        if (l3 == 0L) {
            return this;
        }
        return LocalDate.a0(yig.R((long)this.D(), (long)l3));
    }

    public LocalDate e0(long l3) {
        if (l3 == 0L) {
            return this;
        }
        l3 = (long)this.year * 12L + (long)(this.month - 1) + l3;
        return LocalDate.h0(ChronoField.M.m(yig.s((long)l3, (long)12L)), yig.u((long)l3, (int)12) + 1, this.day);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDate) {
            if (this.G((LocalDate)object) != 0) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public LocalDate f0(long l3) {
        return this.d0(yig.S((long)l3, (int)7));
    }

    @Override
    public org.threeten.bp.temporal.a g(org.threeten.bp.temporal.a a3) {
        return super.g(a3);
    }

    public LocalDate g0(long l3) {
        if (l3 == 0L) {
            return this;
        }
        return LocalDate.h0(ChronoField.M.m((long)this.year + l3), this.month, this.day);
    }

    public ValueRange h(org.threeten.bp.temporal.f f3) {
        if (f3 instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)f3;
            if (chronoField.c()) {
                int n2 = chronoField.ordinal();
                if (n2 != 18) {
                    if (n2 != 19) {
                        if (n2 != 21) {
                            if (n2 != 25) {
                                return f3.i();
                            }
                            long l3 = this.year <= 0 ? 1000000000L : 999999999L;
                            return ValueRange.g(1L, l3);
                        }
                        long l4 = Month.v(this.month) == Month.b && !this.T() ? 4L : 5L;
                        return ValueRange.g(1L, l4);
                    }
                    n2 = this.T() ? 366 : 365;
                    return ValueRange.g(1L, n2);
                }
                n2 = this.month;
                n2 = n2 != 2 ? (n2 != 4 && n2 != 6 && n2 != 9 && n2 != 11 ? 31 : 30) : (this.T() ? 29 : 28);
                return ValueRange.g(1L, n2);
            }
            throw new UnsupportedTemporalTypeException(qe.Z0((String)"Unsupported field: ", (org.threeten.bp.temporal.f)f3));
        }
        return f3.h((org.threeten.bp.temporal.b)this);
    }

    @Override
    public int hashCode() {
        int n2 = this.year;
        return (n2 << 11) + (this.month << 6) + this.day ^ n2 & 0xFFFFF800;
    }

    @Override
    public <R> R i(h<R> h3) {
        if (h3 == g.b()) {
            return (R)this;
        }
        return super.i(h3);
    }

    public LocalDate i0(c c3) {
        if (c3 instanceof LocalDate) {
            return (LocalDate)c3;
        }
        return (LocalDate)c3.g(this);
    }

    public LocalDate j0(org.threeten.bp.temporal.f object, long l3) {
        if (object instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)((Object)object);
            chronoField.o(l3);
            switch (chronoField.ordinal()) {
                default: {
                    throw new UnsupportedTemporalTypeException(qe.Z0((String)"Unsupported field: ", (org.threeten.bp.temporal.f)object));
                }
                case 27: {
                    object = this.r(ChronoField.N) == l3 ? this : this.l0(1 - this.year);
                    return object;
                }
                case 26: {
                    return this.l0((int)l3);
                }
                case 25: {
                    if (this.year < 1) {
                        l3 = 1L - l3;
                    }
                    return this.l0((int)l3);
                }
                case 24: {
                    return this.e0(l3 - this.r(ChronoField.K));
                }
                case 23: {
                    int n2 = (int)l3;
                    if (this.month == n2) {
                        object = this;
                    } else {
                        ChronoField.J.o(n2);
                        object = LocalDate.h0(this.year, n2, this.day);
                    }
                    return object;
                }
                case 22: {
                    return this.f0(l3 - this.r(ChronoField.I));
                }
                case 21: {
                    return this.f0(l3 - this.r(ChronoField.H));
                }
                case 20: {
                    return LocalDate.a0(l3);
                }
                case 19: {
                    int n3 = (int)l3;
                    object = this.O() == n3 ? this : LocalDate.b0(this.year, n3);
                    return object;
                }
                case 18: {
                    int n4 = (int)l3;
                    object = this.day == n4 ? this : LocalDate.Y(this.year, this.month, n4);
                    return object;
                }
                case 17: {
                    return this.d0(l3 - this.r(ChronoField.D));
                }
                case 16: {
                    return this.d0(l3 - this.r(ChronoField.C));
                }
                case 15: 
            }
            return this.d0(l3 - (long)this.N().c());
        }
        return (LocalDate)object.f((org.threeten.bp.temporal.a)this, l3);
    }

    @Override
    public boolean k(org.threeten.bp.temporal.f f3) {
        return super.k(f3);
    }

    public LocalDate k0(int n2) {
        if (this.O() == n2) {
            return this;
        }
        return LocalDate.b0(this.year, n2);
    }

    public LocalDate l0(int n2) {
        if (this.year == n2) {
            return this;
        }
        ChronoField.M.o(n2);
        return LocalDate.h0(n2, this.month, this.day);
    }

    void m0(DataOutput dataOutput) {
        dataOutput.writeInt(this.year);
        dataOutput.writeByte(this.month);
        dataOutput.writeByte(this.day);
    }

    @Override
    public long o(org.threeten.bp.temporal.a object, i object2) {
        object = LocalDate.J((org.threeten.bp.temporal.b)object);
        if (object2 instanceof ChronoUnit) {
            switch (((ChronoUnit)object2).ordinal()) {
                default: {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unsupported unit: ");
                    ((StringBuilder)object).append(object2);
                    throw new UnsupportedTemporalTypeException(((StringBuilder)object).toString());
                }
                case 14: {
                    object2 = ChronoField.N;
                    return ((LocalDate)object).r((org.threeten.bp.temporal.f)object2) - this.r((org.threeten.bp.temporal.f)object2);
                }
                case 13: {
                    return this.X((LocalDate)object) / 12000L;
                }
                case 12: {
                    return this.X((LocalDate)object) / 1200L;
                }
                case 11: {
                    return this.X((LocalDate)object) / 120L;
                }
                case 10: {
                    return this.X((LocalDate)object) / 12L;
                }
                case 9: {
                    return this.X((LocalDate)object);
                }
                case 8: {
                    return this.I((LocalDate)object) / 7L;
                }
                case 7: 
            }
            return this.I((LocalDate)object);
        }
        return object2.f(this, (org.threeten.bp.temporal.a)object);
    }

    public int p(org.threeten.bp.temporal.f f3) {
        if (f3 instanceof ChronoField) {
            return this.K(f3);
        }
        return this.h(f3).a(this.r(f3), f3);
    }

    public long r(org.threeten.bp.temporal.f f3) {
        if (f3 instanceof ChronoField) {
            if (f3 == ChronoField.G) {
                return this.D();
            }
            if (f3 == ChronoField.K) {
                return this.Q();
            }
            return this.K(f3);
        }
        return f3.j((org.threeten.bp.temporal.b)this);
    }

    public b t(LocalTime localTime) {
        return LocalDateTime.T(this, localTime);
    }

    @Override
    public String toString() {
        int n2 = this.year;
        short s2 = this.month;
        short s3 = this.day;
        int n3 = Math.abs(n2);
        StringBuilder stringBuilder = new StringBuilder(10);
        if (n3 < 1000) {
            if (n2 < 0) {
                stringBuilder.append(n2 - 10000);
                stringBuilder.deleteCharAt(1);
            } else {
                stringBuilder.append(n2 + 10000);
                stringBuilder.deleteCharAt(0);
            }
        } else {
            if (n2 > 9999) {
                stringBuilder.append('+');
            }
            stringBuilder.append(n2);
        }
        String string2 = "-0";
        String string3 = s2 < 10 ? "-0" : "-";
        stringBuilder.append(string3);
        stringBuilder.append(s2);
        string3 = s3 < 10 ? string2 : "-";
        stringBuilder.append(string3);
        stringBuilder.append(s3);
        return stringBuilder.toString();
    }

    @Override
    public int v(a a3) {
        if (a3 instanceof LocalDate) {
            return this.G((LocalDate)a3);
        }
        return super.v(a3);
    }

    @Override
    public e w() {
        return IsoChronology.c;
    }

    @Override
    public f x() {
        return super.x();
    }
}

