/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.threeten.bp.Ser;
import org.threeten.bp.temporal.e;

public final class Duration
implements e,
Comparable<Duration>,
Serializable {
    public static final Duration a = new Duration(0L, 0);
    private static final long serialVersionUID = 3078945930695997490L;
    private final int nanos;
    private final long seconds;

    static {
        BigInteger.valueOf(1000000000L);
        Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", 2);
    }

    private Duration(long l3, int n2) {
        this.seconds = l3;
        this.nanos = n2;
    }

    private static Duration c(long l3, int n2) {
        if (((long)n2 | l3) == 0L) {
            return a;
        }
        return new Duration(l3, n2);
    }

    public static Duration g(long l3) {
        long l4 = l3 / 1000000000L;
        int n2 = (int)(l3 % 1000000000L);
        l3 = l4;
        int n3 = n2;
        if (n2 < 0) {
            n3 = n2 + 1000000000;
            l3 = l4 - 1L;
        }
        return Duration.c(l3, n3);
    }

    public static Duration h(long l3) {
        return Duration.c(l3, 0);
    }

    public static Duration i(long l3, long l4) {
        return Duration.c(yig.R((long)l3, (long)yig.s((long)l4, (long)1000000000L)), yig.u((long)l4, (int)1000000000));
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(1, this);
    }

    @Override
    public int compareTo(Object object) {
        object = (Duration)object;
        int n2 = yig.o((long)this.seconds, (long)((Duration)object).seconds);
        if (n2 == 0) {
            n2 = this.nanos - ((Duration)object).nanos;
        }
        return n2;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object instanceof Duration) {
            object = (Duration)object;
            if (this.seconds != ((Duration)object).seconds || this.nanos != ((Duration)object).nanos) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public long f() {
        return this.seconds;
    }

    public int hashCode() {
        long l3 = this.seconds;
        int n2 = (int)(l3 ^ l3 >>> 32);
        return this.nanos * 51 + n2;
    }

    public long j() {
        return this.seconds / 86400L;
    }

    void k(DataOutput dataOutput) {
        dataOutput.writeLong(this.seconds);
        dataOutput.writeInt(this.nanos);
    }

    public String toString() {
        if (this == a) {
            return "PT0S";
        }
        long l3 = this.seconds;
        long l4 = l3 / 3600L;
        int n2 = (int)(l3 % 3600L / 60L);
        int n3 = (int)(l3 % 60L);
        StringBuilder stringBuilder = qe.u1((int)24, (String)"PT");
        if (l4 != 0L) {
            stringBuilder.append(l4);
            stringBuilder.append('H');
        }
        if (n2 != 0) {
            stringBuilder.append(n2);
            stringBuilder.append('M');
        }
        if (n3 == 0 && this.nanos == 0 && stringBuilder.length() > 2) {
            return stringBuilder.toString();
        }
        if (n3 < 0 && this.nanos > 0) {
            if (n3 == -1) {
                stringBuilder.append("-0");
            } else {
                stringBuilder.append(n3 + 1);
            }
        } else {
            stringBuilder.append(n3);
        }
        if (this.nanos > 0) {
            n2 = stringBuilder.length();
            if (n3 < 0) {
                stringBuilder.append(2000000000 - this.nanos);
            } else {
                stringBuilder.append(this.nanos + 1000000000);
            }
            while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            stringBuilder.setCharAt(n2, '.');
        }
        stringBuilder.append('S');
        return stringBuilder.toString();
    }
}

